(function() {
ASPx.currentDragHelper = null;
var currentCursorTargets = null;
var DragHelper = ASPx.CreateClass(null, {
 constructor: function(e, root, clone){
  if(ASPx.currentDragHelper != null) ASPx.currentDragHelper.cancelDrag();
  this.dragArea = 5;
  this.clickX = ASPx.Evt.GetEventX(e);
  this.clickY = ASPx.Evt.GetEventY(e);
  this.centerClone = false;
  this.cachedCloneWidth = -1;
  this.cachedCloneHeight = -1;
  this.cachedOriginalX = -1;
  this.cachedOriginalY = -1;
  this.canDrag = true; 
  if(typeof(root) == "string") 
   root = ASPx.GetParentByTagName(ASPx.Evt.GetEventSource(e), root);
  this.source = e ? ASPx.Evt.GetEventSource(e) : null;
  this.obj = root && root != null ? root : ASPx.Evt.GetEventSource(e);
  this.clone = clone;
  this.dragObj = null; 
  this.additionalObj = null;
  this.onDoClick = null;
  this.onEndDrag = null;
  this.onCancelDrag = null;
  this.onDragDivCreating = null;
  this.onDragDivCreated = null;
  this.onCloneCreating = null;
  this.onCloneCreated = null;
  this.dragDiv = null;
  ASPx.currentDragHelper = this;
  this.clearSelectionOnce = false;
  this.PreventContextMenuOnLongTap();
 }, 
 drag: function(e) {
  if(!this.canDrag) return;
  ASPx.Selection.Clear();
  if(!this.isDragging()) {
   if(!this.isOutOfDragArea(e)) 
    return;
   this.startDragCore(e);
  }
  if(ASPx.Browser.IE && !ASPx.Evt.IsLeftButtonPressed(e)) {
   this.cancelDrag(e);
   return;
  }
  if(!ASPx.Browser.IE)
   ASPx.Selection.SetElementSelectionEnabled(document.body, false);
  this.dragCore(e);
 },
 startDragCore: function(e) {  
  this.dragObj = this.clone != true ? this.obj : this.createClone(e);
 },
 dragCore: function(e) { 
  this.updateDragDivPosition(e);
 },
 endDrag: function(e) { 
  if(!this.isDragging() && !this.isOutOfDragArea(e)) {
   if(this.onDoClick)
    this.onDoClick(this, e);
  } else {
   if(this.onEndDrag)
    this.onEndDrag(this, e);
  }
  this.cancelDrag();
 },
 cancel: function(){
  this.cancelDrag();
 },
 cancelDrag: function() {
  if(this.dragDiv != null) {
   document.body.removeChild(this.dragDiv);
   this.dragDiv = null;
  }
  if(this.onCancelDrag)
   this.onCancelDrag(this);
  ASPx.currentDragHelper = null;
  if(!ASPx.Browser.IE)
   ASPx.Selection.SetElementSelectionEnabled(document.body, true);
 },
 isDragging: function() {    
  return this.dragObj != null;
 },
 updateDragDivPosition: function(e) {
  if(this.centerClone) {
   this.dragDiv.style.left = ASPx.Evt.GetEventX(e) - this.cachedCloneWidth / 2 + "px";
   ASPx.SetAbsoluteY(this.dragDiv, ASPx.Evt.GetEventY(e) - this.cachedCloneHeight / 2);
  } else {
   this.dragDiv.style.left = this.cachedOriginalX + ASPx.Evt.GetEventX(e) - this.clickX + "px";
   ASPx.SetAbsoluteY(this.dragDiv, this.cachedOriginalY + ASPx.Evt.GetEventY(e) - this.clickY);
  }
 },
 createClone: function(e) {
  this.dragDiv = document.createElement("div");
  if(this.onDragDivCreating)
   this.onDragDivCreating(this, this.dragDiv);
  var clone = this.creatingClone();  
  this.dragDiv.appendChild(clone);
  document.body.appendChild(this.dragDiv);
  this.dragDiv.style.position = "absolute";    
  this.dragDiv.style.cursor = "move";
  this.dragDiv.style.borderStyle = "none";
  this.dragDiv.style.padding = "0";
  this.dragDiv.style.margin = "0";
  this.dragDiv.style.backgroundColor = "transparent";
  this.dragDiv.style.zIndex = 20000; 
  if(this.onCloneCreated)
   this.onCloneCreated(clone);
  this.cachedCloneWidth = clone.offsetWidth;
  this.cachedCloneHeight = clone.offsetHeight;
  if(!this.centerClone) {  
   this.cachedOriginalX = ASPx.GetAbsoluteX(this.obj);
   this.cachedOriginalY = ASPx.GetAbsoluteY(this.obj);
  }
  this.dragDiv.style.width = this.cachedCloneWidth + "px";
  this.dragDiv.style.height = this.cachedCloneHeight + "px";
  if(this.onDragDivCreated)
   this.onDragDivCreated(this, this.dragDiv);
  this.updateDragDivPosition(e);
  return this.dragDiv;
 },
 creatingClone: function() {
  var clone = this.obj.cloneNode(true);
  var scripts = ASPx.GetNodesByTagName(clone, "SCRIPT");
  for(var i = scripts.length - 1; i >= 0; i--)
   ASPx.RemoveElement(scripts[i]);
  ASPx.RippleHelper.RemoveRippleContainer(clone);
  if(!this.onCloneCreating) return clone;
  return this.onCloneCreating(clone);
 },
 addElementToDragDiv: function(element) {
  if(this.dragDiv == null) return;
  this.additionalObj = element.cloneNode(true);
  this.additionalObj.style.visibility = "visible";
  this.additionalObj.style.display = "";
  this.additionalObj.style.top = "";
  this.dragDiv.appendChild(this.additionalObj);
 },
 removeElementFromDragDiv: function() {
  if(this.additionalObj == null || this.dragDiv == null) return;
  this.dragDiv.removeChild(this.additionalObj);
  this.additionalObj = null;
 },
 isOutOfDragArea: function(e) {
  return Math.max(
   Math.abs(ASPx.Evt.GetEventX(e) - this.clickX), 
   Math.abs(ASPx.Evt.GetEventY(e) - this.clickY)
  ) >= this.dragArea;
 },
 PreventContextMenuOnLongTap: function() {
  if(!ASPx.DragUtils.RequirePreventContextMenuOnLongTap(this.obj))
   return;
  this.contextMenuHandler = function(e) {
   ASPx.Evt.DetachEventFromElement(this.obj, "contextmenu", this.contextMenuHandler);
   e.preventDefault(); 
  }.bind(this);
  ASPx.Evt.AttachEventToElement(this.obj, "contextmenu", this.contextMenuHandler);
 }
});
var DragUtils = {
 PreventContextMenuOnLongTapMarker: "dxPCM",
 RequirePreventContextMenuOnLongTap: function(element) {
  return element && ASPx.ElementHasCssClass(element, this.PreventContextMenuOnLongTapMarker);
 },
 PreventContextMenuOnLongTap: function(element) {
  if(element && ASPx.Browser.Edge && ASPx.Browser.MSTouchUI) {
   ASPx.AddClassNameToElement(element, this.PreventContextMenuOnLongTapMarker);
  }
 }
};
var CursorTargetTag = { Right: 0, Left: 1, Top: 2, Bottom: 3 };
var CursorTargets = ASPx.CreateClass(null, {
 constructor: function(control) {
  this.control = control;
  this.list = [];
  this.oldtargetElement = null;
  this.oldtargetTag = CursorTargetTag.Right;
  this.targetElement = null;
  this.targetTag = CursorTargetTag.Right;
  this.x = 0;
  this.y = 0;
  this.onTargetCreated = null;
  this.onTargetChanging = null;
  this.onTargetChanged = null;
  this.onTargetAdding = null;
  this.onTargetAllowed = null;
  currentCursorTargets = this;
  this.treeLine = null;
  this.initialScrollOffsetInfo = this.GetParentElementsScrollOffsetInfo();
 },
 addElement: function(element) {
  if(!this.canAddElement(element)) return null;
  var target = new CursorTarget(element);
  if (this.onTargetCreated)
   this.onTargetCreated(this, target);
  this.list.push(target);
  return target;
 },
 removeElement: function(element) {
  for(var i = 0; i < this.list.length; i++) {
   if(this.list[i].element == element) {
    this.list.splice(i, 1);
    return;
   }
  }
 },
 addParentElement: function(parent, child) {
  var target = this.addElement(parent);
  if(target != null) {
   target.targetElement = child;
  }
  return target;
 },
 RegisterTargets: function(element, idPrefixArray) {
  this.addFunc = this.addElement;
  this.RegisterTargetsCore(element, idPrefixArray);
 },
 UnregisterTargets: function(element, idPrefixArray) {
  this.addFunc = this.removeElement;
  this.RegisterTargetsCore(element, idPrefixArray);
 },
 RegisterTargetsCore: function(element, idPrefixArray) {
  if(element == null) return;
  for(var i = 0; i < idPrefixArray.length; i++)
   this.RegisterTargetCore(element, idPrefixArray[i]);
 },
 RegisterTargetCore: function(element, idPrefix) {
  if(!ASPx.IsExists(element.id)) return;
  if(element.id.indexOf(idPrefix) > -1)
   this.addFunc(element);
  for(var i = 0; i < element.childNodes.length; i++)
   this.RegisterTargetCore(element.childNodes[i], idPrefix);
 },
 canAddElement: function(element) {
  if(element == null || !ASPx.GetElementDisplay(element))
   return false;
  for(var i = 0; i < this.list.length; i++) {
   if(this.list[i].targetElement == element) return false;
  }
  if(this.onTargetAdding != null && !this.onTargetAdding(this, element)) return false;
  return element.style.visibility != "hidden";
 },
 getTarget: function(x, y) {
  for(var i = 0; i < this.list.length; i++) {
   var record = this.list[i];
   if(record.contains(x, y)) {
    if(!this.onTargetAllowed || this.onTargetAllowed(record.targetElement, x, y))
     return record.targetElement;
   }
  }
  return null;
 },
 targetChanged: function(element, tag) {
  this.targetElement = element;
  this.targetTag = ASPx.IsExists(tag) ? tag : ASPx.CursorTargetTag.Right;
  if(this.onTargetChanging)
   this.onTargetChanging(this);
  if(this.oldtargetElement != this.targetElement || this.oldtargetTag != this.targetTag) {
   if(this.onTargetChanged)
    this.onTargetChanged(this);
   this.oldtargetElement = this.targetElement;
   this.oldtargetTag = this.targetTag;
  }
 },
 cancelChanging: function() {
  this.targetElement = this.oldtargetElement;
  this.targetTag = this.oldtargetTag;
 },
 refreshTargetTag: function(allowVerticalTags){
  this.targetTag = this.calculateTargetTag(allowVerticalTags);
 },
 calculateTargetTag: function(allowVerticalTags){
  if(allowVerticalTags && this.isCenterPartOfElement())
   return this.isTopPartOfElement() ? CursorTargetTag.Top : CursorTargetTag.Bottom;
  return this.isLeftPartOfElement() ? CursorTargetTag.Left : CursorTargetTag.Right;
 },
 isCenterPartOfElement: function(){
  if(!this.targetElement) return false;
  var coordinate = this.y - this.targetElementY();
  return coordinate < this.targetElement.offsetHeight / 3 || coordinate >  2 * this.targetElement.offsetHeight / 3;
 },
 isLeftPartOfElement: function() {
  if(!this.targetElement) return true;
  var left = this.x - this.targetElementX();
  return left < this.targetElement.offsetWidth / 2;
 },
 isTopPartOfElement: function() {
  if(!this.targetElement) return true;
  var top = this.y - this.targetElementY();
  return top < this.targetElement.offsetHeight / 2;
 },
 targetElementX: function() {
  return this.targetElement != null ? ASPx.GetAbsoluteX(this.targetElement) : 0;
 },
 targetElementY: function() {
  return this.targetElement != null ? ASPx.GetAbsoluteY(this.targetElement) : 0;
 },
 onmousemove: function(e) {
  this.doTargetChanged(e);
 },
 onmouseup: function(e) {
  this.doTargetChanged(e);
  currentCursorTargets = null;
 },
 doTargetChanged: function(e) {
  this.x = ASPx.Evt.GetEventX(e);
  this.y = ASPx.Evt.GetEventY(e);
  var coords = this.GetScrollOffsetCoordinates(this.x, this.y);
  this.targetChanged(this.getTarget(coords.x, coords.y), 0);
 },
 GetScrollOffsetCoordinates: function(x, y) {
  var scrollOffsetInfo = this.GetParentElementsScrollOffsetInfo();
  var dx = scrollOffsetInfo.left - this.initialScrollOffsetInfo.left;
  var dy = scrollOffsetInfo.top - this.initialScrollOffsetInfo.top;
  return {
   x : x + dx,
   y : y + dy
  };
 },
 GetParentElementsScrollOffsetInfo: function() {
  var result = { top : 0, left : 0 };
  var treeLine = this.GetScrollableElementsTreeLine();
  for(var i = 0; i < treeLine.length; i++) {
   result.top += treeLine[i].scrollTop;
   result.left += treeLine[i].scrollLeft;
  }
  return result;
 },
 GetScrollableElementsTreeLine: function() {
  if(!this.treeLine)
   this.treeLine = ASPx.GetElementTreeLine(this.control.GetMainElement().parentNode).filter(function(el) { 
    return ASPx.IsScrollableElement(el); 
   });
  return this.treeLine;
 }
});
var CursorTarget = ASPx.CreateClass(null, {
 constructor: function(element) {
  this.element = element;
  this.targetElement = element;
  this.UpdatePosition();
 },
 contains: function(x, y) {
  return x >= this.absoluteX && x <= this.absoluteX + this.GetElementWidth() &&
   y >= this.absoluteY && y <= this.absoluteY + this.GetElementHeight();
 },
 GetElementWidth: function() {
  return this.element.offsetWidth;
 },
 GetElementHeight: function() {
  return this.element.offsetHeight;
 },
 UpdatePosition: function() {
  this.absoluteX = ASPx.GetAbsoluteX(this.element);
  this.absoluteY = ASPx.GetAbsoluteY(this.element);
 }
});
if(ASPx.Browser.MSTouchUI)
 ASPx.Evt.AttachEventToDocument(ASPx.TouchUIHelper.pointerCancelEventName, function(e) {
  if(ASPx.currentDragHelper != null) {
   ASPx.currentDragHelper.cancel(e);
   return true;
  }
 });
ASPx.Evt.AttachEventToDocument(ASPx.TouchUIHelper.touchMouseUpEventName, function(e) {
  if(ASPx.currentDragHelper != null) {
   ASPx.currentDragHelper.endDrag(e);
   return true;
  }
});
ASPx.Evt.AttachEventToDocument(ASPx.TouchUIHelper.touchMouseMoveEventName, function(e) {
 if(ASPx.currentDragHelper != null && !(ASPx.Browser.WebKitTouchUI && ASPx.TouchUIHelper.isGesture)) {
  ASPx.currentDragHelper.drag(e);
  if(ASPx.TouchUIHelper.isTouchEvent(e) && ASPx.currentDragHelper.canDrag) {
   e.preventDefault();
   ASPx.TouchUIHelper.preventScrollOnEvent(e);
  }
  return true;
 }
});
ASPx.Evt.AttachEventToDocument("keydown", function(e) {
 if(!ASPx.currentDragHelper) return;
 if(e.keyCode == ASPx.Key.Esc)
  ASPx.currentDragHelper.cancelDrag();
 return true;
});
ASPx.Evt.AttachEventToDocument("keyup", function(e) {
 if (!ASPx.currentDragHelper) return;
 if(e.keyCode == ASPx.Key.Esc && ASPx.Browser.WebKitFamily)
  ASPx.currentDragHelper.cancelDrag();
 return true;
});
ASPx.Evt.AttachEventToDocument("selectstart", function(e) {
 var drag = ASPx.currentDragHelper;
 if(drag && (drag.canDrag || drag.clearSelectionOnce)) {
  ASPx.Selection.Clear();
  drag.clearSelectionOnce = false;
  e.preventDefault();
  return false;
 }
});
ASPx.Evt.AttachEventToDocument(ASPx.TouchUIHelper.touchMouseUpEventName, function(e) { 
 if(currentCursorTargets != null) {
  currentCursorTargets.onmouseup(e);
  return true;
 }
});
ASPx.Evt.AttachEventToDocument(ASPx.TouchUIHelper.touchMouseMoveEventName, function(e) {
 if(currentCursorTargets != null) {
  currentCursorTargets.onmousemove(e);
  return true;
 }
});
ASPx.DragHelper = DragHelper;
ASPx.CursorTargets = CursorTargets;
ASPx.CursorTarget = CursorTarget;
ASPx.CursorTargetTag = CursorTargetTag;
ASPx.DragUtils = DragUtils;
})();
(function() {
var GridDragHelperBase = ASPx.CreateClass(null, {
 maxRepeatScrollTimeout : 30,
 updateTargetPositionTimeout: 50,
 constructor: function() {
  this.isHorzDrag = false;
  this.savedPositions = { };
  this.rect = null;
 },
 GetActiveTargets: function() { return [ ]; },
 GetScrollHelper: function() { return null; },
 GetExtraCellWidth: function() { return 0; },
 GetCustomizationWindowElement: function() { return null; },
 GetScrollableControl: function() { 
  var helper = this.GetScrollHelper();
  return this.isHorzDrag ? helper.GetHorzScrollableControl() : helper.GetVertScrollableControl();
 },
 OnDragCreated: function(isHorzDrag) {
  if(this.NeedScrollOnDrag(isHorzDrag))
   this.InitializeDragScrolling(isHorzDrag);
 },
 InitializeDragScrolling: function(isHorzDrag) {
  this.isHorzDrag = isHorzDrag;
  this.SaveControlDimensions();
  this.mouseMoveHandler = function(e) { this.OnMouseMove(e); }.aspxBind(this);
  ASPx.Evt.AttachEventToDocument("mousemove", this.mouseMoveHandler);
 },
 SaveControlDimensions: function() {
  var scrollableControl = this.GetScrollableControl();
  var visibility = ASPx.GetElementDisplay(scrollableControl);
  ASPx.SetElementDisplay(scrollableControl, true);
  var scrollDivX = ASPx.GetAbsoluteX(scrollableControl);
  var scrollDivY = ASPx.GetAbsoluteY(scrollableControl);
  var width = scrollableControl.offsetWidth;
  var height = scrollableControl.offsetHeight;
  ASPx.SetElementDisplay(scrollableControl, visibility);
  this.SaveControlDimensionsCore(scrollDivX, width, scrollDivY, height);
 },
 SaveControlDimensionsCore: function(scrollDivX, width, scrollDivY, height) {
  this.rect = { 
   left: scrollDivX, 
   right: scrollDivX + width - this.GetExtraCellWidth(),
   top: scrollDivY,
   bottom: scrollDivY + height
  };
 },
 NeedScrollOnDrag: function(isHorzDrag) {
  var helper = this.GetScrollHelper();
  if(!helper || (isHorzDrag && !helper.HasHorzScroll()) || !isHorzDrag && !helper.HasVertScroll())
   return false;
  return ASPx.Browser.IE || ASPx.Browser.Firefox || helper.HasVertScroll();
 },
 OnMouseMove: function(e) {
  var pos = this.isHorzDrag ? ASPx.Evt.GetEventX(e) : ASPx.Evt.GetEventY(e);
  if(pos === this.savedPositions[this.isHorzDrag])
   return;
  var line = { 
   start:  this.isHorzDrag ? this.rect.left  : this.rect.top,
   end: this.isHorzDrag ? this.rect.right : this.rect.bottom
  };
  var isLeft = pos < line.start;
  var diff = isLeft ? line.start - pos : pos - line.end;
  if(diff <= 0) {
   this.CancelScrolling();
   return;
  }
  this.repeatScrollTimeout = diff < this.maxRepeatScrollTimeout ? this.maxRepeatScrollTimeout - diff : 1;
  this.scrollInc = isLeft ? -1 : 1;
  this.savedPositions[this.isHorzDrag] = pos;
  this.StartScrolling(this.isHorzDrag);
 },
 StartScrolling: function() {
  if(this.scrollingProcessing)
   return;
  this.scrollingProcessing = true;
  this.scrollHandler = this.RepeatScrolling();
 },
 CancelDrag: function() {
  if(this.mouseMoveHandler)
   ASPx.Evt.DetachEventFromDocument("mousemove", this.mouseMoveHandler);
  this.CancelScrolling();
 },
 CancelScrolling: function() {
  this.scrollingProcessing = false;
  this.scrollHandler = ASPx.Timer.ClearTimer(this.scrollHandler);
 },
 RepeatScrolling: function() {
  var scrollableControl = this.GetScrollableControl();
  if(this.isHorzDrag)
   scrollableControl.scrollLeft += this.scrollInc;
  else
   scrollableControl.scrollTop += this.scrollInc;
  return window.setTimeout(function() { this.scrollHandler = this.RepeatScrolling(); }.aspxBind(this), this.repeatScrollTimeout);
 },
 UpdateTargetPositionPostponed: function() {
  if(!this.GetActiveTargets().length)
   return;
  this.updateTargetPositionTimerID = ASPx.Timer.ClearTimer(this.updateTargetPositionTimerID);
  this.updateTargetPositionTimerID = window.setTimeout(function() { this.UpdateTargetPosition(); }.aspxBind(this), this.updateTargetPositionTimeout);
 },
 UpdateTargetPosition: function() { 
  var targets = this.GetActiveTargets();
  for(var i = 0; i < targets.length; i++)
   targets[i].UpdatePosition();
 },
 OnHeaderTargetAllowed: function(targetElement, x, y) {
  if(!this.rect)
   return true;
  var custWin = this.GetCustomizationWindowElement();
  var inRect = x >= this.rect.left && x <= this.rect.right;
  return inRect || custWin === targetElement;
 },
 UpdateScrollableControlsOnDrag: function(src) {
  this.UpdateTargetPositionPostponed();
  var helper = this.GetScrollHelper();
  var contentScrollDiv = helper.GetScrollDiv(helper.GetContentTable());
  if(contentScrollDiv === src && helper.HasVertScroll()) {
   var scrollDivs = [ helper.GetScrollDiv(helper.GetHeaderTable()), helper.GetScrollDiv(helper.GetFooterTable()) ];
   for(var i = 0; i < scrollDivs.length; i++)
    if(scrollDivs[i])
     scrollDivs[i].scrollLeft = src.scrollLeft;
  }
 }
});
ASPx.GridDragHelperBase = GridDragHelperBase;
})();
(function() {
var GridHeaderFilterMode = { List: 1, CheckedList: 2, DateRangePicker: 3, DateRangeCalendar: 4 };
var GridFilterHelper = ASPx.CreateClass(null, {
 constructor: function(grid) {
  this.grid = grid;
  this.activeElement = null;
  this.lockFilter = true;
  this.searchFilterTimer = -1;
  this.searchEditorInitialValue = undefined;
  this.savedSearchEditorValue_beforeCallback = undefined;
  this.searchEditorLastClientValue = undefined;
  this.searchEditorValueChangedOnCallbackWaiting = false;
  this.headerFilterPopupRelatedColumn = null;
  this.headerFilterPopupDimensions = { };
  this.headerFilterColumnIndicesToInitialize = [ ];
  this.initialHeaderFilterState = { };
  this.SearchEditorKeyDownHandler = this.OnSearchEditorKeyDown.bind(this);
  this.SearchEditorValueChangedHandler = this.OnSearchEditorValueChanged.bind(this);
  this.SearchEditorUserInputHandler = this.OnSearchEditorUserInput.bind(this);
  ASPx.GetControlCollection().ControlsInitialized.AddHandler(this.OnControlsInitialized, this);
 },
 Reset: function() {
  this.initialHeaderFilterState = { };
 },
 IsFilterLocked: function() { return this.lockFilter; },
 LockFilter: function() { this.lockFilter = true; },
 UnlockFilter: function() { this.lockFilter = false; },
 GetActiveElement: function() { return this.activeElement; },
 ResetActiveElement: function() { this.activeElement = null; },
 IsValidInstance: function() { return this.grid.IsValidInstance(); },
 GetAllowSearchFilterTimer: function() { return this.grid.allowSearchFilterTimer; },
 GetSearchFilterDelay: function() { return this.grid.searchFilterDelay; },
 GetEnableAccessibility: function() { return this.grid.accessibilityCompliant; },
 ResolveColumnIndex: function(id) { return this.grid.getColumnIndex(id); },
 GetSearchEditor: function() { return this.grid.GetSearchEditor(); },
 GetCustomSearchPanelEditor: function() { return this.grid.GetCustomSearchPanelEditor(); },
 GetSearchPanelFilter: function() { return this.grid.searchPanelFilter; },
 ApplySearchPanelFilter: function(value) { this.grid.ApplySearchPanelFilter(value, true); },
 GetContentTable: function() { return this.grid.GetMainTable(); },
 OnInit: function() {
  this.LockFilter();
  window.setTimeout(function() { this.UnlockFilter(); }.bind(this), 0);
  this.EnsureSearchEditor();
  window.setTimeout(function() { this.SaveFilterEditorsState(); }.bind(this), 0);
  window.setTimeout(this.InitializeHeaderFilterPopup.bind(this), 0);
 },
 OnAfterCallback: function() {
  this.LockFilter();
  window.setTimeout(function() { this.UnlockFilter(); }.bind(this), 0);
  this.EnsureSearchEditor();
  window.setTimeout(function() { this.SaveFilterEditorsState(); }.bind(this), 0);
  window.setTimeout(this.InitializeHeaderFilterPopup.bind(this), 0);
 },
 OnBeforeCallback: function() {
  this.LockFilter();
  this.UnloadHeaderFilterPopup();
  var edit = this.GetSearchEditor();
  if(edit)
   this.savedSearchEditorValue_beforeCallback = this.GetEditorStringValue(edit);
 },
 OnCancelCallbackCore: function() {
  this.UnlockFilter();
  this.InitializeHeaderFilterButtons();
 },
 SaveFilterEditorsState: function() { },
 ClearFilterEditorsState: function() { },
 OnDispose: function() {
  ASPx.GetControlCollection().ControlsInitialized.RemoveHandler(this.OnControlsInitialized, this);
 },
 LoadSearchEditorValueOnCallback: function() {
  var edit = this.GetSearchEditor();
  if(edit) {
   var value = this.GetEditorStringValue(edit);
   this.searchEditorValueChangedOnCallbackWaiting = value !== this.savedSearchEditorValue_beforeCallback;
   this.searchEditorLastClientValue = value;
   this.savedSearchEditorValue_beforeCallback = undefined;
  }
 },
 SetSearchPanelCustomEditor: function(editor) {
  if(!ASPx.Ident.IsASPxClientEdit(editor) || !editor.GetMainElement())
   return;
  this.RemoveSearchEditorEvents(this.GetSearchEditor());
  this.grid.customSearchPanelEditorID = editor.name;
  this.EnsureSearchEditor();
 },
 AssignSearchEditorEvents: function(edit) {
  if(edit.dxgvFilterHelper === this)
   return;
  if(edit.KeyDown)
   edit.KeyDown.AddHandler(this.SearchEditorKeyDownHandler);
  if(edit.ValueChanged)
   edit.ValueChanged.AddHandler(this.SearchEditorValueChangedHandler);
  if(edit.UserInput)
   edit.UserInput.AddHandler(this.SearchEditorUserInputHandler);
  edit.dxgvFilterHelper = this;
 },
 RemoveSearchEditorEvents: function(edit) {
  if(!edit || edit.dxgvFilterHelper !== this)
   return;
  if(edit.KeyDown)
   edit.KeyDown.RemoveHandler(this.SearchEditorKeyDownHandler);
  if(edit.ValueChanged)
   edit.ValueChanged.RemoveHandler(this.SearchEditorValueChangedHandler);
  if(edit.UserInput)
   edit.UserInput.RemoveHandler(this.SearchEditorUserInputHandler);
  delete edit.dxgvFilterHelper;
 },
 EnsureSearchEditor: function() {
  var edit = this.GetSearchEditor();
  if(!edit) return;
  this.AssignSearchEditorEvents(edit);
  var isCustomEditor = edit === this.GetCustomSearchPanelEditor();
  this.searchEditorInitialValue = isCustomEditor ? this.GetSearchPanelFilter() : this.GetEditorStringValue(edit);
  var applySearchValueOnCallback = this.searchEditorValueChangedOnCallbackWaiting && this.searchEditorInitialValue !== this.searchEditorLastClientValue;
  if(applySearchValueOnCallback) {
   window.setTimeout(function() {
    edit.SetValue(this.searchEditorLastClientValue);
    this.ApplySearchFilterFromEditor(edit);
   }.bind(this), 0);
  }  else {
   if(isCustomEditor)
    window.setTimeout(function() { edit.SetValue(this.GetSearchPanelFilter()); }.bind(this), 0);
  }
  this.searchEditorValueChangedOnCallbackWaiting = false;
 },
 GetEditorStringValue: function(edit) {
  var value = edit.GetValueString();
  return ASPx.IsExists(value) ? value : "";
 },
 OnSearchEditorKeyDown: function(s, e) {
  if(!e.htmlEvent || !this.IsValidInstance())
   return;
  e = e.htmlEvent;
  var clearEditor = e.keyCode == ASPx.Key.Delete && e.ctrlKey;
  if(e.keyCode == ASPx.Key.Enter || clearEditor) {
   if(clearEditor)
    s.SetValue(null);
   this.ApplySearchFilterFromEditor(s);
   ASPx.Evt.PreventEventAndBubble(e);
   return;
  }
  this.CreateSearchFilterTimer(s);
 },
 OnSearchEditorUserInput: function(s, e) {
  if(!this.IsValidInstance() || this.IsSearchFilterTimerActive())
   return;
  this.OnSearchEditorOnPaste(s);
 },
 OnSearchEditorOnPaste: function(editor) {
  this.EnsureEditorRawValue(editor);
  this.CreateSearchFilterTimer(editor);
 },
 OnSearchEditorValueChanged: function(s, e) {
  if(!this.IsValidInstance())
   return;
  window.setTimeout(function() { this.ApplySearchFilterFromEditor(s);  }.bind(this), 0);
 },
 IsSearchFilterTimerActive: function() {
  return this.searchFilterTimer !== -1;
 },
 CreateSearchFilterTimer: function(editor) {
  if(!this.GetAllowSearchFilterTimer()) return;
  this.ClearSearchFilterTimer();
  this.searchFilterTimer = window.setTimeout(function() { this.ApplySearchFilterFromEditor(editor);  }.bind(this), this.GetSearchFilterDelay());
 },
 ClearSearchFilterTimer: function() {
  this.searchFilterTimer = ASPx.Timer.ClearTimer(this.searchFilterTimer);
 },
 ApplySearchFilterFromEditor: function(edit) {
  this.ClearSearchFilterTimer();
  if(this.IsFilterLocked()) return;
  if(!edit || !this.GetContentTable())
   return;
  edit.Validate();
  if(!edit.GetIsValid()) 
   return;
  var value = this.GetEditorStringValue(edit);
  if(value === this.searchEditorInitialValue)
   return;
  this.SaveFilterEditorActiveElement(edit);
  this.ApplySearchPanelFilter(value);
 },
 EnsureEditorRawValue: function(edit) {
  if(ASPx.GetFocusedEditor() === edit && edit.SyncRawValueIfHasTextDecorators) {
   edit.SyncRawValueIfHasTextDecorators();
  }
 },
 SaveFilterEditorActiveElement: function(editor) {
  if(!editor) return;
  var columnIndex = this.ResolveColumnIndex(editor.name);
  if(columnIndex < 0 && editor !== this.GetSearchEditor())
   return;
  this.activeElement = this.GetFilterEditorInputElement(editor);
 },
 GetFilterEditorInputElement: function(editor) {
  if(document.activeElement && !ASPx.Browser.VirtualKeyboardSupported) 
   return document.activeElement;
  if(editor.GetInputElement) 
   return editor.GetInputElement();
  return null;
 },
 GetHeaderFilterPopup: function() { return this.grid.GetHeaderFilterPopup(); },
 GetEnableCallbackAnimation: function() { return this.grid.enableCallbackAnimation; },
 GetEnableHeaderFilterCaching: function() { return this.grid.enableHeaderFilterCaching; },
 GetHeaderFilterIconClassName: function() { return this.grid.HeaderFilterButtonClassName; }, 
 GetColumnHeaders: function(columnIndex) { return [ this.grid.GetHeader(columnIndex, false), this.grid.GetHeader(columnIndex, true) ]; },
 GetColumn: function(columnIndex) { return this.grid._getColumn(columnIndex); },
 GetColumnCount: function() { return this.grid.GetColumnsCount(); },
 ApplyHeaderFilter: function() { this.grid.ApplyHeaderFilterByColumn(); },
 GetCustomizationWindow: function() { return this.grid.GetCustomizationWindow(); },
 ShowLoadingPanelInsideHeaderFilterPopup: function() { this.grid.ShowLoadingPanelInsideHeaderFilterPopup(); },
 GetListBox: function(columnIndex) { return ASPx.GetControlCollection().Get(this.grid.name + "_HFListBox" + columnIndex); },
 GetSelectAllCheckBox: function(columnIndex) { return ASPx.GetControlCollection().Get(this.grid.name + "_HFSACheckBox" + columnIndex); },
 GetDateEdit_From: function(columnIndex) { return ASPx.GetControlCollection().Get(this.grid.name + "_HFFDE" + columnIndex); },
 GetDateEdit_To: function(columnIndex) { return ASPx.GetControlCollection().Get(this.grid.name + "_HFTDE" + columnIndex); },
 GetCalendar: function(columnIndex){ return ASPx.GetControlCollection().Get(this.grid.name + "_HFC" + columnIndex); },
 GetHeaderFilterPopupRelatedColumn: function() { return this.headerFilterPopupRelatedColumn; },
 GetHeaderFilterButton: function(isCancelButton) {
  var popup = this.GetHeaderFilterPopup();
  if(popup)
   return ASPx.GetControlCollection().Get(isCancelButton ? popup.cpCancelButtonID : popup.cpOkButtonID);
  return null;
 },
 SendHeaderFilterCallback: function(columnIndex, shiftKey) {
  this.grid.gridFuncCallBack([ ASPxClientGridViewCallbackCommand.FilterPopup, this.grid.name, columnIndex, shiftKey ? "T" : ""], this.OnHeaderFilterCallback);
 },
 OnHeaderFilterCallback: function(values) {
  var grid = ASPx.GetControlCollection().Get(values[0]);
  if(grid)
   grid.GetFilterHelper().ProcessHeaderFilterCallback(values[1], values[2]);
 },
 GetHeaderFilterState: function(columnIndex) {
  var listBoxSelectedIndices = [ ];
  var pickerRange = null;
  var calendarDates = null;
  var listBox = this.GetListBox(columnIndex);
  if(listBox)
   listBoxSelectedIndices = listBox.GetSelectedIndices();
  var column = this.GetColumn(columnIndex);
  if(column.HFMode === ASPx.GridHeaderFilterMode.DateRangePicker) {
   var dateEditTo = this.GetDateEdit_To(columnIndex);
   var dateEditFrom = this.GetDateEdit_From(columnIndex);
   if(dateEditTo && dateEditFrom)
    pickerRange = { start: dateEditFrom.GetValue(), end: dateEditTo.GetValue() };
  }
  if(column.HFMode === ASPx.GridHeaderFilterMode.DateRangeCalendar) {
   var calendar = this.GetCalendar(columnIndex);
   if(calendar)
    calendarDates = calendar.GetSelectedDates();
  }
  return { listBoxSelectedIndices: listBoxSelectedIndices, pickerRange: pickerRange, calendarDates: calendarDates };
 },
 IsHeaderFilterChanged: function(columnIndex) {
  var initialState = this.initialHeaderFilterState[columnIndex];
  var currentState = this.GetHeaderFilterState(columnIndex);
  if(!initialState || !currentState)
   return false;
  if(!ASPx.Data.ArrayEqual(initialState.listBoxSelectedIndices, currentState.listBoxSelectedIndices))
   return true;
  var column = this.GetColumn(columnIndex);
  if(column.HFMode === ASPx.GridHeaderFilterMode.DateRangePicker && currentState.pickerRange)
   return initialState.pickerRange.start !== currentState.pickerRange.start || initialState.pickerRange.end !== currentState.pickerRange.end;
  if(column.HFMode === ASPx.GridHeaderFilterMode.DateRangeCalendar && currentState.calendarDates)
   return !ASPx.Data.ArrayEqual(initialState.calendarDates, currentState.calendarDates);
  return false;
 },
 GetHeaderFilterCallbackState: function(columnIndex) {
  var result = [ ];
  var listBox = this.GetListBox(columnIndex);
  if(listBox)
   result = result.concat(listBox.GetSelectedValues());
  var currentState = this.GetHeaderFilterState(columnIndex);
  if(currentState.calendarDates && currentState.calendarDates.length > 0)
   result.push("(Calendar)|" + this.CalcDateRanges(currentState.calendarDates, false).join("|"));
  if(currentState.pickerRange && (currentState.pickerRange.start || currentState.pickerRange.end)) {
   var range = [
    currentState.pickerRange.start && ASPx.DateUtils.GetInvariantDateString(currentState.pickerRange.start) || "",
    currentState.pickerRange.end   && ASPx.DateUtils.GetInvariantDateString(currentState.pickerRange.end)   || ""
   ];
   result.push("(DateRangePicker)|" + range.join("|"));
  }
  return result;
 },
 ProcessHeaderFilterCallback: function(columnIndex, htmlObj) {
  this.headerFilterColumnIndicesToInitialize.push(parseInt(columnIndex));
  this.SetHeaderFilterPopupHtml(htmlObj, columnIndex);
 },
 SetHeaderFilterPopupHtml: function(htmlObj, columnIndex) {
  this.GetHeaderFilterPopup().SetContentHtml(htmlObj, this.GetEnableCallbackAnimation());
 },
 OnControlsInitialized: function() {
  for(var i = 0; i < this.headerFilterColumnIndicesToInitialize.length; i++)
   this.InitHeaderFilter(this.headerFilterColumnIndicesToInitialize[i]);
  this.headerFilterColumnIndicesToInitialize = [ ];
 },
 InitHeaderFilter: function(columnIndex) {
  this.initialHeaderFilterState[columnIndex] = this.GetHeaderFilterState(columnIndex);
  var column = this.GetColumn(columnIndex);
  this.headerFilterPopupRelatedColumn = column;
  this.InitializeListBox(column);
  if(column.HFMode === ASPx.GridHeaderFilterMode.CheckedList)
   this.InitializeSelectAllCheckBox(column);
  if(column.HFMode === ASPx.GridHeaderFilterMode.DateRangePicker)
   this.InitializeDateRangePicker(column);
  if(column.HFMode === ASPx.GridHeaderFilterMode.DateRangeCalendar)
   this.InitializeCalendar(column);
  if(this.GetEnableAccessibility())
   this.InitializeAccessibility(column);
 },
 InitializeListBox: function(column) {
  var listBox = this.GetListBox(column.index);
  if(!listBox) return;
  if(column.HFMode === ASPx.GridHeaderFilterMode.List && this.GetEnableAccessibility())
   listBox.ItemClick.AddHandler(this.OnListBoxSelectionChanged.bind(this));
  else
   listBox.SelectedIndexChanged.AddHandler(this.OnListBoxSelectionChanged.bind(this));
  var element = listBox.GetListTable ? listBox.GetListTable() : listBox.GetMainElement();
  ASPx.Evt.AttachEventToElement(element, "mousedown", function() { window.setTimeout(ASPx.Selection.Clear, 0); });
  listBox.gvColumn = column;
  if(listBox.cpFSI && listBox.cpFSI.length > 0)
   this.PrepareSeparators(listBox);
  if(this.IsListBoxHasScrolling())
   this.AdjustHeaderFilterListBox(column);
 },
 AdjustHeaderFilterListBox: function(column) {
  var listBox = this.GetListBox(column.index);
  if(listBox && listBox.GetMainElement() && this.RequireShowHeaderFilterListBoxScrollbar(column)) {
   ASPx.SetStyles(listBox.GetMainElement(), { minHeight: this.GetHeaderFilterPopupScrollableElement().offsetHeight });
   listBox.AdjustControl();
  }
 },
 InitializeSelectAllCheckBox: function(column) {
  var checkBox = this.GetSelectAllCheckBox(column.index);
  if(!checkBox) return;
  checkBox.CheckedChanged.AddHandler(function(s) { this.OnSelectAllCheckedChanged(s); }.bind(this));
  checkBox.gvColumn = column;
 },
 InitializeDateRangePicker: function(column) {
  var dateEdit_From = this.GetDateEdit_From(column.index);
  var dateEdit_To = this.GetDateEdit_To(column.index);
  if(!dateEdit_From || !dateEdit_To)
   return;
  dateEdit_From.gvColumn = dateEdit_To.gvColumn = column;
  dateEdit_From.ValueChanged.AddHandler(this.OnDateRangePickerValueChanged.bind(this));
  dateEdit_To.ValueChanged.AddHandler(this.OnDateRangePickerValueChanged.bind(this));
  this.AdjustDateRangePicker(dateEdit_From, dateEdit_To);
 },
 AdjustDateRangePicker: function(dateEdit_From, dateEdit_To) {
  var firstCaptionCell = dateEdit_From.GetCaptionCell();
  var secondCaptionCell = dateEdit_To.GetCaptionCell();
  var width = Math.max(ASPx.GetClearClientWidth(firstCaptionCell), ASPx.GetClearClientWidth(secondCaptionCell));
  ASPx.SetStyles(firstCaptionCell, { minWidth: width });
  ASPx.SetStyles(secondCaptionCell, { minWidth: width });
 },
 InitializeCalendar: function(column) {
  var calendar = this.GetCalendar(column.index);
  calendar.SelectionChanged.AddHandler(this.OnCalendarSelectionChanged.bind(this));
  calendar.gvColumn = column;
 },
 OnListBoxSelectionChanged: function(listBox) {
  if(!listBox) return;
  var column = listBox.gvColumn;
  if(this.RequireApplyHeaderFilterNow(column.HFMode, column.index))
   this.ApplyHeaderFilter();
  else {
   if(column.HFMode === ASPx.GridHeaderFilterMode.CheckedList)
    this.UpdateSelectAllCheckState(column.index);
   this.UpdateOkButtonEnabledState(column.index);
  }
 },
 OnSelectAllCheckedChanged: function(checkBox) {
  var columnIndex = checkBox.gvColumn.index;
  var listBox = this.GetListBox(columnIndex);
  if(checkBox.GetChecked())
   listBox.SelectAll();
  else
   listBox.UnselectAll();
  this.UpdateOkButtonEnabledState(columnIndex);
 },
 OnDateRangePickerValueChanged: function(editor) {
  this.UpdateOkButtonEnabledState(editor.gvColumn.index);
 },
 OnCalendarSelectionChanged: function(editor) {
  this.UpdateOkButtonEnabledState(editor.gvColumn.index);
 },
 RequireApplyHeaderFilterNow: function(mode, columnIndex) {
  return mode === ASPx.GridHeaderFilterMode.List && this.IsHeaderFilterChanged(columnIndex);
 },
 UpdateSelectAllCheckState: function(columnIndex) {
  var checkBox = this.GetSelectAllCheckBox(columnIndex);
  var listBox = this.GetListBox(columnIndex);
  if(!checkBox || !listBox) 
   return;
  var selectedItemCount = listBox.GetSelectedIndices().length;
  var checkState = ASPx.CheckBoxCheckState.Indeterminate;
  if(selectedItemCount === 0)
   checkState = ASPx.CheckBoxCheckState.Unchecked;
  else if(selectedItemCount === listBox.GetItemCount())
   checkState = ASPx.CheckBoxCheckState.Checked;
  checkBox.SetCheckState(checkState);
 },
 UpdateOkButtonEnabledState: function(columnIndex) {
  if(this.GetColumn(columnIndex).HFMode !== ASPx.GridHeaderFilterMode.List)
   this.SetHFOkButtonEnabled(this.IsHeaderFilterChanged(columnIndex));
 },
 ApplyHeaderFilterInitialState: function(columnIndex) {
  var state = this.initialHeaderFilterState[columnIndex];
  if(!state) return;
  var column = this.GetColumn(columnIndex);
  var listBox = this.GetListBox(columnIndex);
  if(listBox) {
   if(column.HFMode === ASPx.GridHeaderFilterMode.List) {
    if(this.GetEnableAccessibility() && state.listBoxSelectedIndices.length > 0)
     listBox.SelectIndex(state.listBoxSelectedIndices[0]);
   } else {
    listBox.UnselectAll();
    listBox.SelectIndices(state.listBoxSelectedIndices);
   }
  }
  if(column.HFMode === ASPx.GridHeaderFilterMode.CheckedList)
   this.UpdateSelectAllCheckState(columnIndex);
  if(column.HFMode === ASPx.GridHeaderFilterMode.DateRangePicker) {
   this.GetDateEdit_From(columnIndex).SetValue(state.pickerRange.start);
   this.GetDateEdit_To(columnIndex).SetValue(state.pickerRange.end);
  }
  if(column.HFMode === ASPx.GridHeaderFilterMode.DateRangeCalendar) {
   var calendar = this.GetCalendar(columnIndex);
   calendar.SetValue(null);
   var dates = state.calendarDates || [ ];
   for(var i = 0; i < dates.length; i++)
    calendar.SelectDate(dates[i]);
  }
  this.SetHFOkButtonEnabled(false);
 },
 IsListBoxHasScrolling: function() { return true; }, 
 RequireShowHeaderFilterListBoxScrollbar: function(column) { return this.IsListBoxHasScrolling() && column && (column.HFMode === ASPx.GridHeaderFilterMode.List || column.HFMode === ASPx.GridHeaderFilterMode.CheckedList); },
 GetHeaderFilterPopupScrollableElement: function() { return this.GetHeaderFilterPopup().GetWindowContentElement(-1); },
 InitializeHeaderFilterPopup: function() {
  var popup = this.GetHeaderFilterPopup();
  if(!popup || !popup.GetWindowElement(-1)) 
   return;
  popup.PopUp.AddHandler(this.OnHeaderFilterPopup_PopUp.bind(this));
  popup.CloseUp.AddHandler(this.OnHeaderFilterPopup_CloseUp.bind(this));
  popup.Resize.AddHandler(this.OnHeaderFilterPopup_Resize.bind(this));
  if(this.IsListBoxHasScrolling()) {
   popup.AfterResizing.AddHandler(this.OnHeaderFilter_AfterResizing.bind(this));
   ASPx.Evt.AttachEventToElement(this.GetHeaderFilterPopupScrollableElement(), "scroll", this.OnHeaderFilterPopup_Scroll.bind(this));
  }
  this.InitializeHeaderFilterButtons();
 },
 OnHeaderFilterPopup_PopUp: function(popup) {
  var columnIndex = this.FindColumnIndexByHeaderChild(popup.GetCurrentPopupElement());
  var column = this.GetColumn(columnIndex);
  if(!column) return;
  var shiftKey = popup.GetPopUpReasonMouseEvent().shiftKey;
  var callbackWaiting = this.LoadHeaderFilterPopupData(popup, column, shiftKey);
  if(callbackWaiting) {
   var size = this.GetHeaderFilterPopupSize(columnIndex);
   this.SetHFButtonPanelVisibility(popup, column.HFMode !== ASPx.GridHeaderFilterMode.List);
   if(size) {
    popup.SetSize(size[0], size[1]);
    if(ASPx.Browser.Firefox)
     popup.Shown.AddHandler(function(s) { window.setTimeout(function() { s.SetSize(size[0], size[1]); }, 0); }); 
   }
   this.ShowLoadingPanelInsideHeaderFilterPopup();
  }
  if(this.IsListBoxHasScrolling())
   window.setTimeout(this.UpdateHeaderFilterPopupScroll.bind(this), popup.fadeAnimationDuration);
 },
 LoadHeaderFilterPopupData: function(popup, column, shiftKey) {
  if(column === this.GetHeaderFilterPopupRelatedColumn() && this.UseHeaderFilterContentCaching(column.index) && popup.savedShiftKey === shiftKey) {
   this.ApplyHeaderFilterInitialState(column.index);
  } else {
   this.SendHeaderFilterCallback(column.index, shiftKey);
   popup.SetContentHtml("");
   popup.savedShiftKey = shiftKey;
   return true;
  }
 },
 UpdateHeaderFilterPopupScroll: function() {
  var column = this.GetHeaderFilterPopupRelatedColumn();
  var disablePopupScroll = this.RequireShowHeaderFilterListBoxScrollbar(column) && this.GetHeaderFilterPopup().IsVisible();
  ASPx.SetStyles(this.GetHeaderFilterPopupScrollableElement(), { overflowY: disablePopupScroll ? "hidden" : "auto" });
 },
 OnHeaderFilterPopup_CloseUp: function(popup) {
  var column = this.GetHeaderFilterPopupRelatedColumn();
  if(column && !this.UseHeaderFilterContentCaching(column.index))
   window.setTimeout(function() { popup.SetContentHtml(""); }, 0);
  this.UpdateHeaderFilterPopupScroll();
 },
 OnHeaderFilterPopup_Resize: function(popup) {
  var columnIndex = this.FindColumnIndexByHeaderChild(popup.GetCurrentPopupElement());
  if(this.GetColumn(columnIndex))
   this.SetHeaderFilterPopupSize(columnIndex, popup.GetWidth(), popup.GetHeight());
 },
 OnHeaderFilter_AfterResizing: function(popup) {
  var column = this.GetHeaderFilterPopupRelatedColumn();
  if(column)
   this.AdjustHeaderFilterListBox(column);
 },
 OnHeaderFilterPopup_Scroll: function(e) {
  var column = this.GetHeaderFilterPopupRelatedColumn();
  if(this.RequireShowHeaderFilterListBoxScrollbar(column))
   this.GetHeaderFilterPopupScrollableElement().scrollTop = 0;
 },
 InitializeHeaderFilterButtons: function() {
  var popup = this.GetHeaderFilterPopup();
  if(!popup) return;
  var buttons = this.GetHeaderFilterButtons();
  for(var i = 0; i < buttons.length; i++) {
   popup.AddPopupElement(buttons[i]);
   if(this.GetEnableAccessibility())
    ASPx.Evt.AttachEventToElement(buttons[i], "keydown", GridFilterHelper.HeaderFilterButtonKeyDownHandler);
  }
 },
 UnloadHeaderFilterPopup: function() {
  var popup = this.GetHeaderFilterPopup();
  if(!popup) return;
  popup.RemoveAllPopupElements();
  popup.Hide();
  if(this.GetEnableAccessibility()) {
   var buttons = this.GetHeaderFilterButtons();
   for(var i = 0; i < buttons.length; i++)
    ASPx.Evt.DetachEventFromElement(buttons[i], "keydown", GridFilterHelper.HeaderFilterButtonKeyDownHandler);
  }
 },
 GetHeaderFilterButtons: function() {
  var buttons = [ ];
  var visibleIndices = this.GetVisibleColumnIndices();
  for(var i = 0; i < visibleIndices.length; i++) {
   var index = visibleIndices[i];
   var headers = this.GetColumnHeaders(index);
   for(var j = 0; j < headers.length; j++)
    this.PopulateHeaderFilterButtons(headers[j], buttons);
  }
  var custWindow = this.GetCustomizationWindow();
  if(custWindow)
   this.PopulateHeaderFilterButtons(custWindow.GetWindowClientTable(-1), buttons);
  return buttons;
 },
 GetVisibleColumnIndices: function() {
  var indices = [ ];
  for(var i = 0; i < this.GetColumnCount(); i++) {
   if(this.GetColumn(i).visible)
    indices.push(this.GetColumn(i).index);
  }
  return indices;
 },
 PopulateHeaderFilterButtons: function(container, buttons) {
  if(!container) return;
  var images = container.getElementsByTagName("IMG");
  for(var i = 0; i < images.length; i++) {
   var button = ASPx.getSpriteMainElement(images[i]);
   if(ASPx.ElementContainsCssClass(button, this.GetHeaderFilterIconClassName()))
    buttons.push(button);
  }
 },
 SetHFButtonPanelVisibility: function(popup, visible) {
  var buttonPanel = document.getElementById(popup.cpButtonPanelID);
  if(buttonPanel) {
   ASPx.SetElementDisplay(buttonPanel, visible);
   this.SetHFOkButtonEnabled(false);
  }
 },
 SetHFOkButtonEnabled: function(enabled) {
  var button = this.GetHeaderFilterButton(false);
  if(button)
   button.SetEnabled(enabled);
 },
 GetHeaderFilterPopupSize: function(key) {
  var size = this.headerFilterPopupDimensions[key];
  if(size) return size;
  if(!this.headerFilterPopupDimensions["Default"]) {
   var popup = this.GetHeaderFilterPopup();
   this.SetHeaderFilterPopupSize("Default", popup.GetWidth(), popup.GetHeight());
  }
  return this.headerFilterPopupDimensions["Default"];
 },
 SetHeaderFilterPopupSize: function(key, width, height) {
  this.headerFilterPopupDimensions[key] = [ width, height ];
 },
 FindColumnIndexByHeaderChild: function(element) {
  if(!element) 
   return -1;
  var level = 0;
  while(level < 6) {
   var index = this.ResolveColumnIndex(element.id);
   if(index > -1)
    return index;
   element = element.parentNode;
   level++;
  }
  return -1;
 },
 UseHeaderFilterContentCaching: function(columnIndex) {
  if(!this.GetEnableHeaderFilterCaching())
   return false;
  var listBox = this.GetListBox(columnIndex);
  return listBox && listBox.GetMainElement() && listBox.GetItemCount() < 1000; 
 },
 CalcDateRanges: function(dates) { 
  var result = [ ];
  dates.sort(function(a, b) { return a - b; });
  var range = { start: null, end: null };
  for(var i = 0; i < dates.length; i++) {
   var date = dates[i];
   if(!range.start || !range.end)
    range.start = range.end = date;
   var isLastDate = dates.length === i + 1;
   var nextDate = ASPxClientCalendar.AddDays(date, 1);
   if(!isLastDate && ASPx.DateUtils.AreDatesEqualExact(nextDate, dates[i + 1])) {
    range.end = nextDate;
   } else {
    result.push(ASPx.DateUtils.GetInvariantDateString(range.start));
    result.push(ASPx.DateUtils.GetInvariantDateString(range.end));
    range.start = range.end = null;
   }
  }
  return result;
 },
 InitializeAccessibility: function(column) {
  var listBox = this.GetListBox(column.index);
  if(listBox) {
   listBox.SelectedIndexChanged.AddHandler(function() { this.MakeListBoxSelectedItemVisible(column); }.bind(this));
   this.MakeListBoxSelectedItemVisible(column);
  }
  var popup = this.GetHeaderFilterPopup();
  if(popup && !popup.gvAccessibilityEventsAssigned) {
   popup.Shown.AddHandler(function() { this.MakeListBoxSelectedItemVisible(this.GetHeaderFilterPopupRelatedColumn()); }.bind(this));
   ASPx.Evt.AttachEventToElement(popup.GetCurrentWindowElement(), "keydown", this.ProcessAccessibleHeaderFilterPopupKeyDown.bind(this));
   popup.gvAccessibilityEventsAssigned = true;
  }
 },
 MakeListBoxSelectedItemVisible: function(column) {
  if(!column || column.HFMode !== ASPx.GridHeaderFilterMode.List)
   return;
  var listBox = this.GetListBox(column.index);
  var itemIndex = listBox.GetSelectedIndex();
  var div = this.GetHeaderFilterPopupScrollableElement();
  var item = listBox.GetItemElement(itemIndex);
  if(!div || !item)
   return;
  var itemHeight = item.offsetHeight;
  var divHeight = parseInt(ASPx.GetCurrentStyle(div).height);
  var itemStart = item.offsetTop;
  var itemEnd = itemStart + itemHeight;
  var divStart = div.scrollTop;
  var divEnd = divStart + divHeight;
  var scrollTop = divStart;
  var isItemAbove = itemStart < divStart;
  var isItemBelow = itemEnd > divEnd;
  if(isItemAbove)
   scrollTop = itemStart;
  else if(isItemBelow)
   scrollTop = itemEnd - divHeight;
  if(div.scrollTop !== scrollTop)
   div.scrollTop = scrollTop;
 },
 ProcessAccessibleHeaderFilterPopupKeyDown: function(e) {
  var keyCode = ASPx.Evt.GetKeyCode(e);
  if(keyCode !== ASPx.Key.Enter) 
   return;
  var handled = true;
  var column = this.GetHeaderFilterPopupRelatedColumn();
  if(column.HFMode === ASPx.GridHeaderFilterMode.List) {
   this.OnListBoxSelectionChanged(this.GetListBox(column.index));
  } else {
   var applyFilterOnEnter = this.IsHeaderFilterChanged(column.index) && !this.IsCancelButtonEventSource(e) && !this.IsDateEditorDroppedDown(column);
   if(applyFilterOnEnter)
    this.ApplyHeaderFilter();
   else
    handled = false;
  }
  if(handled)
   ASPx.Evt.PreventEventAndBubble(e);
 },
 IsCancelButtonEventSource: function(evt) {
  return ASPx.GetIsParent(this.GetHeaderFilterButton(true).GetMainElement(), ASPx.Evt.GetEventSource(evt));
 },
 IsDateEditorDroppedDown: function(column) {
  if(column.HFMode === ASPx.GridHeaderFilterMode.DateRangePicker)
   return this.GetDateEdit_From(column.index).droppedDown || this.GetDateEdit_To(column.index).droppedDown;
  return false;
 },
 PrepareSeparators: function(listBox) {
  if(typeof(ASPxClientListBox) != "undefined" && listBox instanceof ASPxClientListBox)
   GridHFListBoxWrapper.Initialize(listBox);
  for(var i = 0; i < listBox.cpFSI.length; i++) {
   var separatorIndex = listBox.cpFSI[i];
   var item = listBox.GetItemElement(separatorIndex);
   if(ASPx.IsExists(item)) {
    var tr = ASPx.GetParentByTagName(item, "TR");
    this.AppendSeparatorRow(tr);
   }
  }
 },
 AppendSeparatorRow: function(targetRow){
  var newTr = document.createElement("TR");
  ASPx.InsertElementAfter(newTr, targetRow);
  var td = document.createElement("TD");
  var colSpan = this.GetColSpanSum(targetRow);
  if(colSpan > 1)
   td.colSpan = colSpan;
  newTr.appendChild(td);
  var separatorDiv = document.createElement("DIV");
  separatorDiv.className = this.GetFilterValuesSeparatorClassName();
  td.appendChild(separatorDiv);
 },
 GetColSpanSum: function(tableRow){
  var colSpan = 0;
  var cells = ASPx.GetChildNodesByTagName(tableRow, "TD");
  for(var i = 0; i < cells.length; i++)
   colSpan += cells[i].colSpan;
  return colSpan;
 },
 GetFilterValuesSeparatorClassName: function() { return this.grid.GetCssClassNamePrefix() + "HFSD"; },
});
var GridHFListBoxWrapper = {
 Initialize: function(listBox){
  listBox.GetItemRow = GridHFListBoxWrapper.GetItemRow;
  listBox.GetItemCount = GridHFListBoxWrapper.GetItemCount;
  listBox.OnItemClickCore = listBox.OnItemClick;
  listBox.OnItemClick = GridHFListBoxWrapper.OnItemClick;
  listBox.FindInternalCheckBoxIndexCore = listBox.FindInternalCheckBoxIndex;
  listBox.FindInternalCheckBoxIndex = GridHFListBoxWrapper.FindInternalCheckBoxIndex;
 },
 GetItemRow: function(index){
  var itemRows = GridHFListBoxWrapper.GetItemRows(this);
  if(index >= 0)
   return itemRows[index] || null;
  return null;
 },
 OnItemClick: function(index, evt){
  var correctIndex = GridHFListBoxWrapper.GetCorrectItemIndex(this, index);
  this.OnItemClickCore(correctIndex, evt);
 },
 FindInternalCheckBoxIndex: function(element){
  var index = this.FindInternalCheckBoxIndexCore(element);
  return GridHFListBoxWrapper.GetCorrectItemIndex(this, index);
 },
 GetItemCount: function(){
  return GridHFListBoxWrapper.GetItemRows(this).length;
 },
 GetCorrectItemIndex: function(listBox, index){
  for(var i = 0; i < listBox.cpFSI.length; i++) {
   if(listBox.cpFSI[i] < index)
    index--;
  }
  return index;
 },
 GetItemRows: function(listBox){
  var itemRows = [];
  var listTable = listBox.GetListTable();
  var rows = listTable ? listTable.rows : null;
  for(var i = 0; rows && i < rows.length; i++){
   if(ASPx.ElementContainsCssClass(rows[i], "dxeListBoxItemRow"))
    itemRows.push(rows[i]);
  }
  return itemRows;
 }
};
GridFilterHelper.HeaderFilterButtonKeyDownHandler = function(evt) { ASPx.Evt.InvokeMouseClickByKeyDown(evt, ASPx.PopupElementMouseEvent); };
ASPx.GridHeaderFilterMode = GridHeaderFilterMode;
ASPx.GridFilterHelper = GridFilterHelper;
})();
(function() {
var GridExportItemType = {
 ExportToPdf: "ExportToPdf",
 ExportToDocx: "ExportToDocx",
 ExportToRtf: "ExportToRtf",
 ExportToCsv: "ExportToCsv",
 ExportToXls: "ExportToXls",
 ExportToXlsx: "ExportToXlsx"
};
var ExportHelperBase = ASPx.CreateClass(null, {
 constructor: function(exportFormat) {
  this.exportFormat = exportFormat;
 },
 IsExportItem: function(itemType) {
  return itemType == GridExportItemType.ExportToPdf
   || itemType == GridExportItemType.ExportToDocx
   || itemType == GridExportItemType.ExportToRtf
   || itemType == GridExportItemType.ExportToCsv
   || itemType == GridExportItemType.ExportToXls
   || itemType == GridExportItemType.ExportToXlsx;
 },
 GetExportFormat: function(exportCommand) {
  var exportFormat = this.exportFormat;
  switch(exportCommand) {
   case GridExportItemType.ExportToPdf:
    return exportFormat.Pdf;
   case GridExportItemType.ExportToDocx:
    return exportFormat.Docx;
   case GridExportItemType.ExportToRtf:
    return exportFormat.Rtf;
   case GridExportItemType.ExportToCsv:
    return exportFormat.Csv;
   case GridExportItemType.ExportToXls:
    return exportFormat.Xls;
   case GridExportItemType.ExportToXlsx:
    return exportFormat.Xlsx;
  }
  return null;
 }
});
var CommandToolbarHelper = ASPx.CreateClass(ExportHelperBase, {
 constructor: function(control, exportFormat) {
  this.constructor.prototype.constructor.call(this, exportFormat);
  this.control = control;
  this.ResetToolbarState();
 },
 GetCallbackState: function() {
  if(this.clickedToolbarIndex < 0 || !this.clickedToolbarMenuItem)
   return null;
  return this.clickedToolbarIndex + ";" + this.clickedToolbarMenuItem.indexPath;
 },
 ResetToolbarState: function() {
  this.clickedToolbarIndex = -1;
  this.clickedToolbarMenuItem = null;
 },
 GetToolbarSettings: function() {
  return this.control.toolbars;
 },
 GetToolbarByIndex: function(index) {
  return this.control.GetToolbar(index);
 },
 GetToolbarByName: function(name) {
  var settings = this.GetToolbarSettings();
  var foundToolbars = settings.filter(function(t) { return t.name === name; });
  if(foundToolbars.length < 1)
   return null;
  return this.GetToolbarByIndex(foundToolbars[0].index);
 },
 GetToolbarNameByIndex: function(index) {
  var settings = this.GetToolbarSettings(),
   foundToolbars = settings.filter(function(t) { return t.index === index; });
  return (foundToolbars.length > 0) ? foundToolbars[0].name : null;
 },
 GetToolbarIndexByName: function(name) {
  var index = -1;
  var success = false;
  var n = name.length - 1;
  while(n >= 0 && !isNaN(parseInt(name.substr(n), 10))) {
   index = parseInt(name.substr(n), 10);
   success = true;
   n--;
  }
  return success ? index: -1;
 },
 InitializeCustomizationWindowHandlers: function() {
  var custWindow = this.GetCustomizationWindow();
  if(custWindow) {
   custWindow.PopUp.AddHandler(function() {
    this.SetCheckedItemsState(this.IsShowCustomizationWindowItem, true);
   }.aspxBind(this));
   custWindow.CloseUp.AddHandler(function() {
    this.SetCheckedItemsState(this.IsShowCustomizationWindowItem, false);
   }.aspxBind(this));
  }
 },
 OnInit: function() {
  this.InitializeCustomizationWindowHandlers();
 },
 OnAfterCallback: function() {
  this.ResetToolbarState();
  this.InitializeCustomizationWindowHandlers();
 },
 RefreshItemsState: function() {
  this.ForEachItem(null, this.RefreshItemState.aspxBind(this));
 },
 SetCheckedItemsState: function(filterFunc, checked) {
  var setCheckedFunc = function(item) { item.SetChecked(checked); };
  this.ForEachItem(filterFunc, setCheckedFunc);
 },
 OnUpdateEditEnabledChanged: function(enabled) {
  var setEnabledFunc = function(item) { item.SetEnabled(enabled); };
  this.ForEachItem(this.IsUpdateEditItem.aspxBind(this), setEnabledFunc);
 },
 RefreshItemState: function(item) {
  this.RefreshItemText(item);
  this.RefreshItemEnabled(item);
 },
 RefreshSelectionBasedItemText: function(item, gridItemCount) {
  var text = item.GetText();
  var newText = text;
  var postfixIndex = text.lastIndexOf("(");
  if(postfixIndex !== -1)
   newText = text.substring(0, postfixIndex - 1);
  if(gridItemCount > 1)
   newText += " (" + gridItemCount.toString() + ")";
  if(newText != text)
   item.SetText(newText);
 },
 RefreshItemEnabled: function(item) {
  var itemEnabled = this.GetToolbarItemEnabled(item);
  if(itemEnabled !== null)
   item.SetEnabled(itemEnabled);
 },
 ForEachItem: function(filterFunc, actionFunc) {
  var settings = this.GetToolbarSettings();
  for(var i = 0; i < settings.length; i++){
   var menu = this.GetToolbarByIndex(settings[i].index);
   this.ForEachItemInternal(menu, filterFunc, actionFunc);
  }
 },
 ForEachItemInternal: function(itemsOwner, filterFunc, actionFunc) {
  for(var i = 0; i < itemsOwner.GetItemCount(); i++){
   var item = itemsOwner.GetItem(i);
   if(!filterFunc || filterFunc(item))
    actionFunc(item);
   this.ForEachItemInternal(item, filterFunc, actionFunc);
  }
 },
 RefreshItemText: function(item) {
 },
 GetToolbarItemEnabled: function(item){
  return null;
 },
 IsUpdateEditItem: function(item) {
  return false;
 },
 GetCustomizationWindow: function() {
  return null;
 },
 IsShowCustomizationWindowItem: function(item) {
  return false;
 },
 GetSelectedGridItemCount: function() {
  return 0;
 },
 GetSelectedVisibleGridItemCount: function() {
  return 0;
 },
 OnToolbarMenuItemClick: function(toolbar, e) {
  this.clickedToolbarIndex = this.GetToolbarIndexByName(toolbar.name);
  this.clickedToolbarMenuItem = e.item;
  var clickedToolbarInfo = { index: this.clickedToolbarIndex, name: this.GetToolbarNameByIndex(this.clickedToolbarIndex) },
   handled = this.control.RaiseToolbarItemClick(clickedToolbarInfo, e.item);
  if(!handled)
   this.ProcessToolbarItemClick(e);
 },
 ProcessToolbarItemClick: function(e) {
  var item = e.item;
  if(this.IsExportItem(item.name))
   this.ToolbarExport(item.name);
 },
 ToolbarExport: function(exportCommand) {
  var toolbarIndex = this.clickedToolbarIndex,
   indexPath = this.clickedToolbarMenuItem.indexPath;
  this.SendExportCommand(toolbarIndex, indexPath, this.GetExportFormat(exportCommand));
  this.ResetToolbarState();
 },
 SendExportCommand: function(toolbarIndex, indexPath, exportFormat) { },
 ProcessCustomToolbarItemClickOnServer: function(usePostBack) {
 }
});
var GridToolbarHelper = ASPx.CreateClass(CommandToolbarHelper, {
 constructor: function(grid) {
  this.constructor.prototype.constructor.call(this, grid, ASPx.ASPxClientGridExportFormat);
  this.grid = grid;
 },
 ProcessCustomToolbarItemClickOnServer: function(usePostBack) {
  if(usePostBack)
   this.SendToolbarPostback("Custom");
  else
   this.SendToolbarCallback([ "" ]);
 },
 SendToolbarCallback: function(args) {
  return this.grid.gridCallBack([ ASPxClientGridViewCallbackCommand.Toolbar ].concat(args));
 },
 SendToolbarPostback: function(toolbarCommand) {
  var toolbarIndex = this.clickedToolbarIndex;
  var indexPath = this.clickedToolbarMenuItem.indexPath;
  this.ResetToolbarState();
  this.grid.gridPostBack([ASPxClientGridViewCallbackCommand.Toolbar, toolbarCommand, toolbarIndex, indexPath]);
 },
 SendExportCommand: function(toolbarIndex, indexPath, exportFormat) {
  this.grid.gridPostBack([ASPxClientGridViewCallbackCommand.Toolbar, ASPxClientGridViewCallbackCommand.Export, toolbarIndex, indexPath, exportFormat]);
 },
 ToolbarStartEdit: function() {
  if(this.IsBatchEditMode()) {
   var cellInfo = this.GetFocusedCellInfo();
   if(!cellInfo)
     cellInfo = { visibleIndex: 0, columnIndex: 0 };
   this.grid.batchEditApi.StartEdit(cellInfo.visibleIndex, cellInfo.columnIndex);
  }
  else
   this.grid.StartEditItem(this.GetFocusedItemIndex());
 },
 ToolbarDeleteItem: function() {
  var focusedItemIndex = this.GetFocusedItemIndex();
  if(focusedItemIndex == -1 && this.IsBatchEditMode()) {
   var cellInfo = this.GetFocusedCellInfo();
   if(cellInfo)
    focusedItemIndex = cellInfo.visibleIndex;
  }
  this.grid.DeleteGridItem(focusedItemIndex);
 },
 ToolbarDeleteSelectedItems: function() {
  this.ToolbarDeleteSelectedItemsInternal("DeleteSelected");
 },
 ToolbarDeleteSelectedVisibleItems: function() {
  this.ToolbarDeleteSelectedItemsInternal("DeleteSelectedVisible");
 },
 ToolbarDeleteSelectedItemsInternal: function(commandName) {
  if(this.IsBatchEditMode()) {
   var keys = this.grid.GetSelectedKeysOnPage();
   for(var i = 0, key; key = keys[i]; i++)
    this.grid.DeleteItemByKey(key);
  }
  else
   this.SendToolbarCallback([ commandName ]);
 },
 GetFocusedItemIndex: function(){
  return this.control._getFocusedItemIndex();
 },
 GetFocusedCellInfo: function() {
  return this.control.GetCellFocusHelper().focusedCellInfo;
 },
 GetSelectedGridItemCount: function() {
  return this.control._getSelectedRowCount();
 },
 GetSelectedVisibleGridItemCount: function() {
  return this.control._getSelectedRowCountOnPage();
 },
 GetCustomizationWindow: function() {
  return this.grid.GetCustomizationWindow();
 },
 IsEditingItem: function(visibleIndex){
  return this.control.IsEditingItem(visibleIndex);
 },
 IsBatchEditMode: function(){
  return this.control.GetBatchEditHelper();
 },
 HasBatchEditFocusedCell: function() {
  return this.IsBatchEditMode() && this.GetFocusedCellInfo();
 }
});
ASPx.GridExportItemType = GridExportItemType;
ASPx.ExportHelperBase = ExportHelperBase;
ASPx.CommandToolbarHelper = CommandToolbarHelper;
ASPx.GridToolbarHelper = GridToolbarHelper;
})();
(function() {
var GridSortOrder = { None: 0, Ascending: 1, Descending: 2 };
var ASPxClientGridColumnMovingTargetPosition = {
 Right: 0,
 Left: 1,
 Top: 2,
 Bottom: 3
};
var ASPxClientGridBase = ASPx.CreateClass(ASPxClientControl, {
 MainTableID: "DXMainTable",
 CustomizationWindowSuffix: "_custwindow",
 EditingRowID: "_DXEditingRow",
 EditingErrorItemID: "DXEditingErrorItem",
 BatchEditCellErrorTableID: "DXCErrorTable",
 EmptyHeaderSuffix: "_emptyheader",
 PagerBottomID: "DXPagerBottom",
 PagerTopID: "DXPagerTop",
 SearchEditorID: "DXSE",
 SelectButtonID: "DXSelBtn",
 HeaderFilterButtonClassName: "dxgv__hfb",
 CommandColumnItemClassName: "dxgv__cci",
 DetailGridSuffix: "dxdt",
 FixedColumnsDivID: "DXFixedColumnsDiv",
 FixedColumnsContentDivID: "DXFixedColumnsContentDiv",
 ProgressBarDisplayControlIDFormat: "PBc{0}i{1}",
 AccessibleFilterRowButtonID: "AFRB",
 RequireKeyFieldNameText: "Error while trying to perform a CRUD operation with an incorrect or unspecified KeyFieldName property value.",
 constructor: function(name){
  this.constructor.prototype.constructor.call(this, name);
  this.callBacksEnabled = true;
  this.custwindowLeft = null;
  this.custwindowTop = null;
  this.custwindowVisible = null;
  this.userChangedSelection = false;
  this.confirmDelete = "";
  this.editorIDList = [ ];
  this.keys = [ ];
  this.lastMultiSelectIndex = -1;
  this.mainTableClickData = {
   processing: false,
   focusChanged: false,
   selectionChanged: false
  };
  this.afterCallbackRequired = false;
  this.enableHeaderFilterCaching = true;
  this.supportGestures = true;
  this.checkBoxImageProperties = null;
  this.internalCheckBoxCollection = null;
  this.sizingConfig.adjustControl = true;
  this.lookupBehavior = false;
  this.isAccessibleRowEditing = false;
  this.batchEditApi = this.CreateBatchEditApi();
  this.CustomButtonClick = new ASPxClientEvent();
  this.SelectionChanged = new ASPxClientEvent();
  this.ColumnSorting = new ASPxClientEvent();
  this.CustomizationWindowCloseUp = new ASPxClientEvent();
  this.InternalCheckBoxClick = new ASPxClientEvent();
  this.BatchEditStartEditing = new ASPxClientEvent();
  this.BatchEditEndEditing = new ASPxClientEvent();
  this.BatchEditConfirmShowing = new ASPxClientEvent();
  this.BatchEditTemplateCellFocused = new ASPxClientEvent();
  this.BatchEditChangesSaving = new ASPxClientEvent();
  this.BatchEditChangesCanceling = new ASPxClientEvent();
  this.FocusedCellChanging = new ASPxClientEvent();
  this.ToolbarItemClick = new ASPxClientEvent();
  this.pendingCommands = [ ];
  this.pageRowCount = 0;
  this.pageRowSize = 0;
  this.pageIndex = 0;
  this.pageCount = 1;
  this.allowDelete = false;
  this.allowEdit = false;
  this.allowInsert = false;
  this.allowFocusedRow = false;
  this.allowFocusedCell = false;
  this.allowSelectByItemClick = false;
  this.allowSelectSingleRowOnly = false;
  this.allowMultiColumnAutoFilter = false;
  this.focusedRowIndex = -1;
  this.selectedWithoutPageRowCount = 0;
  this.selectAllSettings = [ ];
  this.selectAllBtnStateWithoutPage = null;
  this.visibleStartIndex = 0;
  this.columns = [ ];
  this.columnResizeMode = ASPx.ColumnResizeMode.None;
  this.horzScroll = ASPx.ScrollBarMode.Hidden;
  this.vertScroll = ASPx.ScrollBarMode.Hidden;
  this.scrollToRowIndex = -1;
  this.useEndlessPaging = false;
  this.allowBatchEditing = false;
  this.batchEditClientState = { };
  this.resetScrollTop = false;
  this.callbackOnFocusedRowChanged = false;
  this.callbackOnSelectionChanged = false;
  this.autoFilterDelay = 1200;
  this.searchFilterDelay = 1200;
  this.allowSearchFilterTimer = true;
  this.editState = 0;
  this.kbdHelper = null;
  this.enableKeyboard = false;
  this.keyboardLock = false;
  this.accessKey = null;
  this.customKbdHelperName = null;
  this.endlessPagingHelper = null;
  this.toolbarHelper = null;
  this.icbFocusedStyle = null;
  this.pendingEvents = [ ];
  this.customSearchPanelEditorID = null;
  this.searchPanelFilter = null;
  this.isDetailGrid = null;
  this.rowHotTrackStyle = null;
  this.updateButtonName = "";
  this.cancelButtonName = "";
  this.isAccessibleFilterRowMenu = false;
  this.userHandledCallbackError = false;
 },
 HasHorzScroll: function() { return this.horzScroll != ASPx.ScrollBarMode.Hidden; },
 HasVertScroll: function() { return this.vertScroll != ASPx.ScrollBarMode.Hidden; },
 HasScrolling: function() { return this.HasHorzScroll() || this.HasVertScroll(); },
 AllowResizing: function() { return this.columnResizeMode != ASPx.ColumnResizeMode.None; },
 GetRootTable: function() { return ASPx.GetElementById(this.name); },
 GetGridTD: function() { 
  var table = this.GetRootTable();
  if(!table) return null;
  return table.rows[0].cells[0];
 },
 GetArrowDragDownImage: function() { return this.GetChildElement("IADD"); },
 GetArrowDragUpImage: function() { return this.GetChildElement("IADU"); },
 GetArrowDragLeftImage: function() { return this.GetChildElement("IADL"); },
 GetArrowDragRightImage: function() { return this.GetChildElement("IADR"); },
 GetArrowDragFieldImage: function() { return this.GetChildElement("IDHF"); },
 GetEndlessPagingUpdatableContainer: function() { return this.GetChildElement("DXEPUC"); },
 GetEndlessPagingLPContainer: function() { return this.GetChildElement("DXEPLPC"); },
 GetBatchEditorsContainer: function() { return this.GetChildElement("DXBEsC"); },
 GetBatchEditorContainer: function(columnIndex) { return this.GetChildElement("DXBEC" + columnIndex); },
 GetBatchEditCellErrorTable: function() { return this.GetChildElement(this.BatchEditCellErrorTableID); },
 GetLoadingPanelDiv: function() {  return this.GetChildElement("LPD"); },
 GetFixedColumnsDiv: function() {  return this.GetChildElement(this.FixedColumnsDivID); },
 GettItem: function(visibleIndex) { return null; },
 GetDataItemIDPrefix: function() { },
 GetEmptyDataItemIDPostfix: function() { },
 GetEmptyDataItem: function() { return this.GetChildElement(this.GetEmptyDataItemIDPostfix()); },
 GetDataRowSelBtnIDPrefix: function() { return "_" + this.SelectButtonID; },
 GetDataRowSelBtn: function(index) {
  var item = this.GetItem(index);
  return item && item.querySelector("input[id^='" + this.name + this.GetDataRowSelBtnIDPrefix(index) + "']");
 },
 GetSelectAllBtn: function(index) { return this.GetChildElement("DXSelAllBtn" + index); },
 GetMainTable: function() { return this.GetChildElement(this.MainTableID); },
 GetLoadingPanelContainer: function() { return this.GetChildElement("DXLPContainer"); },
 GetGroupPanel: function() { return this.GetChildElement("grouppanel"); },
 GetHeader: function(columnIndex, inGroupPanel) { 
  var id = "col" + columnIndex;
  if(inGroupPanel)
   id = "group" + id;
  return this.GetChildElement(id); 
 },
 GetHeaderRow: function(index) {
  return ASPx.GetElementById(this.name + "_" + ASPx.GridViewConsts.HeaderRowID + index);
 },
 GetEditingRow: function(obj) { return ASPx.GetElementById((obj ? obj.name : this.name) + this.EditingRowID); },
 GetEditingErrorItem: function(obj) { return ASPx.GetElementById((obj ? obj.name : this.name) + "_" + this.EditingErrorItemID); },
 GetEditFormTable: function() { return ASPx.GetElementById(this.name + "_DXEFT"); },
 GetCustomizationWindow: function() { return ASPx.GetControlCollection().Get(this.name + this.CustomizationWindowSuffix); },
 GetCustomizationWindowElement: function() {
  var win = this.GetCustomizationWindow();
  return win ? win.GetWindowElement(-1) : null;  
 },
 GetParentRowsWindow: function() { return ASPx.GetControlCollection().Get(this.name + "_DXparentrowswindow"); },
 GetEditorPrefix: function() { return "DXEditor"; },
 GetPopupEditForm: function() { return ASPx.GetControlCollection().Get(this.name  + "_DXPEForm"); },
 GetFilterRowMenu: function() { return ASPx.GetControlCollection().Get(this.name + "_DXFilterRowMenu"); },
 GetFilterRow: function() { return ASPx.GetControlCollection().Get(this.name + "_DXFilterRow"); },
 GetFilterControlPopup: function() { return ASPx.GetControlCollection().Get(this.name + "_DXPFCForm"); },
 GetFilterControl: function() { return ASPx.GetControlCollection().Get(this.name +  "_DXPFCForm_DXPFC"); }, 
 GetHeaderFilterPopup: function() { return ASPx.GetControlCollection().Get(this.name + "_DXHFP"); },
 GetToolbarByName: function(name){
  return this.GetToolbarHelper().GetToolbarByName(name);
 },
 GetToolbar: function(index){
  return ASPx.GetControlCollection().Get(this.name + "_DXCTMenu" + index);
 },
 IsBatchEditDeletedItem: function(visibleIndex) {
  var helper = this.GetBatchEditHelper();
  return helper && helper.IsDeletedItemIndex(visibleIndex);
 },
 IsEmptyHeaderID: function(id) { return false; },
 IsDataItem: function(visibleIndex) { return !!this.GetItem(visibleIndex); },
 GetSearchEditor: function() { 
  var editor = this.GetCustomSearchPanelEditor() || this.GetGridSearchEditor();
  if(editor && editor.GetMainElement())
   return editor;
  return null;
 },
 GetGridSearchEditor: function() { return ASPx.GetControlCollection().Get(this.name + "_" + this.SearchEditorID); },
 GetCustomSearchPanelEditor: function() { return ASPx.GetControlCollection().Get(this.customSearchPanelEditorID); },
 SetSearchPanelCustomEditor: function(editor) { this.GetFilterHelper().SetSearchPanelCustomEditor(editor); },
 GetEditorByColumnIndex: function(colIndex) {
  var list = this._getEditors();
  for(var i = 0; i < list.length; i++) {
   if(this.tryGetNumberFromEndOfString(list[i].name).value === colIndex)
    return list[i];
  }
  return null;
 },
 GetProgressBarControlID: function(visibleIndex, columnIndex) { return ASPx.Str.ApplyReplacement(this.ProgressBarDisplayControlIDFormat, [["{0}", columnIndex], ["{1}", visibleIndex]]); },
 GetProgressBarControl: function(visibleIndex, columnIndex) { return ASPx.GetControlCollection().Get(this.name + "_" + this.GetProgressBarControlID(visibleIndex, columnIndex)); },
 CreateBatchEditApi: function() { },
 SetProperties: function(properties, obj) {
  ASPxClientControl.prototype.SetProperties.call(this, properties, obj);
  this.CreateColumns();
  this.CreateToolbars();
 },
 CreateColumns: function() {
  this.columns = [ ];
  for(var i = 0; i < this.columnProp.length; i++)
   this.columns.push(this.CreateColumn(this.columnProp[i]));
 },
 CreateToolbars: function(){
  this.toolbars = [ ];
  for(var i = 0; this.toolbarsProp && i < this.toolbarsProp.length; i++){
   var tollbarInfo = {
    index: this.toolbarsProp[i][0],
    name: this.toolbarsProp[i][1]
   };
   this.toolbars.push(tollbarInfo);
  }
 },
 CreateColumn: function(prop) { },
 IsFilterLocked: function() { return this.GetFilterHelper().IsFilterLocked(); },
 LockFilter: function() { this.GetFilterHelper().LockFilter(); },
 UnlockFilter: function() { this.GetFilterHelper().UnlockFilter(); },
 Initialize: function() {
  ASPxClientControl.prototype.Initialize.call(this);
  this.GetFilterHelper().OnInit();
  this.GetToolbarHelper().OnInit();
  if(this.enabled)
   this.SetHeadersClientEvents();
  this.EnsureRowKeys();
  this._setFocusedItemInputValue();
  this.AddSelectStartHandler();
  if(this.isAccessibleFilterRowMenu)
   this.AddKeyDownFilterRowButtonHandler();
  this.EnsureRowHotTrackItems();
  if(this.checkBoxImageProperties){
   this.CreateInternalCheckBoxCollection();
   this.UpdateSelectAllCheckboxesState();
  }
  this.CheckPendingEvents();
  this.CheckEndlessPagingLoadNextPage();
  this.PrepareCommandButtons();
  var batchEditHelper = this.GetBatchEditHelper();
  if(batchEditHelper)
   batchEditHelper.Init();
  var cellFocusHelper = this.GetCellFocusHelper();
  if(cellFocusHelper)
   cellFocusHelper.Update();
  window.setTimeout(function() { this.EnsureVisibleRowFromServer(); }.aspxBind(this), 0);
 },
 AttachEventToEditor: function(columnIndex, eventName, handler) {
  var editor = this.GetEditorByColumnIndex(columnIndex);
  if(!ASPx.Ident.IsASPxClientEdit(editor))
   return;
  var attachKeyDownToInput = eventName === "KeyDown" && this.IsCheckEditor(editor);
  if(!editor[eventName] && !attachKeyDownToInput)
   return;
  var duplicateAttachLocker = "dxgv" + eventName + "Assigned";
  if(editor[duplicateAttachLocker]) 
   return;
  if(attachKeyDownToInput)
   ASPx.Evt.AttachEventToElement(editor.GetFocusableInputElement(), "keydown", function(e) { handler(editor, { htmlEvent: e }); });
  else
   editor[eventName].AddHandler(handler);
  editor.dxgvColumnIndex = columnIndex;
  editor[duplicateAttachLocker] = true;
 },
 IsCheckEditor: function(editor) {
  return ASPx.Ident.IsASPxClientCheckEdit && ASPx.Ident.IsASPxClientCheckEdit(editor);
 },
 IsStaticBinaryImageEditor: function(editor) {
  return ASPx.Ident.IsStaticASPxClientBinaryImage && ASPx.Ident.IsStaticASPxClientBinaryImage(editor);
 },
 IsDetailGrid: function() { 
  if(this.isDetailGrid !== null)
   return this.isDetailGrid;
  var regTest = new RegExp(this.DetailGridSuffix + "[0-9]");
  this.isDetailGrid = regTest.test(this.name);
  if(this.isDetailGrid)
   return true;
  var mainElement = this.GetMainElement();
  var parent = mainElement.parentNode;
  while(parent && parent.tagName !== "BODY") {
   this.isDetailGrid = regTest.test(parent.id);
   if(this.isDetailGrid) return true;
   parent = parent.parentNode;
  }
  return false;
 },
 PrepareCommandButtons: function(){
  if(!this.cButtonIDs || this.cButtonIDs.length == 0) return;
  for(var i = 0; i < this.cButtonIDs.length; i++){
   var name = this.cButtonIDs[i];
   if(!ASPx.GetElementById(name)) continue;
   var button = new ASPxClientButton(name);
   button.cpGVName = this.name;
   button.useSubmitBehavior = false;
   button.causesValidation = false;
   button.isNative = !!eval(ASPx.Attr.GetAttribute(button.GetMainElement(), "data-isNative"));
   button.encodeHtml = !!eval(ASPx.Attr.GetAttribute(button.GetMainElement(), "data-encodeHtml"));
   button.enabled = !ASPx.ElementContainsCssClass(button.GetMainElement(), "dxbDisabled");
   button.Click.AddHandler(this.OnCommandButtonClick.aspxBind(this));
   button.InlineInitialize();
   this.PrepareCommandButton(button);
  }
  delete this.cButtonIDs;
 },
 PrepareCommandButton: function(button) {
  if(this.allowBatchEditing) {
   this.EnsureCommandButtonClickArgs(button);
   var commandName = button.gvClickArgs && button.gvClickArgs[0][0];
   if(commandName === "UpdateEdit")
    this.updateButtonName = button.name;
   if(commandName === "CancelEdit")
    this.cancelButtonName = button.name;
  }
 },
 GetBatchEditCommandButtons: function() {
  var buttons = [];
  this.AddBatchEditCommandButton(buttons, this.cancelButtonName);
  this.AddBatchEditCommandButton(buttons, this.updateButtonName);
  return buttons;
 },
 AddBatchEditCommandButton: function(buttons, name) {
  var button = ASPx.GetControlCollection().Get(name);
  if(button)
   buttons.push(button);
 },
 EnsureCommandButtonClickArgs: function(button) {
  if(!button.gvClickArgs)
   button.gvClickArgs = eval(ASPx.Attr.GetAttribute(button.GetMainElement(), "data-args"));
 },
 OnCommandButtonClick: function(s, e){
  var mainElement = s.GetMainElement();
  if(!s.gvClickArgs)
   s.gvClickArgs = eval(ASPx.Attr.GetAttribute(mainElement, "data-args"));
  this.EnsureCommandButtonClickArgs(s);
  if(s.gvClickArgs && s.gvClickArgs.length > 1)
   this.ScheduleUserCommand(s.gvClickArgs[0], s.gvClickArgs[1], mainElement);
 },
 GetCommandButtonsInContainer: function(container) {
  var buttons = [];   
  ASPx.GetControlCollection().ProcessControlsInContainer(container, function(control){
   var isCommandButton = control.cpGVName === this.name && control.name.indexOf("DXCBtn") > -1;
   if(isCommandButton)
    buttons.push(control);
  }.bind(this));
  return buttons;
 },
 IsRecoverButton: function(button) {
  this.EnsureCommandButtonClickArgs(button);
  return button.gvClickArgs[0] && button.gvClickArgs[0][0] === "Recover" ;
 },
 CheckEndlessPagingLoadNextPage: function() {
  window.setTimeout(function() {
   var scrollHelper = this.GetScrollHelper();
   if(this.useEndlessPaging && scrollHelper)
    scrollHelper.CheckEndlessPagingLoadNextPage();
  }.aspxBind(this), 0);
 },
 EnsureRowKeys: function() {
  if(ASPx.IsExists(this.stateObject.keys))
   this.keys = this.stateObject.keys;
  if(!this.keys)
   this.keys = [ ];
 }, 
 CheckPendingEvents: function() {
  if(this.pendingEvents.length < 1)
   return;
  for(var i = 0; i < this.pendingEvents.length; i++)
   this.ScheduleRaisingEvent(this.pendingEvents[i]);
  this.pendingEvents.length = 0;
 },
 ScheduleRaisingEvent: function(eventName) {
  window.setTimeout(function() { this[eventName](); }.aspxBind(this), 0);
 },
 CreateInternalCheckBoxCollection: function() {
  if(!this.internalCheckBoxCollection)
   this.internalCheckBoxCollection = new ASPx.CheckBoxInternalCollection(this.checkBoxImageProperties, true, undefined, undefined, undefined, this.accessibilityCompliant);
  else
   this.internalCheckBoxCollection.SetImageProperties(this.checkBoxImageProperties);
  this.CompleteInternalCheckBoxCollection();
 },
 CompleteInternalCheckBoxCollection: function() {
  if(!this.IsLastCallbackProcessedAsEndless()){
   this.internalCheckBoxCollection.Clear();
   for(var i = 0; i < this.selectAllSettings.length; i++){
    var selectAllSettings = this.selectAllSettings[i];
    if(selectAllSettings === null)
     continue;
    var icbSelectAllElement = this.GetSelectAllBtn(selectAllSettings.index);
    if(ASPx.IsExistsElement(icbSelectAllElement))
     this.AddInternalCheckBoxToCollection(icbSelectAllElement, -(selectAllSettings.index + 1), !this.IsCheckBoxDisabled(icbSelectAllElement));
   }
  }
  for(var i = 0; i < this.pageRowCount; i ++) {
   var index = i + this.visibleStartIndex;
   var icbInputElement = this.GetDataRowSelBtn(index);
   if(icbInputElement) {
    var enabled = !this.IsCheckBoxDisabled(icbInputElement);
    this.AddInternalCheckBoxToCollection(icbInputElement, index, enabled);
   }
  }
 },
 IsCheckBoxDisabled: function(icbInputElement) {
  var icbMainElement = ASPx.CheckableElementHelper.Instance.GetICBMainElementByInput(icbInputElement);
  return icbMainElement.className.indexOf(this.GetDisabledCheckboxClassName()) != -1;
 },
 GetCssClassNamePrefix: function() { return ""; },
 GetDisabledCheckboxClassName: function() { return this.GetCssClassNamePrefix() + "_cd"; },
 AddInternalCheckBoxToCollection: function (icbInputElement, visibleIndex, enabled) {
  var internalCheckBox = null;
  if(this.IsLastCallbackProcessedAsEndless())
   internalCheckBox = this.internalCheckBoxCollection.Get(icbInputElement.id);
  if(internalCheckBox && internalCheckBox.inputElement != icbInputElement){
   this.internalCheckBoxCollection.Remove(icbInputElement.id);
   internalCheckBox = null;
  }
  if(!internalCheckBox)
   internalCheckBox = this.internalCheckBoxCollection.Add(icbInputElement.id, icbInputElement);
  internalCheckBox.CreateFocusDecoration(this.icbFocusedStyle);
  internalCheckBox.SetEnabled(enabled && this.GetEnabled());
  internalCheckBox.readOnly = this.readOnly;
  internalCheckBox.autoSwitchEnabled = !this.allowSelectSingleRowOnly;
  var grid = this;
  function OnCheckedChanged(s, e){
   if(!s.autoSwitchEnabled && s.GetValue() == ASPx.CheckBoxInputKey.Unchecked){
    var value = s.stateController.GetNextCheckBoxValue(s.GetValue(), s.allowGrayedByClick && s.allowGrayed);
    s.SetValue(value);
   }
   var rowCheckBox = grid.GetDataRowSelBtn(visibleIndex);
   if(grid.allowSelectSingleRowOnly)
    grid._selectAllSelBtn(false, rowCheckBox.id);
   if(!grid.RaiseInternalCheckBoxClick(visibleIndex)){
    grid.ScheduleCommand(function() { grid.SelectItem(visibleIndex, s.GetChecked()); }, true);
    grid.mainTableClickCore(e, true);
   }
  }
  function OnSelectAllCheckedChanged(s, e){
   grid.ScheduleCommand(function() {
    var index = grid.tryGetNumberFromEndOfString(s.inputElement.id).value;
    var columnSelectAllSettings = grid.GetColumnSelectAllSettings(index);
    if(!columnSelectAllSettings)
     return;
    switch(columnSelectAllSettings.mode){
     case 1:
      if(s.GetChecked())
       grid.SelectAllItemsOnPage();
      else 
       grid.UnselectAllItemsOnPage();
      break;
     case 2:
      if(s.GetChecked())
       grid.SelectItemsCore(null, true, true);
      else 
       grid.UnselectFilteredItemsCore(true);
      break;
    }
    grid.UpdateSelectAllCheckboxesState();
   }, true);
   grid.mainTableClickCore(e, true);
  }
  var checkedChangedHandler = visibleIndex < 0 ? OnSelectAllCheckedChanged : OnCheckedChanged;
  internalCheckBox.CheckedChanged.AddHandler(checkedChangedHandler);
 },
 GetColumnSelectAllSettings: function(index){
  for(var i = 0; i < this.selectAllSettings.length; i++){
   if(this.selectAllSettings[i].index == index)
    return this.selectAllSettings[i];
  }
 },
 SelectItemsCore: function(visibleIndices, selected, changedBySelectAll){
  if(!ASPx.IsExists(selected)) selected = true;
  if(!ASPx.IsExists(visibleIndices)) {
   selected = selected ? "all" : "unall";
   changedBySelectAll = ASPx.IsExists(changedBySelectAll) ? changedBySelectAll : false;
   visibleIndices = [ ];
  } else {
   changedBySelectAll = false;
   if(visibleIndices.constructor != Array)
    visibleIndices = [visibleIndices];
  }
  this.gridCallBack([ASPxClientGridViewCallbackCommand.SelectRows, selected, changedBySelectAll].concat(visibleIndices));
 },
 UnselectFilteredItemsCore: function(changedBySelectAll){
  if(!ASPx.IsExists(changedBySelectAll))
   changedBySelectAll = false;
  this.gridCallBack([ASPxClientGridViewCallbackCommand.SelectRows, "unallf", changedBySelectAll]);
 },
 AdjustControlCore: function() {
  ASPxClientControl.prototype.AdjustControlCore.call(this);
  this.UpdateScrollableControls();
  this.ApplyPostBackSyncData();
  this.AdjustPagerControls();
  this.InvalidateLayout();
 },
 NeedCollapseControlCore: function() {
  return this.HasScrolling();
 },
 InRegularCallback: function() {
  return this.InCallback() && !this.GetCallbackHelper().HasWaitedFuncCallbacks();
 },
 gridCallBack: function (args, callbackHandler) {
  this.GetCallbackHelper().SendRequest(args, callbackHandler);
 },
 gridPostBack: function(args) { 
  this.GetCallbackHelper().SendPostback(args); 
 },
 gridFuncCallBack: function(args, onCallBack) {
  this.GetCallbackHelper().SendFuncCallback(args, onCallBack);
 },
 OnCallback: function (result) {
  var html = result.html;
  this.HideFilterControlPopup();
  var isFuncCallback = html.indexOf("FB|") == 0;
  this.afterCallbackRequired = !isFuncCallback; 
  if(isFuncCallback)
   this.OnFunctionalCallback(html);
  else {
   this.UpdateStateObjectWithObject(result.stateObject);
   this.GetFilterHelper().LoadSearchEditorValueOnCallback();
   if(this.RequirePartialUpdate(html))
    this.ProcessPartialCallbackResult(html);
   else
    this.ProcessFullCallbackResult(html);
  }
 },
 RequirePartialUpdate: function(html) {
  var helper = this.GetEndlessPagingHelper();
  return html.indexOf("EP|") == 0 && helper;
 },
 ProcessPartialCallbackResult: function(result) {
  var helper = this.GetEndlessPagingHelper();
  helper.OnCallback(result);
 },
 ProcessFullCallbackResult: function(result) {
  var rootTD = this.GetGridTD();
  if(rootTD)
   ASPx.SetInnerHtml(rootTD, result);
 },
 OnFunctionalCallback: function(result){
  this.PreventCallbackAnimation();
  var result = this.ParseFuncCallbackResult(result.substr(3));
  if(!result) return;
  if(this.IsHeaderFilterFuncCallback(result.callback))
   this.OnFuncCallback(result);
  else 
   window.setTimeout(function() { this.OnFuncCallback(result); }.aspxBind(this), 0);
 },
 OnCallbackFinalized: function() {
  if(this.afterCallbackRequired)
   this.OnAfterCallback();
 },
 IsHeaderFilterFuncCallback: function(callback) {
  return callback === this.GetFilterHelper().OnHeaderFilterCallback;
 },
 ParseFuncCallbackResult: function(result) {
  var pos = result.indexOf("|");
  if(pos < 0) return;
  var index = parseInt(result.substr(0, pos), 10);
  var info = this.GetCallbackHelper().GetFuncCallBackInfo(index);
  if(info && info.callback)
   return { callback: info.callback, params: result.substr(pos + 1) };
 },
 OnFuncCallback: function(result) {
  if(result && result.callback)
   result.callback(eval(result.params));
 },
 OnCallbackErrorAfterUserHandle: function(errorMessage, data) {
  this.SetCallbackErrorData(errorMessage, data, true);
 },
 OnCallbackError: function(result, data){
  this.SetCallbackErrorData(result, data, false);
  this.SetAfterCallbackRequired();
 },
 SetAfterCallbackRequired: function() {
  if(this.GetGridTD())
   this.afterCallbackRequired = true;
 },
 SetCallbackErrorData: function(errorMessage, data, userHandled) {
  this.showingError = errorMessage;
  this.errorData = data;
  this.userHandledCallbackError = userHandled;
 },
 ShowCallbackError: function(errorText, errorData) {
  var batchEditHelper = this.GetBatchEditHelper();
  if(batchEditHelper && batchEditHelper.ShowCallbackError(errorText, errorData))
   return;
  var displayIn = this;
  var popupForm = this.GetPopupEditForm();
  if(popupForm) {
   displayIn = popupForm;
   this.ShowPopupEditForm();
  }
  this.ShowCallbackErrorCore(displayIn, errorText);
 },
 ShowCallbackErrorCore: function(displayIn, errorText) {
  var errorTextContainer = this.GetErrorTextContainer(displayIn);
  if(errorTextContainer)
   errorTextContainer.innerHTML = errorText;
  else
   ASPx.ShowErrorAlert(errorText);
 },
 GetErrorTextContainer: function(displayIn) { },
 CreateEditingErrorItem: function(visibleIndex) { },
 CancelCallbackCore: function() {
  this.RestoreCallbackSettings();
  this.AddSelectStartHandler();
  if(this.isAccessibleFilterRowMenu)
   this.AddKeyDownFilterRowButtonHandler();
  this.ResetGestureElementPosition();
  this.GetFilterHelper().OnCancelCallbackCore();
  this.keyboardLock = false;
 },
 ResetGestureElementPosition: function() {  
  if(!ASPx.GesturesHelper) return;
  var handler = ASPx.GesturesHelper.handlers[this.name];
  if(handler)
   handler.ResetGestureElementPosition();
 },
 OnBeforeCallbackOrPostBack: function() {
  this.HidePopupEditForm();
  ASPxClientGridBase.SaveActiveElementSettings(this);
 },
 OnBeforeCallback: function(command) {
  this.GetFilterHelper().OnBeforeCallback();
  this.keyboardLock = true;
  var endlessPagingHelper = this.GetEndlessPagingHelper();
  if(endlessPagingHelper)
   endlessPagingHelper.OnBeforeCallback(command);
  var scrollHelper = this.GetScrollHelper();
  if(scrollHelper)
   scrollHelper.OnBeforeCallback(command);
  var cellFocusHelper = this.GetCellFocusHelper();
  if(cellFocusHelper)
   cellFocusHelper.OnBeforeCallback();
  this.ShowLoadingElements();
  this.SaveCallbackSettings();
  this.RemoveSelectStartHandler();
  if(this.accessibilityCompliant)
   this.isAccessibleRowEditing = this.IsRowEditingCommand(command);
 },
 IsRowEditingCommand: function(command) {
  return command == ASPxClientGridViewCallbackCommand.AddNewRow || 
      command == ASPxClientGridViewCallbackCommand.StartEdit;
 },
 OnAfterCallback: function() {
  this.Invalidate();
  this.GetFilterHelper().OnAfterCallback();
  this.GetToolbarHelper().OnAfterCallback();
  var checkBoxCollectionReinitializeRequired = !this.HasCallbackError(); 
  this.ProcessGridCallbackError();
  this.pendingCommands = [ ];
  try {
   this._setFocusedItemInputValue();
   this.EnsureRowKeys();
   this.SetHeadersClientEvents();
   this.RestoreCallbackSettings();
   this.AddSelectStartHandler();
   if(this.isAccessibleFilterRowMenu)
    this.AddKeyDownFilterRowButtonHandler();
   this.EnsureRowHotTrackItems();
   if(this.kbdHelper && !this.useEndlessPaging)
    this.kbdHelper.EnsureFocusedRowVisible();
  }
  finally {
   this.keyboardLock = false;
  }
  this.CheckPendingEvents();
  this.PrepareCommandButtons();
  var endlessPagingHelper = this.GetEndlessPagingHelper();
  if(endlessPagingHelper)
   endlessPagingHelper.OnAfterCallback();
  if(this.checkBoxImageProperties && checkBoxCollectionReinitializeRequired){
   this.CreateInternalCheckBoxCollection();
   this.UpdateSelectAllCheckboxesState();
  }
  var batchEditHelper = this.GetBatchEditHelper();
  if(batchEditHelper)
   batchEditHelper.OnAfterCallback();
  var cellFocusHelper = this.GetCellFocusHelper();
  if(cellFocusHelper)
   cellFocusHelper.OnAfterCallback();
  this.CheckEndlessPagingLoadNextPage();
  window.setTimeout(function() { this.EnsureVisibleRowFromServer(); }.aspxBind(this), 0);
  if(this.isAccessibleRowEditing)
   this.HandleAccessibleFocusForEditingRow();
 },
 HasCallbackError: function() { return !!this.showingError; },
 ProcessGridCallbackError: function() {
  if(!this.HasCallbackError()) return;
  if(this.userHandledCallbackError)
   this.ProcessCallbackErrorAfterUserHandle();
  else
   this.ShowCallbackError(this.showingError, this.errorData);
  this.SetCallbackErrorData(null, null, false);
 },
 ProcessCallbackErrorAfterUserHandle: function() {
  this.ShowPopupEditForm();
 },
 SaveCallbackSettings: function() {
  this.SaveCustWindowScroll();
 },
 RestoreCallbackSettings: function() {
  this.RestoreCustWindowScroll();
  this.ApplyPostBackSyncData();
  this.ResetControlAdjustment(); 
  ASPxClientGridBase.RestoreActiveElementSettings(this); 
 },
 SaveCustWindowScroll: function() {
  var custWindow = this.GetCustomizationWindow();
  var contentContainer = custWindow && custWindow.IsVisible() && custWindow.GetContentContainer(-1);
  if(contentContainer)
   this.savedCustWindowScroll = { left: contentContainer.scrollLeft, top: contentContainer.scrollTop };
 },
 RestoreCustWindowScroll: function() {   
  var custWindow = this.GetCustomizationWindow();
  var contentContainer = custWindow && custWindow.IsVisible() && custWindow.GetContentContainer(-1);
  if(contentContainer && ASPx.IsExists(this.savedCustWindowScroll)) {
   contentContainer.scrollLeft = this.savedCustWindowScroll.left;
   contentContainer.scrollTop = this.savedCustWindowScroll.top;
  }
 },
 ShowPopupEditForm: function() {
  var popupForm = this.GetPopupEditForm();
  if(popupForm && !popupForm.IsVisible())
   popupForm.Show();
 },
 HidePopupEditForm: function() {
  var popup = this.GetPopupEditForm();
  if(popup)
   popup.Hide();
 },
 OnPopupEditFormInit: function(popup) {
  if(this.HasHorzScroll() && this.GetVisibleItemsOnPage() > 0) {
   var popupHorzOffset = popup.GetPopupHorizontalOffset();
   popup.SetPopupHorizontalOffset(popupHorzOffset - this.GetPopupEditFormHorzOffsetCorrection(popup));
  }
  popup.Show();
 },
 GetPopupEditFormHorzOffsetCorrection: function(popup) {
  return 0;
 },
 HandleAccessibleFocusForEditingRow: function() {
  var editingRow = this.GetEditingRow();
  if(!editingRow || !this.accessibilityFocusTreeLine)
   return;
  var focusElement = ASPx.FindFirstChildActionElement(editingRow, function(element) {
   return !this.IsCommandColumnItem(element);
  }.aspxBind(this));
  this.accessibilityFocusTreeLine = ASPx.RestoreFocusHelper.getTreeLineCore(this.GetMainElement(), focusElement);
  this.isAccessibleRowEditing = false;
 },
 _isRowSelected: function(visibleIndex) {
  if(!ASPx.IsExists(this.stateObject.selection)) return false;
  var index = this._getItemIndexOnPage(visibleIndex);
  return this._isTrueInCheckList(this.stateObject.selection, index);
 },
 _isTrueInCheckList: function(checkList, index) {
  if(index < 0 ||  index >= checkList.length) return false;
  return checkList.charAt(index) == "T";
 },
 _getSelectedRowCount: function() {
  return this.selectedWithoutPageRowCount + this._getSelectedRowCountOnPage();
 },
 _getSelectedRowCountOnPage: function(){
  if(!ASPx.IsExists(this.stateObject.selection))
   return 0;
  var checkList = this.stateObject.selection;
  var selCount = 0;
  for(var i = 0; i < checkList.length; i++) {
   if(checkList.charAt(i) == "T") selCount ++;
  }
  return selCount;
 },
 _selectAllRowsOnPage: function(checked) {
  if(checked && this.allowSelectSingleRowOnly) {
   this.SelectItem(0, true);
   return;
  }
  if(!ASPx.IsExists(this.stateObject.selection)) return;
  this._selectAllSelBtn(checked);
  var prevSelectedRowCount = 0;
  var isTrueInCheckList = false;
  for(var i = 0; i < this.pageRowCount; i ++) {
   isTrueInCheckList = this._isTrueInCheckList(this.stateObject.selection, i);
   if(isTrueInCheckList) prevSelectedRowCount++; 
   if(isTrueInCheckList != checked)
    this.ChangeItemStyle(i + this.visibleStartIndex, checked ? ASPxClientGridItemStyle.Selected : ASPxClientGridItemStyle.Item);
  }
  if (prevSelectedRowCount == 0 && !checked) return;
  var selValue = "";
  if(checked) {
   for(var i = 0; i < this.pageRowCount; i ++)
    selValue += this.IsDataItem(this.visibleStartIndex + i ) ? "T" : "F";
  }
  if(selValue != this.stateObject.selection) {
   this.userChangedSelection = true;
   if(selValue == "") selValue = "U";
   this.stateObject.selection = selValue;
  }
  this.DoSelectionChanged(-1, checked, true);
  this.UpdateSelectAllCheckboxesState();
 },
 SelectAllItemsOnPage: function(selected) {
  if(!ASPx.IsExists(selected)) selected = true;
  this._selectAllRowsOnPage(selected);
 },
 UnselectAllItemsOnPage: function() {
  this.SelectAllItemsOnPage(false);
 },
 DeleteGridItem: function(visibleIndex) {
  if(this.confirmDelete != "" && !confirm(this.confirmDelete)) return;
  this.DeleteItem(visibleIndex);
 },
 _selectAllSelBtn: function(checked, exceptName) {
  if(!this.checkBoxImageProperties) return;
  this.internalCheckBoxCollection.elementsMap.forEachEntry(function(key, checkBox) {
   if(key !== exceptName && checkBox.SetValue)
    checkBox.SetValue(checked ? ASPx.CheckBoxInputKey.Checked : ASPx.CheckBoxInputKey.Unchecked);
  });
 },
 doRowMultiSelect: function(row, rowIndex, evt) {
  var ctrlKey = evt.ctrlKey || evt.metaKey,
   shiftKey = evt.shiftKey;
  if((ctrlKey || shiftKey) && (!ASPx.Browser.IE || ASPx.Browser.Version > 8))
   ASPx.Selection.Clear();
  if(this.allowSelectSingleRowOnly)
   shiftKey = false;
  if(!ctrlKey && !shiftKey) {
   if(this._getSelectedRowCountOnPage() === 1 && this._isRowSelected(rowIndex))
    return;
   this._selectAllRowsOnPage(false);
   this.SelectItem(rowIndex, true);
   this.lastMultiSelectIndex = rowIndex;
  } else {
   if(ctrlKey) {
    this.SelectItem(rowIndex, !this._isRowSelected(rowIndex));
    this.lastMultiSelectIndex = rowIndex;
   } else {
    var startIndex = rowIndex > this.lastMultiSelectIndex ? this.lastMultiSelectIndex + 1 : rowIndex;
    var endIndex = rowIndex > this.lastMultiSelectIndex ? rowIndex : this.lastMultiSelectIndex - 1;
    for(var i = this.visibleStartIndex; i < this.pageRowCount + this.visibleStartIndex; i ++) {
     if(i == this.lastMultiSelectIndex) 
      continue;
     this.SelectItem(i, i >= startIndex && i <= endIndex);
    }
   }
  }
  this.UpdatePostBackSyncInput();
 },
 AddSelectStartHandler: function() {   
  if(!this.allowSelectByItemClick || !ASPx.Browser.IE || ASPx.Browser.Version > 8 )
   return;
  ASPx.Evt.AttachEventToElement(this.GetMainTable(), "selectstart", ASPxClientGridBase.SelectStartHandler);
 },
 AddKeyDownFilterRowButtonHandler: function() {
  var filterRow = this.GetFilterRow();
  if(!filterRow)
   return;
  var buttons = [];
  ASPx.GetNodesByPartialId(filterRow, this.AccessibleFilterRowButtonID, buttons);
  for(var i = 0; i < buttons.length; i++)
   ASPx.Evt.AttachEventToElement(buttons[i], "keydown", ASPx.Evt.InvokeMouseClickByKeyDown);
 },
 RemoveSelectStartHandler: function() {
  if(!this.allowSelectByItemClick || !ASPx.Browser.IE)
   return; 
  ASPx.Evt.DetachEventFromElement(this.GetMainTable(), "selectstart", ASPxClientGridBase.SelectStartHandler);
 },
 SelectItemsByKey: function(keys, selected){
  if(!ASPx.IsExists(selected)) selected = true;
  if(!ASPx.IsExists(keys)) return;
  if(keys.constructor != Array)
   keys = [keys];
  this.gridCallBack([ASPxClientGridViewCallbackCommand.SelectRowsKey, selected].concat(keys));
 },
 SelectItem: function(visibleIndex, checked, fromCheckBox) {
  if(!this.IsPossibleSelectItem(visibleIndex, checked)) return;
  if(ASPx.IsExists(fromCheckBox)) fromCheckBox = false;
  var index = this._getItemIndexOnPage(visibleIndex);
  if(index < 0) return;
  if(checked && this.allowSelectSingleRowOnly)
   this._selectAllRowsOnPage(false);
  if(ASPx.IsExists(this.stateObject.selection)) {
   this.userChangedSelection = true;
   var checkList = this.stateObject.selection;
   if(index >= checkList.length) {
    if(!checked) return;
    for(var i = checkList.length; i <= index; i ++)
     checkList += "F";
   }
   checkList = checkList.substr(0, index) + (checked ? "T" : "F") + checkList.substr(index + 1, checkList.length - index - 1);
   if(checkList.indexOf("T") < 0) checkList = "U";
   this.stateObject.selection = checkList;
  }
  this.selectItemCheckbox(visibleIndex, checked);
  this.UpdateSelectAllCheckboxesState();
  this.ChangeItemStyle(visibleIndex, checked ? ASPxClientGridItemStyle.Selected : ASPxClientGridItemStyle.Item);
  this.DoSelectionChanged(visibleIndex, checked, false);
 },
 selectItemCheckbox: function(visibleIndex, checked) {
  var checkBox = this.GetDataRowSelBtn(visibleIndex);
  if(checkBox) {
   var internalCheckBox = this.internalCheckBoxCollection.Get(checkBox.id);
   if(internalCheckBox)
    internalCheckBox.SetValue(checked ? ASPx.CheckBoxInputKey.Checked : ASPx.CheckBoxInputKey.Unchecked);
  }
 },
 IsPossibleSelectItem: function(visibleIndex, newSelectedValue){
  if(this.IsBatchEditDeletedItem(visibleIndex))
   return false;
  return visibleIndex > -1 && this._isRowSelected(visibleIndex) != newSelectedValue;
 },
 UpdateSelectAllCheckboxesState: function(){
  if(!this.selectAllSettings)
   return;
  for(var i = 0; i < this.selectAllSettings.length; i++){
   var columnSelectAllSettings = this.selectAllSettings[i];
   if(columnSelectAllSettings === null)
    continue;
   var selectAllButtonInput = this.GetSelectAllBtn(columnSelectAllSettings.index);
   if(selectAllButtonInput && !this.IsCheckBoxDisabled(selectAllButtonInput))
    this.UpdateSelectAllCheckboxStateCore(selectAllButtonInput, columnSelectAllSettings.mode);
  }
 },
 UpdateSelectAllCheckboxStateCore: function(selectAllButtonInput, selectMode){
  var value = ASPx.CheckBoxInputKey.Indeterminate;
  var selectedRowCountOnPage = this.GetSelectedKeysOnPage().length;
  var considerSelectionOnPages = selectMode == 2 && this.selectAllBtnStateWithoutPage !== null;
  if(this.GetDataItemCountOnPage() == selectedRowCountOnPage && (!considerSelectionOnPages || this.selectAllBtnStateWithoutPage == ASPx.CheckBoxInputKey.Checked))
   value = ASPx.CheckBoxInputKey.Checked;
  else if(selectedRowCountOnPage == 0 && (!considerSelectionOnPages || this.selectAllBtnStateWithoutPage == ASPx.CheckBoxInputKey.Unchecked))
   value = ASPx.CheckBoxInputKey.Unchecked;
  var selectAllCheckBoxInst = this.internalCheckBoxCollection.Get(selectAllButtonInput.id);
  selectAllCheckBoxInst.SetValue(value);
 },
 GetDataItemCountOnPage: function(){
  return this.pageRowCount;
 },
 ScheduleUserCommand: function(args, postponed, eventSource) {
  if(!args || args.length == 0) 
   return;
  var commandName = args[0];
  var rowCommands = this.GetUserCommandNamesForRow();
  if((this.useEndlessPaging || this.allowBatchEditing) && ASPx.Data.ArrayIndexOf(rowCommands, commandName) > -1)
   args[args.length - 1] = this.FindParentRowVisibleIndex(eventSource, true);
  postponed &= this.IsMainTableChildElement(eventSource);
  this.ScheduleCommand(args, postponed);
 },
 GetUserCommandNamesForRow: function() { return [ "CustomButton", "Select", "StartEdit", "Delete", "Recover" ]; },
 IsMainTableChildElement: function(src) { return true; },
 FindParentRowVisibleIndex: function(element, dataAndGroupOnly) {
  var regEx = this.GetItemVisibleIndexRegExp(dataAndGroupOnly);
  var editingRow = this.GetEditingRow();
  while(element) {
   if(element.tagName === "BODY" || element.id == this.name)
    return -1;
   var matches = regEx.exec(element.id);
   if(matches && matches.length == 3)
    return parseInt(matches[2]);
   if(element === editingRow)
    return this.editItemVisibleIndex;
   element = element.parentNode;
  }
  return -1;
 },
 GetItemVisibleIndexRegExp: function(dataAndGroupOnly) {
  return this.GetItemVisibleIndexRegExpByIdParts();
 },
 GetItemVisibleIndexRegExpByIdParts: function(idParts){
  if(!idParts) idParts = [ ];
  return new RegExp("^(" + this.name + "_(?:" + idParts.join("|") + "))(-?\\d+)(?:_\\d+)?$");
 },
 ScheduleCommand: function(args, postponed) {
  if(postponed)
   this.pendingCommands.push(args);
  else 
   this.PerformScheduledCommand(args);
 },
 PerformScheduledCommand: function(args) {
  if(ASPx.IsFunction(args)) {
   args(); 
   return;
  }
  if(args && args.length > 0) {
   var commandName = "UA_" + args[0];
   if(this[commandName])
    this[commandName].apply(this, args.slice(1));
  }
 },
 PerformPendingCommands: function() {
  var commandCount = this.pendingCommands.length;
  for(var i = 0; i < commandCount; i++)
   this.PerformScheduledCommand(this.pendingCommands.pop());
 },
 getItemByHtmlEvent: function(evt) { return null; },
 getItemByHtmlEventCore: function(evt, partialID) {
  var item = ASPx.GetParentByPartialId(ASPx.Evt.GetEventSource(evt), partialID);
  if(item && item.id.indexOf(this.name) > -1)
   return item;
  return null;
 },
 NeedProcessTableClick: function(evt) {
  var mainTable = ASPx.GetParentByPartialId(ASPx.Evt.GetEventSource(evt), this.MainTableID);
  if(mainTable) {
   var mainTableID = mainTable.id;
   var gridID = mainTableID.substr(0, mainTableID.length - this.MainTableID.length - 1);
   return this.name == gridID;
  }
  return false;
 },
 mainTableClick: function(evt) { this.mainTableClickCore(evt); },
 mainTableDblClick: function(evt) { 
  var item = this.getItemByHtmlEvent(evt);
  if(!item) return;
  var forceItemDblClickEvent = true;
  var itemIndex = this.getItemIndex(item.id);
  var batchEditHelper = this.GetBatchEditHelper();
  if(batchEditHelper){
   batchEditHelper.ProcessTableClick(item, ASPx.Evt.GetEventSource(evt), true);
   forceItemDblClickEvent = batchEditHelper.editRowVisibleIndex != itemIndex;
  }
  if(forceItemDblClickEvent)
   this.RaiseItemDblClick(itemIndex, evt);
 },
 mainTableClickCore: function(evt, fromCheckBox) {
  if(this.kbdHelper)
   this.kbdHelper.HandleClick(evt);
  var sendNotificationCallback = true;
  this.mainTableClickData.processing = true;
  try {
   this.ProcessTableClick(evt, fromCheckBox);
   var callbackHelper = this.GetCallbackHelper();
   var savedRequestCount = callbackHelper.GetTotalRequestCount();
   this.PerformPendingCommands();
   var currentRequestCount = callbackHelper.GetTotalRequestCount();
   sendNotificationCallback = currentRequestCount === savedRequestCount;
  } finally {
   if(sendNotificationCallback)
    if(this.mainTableClickData.focusChanged && !this.mainTableClickData.selectionChanged) {
     this.gridCallBack([ASPxClientGridViewCallbackCommand.FocusedRow]);
    } else if(this.mainTableClickData.selectionChanged) {
     this.gridCallBack([ASPxClientGridViewCallbackCommand.Selection]);
    }
   this.mainTableClickData.processing = false;
   this.mainTableClickData.focusChanged = false;
   this.mainTableClickData.selectionChanged = false;
  }
 },
 ProcessTableClick: function(evt, fromCheckBox) {
  var source = ASPx.Evt.GetEventSource(evt);
  var item = this.getItemByHtmlEvent(evt);
  if(item) {
   var itemIndex = this.getItemIndex(item.id);
   var isCommandColumnItem = this.IsCommandColumnItem(source);
   if(!isCommandColumnItem && !fromCheckBox) {
    var batchEditHelper = this.GetBatchEditHelper();
    if(batchEditHelper && batchEditHelper.ProcessTableClick(item, source))
     return;
    if(this.RaiseItemClick(itemIndex, evt)) 
     return;
   }
   var prevFocusedItemIndex = this._getFocusedItemIndex();
   this.TryFocusItem(itemIndex, evt);
   if(this.allowSelectByItemClick) {
    if(!this.testActionElement(source) && !isCommandColumnItem && !fromCheckBox) {
     if(this.lookupBehavior){
      var checked = this.allowSelectSingleRowOnly || !this._isRowSelected(itemIndex);
      this.SelectItem(itemIndex, checked);
     } else {
      var indexCorrection = 0;
      if(this.lastMultiSelectIndex < 0 && prevFocusedItemIndex > -1) {
       if(evt.shiftKey && itemIndex != prevFocusedItemIndex && !this._isRowSelected(prevFocusedItemIndex))
        indexCorrection = itemIndex > prevFocusedItemIndex ? -1 : 1;
       this.lastMultiSelectIndex = prevFocusedItemIndex + indexCorrection;
      }
      this.doRowMultiSelect(item, itemIndex, evt);
      this.lastMultiSelectIndex -= indexCorrection;
     }
    }
   } else {
    this.lastMultiSelectIndex = itemIndex;
   }
  }
 },
 testActionElement: function(element) {
  return element && element.tagName.match(/input|select|textarea|^a$/i);
 },
 IsCommandColumnItem: function(element) {
  if(!element)
   return false;
  if(ASPx.ElementHasCssClass(element, this.CommandColumnItemClassName))
   return true;
  var parent = ASPx.GetParentByPartialId(element,"DXCBtn");
  var elementId = parent && parent.id;
  return ASPx.IsExists(elementId) && elementId.indexOf(this.name) > -1;
 },
 OnFocusedCellChanged: function(visibleIndex) {
  this._setFocusedItemIndex(visibleIndex);
  if(!this.allowFocusedRow)
   this.ChangeToolbarItemsEnabling();
 },
 TryFocusItem: function(visibleIndex, htmlEvent) {
  if(this.allowFocusedRow && visibleIndex >= 0 && visibleIndex !== this.focusedRowIndex && !this.IsBatchEditDeletedItem(visibleIndex)) {
   var isCanceledByUser = this.RaiseItemFocusing(visibleIndex, htmlEvent);
   if(!isCanceledByUser) {
    this._setFocusedItemIndex(visibleIndex);
    return true;
   }
  }
  return false;
 },
 _setFocusedItemIndex: function(visibleIndex) {
  if(visibleIndex < 0) 
   visibleIndex = -1;
  if(!this.allowFocusedRow || visibleIndex == this.focusedRowIndex || this.IsBatchEditDeletedItem(visibleIndex)) 
   return;
  var oldIndex = this.focusedRowIndex;
  this.focusedRowIndex = visibleIndex;
  this.ChangeFocusedItemStyle(oldIndex, false);
  this.ChangeFocusedItemStyle(this.focusedRowIndex, true);
  this._setFocusedItemInputValue();
  if(this.callbackOnFocusedRowChanged) {
   this.UpdatePostBackSyncInput(true);
   if(!this.mainTableClickData.processing) {
    this.gridCallBack([ASPxClientGridViewCallbackCommand.FocusedRow]);
   } else {
    this.mainTableClickData.focusChanged = true;
   }
   return;
  }
  this.ChangeToolbarItemsEnabling();
  this.RaiseFocusedItemChanged();
 },
 ChangeToolbarItemsEnabling: function(){
  var helper = this.GetToolbarHelper();
  helper.RefreshItemsState();
 },
 ChangeToolbarUpdateEditItemsEnabling: function(enabled) {
  var helper = this.GetToolbarHelper();
  helper.OnUpdateEditEnabledChanged(enabled);
 },
 ChangeFocusedItemStyle: function(visibleIndex, focused) {
  if(visibleIndex < 0) return;
  var itemStyle = this.GetFocusedItemStyle(visibleIndex, focused);
  this.ChangeItemStyle(visibleIndex, itemStyle);
 },
 GetFocusedItemStyle: function(visibleIndex, focused){
  if(focused)
   return ASPxClientGridItemStyle.FocusedItem;
  return this._isRowSelected(visibleIndex) ? ASPxClientGridItemStyle.Selected : ASPxClientGridItemStyle.Item;
 },
 GetFocusedCell: function() {
  var cellFocusHelper = this.GetCellFocusHelper();
  return cellFocusHelper &&  cellFocusHelper.GetFocusedCell();
 },
 SetFocusedCell: function(itemIndex, columnIndex) {
  var cellFocusHelper = this.GetCellFocusHelper();
  if(cellFocusHelper) 
   cellFocusHelper.SetFocusedCell(itemIndex, columnIndex);
 },
 _setFocusedItemInputValue: function() {
  if(ASPx.IsExists(this.stateObject.focusedRow)) 
   this.stateObject.focusedRow = this.focusedRowIndex;
 },
 _getFocusedItemIndex: function() {
  if(!this.allowFocusedRow) return -1;
  return this.focusedRowIndex;
 },
 getItemIndex: function(rowId) {   
  return this.tryGetNumberFromEndOfString(rowId).value;
 },
 tryGetNumberFromEndOfString: function(str) {
  var value = -1;
  var success = false;
  var n = str.length - 1;
  while(n >= 0 && !isNaN(parseInt(str.substr(n), 10))) {
   value = parseInt(str.substr(n), 10);
   success = true;
   n--;
  }
  return { success: success, value: value };
 },
 GetSelectedState: function() {
  if(!this.userChangedSelection) return null;
  if(!ASPx.IsExists(this.stateObject.selection)) return null;
  return this.stateObject.selection;
 },
 GetKeyValues: function() {
  return ASPx.Json.ToJson(this.stateObject.keys);
 },
 UpdateItemsStyle: function() {
  var start = this.GetTopVisibleIndex();
  var end = start + this.GetVisibleItemsOnPage();
  for(var i = start; i < end; i++) 
   this.UpdateItemStyle(i, this.GetItemStyle(i));
 },
 UpdateItemStyle: function(visibleIndex) {
  this.ChangeItemStyle(visibleIndex, this.GetItemStyle(visibleIndex));
 },
 GetItemStyle: function(visibleIndex){
  var style = ASPxClientGridItemStyle.Item;
  if(this.IsBatchEditDeletedItem(visibleIndex))
   style = ASPxClientGridItemStyle.BatchEditDeletedItem;
  else if(this.allowFocusedRow && this._getFocusedItemIndex() == visibleIndex)
   style = ASPxClientGridItemStyle.FocusedItem;
  else if(this._isRowSelected(visibleIndex))
   style = ASPxClientGridItemStyle.Selected;
  return style;
 },
 ChangeItemStyle: function(visibleIndex, rowStyle) {
  if(!this.RequireChangeItemStyle(visibleIndex, rowStyle))
   return;
  var styleInfo = this.getItemStyleInfo(rowStyle);
  this.ApplyItemStyle(visibleIndex, styleInfo);
  var batchEditHelper = this.GetBatchEditHelper();
  if(batchEditHelper)
   batchEditHelper.OnItemStyleChanged(visibleIndex, rowStyle);
 },
 ApplyItemStyle: function(visibleIndex, styleInfo) {
  var item = this.GetItem(visibleIndex);
  this.ApplyElementStyle(item, styleInfo);
 },
 ApplyElementStyle: function(element, styleInfo){
  if(!element) return;
  if(!ASPx.IsExists(element.initialClassName))
   element.initialClassName = element.className;
  if(!ASPx.IsExists(element.initialCssText))
   element.initialCssText = element.style.cssText;
  element.className = element.initialClassName;
  element.style.cssText = element.initialCssText;
  if(styleInfo) {
   element.className += " " + styleInfo.css;
   element.style.cssText += " " + styleInfo.style;
  }
 },
 RequireChangeItemStyle: function(visibleIndex, itemStyle){
  var focusedIndex = this._getFocusedItemIndex();
  if(focusedIndex > -1 && focusedIndex == visibleIndex && itemStyle != ASPxClientGridItemStyle.FocusedItem && itemStyle != ASPxClientGridItemStyle.FocusedGroupItem)
   return false;
  return !!this.GetItem(visibleIndex);
 },
 _getItemIndexOnPage: function(visibleIndex) { 
  return visibleIndex - this.visibleStartIndex; 
 },
 getColumnIndex: function(colId) {
  if(this.IsEmptyHeaderID(colId))
   return -1;
  var index = this.tryGetNumberFromEndOfString(colId).value;
  var postfix = "col" + index;
  if(colId.lastIndexOf(postfix) == colId.length - postfix.length)
   return index;
  return -1;
 },
 getColumnObject: function(colId) {
  var index = this.getColumnIndex(colId);
  return index > -1 ? this._getColumn(index) : null;
 },
 _getColumnIndexByColumnArgs: function(column) {
  column = this._getColumnObjectByArg(column);
  if(!column) return null;
  return column.index;
 },
 _getColumnObjectByArg: function(arg) {
  if(!ASPx.IsExists(arg)) return null;
  if(typeof(arg) == "number") return this._getColumn(arg);
  if(ASPx.IsExists(arg.index)) return arg;
  var column = this._getColumnById(arg);
  if(column) return column;
  return this._getColumnByField(arg);  
 },
 _getColumnCount: function() { return this.columns.length; },
 _getColumn: function(index) {
  for(var i = 0; i < this.columns.length; i++){
   if(this.columns[i].index == index) return this.columns[i];
  }
  return null;
 },
 _getColumnById: function(id) {
  if(!ASPx.IsExists(id)) return null;
  for(var i = 0; i < this.columns.length; i++) {
   if(this.columns[i].id == id) return this.columns[i];
  }
  return null;
 },
 _getColumnByField: function(fieldName) {
  if(!ASPx.IsExists(fieldName)) return null;
  for(var i = 0; i < this.columns.length; i++) {
   if(this.columns[i].fieldName == fieldName) return this.columns[i];
  }
  return null;
 },
 getItemStyleInfo: function(itemStyleType, columnIndex) {
  if(!this.styleInfo) return;
  if(ASPx.IsExists(columnIndex)) {
   var key = itemStyleType + columnIndex;
   if(this.styleInfo.hasOwnProperty(key))
    return this.styleInfo[key];
  }
  return this.styleInfo[itemStyleType];
 },
 DoSelectionChanged: function(index, isSelected, isSelectAllOnPage){
  if(this.callbackOnSelectionChanged) {
   this.UpdatePostBackSyncInput(true);
   if(!this.mainTableClickData.processing) {
    this.gridCallBack([ASPxClientGridViewCallbackCommand.Selection]);
   } else {
    this.mainTableClickData.selectionChanged = true;
   }
   return;
  }
  this.ChangeToolbarItemsEnabling();
  this.RaiseSelectionChanged(index, isSelected, isSelectAllOnPage, false);
 },
 CommandCustomButton:function(id, index) {
  var processOnServer = true;
  if(!this.CustomButtonClick.IsEmpty()) {
   var e = this.CreateCommandCustomButtonEventArgs(index, id);
   this.CustomButtonClick.FireEvent(this, e);
   processOnServer = e.processOnServer;
  }
  if(processOnServer)
   this.gridCallBack([ASPxClientGridViewCallbackCommand.CustomButton, id, index]);
 },
 CreateCommandCustomButtonEventArgs: function(index, id){
  return null;
 },
 HeaderMouseDown: function(element, e){
  if(!ASPx.Evt.IsLeftButtonPressed(e)) 
   return;
  var source = ASPx.Evt.GetEventSource(e);
  if(this.isHeaderFilterButton(source))
   return;
  if(this.TryStartColumnResizing(e, element))
   return;
  var canDrag = this.canDragColumn(element) && source.tagName != "IMG";
  var dragHelper = this.GetDragHelper();
  var drag = dragHelper.CreateDrag(e, element, canDrag);
  if(!canDrag && (e.shiftKey || e.ctrlKey))
   drag.clearSelectionOnce = true;
  dragHelper.CreateTargets(drag, e);
 },
 isHeaderFilterButton: function(el) {
  return ASPx.ElementContainsCssClass(ASPx.getSpriteMainElement(el), this.HeaderFilterButtonClassName);
 },
 TryStartColumnResizing: function(e, headerCell) {
  return false;
 }, 
 OnParentRowMouseEnter: function(element) {
  if(this.GetParentRowsWindow() == null) return;
  if(this.GetParentRowsWindow().IsWindowVisible()) return;
  this.ParentRowsTimerId = window.setTimeout(function() {
   var gv = ASPx.GetControlCollection().Get(this.name);
   if(gv)
    gv.OnParentRowsTimer(element.id);
  }.aspxBind(this), 500);
 },
 OnParentRowsTimer: function(rowId) {
  var element = ASPx.GetElementById(rowId);
  if(element)
   this.ShowParentRows(element);
 },
 OnParentRowMouseLeave: function(evt) {
  ASPx.Timer.ClearTimer(this.ParentRowsTimerId);
  if(this.GetParentRowsWindow() == null) return;
  if(evt && evt.toElement) {
   if(ASPx.GetParentByPartialId(evt.toElement, this.GetParentRowsWindow().name) != null)
    return;
  }
  this.HideParentRows();
 },
 ShowParentRows: function(element) {
  this.ParentRowsTimerId = null;
  if(this.GetParentRowsWindow() != null) {
   this.GetParentRowsWindow().ShowAtElement(element);
  }
 },
 HideParentRows: function() {
  this.ParentRowsTimerId = null;
  if(this.GetParentRowsWindow() != null) {
   this.GetParentRowsWindow().Hide();
  }
 }, 
 canSortByColumn: function(headerElement) {
  return this.getColumnObject(headerElement.id).allowSort;
 },
 canGroupByColumn: function(headerElement) {
  return false;
 },
 canDragColumn: function(headerElement) {
  return false;
 },
 doPagerOnClick: function(id) {
  if(!ASPx.IsExists(id)) return;
  this.gridCallBack([ASPxClientGridViewCallbackCommand.PagerOnClick, id]);
 },
 CanHandleGesture: function(evt) {
  var source = ASPx.Evt.GetEventSource(evt);
  var table = this.GetMainTable();
  if(!table) return false;
  if(ASPx.GetIsParent(table, source))
   return !this.NeedPreventGestures(source, table);
  if(table.parentNode.tagName == "DIV" && ASPx.GetIsParent(table.parentNode, source))
   return ASPx.Browser.TouchUI || evt.offsetX < table.parentNode.clientWidth;
  return false;
 },
 AllowStartGesture: function() {
  return ASPxClientControl.prototype.AllowStartGesture.call(this) && 
   (this.AllowExecutePagerGesture(this.pageIndex, this.pageCount, 1) || this.AllowExecutePagerGesture(this.pageIndex, this.pageCount, -1));
 },
 AllowExecuteGesture: function(value) {
  return this.AllowExecutePagerGesture(this.pageIndex, this.pageCount, value);
 },
 ExecuteGesture: function(value, count) {
  this.ExecutePagerGesture(this.pageIndex, this.pageCount, value, count, function(arg) { this.doPagerOnClick(arg); }.aspxBind(this));
 },
 ApplySearchPanelFilter: function(value, isInternalCall) {
  if(!ASPx.IsExists(value))
   value = "";
  var edit = this.GetSearchEditor();
  if(edit && !isInternalCall)
   edit.SetText(value);
  var scrollHelper = this.GetScrollHelper();
  if(scrollHelper)
   scrollHelper.ResetScrollTop();
  this.gridCallBack([ASPxClientGridViewCallbackCommand.ApplySearchPanelFilter, value]);
 },
 NeedShowLoadingPanelInsideEndlessPagingContainer: function() {
  var endlessPagingHelper = this.GetEndlessPagingHelper();
  return endlessPagingHelper && endlessPagingHelper.NeedShowLoadingPanelAtBottom();
 },
 ShowLoadingPanel: function() {
  var gridMainCell = this.GetGridTD();
  if(!gridMainCell)
   return;
  if(this.NeedShowLoadingPanelInsideEndlessPagingContainer()) {
   var container = this.GetEndlessPagingLPContainer();
   ASPx.SetElementDisplay(container, true);
   this.CreateLoadingPanelWithoutBordersInsideContainer(container);
   return;
  }
  var lpContainer = this.GetLoadingPanelContainer();
  if(lpContainer)
   this.CreateLoadingPanelInline(lpContainer);
  else
   this.CreateLoadingPanelWithAbsolutePosition(gridMainCell, this.GetLoadingPanelOffsetElement(gridMainCell));
 },
 ShowLoadingDiv: function () {
  if(!this.NeedShowLoadingPanelInsideEndlessPagingContainer())
   this.CreateLoadingDiv(this.GetGridTD());
 },
 ShowLoadingPanelInsideHeaderFilterPopup: function() {
  this.CreateLoadingPanelWithoutBordersInsideContainer(this.GetHeaderFilterPopup().GetContentContainer(-1));
 },
 GetCallbackAnimationElement: function() {
  var table = this.GetMainTable();
  if(table && table.parentNode && table.parentNode.tagName == "DIV")
   return table.parentNode;
  return table;
 },
 NeedPreventTouchUIMouseScrolling: function(element) {
  return this.NeedPreventGestures(element);
 },
 NeedPreventGestures: function(element, mainElement) {
  if(!ASPx.IsExists(mainElement)) {
   mainElement = this.GetMainElement();
   if(!ASPx.IsExists(mainElement) || !ASPx.GetIsParent(mainElement, element))
    return false;
  }
  var preventElement = this.IsHeaderChild(element) || this.IsActionElement(mainElement, element);
  if(preventElement)
   return true;
  return this.pageCount <= 1 ? !ASPx.Browser.MSTouchUI : false;
 },
 IsHeaderChild: function(source) {
  return false;
 },
 IsActionElement: function(mainElement, source) {
  return false;
 },
 _updateEdit: function() {
  var batchEditHelper = this.GetBatchEditHelper();
  if(batchEditHelper && !batchEditHelper.CanUpdate())
   return;
  if(!batchEditHelper && !this._validateEditors())
   return;
  if(batchEditHelper)
   batchEditHelper.OnUpdate();
  this.gridCallBack([ASPxClientGridViewCallbackCommand.UpdateEdit]);
 },
 _validateEditors: function() {
  var editors = this._getEditors();
  var isValid = true;
  if(editors.length > 0)
   isValid &= this._validate(editors);
  if(window.ASPxClientEdit)
   isValid &= ASPxClientEdit.ValidateEditorsInContainer(this.GetEditFormTable(), this.name);
  return isValid;
 },
 _validate: function(list) {
  var isValid = true;
  var firstInvalid = null;
  var edit;
  for(var i = 0; i < list.length; i ++) {
   edit = list[i];
   edit.Validate();
   isValid = edit.GetIsValid() && isValid;
   if(firstInvalid == null && edit.setFocusOnError && !edit.GetIsValid())
    firstInvalid = edit;
  }
  if (firstInvalid != null)
   firstInvalid.Focus();
  return isValid;
 },
 _getEditors: function() {
  var list = [ ];
  for(var i = 0; i < this.editorIDList.length; i++) {
   var editor = ASPx.GetControlCollection().Get(this.editorIDList[i]);
   if(editor && editor.enabled && editor.GetMainElement && ASPx.IsExistsElement(editor.GetMainElement())) {
    if(!editor.Validate || this.IsStaticBinaryImageEditor(editor)) 
     continue; 
    list.push(editor);
   }
  }
  return list;
 },
 GetEditorValues: function() {
  if(this.allowBatchEditing) return null;
  var list = this._getEditors();
  if(list.length == 0) return null;
  var res = list.length + ";";
  for(var i = 0; i < list.length; i ++) {
   res += this.GetEditorValue(list[i]);
  }
  return res;
 },
 GetEditorValue: function(editor) {
  var value = editor.GetValueString();
  var valueLength = -1;
  if(!ASPx.IsExists(value)) {
   value = "";
  } else {
   value = value.toString();
   valueLength = value.length;
  }
  return this.GetEditorIndex(editor.name) + "," + valueLength + "," + value + ";";
 },
 GetEditorIndex: function(editorId) {
  var i = editorId.lastIndexOf(this.GetEditorPrefix());
  if(i < 0) return -1;
  var result = editorId.substr(i + this.GetEditorPrefix().length);
  i = result.indexOf('_'); 
  return i > 0
   ? result.substr(0, i)
   : result;
 },
 GetBatchEditHelper: function() {
  if(!this.allowBatchEditing) return null;
  if(!this.batchEditHelper)
   this.batchEditHelper = this.CreateBatchEditHelper();
  return this.batchEditHelper;
 },
 CreateBatchEditHelper: function() { },
 GetScrollHelper: function() { return null; },
 GetDragHelper: function() {
  if(!this.dragHelper)
   this.dragHelper = new GridViewDragHelper(this);
  return this.dragHelper;
 },
 GetEndlessPagingHelper: function() {
  if(!this.useEndlessPaging) return null;
  if(!this.endlessPagingHelper)
   this.endlessPagingHelper = this.CreateEndlessPagingHelper();
  return this.endlessPagingHelper;
 },
 CreateEndlessPagingHelper: function() { return null; },
 GetCellFocusHelper: function() {
  if(!this.allowFocusedCell) return null;
  if(!this.cellFocusHelper)
   this.cellFocusHelper = this.CreateCellFocusHelper();
  return this.cellFocusHelper;
 },
 CreateCellFocusHelper: function() { return null; },
 GetCellStyleManager: function() {
  if(!this.cellStyleManager)
   this.cellStyleManager = this.CreateCellStyleManager(this);
  return this.cellStyleManager;
 },
 CreateCellStyleManager: function() { return new GridCellStyleManager(this); },
 GetLayoutHelper: function() {
  if(!this.layoutHelper)
   this.layoutHelper = this.CreateLayoutHelper();
  return this.layoutHelper;
 },
 CreateLayoutHelper: function() { return new GridLayoutHelper(this); },
 GetNavigationHelper: function() {
  if(!this.navigationHelper)
   this.navigationHelper = this.CreateNavigationHelper();
  return this.navigationHelper;
 },
 CreateNavigationHelper: function() { },
 GetCallbackHelper: function() {
  if(!this.callbackHelper)
   this.callbackHelper = this.CreateCallbackHelper();
  return this.callbackHelper;
 },
 CreateCallbackHelper: function() { return new GridCallbackHelper(this); },
 GetFilterHelper: function() {
  if(!this.filterHelper)
   this.filterHelper = this.CreateFilterHelper();
  return this.filterHelper;
 },
 CreateFilterHelper: function() { return new ASPx.GridFilterHelper(this); },
 GetToolbarHelper: function() {
  if(!this.toolbarHelper)
   this.toolbarHelper = this.CreateToolbarHelper();
  return this.toolbarHelper;
 },
 CreateToolbarHelper: function() { return new ASPx.GridToolbarHelper(this); },
 Invalidate: function() {
  this.InvalidateLayout();
 },
 InvalidateLayout: function() {
  this.GetLayoutHelper().Invalidate();
  var navigationHelper = this.GetNavigationHelper();
  if(navigationHelper)
   navigationHelper.Invalidate();
 },
 IsLastCallbackProcessedAsEndless: function() {
  var helper = this.GetEndlessPagingHelper();
  return helper && helper.endlessCallbackComplete;
 },
 UpdateScrollableControls: function() {
  var helper = this.GetScrollHelper();
  if(helper)
   helper.Update();
 },
 SetHeight: function(height) {
  var mainElemnt = this.GetMainElement();
  if(!ASPx.IsExistsElement(mainElemnt)) return;
  var scrollHelper = this.GetScrollHelper();
  if(scrollHelper)
   scrollHelper.SetHeight(height);
 },
 SetHeadersClientEvents: function() {
  var grid = this;
  var attachMouseDown = function(headerCell) { 
   ASPx.Evt.AttachEventToElement(headerCell, ASPx.TouchUIHelper.touchMouseDownEventName, function(e) { 
    grid.HeaderMouseDown(headerCell, e);
   }, true);
  };
  this.AttachEventToHeaderCells(attachMouseDown, false);
  this.AttachEventToHeaderCells(attachMouseDown, true);
  this.AttachEventToCustomizationWindowHeaderCells(attachMouseDown);
 },
 AttachEventToCustomizationWindowHeaderCells: function(attachFunc) {
  var custWindow = this.GetCustomizationWindowElement();
  if(!custWindow) return;
  var headers = this.GetCustomizationWindowHeaders();
  for(var i = 0; i < headers.length; i++)
   attachFunc(headers[i]);
 },
 AttachEventToHeaderCells: function(attachFunc, inGroupPanel) {
  for(var i = 0; i < this.columns.length; i++) {
   var header = this.GetHeader(this.columns[i].index, inGroupPanel);
   if(header) 
    attachFunc(header);
  }
 },
 GetCustomizationWindowHeaders: function() {
  return ASPx.GetNodesByPartialClassName(this.GetCustomizationWindowElement(), ASPx.GridViewConsts.HeaderCellCssClass);
 },
 UpdatePostBackSyncInput: function(isChangedNotification) {
  if(!ASPx.IsExists(this.stateObject.lastMultiSelectIndex)) return;
  var selectedIndex = isChangedNotification ? -1 : this.lastMultiSelectIndex; 
  this.stateObject.lastMultiSelectIndex = selectedIndex;
 },
 ApplyPostBackSyncData: function() {
  if(!ASPx.IsExists(this.stateObject.lastMultiSelectIndex)) return;
  this.lastMultiSelectIndex = this.stateObject.lastMultiSelectIndex;
 },
 EnsureVisibleRowFromServer: function() {
  if(this.scrollToRowIndex < 0) return;
  this.MakeRowVisible(this.scrollToRowIndex);
  this.scrollToRowIndex = -1;
 },
 EnsureRowHotTrackItems: function() {
  if(this.rowHotTrackStyle == null) 
   return;
  var list = [ ];
  var rowIndices = this.GetRowHotTrackItemsRowIndices();
  for(var i = rowIndices.start; i < rowIndices.start + rowIndices.end; i++)
   list.push(this.GetDataItemIDPrefix() + i);
  if(list.length > 0)
   ASPx.AddHoverItems(this.name, [ [ [this.rowHotTrackStyle[0]], [this.rowHotTrackStyle[1]],  list, this.GetHotTrackItemPostfixes() ] ]);
 },
 GetHotTrackItemPostfixes: function(){ return null; },
 GetRowHotTrackItemsRowIndices: function() {
  return {
   start: this.visibleStartIndex,
   end: this.pageRowCount
  };
 },
 GetFooterCellIndex: function(element) {
  element = this.GetFooterCellElement(element, ASPx.GridViewConsts.FooterRowID);
  if(element == null)
   return -1;
  var matrix = this.GetHeaderMatrix();
  var leafIndex = element.cellIndex - this.GetFooterIndentCount(element.parentNode);
  var index = matrix.GetLeafIndices()[leafIndex];
  return ASPx.IsExists(index) ? index : -1;
 },
 GetGroupFooterCellIndex: function(element) {
  element = this.GetFooterCellElement(element, ASPx.GridViewConsts.GroupFooterRowID);
  return element != null ? this.GetColumnIndexByDataCell(element) : -1;
 },
 GetColumnIndexByDataCell: function(element) {
  return -1;
 },
 GetFooterCellElement: function(element, footerRowID) {
  var footerRowName = this.name + "_" + footerRowID;
  while(element.parentNode.id.indexOf(footerRowName) === -1) {
   if(element.tagName == "BODY")
    return null;
   element = element.parentElement;
  }
  return element;
 },
 GetFooterIndentCount: function(footerElement) {
  return ASPx.GetChildNodesByClassName(footerElement, "dxgvIndentCell").length;
 },
 Focus: function() {
  if(this.kbdHelper)
   this.kbdHelper.Focus();
 },
 PerformCallback: function(args, onSuccess){
  if(!ASPx.IsExists(args)) args = "";
  this.gridCallBack([ASPxClientGridViewCallbackCommand.CustomCallback, args], onSuccess);
 },
 GetValuesOnCustomCallback: function(args, onCallBack) {
  this.gridFuncCallBack([ASPxClientGridViewCallbackCommand.CustomValues, args], onCallBack);
 },
 GotoPage: function(pageIndex){
  if(this.useEndlessPaging)
   return;
  this.gridCallBack([ASPxClientGridViewCallbackCommand.GotoPage, pageIndex]);
 },
 GetPageIndex: function(){
  return this.pageIndex;
 },
 GetPageCount: function(){
  return this.pageCount;
 },
 NextPage: function(){
  this.gridCallBack([ASPxClientGridViewCallbackCommand.NextPage]);
 },
 PrevPage: function(focusBottomRow){
  if(!this.useEndlessPaging)
   this.gridCallBack([ASPxClientGridViewCallbackCommand.PreviousPage, focusBottomRow ? "T" : "F"]);
 },
 IsLastPage: function() {
  return this.pageIndex === this.pageCount - 1;
 },
 GetItemKey: function(visibleIndex) {
  var arrayIndex = visibleIndex - this.visibleStartIndex;
  if(arrayIndex < 0 || arrayIndex > this.keys.length - 1) 
   return null;
  var key = this.keys[arrayIndex];
  if(key == "/^DXN")
   key = null;
  return key;
 },   
 StartEditItem: function(visibleIndex, columnIndex) {
  var batchEditHelper = this.GetBatchEditHelper();
  if(batchEditHelper)
   batchEditHelper.StartEditCell(visibleIndex, columnIndex);
  else
   this.StartEditItemByKey(this.GetItemKey(visibleIndex));
 },
 StartEditItemByKey: function(key) {
  if(!this.HasKeyField() || key === null) 
   return;
  var batchEditHelper = this.GetBatchEditHelper();
  if(batchEditHelper)
   batchEditHelper.StartEditItemByKey(key);
  else
   this.gridCallBack([ASPxClientGridViewCallbackCommand.StartEdit, key]);
 },
 IsEditing: function() { return this.editState > 0; },
 IsNewItemEditing: function() { return this.editState > 1; },
 IsEditingItem: function(visibleIndex) { return this.editItemVisibleIndex === visibleIndex; },
 IsNewRowAtBottom: function() { return this.editState == 3; },
 UpdateEdit: function(){
  this._updateEdit();
 },
 CancelEdit: function() {
  var batchEditHelper = this.GetBatchEditHelper();
  if(batchEditHelper)
   batchEditHelper.CancelEdit();
  else
   this.gridCallBack([ASPxClientGridViewCallbackCommand.CancelEdit]);
 },
 AddNewItem: function() {
  if(this.allowBatchEditing)
   this.batchEditApi.AddNewItem();
  else 
   this.AddNewItemOnServer();
 },
 AddNewItemOnServer: function() {
  if(!this.HasKeyField()) return;
  this.gridCallBack([ASPxClientGridViewCallbackCommand.AddNewRow]);
 },
 DeleteItem: function(visibleIndex) {
  if(this.allowBatchEditing)
   this.batchEditApi.DeleteItem(visibleIndex);  
  else
   this.DeleteItemByKey(this.GetItemKey(visibleIndex));
 },
 RecoverItem: function(visibleIndex){
  if(this.allowBatchEditing)
   this.batchEditApi.RecoverItem(visibleIndex);  
 },
 DeleteItemByKey: function(key) {
  if(this.allowBatchEditing)
   this.batchEditApi.DeleteItemByKey(key);
  else
   this.DeleteItemByKeyOnServer(key);
 },
 DeleteItemByKeyOnServer: function(key) {
  if(!this.HasKeyField() || key === null) 
   return;
  this.gridCallBack([ASPxClientGridViewCallbackCommand.DeleteRow, key]);
 },
 HasKeyField: function() {
  var result = this.keys.length > 0 || this.pageRowCount === 0;
  if(!result)
   alert(this.RequireKeyFieldNameText);
  return result;
 },
 Refresh: function(){
  var batchEditHelper = this.GetBatchEditHelper();
  if(batchEditHelper)
   batchEditHelper.CancelEdit();
  this.gridCallBack([ASPxClientGridViewCallbackCommand.Refresh]);
 },
 ApplyFilter: function(expression){
  expression = expression || "";
  this.gridCallBack([ASPxClientGridViewCallbackCommand.ApplyFilter, expression]);
 },
 ClearFilter: function () {
  this.GetFilterHelper().ClearFilterEditorsState();
  this.ApplyFilter();
 },
 GetAutoFilterEditor: function(column) { 
  var index = this._getColumnIndexByColumnArgs(column);
  if(!ASPx.IsExists(index)) return null;
  return ASPx.GetControlCollection().Get(this.name + "_DXFREditorcol" + index);
 },
 AutoFilterByColumn: function(column, val){
  var index = this._getColumnIndexByColumnArgs(column);
  if(!ASPx.IsExists(index)) return;
  if(!ASPx.IsExists(val)) val = "";  
  this.gridCallBack([ASPxClientGridViewCallbackCommand.ApplyColumnFilter, index, val]);
 },
 ApplyHeaderFilterByColumn: function() {
  var popup = this.GetHeaderFilterPopup();
  popup.Hide();
  var helper = this.GetFilterHelper();
  var column = helper.GetHeaderFilterPopupRelatedColumn();
  if(column) {
   var state = helper.GetHeaderFilterCallbackState(column.index);
   this.gridCallBack([ASPxClientGridViewCallbackCommand.ApplyHeaderColumnFilter, column.index, ASPx.Json.ToJson(state)]);
  }
 },
 SortBy: function(column, sortOrder, reset, sortIndex){
  if(this.RaiseColumnSorting(this._getColumnObjectByArg(column))) return;
  column = this._getColumnIndexByColumnArgs(column);
  if(!ASPx.IsExists(sortIndex)) sortIndex = "";
  if(!ASPx.IsExists(sortOrder)) sortOrder = "";
  if(!ASPx.IsExists(reset)) reset = true;
  this.gridCallBack([ASPxClientGridViewCallbackCommand.Sort, column, sortIndex, sortOrder, reset]);
 },
 MoveColumn: function(column, columnMoveTo, direction, moveToGroup, moveFromGroup){
  if(!ASPx.IsExists(column)) return;
  if(!ASPx.IsExists(columnMoveTo)) columnMoveTo = -1;
  if(!ASPx.IsExists(moveToGroup)) moveToGroup = false;
  if(!ASPx.IsExists(moveFromGroup)) moveFromGroup = false;
  if(moveToGroup) {
   if(this.RaiseColumnGrouping(this._getColumnObjectByArg(column))) return;
  }
  direction = this.getColumnMoveDirection(direction);
  column = this._getColumnIndexByColumnArgs(column);
  this.MoveColumnCore(column, columnMoveTo, direction, moveToGroup, moveFromGroup);
 },
 MoveColumnCore: function(sourceIndex, targetIndex, direction, moveToGroup, moveFromGroup) {
  this.gridCallBack([ASPxClientGridViewCallbackCommand.ColumnMove, sourceIndex, targetIndex, direction, moveToGroup, moveFromGroup]);
 },
 getColumnMoveDirection: function(direction){
  if(!ASPx.IsExists(direction))
   return ASPxClientGridColumnMovingTargetPosition.Left;
  if(direction === false)
   return ASPxClientGridColumnMovingTargetPosition.Left;
  if(direction === true)
   return ASPxClientGridColumnMovingTargetPosition.Right;
  if(ASPx.IsNumber(direction))
   return direction;
  return ASPxClientGridColumnMovingTargetPosition.Left;
 },
 IsCustomizationWindowVisible: function(){
  var custWindow = this.GetCustomizationWindow();
  return custWindow != null && custWindow.IsVisible();
 },
 ShowCustomizationWindow: function(showAtElement){
  var custWindow = this.GetCustomizationWindow();
  if(!custWindow) return;
  if(!showAtElement) showAtElement = this.GetMainElement();
  custWindow.ShowAtElement(showAtElement);
 },
 HideCustomizationWindow: function(){
  var custWindow = this.GetCustomizationWindow();
  if(custWindow != null) custWindow.Hide();
 },
 ShowCustomizationDialog: function() { },
 ExportTo: function(format) {
  this.gridPostBack([ASPxClientGridViewCallbackCommand.Export, format]);
 },
 GetSelectedFieldValues: function(fieldNames, onCallBack) {
  this.gridFuncCallBack([ASPxClientGridViewCallbackCommand.SelFieldValues, fieldNames], onCallBack);
 },
 GetSelectedKeysOnPage: function() {
  var keys = [];
  for(var i = 0; i < this.pageRowCount; i++) {
   if(this._isRowSelected(this.visibleStartIndex + i))
    keys.push(this.keys[i]);
  }
  return keys; 
 },
 GetItemValues: function(visibleIndex, fieldNames, onCallBack) {
  this.gridFuncCallBack([ASPxClientGridViewCallbackCommand.RowValues, visibleIndex, fieldNames], onCallBack);
 },
 GetPageItemValues: function(fieldNames, onCallBack) {
  this.gridFuncCallBack([ASPxClientGridViewCallbackCommand.PageRowValues, fieldNames], onCallBack);
 },
 GetVisibleItemsOnPage: function() {
  var batchEditHelper = this.GetBatchEditHelper();
  if(batchEditHelper)
   return batchEditHelper.GetVisibleItemsOnPageCount();
  return this.pageRowCount;
 },
 GetTopVisibleIndex: function() {
  return this.visibleStartIndex;
 },
 GetColumnsCount: function() {
  return this.GetColumnCount();
 },
 GetColumnCount: function() {
  return this._getColumnCount();
 },
 GetColumn: function(index) {
  return this._getColumn(index);
 },
 GetColumnById: function(id) {
  return this._getColumnById(id);
 },
 GetColumnByField: function(fieldName) {
  return this._getColumnByField(fieldName);
 },
 GetEditor: function(column) {
  var columnObject = this._getColumnObjectByArg(column);
  return columnObject != null ? this.GetEditorByColumnIndex(columnObject.index) : null;
 },
 FocusEditor: function(column) {
  var editor = this.GetEditor(column);
  if(editor && editor.SetFocus) {
   editor.SetFocus();  
  }
 },
 GetEditValue: function(column) {
  var editor = this.GetEditor(column);
  return editor != null && editor.enabled ? editor.GetValue() : null;
 },
 SetEditValue: function(column, value) {
  var editor = this.GetEditor(column);
  if(editor != null && editor.enabled) {
   editor.SetValue(value);
  }
 },
 ShowFilterControl: function() {
  this.PreventCallbackAnimation();
  this.gridCallBack([ASPxClientGridViewCallbackCommand.ShowFilterControl]);
 },
 CloseFilterControl: function() {
  this.PreventCallbackAnimation();
  this.HideFilterControlPopup();
  this.gridCallBack([ASPxClientGridViewCallbackCommand.CloseFilterControl]);
 },
 HideFilterControlPopup: function() {
  var popup = this.GetFilterControlPopup();
  if(popup) {
   popup.Hide();
   if(this.accessibilityCompliant) {
    var needToStoreFocusTreeLine = !this.accessibilityFocusTreeLine && ASPx.GetIsParent(this.GetMainElement(), ASPx.GetActiveElement());
    if(needToStoreFocusTreeLine)
     this.accessibilityFocusTreeLine = ASPx.RestoreFocusHelper.getFocusTreeLine(this);
   }
  }
 },
 ApplyFilterControl: function() {
  this.PreventCallbackAnimation();
  var fc = this.GetFilterControl();
  if(fc == null) return;
  if(!this.callBacksEnabled)
   this.HideFilterControlPopup();
  if(!fc.isApplied)
   fc.Apply(this);
 },
 SetFilterEnabled: function(isFilterEnabled) {
  this.gridCallBack([ASPxClientGridViewCallbackCommand.SetFilterEnabled, isFilterEnabled]);
 },
 GetVerticalScrollPosition: function() { return 0; },
 SetVerticalScrollPosition: function(value) { },
 RaiseSelectionChangedOutOfServer: function() {
  this.RaiseSelectionChanged(-1, false, false, true);
 },
 RaiseSelectionChanged: function(visibleIndex, isSelected, isAllRecordsOnPage, isChangedOnServer) {
  if(!this.SelectionChanged.IsEmpty()){
   var args = this.CreateSelectionEventArgs(visibleIndex, isSelected, isAllRecordsOnPage, isChangedOnServer);
   this.SelectionChanged.FireEvent(this, args);
   if(args.processOnServer) {
    this.gridCallBack([ASPxClientGridViewCallbackCommand.Selection]);
   }
  }
  return false; 
 },
 CreateSelectionEventArgs: function(visibleIndex, isSelected, isAllRecordsOnPage, isChangedOnServer){
  return null;
 },
 RaiseFocusedItemChangedOutOfServer: function() { 
  this.RaiseFocusedItemChanged(true); 
 },
 RaiseFocusedItemChanged: function(isChangedOnServer) { return false; },
 RaiseItemFocusing: function(visibleIndex, htmlEvent) { return false; },
 RaiseColumnSorting: function(column) {
  if(!this.ColumnSorting.IsEmpty()){
   var args = this.CreateColumnCancelEventArgs(column);
   this.ColumnSorting.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 CreateColumnCancelEventArgs: function(column){
  return null;
 },
 RaiseColumnGrouping: function(column) {
  return false; 
 },
 RaiseItemClick: function(visibleIndex, htmlEvent) {
  return false; 
 },
 RaiseItemDblClick: function(visibleIndex, htmlEvent) {
  return false; 
 },
 RaiseCustomizationWindowCloseUp: function() {
  if(!this.CustomizationWindowCloseUp.IsEmpty()){
   var args = new ASPxClientEventArgs();
   this.CustomizationWindowCloseUp.FireEvent(this, args);
  }
  return false; 
 },
 RaiseColumnMoving: function(targets) {
  return false;
 },
 RaiseToolbarItemClick: function(toolbarInfo, item) {
  if(this.ToolbarItemClick.IsEmpty())
   return false;
  var args = new ASPxClientGridToolbarItemClickEventArgs(toolbarInfo.index, toolbarInfo.name, item, false);
  this.ToolbarItemClick.FireEvent(this, args);
  if(!args.handled && args.processOnServer) {
   this.GetToolbarHelper().ProcessCustomToolbarItemClickOnServer(args.usePostBack);
   return true;
  }
  return args.handled;
 },
 RaiseBatchEditStartEditing: function(visibleIndex, column, rowValues) { return null; },
 RaiseBatchEditEndEditing: function(visibleIndex, rowValues) { return null; },
 RaiseBatchEditItemValidating: function(visibleIndex, validationInfo) { return null; },
 RaiseBatchEditConfirmShowing: function(requestTriggerID) { return false; },
 RaiseBatchEditTemplateCellFocused: function(columnIndex) { return false; },
 RaiseBatchEditChangesSaving: function(valuesInfo) { return false; },
 RaiseBatchEditChangesCanceling: function(valuesInfo) { return false; },
 RaiseBatchEditItemInserting: function(visibleIndex) { return false; },
 RaiseBatchEditItemDeleting: function(visibleIndex, itemValues) { return false; },
 RaiseFocusedCellChanging: function(visibleIndex, columnIndex) {
  if(!this.FocusedCellChanging.IsEmpty()){   
   var info = this.CreateCellInfo(visibleIndex, this.GetColumn(columnIndex));
   var args = this.CreateFocusedCellChangingArgs(info);
   this.FocusedCellChanging.FireEvent(this, args);
   return args.cancel;
  }
  return false;   
 },
 CreateCellInfo: function(visibleIndex, column) { return null; },
 CreateFocusedCellChangingArgs: function(cellInfo) { return null; },
 RaiseInternalCheckBoxClick: function(visibleIndex) {
  if(!this.InternalCheckBoxClick.IsEmpty()){
   var args = {"visibleIndex": visibleIndex, cancel: false};
   this.InternalCheckBoxClick.FireEvent(this, args);
   return args.cancel;
  }
  return false;
 },
 UA_AddNew: function() {
  this.AddNewItem();
 },
 UA_StartEdit: function(visibleIndex) {
  this.StartEditItem(visibleIndex);
 },
 UA_Delete: function(visibleIndex) {
  this.DeleteGridItem(visibleIndex);
 },
 UA_Recover: function(visibleIndex) {
  this.RecoverItem(visibleIndex);
 },
 UA_UpdateEdit: function() {
  this.UpdateEdit();
 },
 UA_CancelEdit: function() {
  this.CancelEdit();
 },
 UA_CustomButton: function(id, visibleIndex) {
  this.CommandCustomButton(id, visibleIndex);
 },
 UA_Select: function(visibleIndex) {
  if(!this.lookupBehavior || this.allowSelectByItemClick){
   var selected = this.allowSelectSingleRowOnly || !this._isRowSelected(visibleIndex);
   this.SelectItem(visibleIndex, selected);
  }
 },
 UA_ClearFilter: function() {
  this.ClearFilter();
 },
 UA_ApplySearchFilter: function() {
  this.ApplySearchFilterFromEditor();
 },
 UA_ClearSearchFilter: function() {
  var editor = this.GetSearchEditor();
  if(editor)
   editor.SetValue(null);
  this.ApplySearchFilterFromEditor();
 },
 ApplySearchFilterFromEditor: function() {
  this.GetFilterHelper().ApplySearchFilterFromEditor(this.GetSearchEditor());
 },
 ChangeCellInitialClass: function(cell, className, add) { this.GetCellStyleManager().ChangeCellInitialClass(cell, className, add); },
 OnDispose: function() { 
  if(this.filterHelper)
   this.filterHelper.OnDispose();
  ASPxClientControl.prototype.OnDispose.call(this);
 },
});
ASPxClientGridBase.Cast = ASPxClientControl.Cast;
var GridCallbackHelper = ASPx.CreateClass(null, {
 constructor: function(grid) {
  this.grid = grid;
  this.funcCallbackInfoList = [ ];
  this.postbackRequestCount = 0;
 },
 GetAllowDelete: function() { return this.grid.allowDelete; },
 GetAllowEdit: function() { return this.grid.allowEdit; },
 GetAllowInsert: function() { return this.grid.allowInsert; },
 CanSendCallback: function() { return this.grid.callBack && this.grid.callBacksEnabled; },
 GetEditorValues: function() { return this.grid.GetEditorValues(); },
 GetSelectionState: function() { return this.grid.GetSelectedState(); },
 GetKeyValues: function() { return this.grid.GetKeyValues(); },
 GetFocusedRowState: function() { return this.grid.stateObject.focusedRow; },
 GetToolbarState: function() { return this.grid.GetToolbarHelper().GetCallbackState(); },
 GetRequestCount: function() { return this.grid.requestCount; },
 ResetUserChangedSelection: function() { 
  this.grid.userChangedSelection = false; 
 },
 GetTotalRequestCount: function() { return this.GetRequestCount() + this.postbackRequestCount; },
 CreateGridCallback: function(command, args, callbackHandler) {
  this.grid.CreateCallback(args, command, callbackHandler);
 },
 CreateGridPostback: function(args) { 
  this.grid.SendPostBack(args); 
 },
 OnBeforeCallbackOrPostBack: function() {
  this.grid.OnBeforeCallbackOrPostBack(); 
 },
 OnBeforeCallback: function(command) { this.grid.OnBeforeCallback(command); },
 SendRequest: function(args, callbackHandler) {
  var command = this.GetCorrectedCommand(args);
  if(!this.ValidateCommand(command))
   return;
  this.OnBeforeCallbackOrPostBack();
  if(this.CanSendCallback())
   this.SendCallback(command, args, callbackHandler);
  else
   this.SendPostback(args);
 },
 SendCallback: function(command, args, callbackHandler) {
  this.OnBeforeCallback(command);
  var callbackState = this.GetGridCallbackState();
  this.ResetUserChangedSelection();
  this.SendCallbackCore(command, args, callbackState, callbackHandler);
 },
 SendFuncCallback: function(args, onCallBack) {
  var callbackState = this.GetGridCallbackState();
  callbackState.push([ "FB", this.GetFuncCallBackIndex(onCallBack) ]);
  this.SendCallbackCore("FUNCTION", args, callbackState);
 },
 SendCallbackCore: function(command, commandArgs, callbackState, callbackHandler) {
  callbackState.push([ "GB", this.SerializeCallbackArgs(commandArgs) ]);
  this.CreateGridCallback(command, this.FormatCallbackState(callbackState), callbackHandler);
 },
 SendPostback: function(args) {
  this.postbackRequestCount++;
  this.CreateGridPostback(this.SerializeCallbackArgs(args));
 },
 ValidateCommand: function(command) {
  if(command === ASPxClientGridViewCallbackCommand.DeleteRow && !this.GetAllowDelete())
   return false;
  if(command === ASPxClientGridViewCallbackCommand.StartEdit && !this.GetAllowEdit())
   return false;
  if(command === ASPxClientGridViewCallbackCommand.AddNewRow && !this.GetAllowInsert())
   return false;
  return true;
 },
 GetCorrectedCommand: function(args) {
  if(args.length === 0) return "";
  var command = args[0];
  if(args.length > 1 && command === ASPxClientGridViewCallbackCommand.ColumnMove) {
   if(args[args.length - 1])
    command = ASPxClientGridViewCallbackCommand.UnGroup;
   if(args[args.length - 2])
    command = ASPxClientGridViewCallbackCommand.Group;
  }
  return command;
 },
 GetGridCallbackState: function() {
  return [
   [ "EV", this.GetEditorValues() ],
   [ "SR", this.GetSelectionState() ],
   [ "KV", this.GetKeyValues() ],
   [ "FR", this.GetFocusedRowState() ],
   [ "CT", this.GetToolbarState() ]
  ];
 },
 GetFuncCallBackIndex: function(onCallBack) {
  var info = { date: new Date(), callback: onCallBack };
  for(var i = 0; i < this.funcCallbackInfoList.length; i ++) {
   if(this.funcCallbackInfoList[i] === null) {
    this.funcCallbackInfoList[i] = info;
    return i;
   }
  }
  this.funcCallbackInfoList.push(info);
  return this.funcCallbackInfoList.length - 1;
 },
 GetFuncCallBackInfo: function(index) {
  if(index < 0 || index >= this.funcCallbackInfoList.length) 
   return null;
  var result = this.funcCallbackInfoList[index];
  this.funcCallbackInfoList[index] = null;
  return result;
 },
 HasWaitedFuncCallbacks: function() {
  return this.funcCallbackInfoList.filter(function(i) { return i !== null; }).length > 0;
 },
 HasWaitedFuncCallbacksFromInterval: function(timeout) {
  var date = new Date();
  for(var i = 0; i < this.funcCallbackInfoList.length; i++) {
   var info = this.funcCallbackInfoList[i];
   if(info && (date - info.date) < timeout)
    return true;
  }
  return false;
 },
 FormatCallbackState: function(callbackState) {
  var result = [ ];
  for(var i = 0; i < callbackState.length; i++) {
   var stateItem = callbackState[i];
   if(!stateItem || stateItem.length !== 2)
    continue;
   var stateKey = stateItem[0];
   var stateValue = stateItem[1];
   if(ASPx.IsExists(stateValue) && stateValue !== "") {
    var stateValueString = stateValue.toString();
    result.push(stateKey);
    result.push("|");
    result.push(stateValueString.length);
    result.push(";");
    result.push(stateValueString);
    result.push(";");
   }
  }
  return result.join("");
 },
 SerializeCallbackArgs: function(args) {
  if(!ASPx.Ident.IsArray(args) || args.length === 0)
   return "";
  var result = [ ];
  for(var i = 0; i < args.length; i++) {
   var item = args[i].toString();
   result.push(item.length);
   result.push("|");
   result.push(item);
  }
  return result.join("");
 }
});
var GridCellStyleManager = ASPx.CreateClass(null, {
 InitialStyleKey: "initial",
 BatchEditStylKey: "batchEdit",
 FocusedStyleKey: "focused",
 constructor: function(grid) {
  this.grid = grid;
 },
 SetBatchEditStyle: function(styleType, cell, columnIndex) { this.SetCellStyle(this.BatchEditStylKey, styleType, cell, columnIndex); },
 SetFocusedStyle: function(styleType, cell, columnIndex) { this.SetCellStyle(this.FocusedStyleKey, styleType, cell, columnIndex); },
 SetCellStyle: function(styleKey, styleType, cell, columnIndex) {
  if(!cell) return;
  this.EnsureCellStyles(cell);
  cell.appliedStyles[styleKey] = this.GetGridStyle(styleType, columnIndex);
  this.ApplyCellStyle(cell);
 },
 EnsureCellStyles: function(cell) {
  if(cell.appliedStyles)
   return;
  cell.appliedStyles = { }; 
  cell.appliedStyles[this.InitialStyleKey] = this.CreateStyle(cell.className, cell.style.cssText);
  var keys = this.GetCellStyleKeys();
  for(var i = 0; i < keys.length; i++)
   cell.appliedStyles[keys[i]] = this.CreateStyle();
 },
 GetCellStyleKeys: function() {
  var result = [];
  result.push(this.BatchEditStylKey);
  result.push(this.FocusedStyleKey);
  return result;
 },
 CreateStyle: function(className, cssText) {  
  className = className || "";
  cssText = cssText || "";
  return { className: className, cssText: cssText};
 },
 GetGridStyle: function(styleType, columnIndex) {
  var result = this.CreateStyle();
  if(styleType) {
   var styleInfo = this.IsStyleInfo(styleType) ? styleType : this.grid.getItemStyleInfo(styleType, columnIndex);
   if(styleInfo) {
    result.className = styleInfo.css || "";
    result.cssText = styleInfo.style || "";
   }
  }
  return result;
 },
 IsStyleInfo: function(obj) { return ASPx.IsExists(obj.css) || ASPx.IsExists(obj.style); },
 ApplyCellStyle: function(cell) {
  var className = "";
  var cssText = "";
  for(var key in cell.appliedStyles) {
   if(!cell.appliedStyles.hasOwnProperty(key)) continue;
   var style = cell.appliedStyles[key];
   if(!style) continue;
   if(style.className)
    className += " " + style.className;
   if(style.cssText)
    cssText += ";" + style.cssText;
  }
  cell.className = className;
  cell.style.cssText = cssText;
 },
 AddToBatchEditStyle: function(cell, styles) { this.AddToCellStyleCore(cell, this.BatchEditStylKey, styles); },
 AddToInitialStyle: function(cell, styles) { this.AddToCellStyleCore(cell, this.InitialStyleKey, styles); },
 AddToCellStyleCore: function(cell, styleKey, styles) {
  if(!styles || !cell) return;
  this.EnsureCellStyles(cell);
  var style = cell.appliedStyles[styleKey];
  if(!style) return;
  var fakeCell = document.createElement("TD");
  fakeCell.style.cssText = style.cssText || "";
  for(var property in styles) {
   if(styles.hasOwnProperty(property)) {
    var value = styles[property];
    fakeCell.style[property] = value + (typeof (value) == "number" ? "px" : "");
   }
  }
  style.cssText = fakeCell.style.cssText;
  this.ApplyCellStyle(cell);
 },
 ChangeCellInitialClass: function(cell, className, add) {
  if(!cell.appliedStyles)
   return;
  var hasClass = cell.appliedStyles.initial.className.indexOf(className) > -1;
  if(hasClass && !add)
    cell.appliedStyles.initial.className =  cell.appliedStyles.initial.className.replace(className, "");
  if(!hasClass && add)
    cell.appliedStyles.initial.className += " " + className;
  this.ApplyCellStyle(cell);
 }
});
var ASPxClientGridColumnBase = ASPx.CreateClass(null, {
 constructor: function(prop) {
  this.index =   ASPx.IsExists(prop[0]) ? prop[0] : -1;
  this.visible =    ASPx.IsExists(prop[1]) ?  !!prop[1] : true;
  this.name =    ASPx.IsExists(prop[2]) ? prop[2] : "";
  this.fieldName =  ASPx.IsExists(prop[3]) ? prop[3] : "";
  this.allowSort =  ASPx.IsExists(prop[4]) ?  !!prop[4] : true;
  this.HFMode =     ASPx.IsExists(prop[5]) ? prop[5] : 1;
  this.sortIndex =  ASPx.IsExists(prop[6]) ? prop[6] : -1;
  this.sortOrder =  ASPx.IsExists(prop[7]) ? prop[7] : ASPx.GridSortOrder.None;
  this.id = this.name;
 }
});
var GridLayoutHelper = ASPx.CreateClass(null, { 
 constructor: function(grid) {
  this.grid = grid;
 },
 GetDataItemVisibleIndices: function(includeDeleted) { 
  var grid = this.grid;
  var helper = grid.GetBatchEditHelper();
  if(helper) {
   includeDeleted |= helper.GetHighlightDeletedItems();
   return helper.GetDataItemVisibleIndices(!includeDeleted);
  }
  var indices = [ ];
  var start = grid.GetTopVisibleIndex();
  var end = start + grid.pageRowCount;
  for(var i = start; i < end; i++) {
   if(grid.GetDataItem(i)) 
    indices.push(i);
  }
  return indices;
 },
 Invalidate: function() { 
 },
});
var GridViewDragHelper = ASPx.CreateClass(ASPx.GridDragHelperBase, {
 constructor: function(grid) {
  this.grid = grid;
  this.targets = null;
  this.constructor.prototype.constructor.call(this);
 },
 CreateDrag: function(e, element, canDrag) {
  var drag = new ASPx.DragHelper(e, element, true);
  drag.centerClone = true;
  drag.canDrag = canDrag;  
  drag.grid = this.grid;
  drag.ctrl = e.ctrlKey;
  drag.shift = e.shiftKey;
  drag.onDragDivCreating = this.OnDragDivCreating;
  drag.onDoClick = this.OnDoClick;
  drag.onCloneCreating = this.OnCloneCreating;
  drag.onEndDrag = this.OnEndDrag;
  drag.onCancelDrag = this.OnCancelDrag;
  this.OnDragCreated(true);
  return drag;
 },
 GetActiveTargets: function() { 
  if(this.targets && this.targets.list)
   return this.targets.list;
  return [ ];
 },
 GetScrollHelper: function() { return this.grid.GetScrollHelper(); },
 GetCustomizationWindowElement: function() { return this.grid.GetCustomizationWindowElement(); },
 GetHeaderLeaf: function(columnIndex, isLeft){ return this.grid.GetHeaderMatrix().GetLeaf(columnIndex, isLeft, false); },
 GetHeaderLevel: function(columnIndex){ return this.grid.GetHeaderMatrix().GetColumnLevel(columnIndex); },
 NeedScrollOnDrag: function(isHorzDrag) { 
  var hasFixedColumns = this.grid.GetFixedColumnsHelper && this.grid.GetFixedColumnsHelper();
  return ASPx.GridDragHelperBase.prototype.NeedScrollOnDrag.call(this, isHorzDrag) || hasFixedColumns; 
 },
 PrepareTargetHeightFunc: function() {
  GridViewDragHelper.Target_GetElementHeight = null;
  if(this.grid.allowChangeColumnHierarchy)
   return;
  var headerRowCount = this.grid.GetHeaderMatrix().GetRowCount();
  if(headerRowCount > 0) {
   var row = this.grid.GetHeaderRow(headerRowCount - 1);
   var headerBottom = ASPx.GetAbsoluteY(row) + row.offsetHeight;
   GridViewDragHelper.Target_GetElementHeight = function() {
    return headerBottom - this.absoluteY;
   };
  }
 },
 CreateTargets: function(drag, e) {
  if(!drag.canDrag) return;
  var grid = this.grid;
  this.PrepareTargetHeightFunc();
  var targets = new ASPx.CursorTargets(grid);
  targets.obj = drag.obj;
  targets.onTargetCreated = this.OnTargetCreated;
  targets.onTargetChanging = this.OnTargetChanging;
  targets.onTargetChanged = this.OnTargetChanged;
  targets.onTargetAllowed = this.OnHeaderTargetAllowed.aspxBind(this);
  this.targets = targets;
  var scrollLeft = null, scrollRight;
  var scrollHelper = grid.GetScrollHelper();
  var scrollableControl = scrollHelper && scrollHelper.GetHorzScrollableControl();
  if(scrollableControl) {
   scrollLeft = ASPx.GetAbsoluteX(scrollableControl);
   scrollRight = scrollLeft + scrollableControl.offsetWidth;
  }
  var sourceColumn = grid.getColumnObject(drag.obj.id);
  var win = grid.GetCustomizationWindow();
  if(win && !sourceColumn.inCustWindow)
   this.AddDragDropTarget(targets, win.GetWindowClientTable(-1));
  for(var i = 0; i < grid.columns.length; i++) {
   var column = grid.columns[i];
   for(var grouped = 0; grouped <= 1; grouped++) {
    var targetElement = grid.GetHeader(column.index, !!grouped);
    if(!targetElement)
     continue;
    if(this.IsValidColumnDragDropTarget(drag.obj, targetElement, sourceColumn, column))
     this.AddDragDropTarget(targets, targetElement);  
   }
  }
  this.AddAdaptivePanelTarget(targets, grid.GetAdaptiveHeaderPanel());
  this.AddAdaptivePanelTarget(targets, grid.GetAdaptiveGroupPanel());
  this.AddDragDropTarget(targets, grid.GetGroupPanel());
  this.AddDragDropTarget(targets, ASPx.GetElementById(grid.name + this.grid.EmptyHeaderSuffix));
 },
 IsValidColumnDragDropTarget: function(sourceElement, targetElement, sourceColumn, targetColumn) {
  if(sourceColumn == targetColumn)
   return false;
  if(this.grid.allowChangeColumnHierarchy)
   return true;
  if(sourceColumn.parentIndex == targetColumn.parentIndex)
   return true;
  if(sourceColumn.parentIndex == targetColumn.index) {
   return (sourceColumn.inCustWindow || this.IsGroupingTarget(sourceElement))
    && this.grid.GetHeaderMatrix().IsLeaf(targetColumn.index);
  }
  if(this.IsParentColumn(sourceColumn.index, targetColumn.index))
   return (sourceColumn.inCustWindow || this.IsGroupingTarget(sourceElement));
  if(this.IsGroupingTarget(targetElement))
   return true;
  if(this.IsValidAdaptiveTarget(sourceElement, targetElement, sourceColumn, targetColumn))
   return true;
  return false;
 },
 AddAdaptivePanelTarget: function(targets, panel) {
  if(!panel) return;
  this.AppendAdaptivePanelDragAreas(targets, panel);
  this.AddDragDropTarget(targets, panel);
 },
 AppendAdaptivePanelDragAreas: function(targets, panel) {
  panel.dragAreas = [ ];
  var headers = this.GetAdaptivePanelHeaders(panel);
  if(headers.length === 0) 
   return;
  var rows = [ ];
  var row = [ headers[0] ];
  rows.push(row);
  for(var i = 0; i < headers.length - 1; i++) {
   var currentHeader = headers[i];
   var nextHeader = headers[i + 1];
   if(ASPx.GetAbsoluteY(currentHeader) !== ASPx.GetAbsoluteY(nextHeader)) {
    row = [ ];
    rows.push(row);
   }
   row.push(nextHeader);
  }
  for(var i = 0; i < rows.length; i++) {
   var row = rows[i];
   this.CreateDragArea(panel, row[0], targets, true);
   this.CreateDragArea(panel, row[row.length - 1], targets,  false);
  }
 },
 GetAdaptivePanelHeaders: function(panel) {
  return ASPx.GetNodesByPartialClassName(panel, ASPx.GridViewConsts.HeaderCellCssClass);
 },
 CreateDragArea: function(panel, target, targets, isLeft) {
  if(!this.ContainsTarget(targets, target)) 
   return; 
  var targetTop = ASPx.GetAbsolutePositionY(target);
  var area = { 
   target: target,
   isLeft: isLeft,
   top: targetTop,
   bottom: targetTop + target.offsetHeight,
   left: isLeft ? ASPx.GetAbsolutePositionX(panel) : ASPx.GetAbsolutePositionX(target) + target.offsetWidth,
   right: isLeft ? ASPx.GetAbsolutePositionX(target) :  ASPx.GetAbsolutePositionX(panel) + panel.offsetWidth
  };
  panel.dragAreas.push(area);
 },
 ContainsTarget: function(targets, target) {
  for(var i = 0; i < targets.list.length; i++) {
   if(targets.list[i].element == target)
    return true;
  }
  return false;
 },
 IsValidAdaptiveTarget: function(sourceElement, targetElement, sourceColumn, targetColumn) {
  this.EnsureAdaptiveTargetInfo(sourceElement, targetElement, sourceColumn, targetColumn);
  return !!targetElement.adaptiveInfo;
 },
 EnsureAdaptiveTargetInfo: function(sourceElement, targetElement, sourceColumn, targetColumn) {
  if(!this.IsAdaptiveHeaderTarget(targetElement))
   return;
  var sourceLevel = this.GetHeaderLevel(sourceColumn.index);
  var targetLevel = this.GetHeaderLevel(targetColumn.index);
  targetElement.adaptiveInfo = null;
  if(targetLevel < 0 || sourceLevel >= targetLevel)
   return;
  var brother = this.FindColumnBrother(sourceColumn, targetColumn);
  if(!brother) 
   return;
  var leftLeaf = this.GetHeaderLeaf(brother.index, true);
  var rightLeaf = this.GetHeaderLeaf(brother.index, false);  
  if(targetColumn.index === leftLeaf || targetColumn.index === rightLeaf)
   targetElement.adaptiveInfo = { brotherIndex : brother.index, brotherHasOnlyOneLeaf: leftLeaf == rightLeaf, isLeftLeaf: targetColumn.index == leftLeaf };
 },
 FindColumnBrother: function(sourceColumn, targetColumn) {
  while(targetColumn && targetColumn.parentIndex !== sourceColumn.parentIndex)
   targetColumn = this.grid.GetColumn(targetColumn.parentIndex);
  return targetColumn;
 },
 AddDragDropTarget: function(targets, element) {
  if(element)
   targets.addElement(element);
 },
 IsAdaptiveHeaderPanelVisible: function() { return ASPx.IsElementDisplayed(this.grid.GetAdaptiveHeaderPanel()); },
 IsAdaptiveGroupPanelVisible: function() { return ASPx.IsElementDisplayed(this.grid.GetAdaptiveGroupPanel()); },
 IsDataHeaderTarget: function(element) { return element && element.id.indexOf(this.grid.name + "_col") == 0; },
 IsAdaptiveHeaderTarget: function(element) { return this.IsAdaptiveHeaderPanelVisible() && this.IsDataHeaderTarget(element) && element.adaptiveMoved; },
 IsAdaptivePanelTarget: function(element) { return element && (element == this.grid.GetAdaptiveHeaderPanel() || element == this.grid.GetAdaptiveGroupPanel()); },
 IsAdaptiveGroupHeaderTarget: function(element) { return this.IsAdaptiveGroupPanelVisible() && this.IsGroupHeaderTarget(element) && element.adaptiveMoved; },
 IsGroupHeaderTarget: function(element) {
  if(!element || !element.id)
   return false;
  return element.id.indexOf(this.grid.name + "_groupcol") == 0;
 },
 IsGroupingTarget: function(element) { 
  return element == this.grid.GetGroupPanel() || this.IsGroupHeaderTarget(element) || element ==  this.grid.GetAdaptiveGroupPanel();
 },
 IsCustWindowTarget: function(element) {
  var win = this.grid.GetCustomizationWindow();
  return win && element == win.GetWindowClientTable(-1); 
 },
 AllowVerticalTargetTags: function(element){
  return this.grid.allowChangeColumnHierarchy && !this.IsGroupingTarget(element) && !this.IsCustWindowTarget(element);
 },
 OnDragDivCreating: function(drag, dragDiv) {
  var rootTable = drag.grid.GetRootTable();
  if(!dragDiv || !rootTable) return;
  dragDiv.className = rootTable.className;
  dragDiv.style.cssText = rootTable.style.cssText;
 },
 OnDoClick: function(drag) {
  window.setTimeout(function() {
   var grid = drag.grid;
   var contextMenuHelper = grid.GetContextMenuHelper && grid.GetContextMenuHelper(); 
   if(contextMenuHelper && contextMenuHelper.contextMenuActivating) {
    contextMenuHelper.contextMenuActivating = false;
    return;
   }
   if(!grid.canSortByColumn(drag.obj) || grid.InRegularCallback()) 
    return;
   grid.SortBy(grid.getColumnIndex(drag.obj.id), drag.ctrl ? "NONE" : "", !drag.shift && !drag.ctrl);
  }, 0);
 },
 OnCancelDrag: function(drag) {
  drag.grid.dragHelper.DisplayTargetImages(false);
  drag.grid.dragHelper.CancelDrag();
 },
 OnEndDrag: function(drag) {
  if(!drag.targetElement)
   return;
  var grid = drag.grid;
  var sourceElement = drag.obj;
  var targetElement = drag.targetElement;
  var sourceIndex = grid.getColumnIndex(sourceElement.id);
  var targetIndex =  grid.getColumnIndex(targetElement.id);
  var direction = drag.targetTag;
  if(grid.IsEmptyHeaderID(targetElement.id) || targetElement == grid.GetAdaptiveHeaderPanel())
   targetIndex = 0;
  if(grid.dragHelper.IsAdaptiveHeaderTarget(targetElement) && targetElement.adaptiveInfo) {
   targetIndex = targetElement.adaptiveInfo.brotherIndex;
   var isLeft = !targetElement.adaptiveInfo.brotherHasOnlyOneLeaf ? targetElement.adaptiveInfo.isLeftLeaf : isLeft;
   direction = isLeft ? ASPx.CursorTargetTag.Left : ASPx.CursorTargetTag.Right;
  }
  if(grid.rtl && direction < 2)
   direction = direction == ASPx.CursorTargetTag.Left ? ASPx.CursorTargetTag.Right : ASPx.CursorTargetTag.Left;
  grid.MoveColumn(
   sourceIndex,
   targetIndex,
   direction,
   grid.dragHelper.IsGroupingTarget(targetElement),
   grid.dragHelper.IsGroupingTarget(sourceElement)
  );
 },
 OnCloneCreating: function(clone) {
  var table = document.createElement("table");
  table.cellSpacing = 0;
  if(this.obj.offsetWidth > 0)
   table.style.width = Math.min(200, this.obj.offsetWidth) + "px";
  if(this.obj.offsetHeight > 0)
   table.style.height = this.obj.offsetHeight + "px";
  var row = table.insertRow(-1);
  clone.style.borderLeftWidth = "";
  clone.style.borderTopWidth = "";
  clone.style.borderRightWidth = "";
  row.appendChild(clone);
  table.style.opacity = 0.80;
  table.style.filter = "alpha(opacity=80)"; 
  if(ASPx.IsElementRightToLeft(this.obj))
   table.dir = "rtl";
  return table;
 },
 OnTargetCreated: function(targets, targetObj) {
  var f = GridViewDragHelper.Target_GetElementHeight;
  var h = targets.control.dragHelper;
  var el = targetObj.element;
  if(f && !h.IsCustWindowTarget(el) && !h.IsGroupingTarget(el) && !h.IsAdaptiveHeaderTarget(el) && !h.IsAdaptivePanelTarget(el))
   targetObj.GetElementHeight = f;
 },
 OnTargetChanging: function(targets) {
  if(!targets.targetElement)
   return;
  var grid = targets.control;
  var allowVerticalTags = grid.dragHelper.AllowVerticalTargetTags(targets.targetElement);
  targets.refreshTargetTag(allowVerticalTags);
  if(allowVerticalTags)
   grid.dragHelper.CorrectTargetTagOnMovingColumnFromCustWindow(targets);
  var grouping = false;
  if(targets.targetElement == grid.GetGroupPanel() || targets.targetElement == grid.GetAdaptiveGroupPanel()) {
   targets.targetTag = ASPx.CursorTargetTag.Left;
   grouping = true;
  }  
  if(grid.dragHelper.IsGroupHeaderTarget(targets.targetElement)) {
   grouping = true;
  }
  if(grouping && !grid.canGroupByColumn(targets.obj))
   targets.targetElement = null;
  if(grid.dragHelper.IsAdaptivePanelTarget(targets.targetElement)) {
   var info = grid.dragHelper.GetAdaptivePanelTargetInfo(targets, targets.targetElement);
   targets.targetTag = info.isLeftSide ? ASPx.CursorTargetTag.Left : ASPx.CursorTargetTag.Right;
   targets.targetElement = info.targetElement;
   targets.skipNeighbor = true;
  }
  if(targets.targetElement)
   grid.RaiseColumnMoving(targets);
 },
 CorrectTargetTagOnMovingColumnFromCustWindow: function(targets){
  if(!ASPx.currentDragHelper || !ASPx.currentDragHelper.obj || !targets.targetElement)
   return;
  var grid = targets.control;
  var sourceColumn = grid.getColumnObject(ASPx.currentDragHelper.obj.id);
  if(!sourceColumn || !sourceColumn.inCustWindow || !grid.GetColumnHelper().HasColumnChildren(sourceColumn.index))
   return;
  var sourceColumn = grid.getColumnObject(ASPx.currentDragHelper.obj.id);
  var targetColumn = grid.getColumnObject(targets.targetElement.id);
  if(targets.targetTag == ASPx.CursorTargetTag.Top || targets.targetTag == ASPx.CursorTargetTag.Bottom && grid.GetColumnHelper().HasColumnChildren(targetColumn.index))
   targets.refreshTargetTag(false);
 },
 GetAdaptivePanelTargetInfo: function(targets, panel) {
  var x = targets.x;
  var y = targets.y;
  for(var i = 0; i < panel.dragAreas.length; i++) {
   var dragArea = panel.dragAreas[i];
   if(x >= dragArea.left && x <= dragArea.right && y >= dragArea.top && y <= dragArea.bottom)
    return { targetElement: dragArea.target, isLeftSide: dragArea.isLeft };
  }
  return { targetElement: panel.children.length == 0 ? panel : null, isLeftSide: true };
 },
 OnTargetChanged: function(targets) {
  if(ASPx.currentDragHelper == null)
   return;
  var element = targets.targetElement;
  if(element == ASPx.currentDragHelper.obj)
   return;
  var grid = targets.control;
  grid.dragHelper.DisplayTargetImages(false);
  if(!element) {
   ASPx.currentDragHelper.targetElement = null;
   return;
  }
  ASPx.currentDragHelper.targetElement = element;
  ASPx.currentDragHelper.targetTag = targets.targetTag;
  var moveToCustWindow = grid.dragHelper.IsCustWindowTarget(element);
  if(moveToCustWindow) {
   ASPx.currentDragHelper.addElementToDragDiv(grid.GetArrowDragFieldImage());
   return;
  }
  var moveToGroup = grid.dragHelper.IsGroupingTarget(element);
  var info = grid.dragHelper.CreateTargetImagesInfo(targets, moveToGroup);
  if(!info) {
   ASPx.currentDragHelper.targetElement = null;
   return;
  }
  if(targets.skipNeighbor)
   info.neighbor = null;
  var position = grid.dragHelper.CreateTargetImagesPosition(element, info);
  grid.dragHelper.DisplayTargetImages(true, position);
 },
 CreateTargetImagesPosition: function(targetElement, info){
  if(info.side == ASPx.CursorTargetTag.Top || info.side == ASPx.CursorTargetTag.Bottom)
   return this.CreateVerticalTargetImagesPosition(targetElement, info);
  return this.CreateHorizontalTargetImagesPosition(targetElement, info);
 },
 CreateHorizontalTargetImagesPosition: function(targetElement, info){
  var left = ASPx.GetAbsoluteX(targetElement);
  var isRightSide = info.side == ASPx.CursorTargetTag.Right;
  if(targetElement == this.grid.GetGroupPanel() || targetElement == this.grid.GetAdaptiveHeaderPanel() || targetElement == this.grid.GetAdaptiveGroupPanel()) {
   if(this.grid.rtl)
    left += targetElement.offsetWidth;
  } else {
   if(isRightSide) {
    if(info.neighbor)
     left = ASPx.GetAbsoluteX(info.neighbor);
    else
     left += targetElement.offsetWidth;
   }
  }
  var top = ASPx.GetAbsoluteY(targetElement);
  var bottomElement = targetElement;
  var moveToGroup = this.IsGroupingTarget(targetElement);
  if(!moveToGroup && info.targetColumnIndex > -1)
   bottomElement = this.grid.GetHeader(this.GetHeaderLeaf(info.targetColumnIndex, !isRightSide));
  var bottom = ASPx.GetAbsoluteY(bottomElement) + bottomElement.offsetHeight;
  return { top: top, bottom: bottom, left: left, right: left };
 },
 CreateVerticalTargetImagesPosition: function(targetElement, info){
  var left = ASPx.GetAbsoluteX(targetElement);
  var right = left + targetElement.offsetWidth;
  var top = ASPx.GetAbsoluteY(targetElement);
  if(info.side == ASPx.CursorTargetTag.Bottom)
   top += targetElement.offsetHeight;
  return { top: top, bottom: top, left: left, right: right };
 },
 GetChildHeaderElement: function(parentIndex, childIndex, left){
  var grid = this.grid;
  var childColumnIndex = childIndex;
  var currentColumnIndex = childIndex;
  var getNextNeighborHeaderMatrixMethodName = "Get" + (left ? "Left" : "Right") + "Neighbor";
  while(ASPx.IsExists(currentColumnIndex) && this.IsParentColumn(parentIndex, currentColumnIndex)){
   childColumnIndex = currentColumnIndex; 
   currentColumnIndex = grid.GetHeaderMatrix()[getNextNeighborHeaderMatrixMethodName](childColumnIndex);
  }
  return grid.GetHeader(childColumnIndex);
 },
 IsParentColumn: function(parentIndex, columnIndex){
  var index = columnIndex;
  while(index >= 0 && index != parentIndex)
   index = this.grid.GetColumn(index).parentIndex;
  return index >= 0;
 },
 CreateTargetImagesInfo: function(targets, moveToGroup){
  if(moveToGroup)
   return this.CreateGroupPanelTargetImagesInfo(targets);
  var grid = targets.control;
  var targetElement = targets.targetElement;
  var info = {
   targetColumnIndex: grid.getColumnIndex(targetElement.id),
   side: targets.targetTag,
   neighbor: null
  };
  var isAdaptiveHeader = grid.dragHelper.IsAdaptiveHeaderTarget(targetElement);
  if(!isAdaptiveHeader && info.targetColumnIndex < 0)
   return info;
  if(isAdaptiveHeader && targetElement.adaptiveInfo) {
   info.targetColumnIndex = targetElement.adaptiveInfo.brotherIndex;
   if(!targetElement.adaptiveInfo.brotherHasOnlyOneLeaf)
    info.side = targetElement.adaptiveInfo.isLeftLeaf ? ASPx.CursorTargetTag.Left : ASPx.CursorTargetTag.Right;
  }
  var neighborIndex = this.FindHeaderNeighborIndexByHorizontal(info.side, info.targetColumnIndex, isAdaptiveHeader);
  if(neighborIndex == null)
   info = null;
  else if(neighborIndex > -1)
   info.neighbor = grid.GetHeader(neighborIndex);
  return info;
 },
 CreateGroupPanelTargetImagesInfo: function(targets){
  var grid = targets.control;
  var isRightSide = targets.targetTag == ASPx.CursorTargetTag.Right;
  var method = isRightSide ^ grid.rtl ? "nextSibling" : "previousSibling";
  var neighbor = grid.dragHelper.GetGroupNodeNeighbor(targets.targetElement, method);
  if(neighbor && neighbor.id == ASPx.currentDragHelper.obj.id)
   return null;
  return {
   targetColumnIndex: grid.getColumnIndex(targets.targetElement.id),
   side: targets.targetTag,
   neighbor: neighbor
  };
 },
 FindHeaderNeighborIndexByHorizontal: function(side, targetColumnIndex, isAdaptiveHeader){
  if(side == ASPx.CursorTargetTag.Top || side == ASPx.CursorTargetTag.Bottom)
   return targetColumnIndex;
  var grid = this.grid;
  var isRightSide = side == ASPx.CursorTargetTag.Right;
  var matrix =  grid.GetHeaderMatrix();
  var method = isRightSide ^ grid.rtl ? "GetRightNeighbor" : "GetLeftNeighbor";
  var neighborIndex = matrix[method](targetColumnIndex, !isAdaptiveHeader);
  var sourceColumn = grid.getColumnObject(ASPx.currentDragHelper.obj.id);
  if(neighborIndex == sourceColumn.index && !sourceColumn.inCustWindow && !this.IsGroupHeaderTarget(ASPx.currentDragHelper.obj))
   return sourceColumn.parentIndex != grid.GetColumn(targetColumnIndex).parentIndex ? -1 : null;
  if(!isNaN(neighborIndex)){
   if(isAdaptiveHeader && !matrix.IsLeaf(neighborIndex))
    neighborIndex = matrix.GetLeaf(neighborIndex, isRightSide);
  } else
   neighborIndex = -1;
  return neighborIndex;
 },
 GetGroupNodeNeighbor: function(element, method) {
  if(this.IsAdaptiveGroupHeaderTarget(element)) 
   return this.GetAdaptiveGroupNodeNeighbor(element, method);
  return this.GetGroupNodeNeighborCore(element, method, 2);
 },
 GetAdaptiveGroupNodeNeighbor: function(element, method) {   
  var headers = ASPx.GetNodesByPartialClassName(this.grid.GetAdaptiveGroupPanel(), ASPx.GridViewConsts.HeaderCellCssClass);
  var index = ASPx.Data.ArrayIndexOf(headers, element);
  if(index < 0) return null;   
  return method == "nextSibling" ? headers[index + 1] : headers[index - 1];
 },
 GetGroupNodeNeighborCore: function(element, method, distance) {
  var neighbor = element[method];
  if(neighbor && neighbor.nodeType == 1) {
   if(this.IsGroupingTarget(neighbor)) 
    return neighbor;
   if(distance > 1)
    return this.GetGroupNodeNeighborCore(neighbor, method, --distance);
  }
  return null;
 },
 DisplayTargetImages: function(visible, position){
  var downImage = this.grid.GetArrowDragDownImage();
  if(downImage){
   var showImage = visible && position.left == position.right;
   if(showImage) {
    ASPx.SetAbsoluteX(downImage, position.left - downImage.offsetWidth / 2);
    ASPx.SetAbsoluteY(downImage, position.top - downImage.offsetHeight);
   }
   ASPx.SetElementVisibility(downImage, showImage);
  }
  var upImage = this.grid.GetArrowDragUpImage();
  if(upImage){
   var showImage = visible && position.left == position.right;
   if(showImage) {
    ASPx.SetAbsoluteX(upImage, position.left - upImage.offsetWidth / 2);
    ASPx.SetAbsoluteY(upImage, position.bottom);
   }
   ASPx.SetElementVisibility(upImage, showImage);
  }
  var rightImage = this.grid.GetArrowDragRightImage();
  if(rightImage){
   var showImage = visible && position.left != position.right;
   if(showImage) {
    ASPx.SetAbsoluteX(rightImage, position.left - rightImage.offsetWidth);
    ASPx.SetAbsoluteY(rightImage, position.top - rightImage.offsetHeight / 2);
   }
   ASPx.SetElementVisibility(rightImage, showImage);
  }
  var leftImage = this.grid.GetArrowDragLeftImage();
  if(leftImage){
   var showImage = visible && position.left != position.right;
   if(showImage) {
    ASPx.SetAbsoluteX(leftImage, position.right);
    ASPx.SetAbsoluteY(leftImage, position.top - rightImage.offsetHeight / 2);
   }
   ASPx.SetElementVisibility(leftImage, showImage);
  }
 }
});
GridViewDragHelper.Target_GetElementHeight = null;
ASPx.GridViewDragHelper = GridViewDragHelper;
ASPxClientGridBase.SelectStartHandler = function(e) {
 if(ASPx.Evt.GetEventSource(e).tagName.match(/input|select|textarea/i))
  return;
 if(e.ctrlKey || e.shiftKey) {
  ASPx.Selection.Clear();
  ASPx.Evt.PreventEventAndBubble(e);
 }
};
ASPxClientGridBase.SaveActiveElementSettings = function(grid) {
 var element = grid.GetFilterHelper().GetActiveElement();
 grid.GetFilterHelper().ResetActiveElement();
 ASPxClientGridBase.activeElementData = null;
 if (!element || !element.id || element.tagName != "INPUT" || !(ASPx.GetIsParent(grid.GetMainElement(), element) || element.id.indexOf(grid.name + "_") == 0))
  return;  
 ASPxClientGridBase.activeElementData = [ grid.name, element.id, ASPx.Selection.GetInfo(element).endPos ];
 if(typeof(Sys) != "undefined" && typeof(Sys.Application) != "undefined") {
  if(!ASPxClientGridBase.MsAjaxActiveElementHandlerAdded) {
   Sys.Application.add_load(function() { ASPxClientGridBase.RestoreActiveElementSettings(); } );
   ASPxClientGridBase.MsAjaxActiveElementHandlerAdded = true;
  }
 } 
};
ASPxClientGridBase.RestoreActiveElementSettings = function(grid) {
 var data = ASPxClientGridBase.activeElementData;
 if(!data || grid && data[0] != grid.name) return;
 var element = ASPx.GetElementById(data[1]);
 if(element) {
  window.setTimeout(function() {
   element.focus();
   ASPx.Selection.Set(element, data[2], data[2]);
  }, 0);
 }
 ASPxClientGridBase.activeElementData = null;
};
var ASPxClientGridItemStyle = {
 Item: "items",
 Selected: "sel",
 FocusedItem: "fi",
 FocusedGroupItem: "fgi",
 ErrorItemHtml: "ei",
 BatchEditCell: "bec",
 BatchEditModifiedCell: "bemc",
 BatchEditMergedModifiedCell: "bemergmc",
 BatchEditDeletedItem: "bedi",
 FocusedCell: "fc"
};
var ASPxClientGridViewCallbackCommand = {
 NextPage: "NEXTPAGE",
 PreviousPage: "PREVPAGE",
 GotoPage: "GOTOPAGE",
 SelectRows: "SELECTROWS",
 SelectRowsKey: "SELECTROWSKEY",
 Selection: "SELECTION",
 FocusedRow: "FOCUSEDROW",
 Group: "GROUP",
 UnGroup: "UNGROUP",
 Sort: "SORT",
 ColumnMove: "COLUMNMOVE",
 CollapseAll: "COLLAPSEALL",
 ExpandAll: "EXPANDALL",
 ExpandRow: "EXPANDROW",
 CollapseRow: "COLLAPSEROW",
 HideAllDetail: "HIDEALLDETAIL",
 ShowAllDetail: "SHOWALLDETAIL",
 ShowDetailRow: "SHOWDETAILROW",
 HideDetailRow: "HIDEDETAILROW",
 PagerOnClick: "PAGERONCLICK",
 ApplyFilter: "APPLYFILTER",
 ApplyColumnFilter: "APPLYCOLUMNFILTER",
 ApplyMultiColumnFilter: "APPLYMULTICOLUMNFILTER",
 ApplyHeaderColumnFilter: "APPLYHEADERCOLUMNFILTER",
 ApplySearchPanelFilter: "APPLYSEARCHPANELFILTER",
 ApplyCustomizationDialogChanges: "APPLYCUSTOMIZATIONDIALOGCHANGES",
 FilterRowMenu: "FILTERROWMENU",
 StartEdit: "STARTEDIT",
 CancelEdit: "CANCELEDIT",
 UpdateEdit: "UPDATEEDIT",
 AddNewRow: "ADDNEWROW",
 DeleteRow: "DELETEROW",
 CustomButton: "CUSTOMBUTTON",
 CustomCallback: "CUSTOMCALLBACK",
 ShowFilterControl: "SHOWFILTERCONTROL",
 CloseFilterControl: "CLOSEFILTERCONTROL",
 SetFilterEnabled: "SETFILTERENABLED",
 Refresh: "REFRESH",
 SelFieldValues: "SELFIELDVALUES",
 RowValues: "ROWVALUES",
 PageRowValues: "PAGEROWVALUES",
 FilterPopup: "FILTERPOPUP",
 ContextMenu: "CONTEXTMENU",
 Toolbar: "TOOLBAR",
 Export: "EXPORT",
 CustomValues: "CUSTOMVALUES"
};
var ASPxClientGridExportFormat = {
 Pdf: "Pdf",
 Docx: "Docx",
 Rtf: "Rtf",
 Csv: "Csv",
 Xls: "Xls",
 Xlsx: "Xlsx"
};
var ASPxClientGridBatchEditStartEditingEventArgs = ASPx.CreateClass(ASPxClientCancelEventArgs, {
 constructor: function(visibleIndex, focusedColumn, itemValues) {
  this.constructor.prototype.constructor.call(this);
  this.visibleIndex = visibleIndex;
  this.focusedColumn = focusedColumn;
  this.itemValues = ASPx.CloneObject(itemValues);
 }
});
var ASPxClientGridBatchEditEndEditingEventArgs = ASPx.CreateClass(ASPxClientCancelEventArgs, {
 constructor: function(visibleIndex, itemValues) {
  this.constructor.prototype.constructor.call(this);
  this.visibleIndex = visibleIndex;
  this.itemValues = ASPx.CloneObject(itemValues);
 }
});
var ASPxClientGridBatchEditItemValidatingEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(visibleIndex, validationInfo) {
  this.constructor.prototype.constructor.call(this);
  this.visibleIndex = visibleIndex;
  this.validationInfo = ASPx.CloneObject(validationInfo);
 }
});
var ASPxClientGridBatchEditConfirmShowingEventArgs = ASPx.CreateClass(ASPxClientCancelEventArgs, {
 constructor: function(requestTriggerID) {
  this.constructor.prototype.constructor.call(this);
  this.requestTriggerID = requestTriggerID;
 }
});
var ASPxClientGridBatchEditTemplateCellFocusedEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(column) {
  this.constructor.prototype.constructor.call(this);
  this.column = column;
  this.handled = false;
 }
});
var ASPxClientGridBatchEditClientChangesEventArgs = ASPx.CreateClass(ASPxClientCancelEventArgs, {
 constructor: function(insertedValues, deletedValues, updatedValues) {
  this.constructor.prototype.constructor.call(this);
  this.insertedValues = insertedValues;
  this.deletedValues = deletedValues;
  this.updatedValues = updatedValues;
 }
});
var ASPxClientGridBatchEditItemInsertingEventArgs = ASPx.CreateClass(ASPxClientCancelEventArgs, {
 constructor: function(visibleIndex) {
  this.constructor.prototype.constructor.call(this);
  this.visibleIndex = visibleIndex;
 }
});
var ASPxClientGridBatchEditItemDeletingEventArgs = ASPx.CreateClass(ASPxClientCancelEventArgs, {
 constructor: function(visibleIndex, itemValues) {
  this.constructor.prototype.constructor.call(this);
  this.visibleIndex = visibleIndex;
  this.itemValues = itemValues;
 }
});
var ASPxClientGridFocusedCellChangingEventArgs = ASPx.CreateClass(ASPxClientCancelEventArgs, {
 constructor: function(cellInfo) {
  this.constructor.prototype.constructor.call(this);
  this.cellInfo = cellInfo;
 }
});
var ASPxClientGridBatchEditApi = ASPx.CreateClass(null, {
 constructor: function(grid) {
  this.grid = grid;
 },
 GetHelper: function() { return this.grid.GetBatchEditHelper(); },
 GetColumnIndex: function(column) { return this.grid._getColumnIndexByColumnArgs(column); },
 SetCellValue: function(visibleIndex, column, value, displayText, cancelCellHighlighting) {
  var helper = this.GetHelper();
  var columnIndex = this.GetColumnIndex(column);
  if(!helper || columnIndex === null) 
   return;
  if(!helper.IsValidVisibleIndex(visibleIndex))
   return;
  if(helper.IsEditingCell(visibleIndex, columnIndex))
   return;
  if(!ASPx.IsExists(displayText))
   displayText = helper.GetColumnDisplayTextByEditor(value, visibleIndex, columnIndex);
  if(helper.IsCheckColumn(columnIndex))
   displayText = helper.GetCheckColumnDisplayText(value, columnIndex);
  if(helper.IsColorEditColumn(columnIndex))
   displayText = helper.GetColorEditColumnDisplayText(value, columnIndex);
  helper.SetCellValue(visibleIndex, columnIndex, value, displayText, cancelCellHighlighting);
  helper.ResetCellValidationState(visibleIndex, columnIndex);
  helper.UpdateSyncInput(); 
  helper.UpdateItem(visibleIndex, [columnIndex], false, false, true);
  helper.UpdateCommandButtonsEnabled();
 },
 GetCellValue: function(visibleIndex, column, initial) {
  var helper = this.GetHelper();
  var columnIndex = this.GetColumnIndex(column);
  if(!helper || columnIndex === null) return;
  return helper.GetCellValue(visibleIndex, columnIndex, initial);
 },
 GetCellTextContainer: function(visibleIndex, column) {
  var helper = this.GetHelper();
  var columnIndex = this.GetColumnIndex(column);
  if(!helper || columnIndex === null) return;
  return helper.GetCellTextContainer(visibleIndex, columnIndex);
 },
 HasChanges: function(visibleIndex, column) {
  var helper = this.GetHelper();
  if(!helper) return false;
  var columnIndex = this.GetColumnIndex(column);
  return helper.HasChanges(visibleIndex, columnIndex);
 },
 ResetChanges: function(visibleIndex, columnIndex) {
  var helper = this.GetHelper();
  if(!helper) return;
  helper.ResetChanges(visibleIndex, columnIndex);
 },
 StartEdit: function(visibleIndex, columnIndex) {
  var helper = this.GetHelper();
  if(!helper) return;
  helper.StartEdit(visibleIndex, columnIndex);
 },
 EndEdit: function() {
  var helper = this.GetHelper();
  if(!helper || helper.focusHelper.lockUserEndEdit) 
   return;
  helper.EndEdit();
 },
 MoveFocusBackward: function() {
  var helper = this.GetHelper();
  if(!helper) return;
  return helper.focusHelper.MoveFocusPrev();
 },
 MoveFocusForward: function() {
  var helper = this.GetHelper();
  if(!helper) return;
  return helper.focusHelper.MoveFocusNext();
 },
 IsColumnEdited: function(column) {
  var helper = this.GetHelper();
  if(!helper || !column) return false;
  return helper.IsColumnEdited(column.index);
 },
 ValidateItems: function(validateOnlyModified) {
  var helper = this.GetHelper();
  if(!helper) return false;
  return !!helper.UserValidateItems(null, validateOnlyModified).isValid;
 },
 ValidateItem: function(visibleIndex) {
  var helper = this.GetHelper();
  if(!helper) return false;
  return !!helper.UserValidateItems(visibleIndex).isValid;
 },
 GetItemVisibleIndices: function(includeDeleted) {
  var helper = this.GetHelper();
  if(!helper) return [ ];
  return helper.GetDataItemVisibleIndices(!includeDeleted);
 },
 GetInsertedItemVisibleIndices: function() {
  var helper = this.GetHelper();
  if(!helper) return [ ];
  var indices = helper.insertedItemIndices.slice();
  if(helper.IsNewItemOnTop())
   indices.reverse();
  return indices;
 },
 GetDeletedItemVisibleIndices: function() {
  var helper = this.GetHelper();
  if(!helper) return [ ];
  return helper.GetDeletedItemVisibleIndices();
 },
 IsDeletedItem: function(visibleIndex) {
  return this.grid.IsBatchEditDeletedItem(visibleIndex);
 },
 IsNewItem: function(visibleIndex) {
  var helper = this.GetHelper();
  if(!helper) return false;
  return helper.IsNewItem(visibleIndex);
 },
 GetEditCellInfo: function() {
  var helper = this.GetHelper();
  if(!helper || !helper.IsEditing()) 
   return null;
  return this.grid.CreateCellInfo(helper.editItemVisibleIndex, helper.GetFocusedColumn());
 },
 AddNewItem: function() {
  var helper = this.GetHelper();
  if(helper)
   helper.AddNewItem();
 },
 DeleteItem: function(visibleIndex) { 
  var helper = this.GetHelper();
  if(helper)
   helper.DeleteItem(visibleIndex); 
 },
 DeleteItemByKey: function(key) {
  var helper = this.GetHelper();
  if(helper)
   helper.DeleteItemByKey(key);
 },
 RecoverItem: function(visibleIndex) {
  var helper = this.GetHelper();
  if(helper)
   helper.RecoverItemByIndex(visibleIndex); 
 },
 RecoverItemByKey: function(key) {
  var helper = this.GetHelper();
  if(helper)
   helper.RecoverItem(key);
 }
});
var ASPxClientGridCellInfo = ASPx.CreateClass(null, {
 constructor: function(visibleIndex, column) {
  this.itemVisibleIndex = visibleIndex;
  this.column = column;
 }
});
var ASPxClientGridToolbarItemClickEventArgs = ASPx.CreateClass(ASPxClientProcessingModeEventArgs, {
 constructor: function(toolbarIndex, toolbarName, item, processOnServer) {
  this.constructor.prototype.constructor.call(this, processOnServer);
  this.toolbarIndex = toolbarIndex;
  this.toolbarName = toolbarName;
  this.item = item;
  this.usePostBack = false;
 }
});
ASPxClientGridBase.PostponeInitialize = function(name, info){
 var grid = ASPx.GetControlCollection().Get(name);
 if(grid) {
  grid.styleInfo = info.styleInfo;
  grid.cButtonIDs = info.commandButtonIDs;
  if(grid.batchEditClientState)
   grid.batchEditClientState.recoverButtonsInfo = info.recoverButtonsInfo;
  grid.EnsureRowKeys();
  grid.UpdateItemsStyle();
 }
};
ASPx.GHeaderMouseDown = function(name, element, e) {
 var grid = ASPx.GetControlCollection().Get(name);
 if(grid != null) 
  grid.HeaderMouseDown(element, e);
};
ASPx.GSort = function(name, columnIndex) {
 var grid = ASPx.GetControlCollection().Get(name);
 if(grid != null)  
  grid.SortBy(columnIndex);
};
ASPx.GVPopupEditFormOnInit = function(name, popup) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null)
  window.setTimeout(function() { gv.OnPopupEditFormInit(popup); }, 0);
};
ASPx.GVPagerOnClick = function(name, value) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) 
  gv.doPagerOnClick(value);
};
ASPx.GVFilterKeyPress = function(name, element, e) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) 
  gv.GetFilterHelper().OnColumnFilterInputKeyPress(element, e);
};
ASPx.GVFilterSpecKeyPress = function(name, element, e) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) 
  gv.GetFilterHelper().OnColumnFilterInputSpecKeyPress(element, e);
};
ASPx.GVFilterChanged = function(name, element) {
 window.setTimeout(function() {
  var gv = ASPx.GetControlCollection().Get(name);
  var el = ASPx.GetControlCollection().Get(element.name);
  if(gv != null && el != null) 
   gv.GetFilterHelper().OnColumnFilterInputChanged(el);
 }, 0);
};
ASPx.GVFilterUserInput = function(name, element) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null)
  gv.GetFilterHelper().OnColumnFilterUserInput(element);
};
ASPx.GVShowParentRows = function(name, evt, element) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) {
  if(element)
   gv.OnParentRowMouseEnter(element);  
  else 
   gv.OnParentRowMouseLeave(evt);
 }
};
ASPx.GTableClick = function(name, evt) {
 var g = ASPx.GetControlCollection().Get(name);
 if(g != null && g.NeedProcessTableClick(evt))
  g.mainTableClick(evt);
};
ASPx.GVTableDblClick = function(name, evt) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null && gv.NeedProcessTableClick(evt))
  gv.mainTableDblClick(evt);
};
ASPx.GVCustWindowCloseUp = function(name) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) {
  gv.RaiseCustomizationWindowCloseUp();
 }
};
ASPx.GVApplyFilterPopup = function(name) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null)
  gv.ApplyHeaderFilterByColumn();
};
ASPx.GVShowFilterControl = function(name) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) {
  gv.ShowFilterControl();
 }
};
ASPx.GVCloseFilterControl = function(name) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) {
  gv.CloseFilterControl();
 }
};
ASPx.GVSetFilterEnabled = function(name, value) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) {
  gv.SetFilterEnabled(value);
 }
};
ASPx.GVApplyFilterControl = function(name) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null)
  gv.ApplyFilterControl();
};
ASPx.GVFilterRowMenu = function(name, columnIndex, element) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null)
  gv.GetFilterHelper().FilterRowMenuButtonClick(columnIndex, element);
};
ASPx.GVFilterRowMenuClick = function(name, e) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null)
  gv.GetFilterHelper().FilterRowMenuItemClick(e.item);
};
ASPx.GCmdToolbarMenuItemClick = function(name, toolbar, e) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null)
  gv.GetToolbarHelper().OnToolbarMenuItemClick(toolbar, e);
};
ASPx.GVScheduleCommand = function(name, commandArgs, postponed, event) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null)
  gv.ScheduleUserCommand(commandArgs, postponed, ASPx.Evt.GetEventSource(event));
};
ASPx.GVHFCancelButtonClick = function(name) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null)
  gv.GetHeaderFilterPopup().Hide();
};
ASPx.GridCellStyleManager = GridCellStyleManager;
ASPx.GridLayoutHelper = GridLayoutHelper;
ASPx.GridViewDragHelper = GridViewDragHelper;
ASPx.GridCallbackHelper = GridCallbackHelper;
ASPx.GridSortOrder = GridSortOrder;
ASPx.ASPxClientGridExportFormat = ASPxClientGridExportFormat;
ASPx.ASPxClientGridItemStyle = ASPxClientGridItemStyle;
window.ASPxClientGridItemStyle = ASPxClientGridItemStyle; 
window.ASPxClientGridBase = ASPxClientGridBase;
window.ASPxClientGridColumnBase = ASPxClientGridColumnBase;
window.ASPxClientGridViewCallbackCommand = ASPxClientGridViewCallbackCommand;
window.ASPxClientGridBatchEditStartEditingEventArgs = ASPxClientGridBatchEditStartEditingEventArgs;
window.ASPxClientGridBatchEditEndEditingEventArgs = ASPxClientGridBatchEditEndEditingEventArgs;
window.ASPxClientGridBatchEditItemValidatingEventArgs = ASPxClientGridBatchEditItemValidatingEventArgs;
window.ASPxClientGridBatchEditConfirmShowingEventArgs = ASPxClientGridBatchEditConfirmShowingEventArgs;
window.ASPxClientGridBatchEditTemplateCellFocusedEventArgs = ASPxClientGridBatchEditTemplateCellFocusedEventArgs;
window.ASPxClientGridBatchEditClientChangesEventArgs = ASPxClientGridBatchEditClientChangesEventArgs;
window.ASPxClientGridBatchEditItemInsertingEventArgs = ASPxClientGridBatchEditItemInsertingEventArgs;
window.ASPxClientGridBatchEditItemDeletingEventArgs = ASPxClientGridBatchEditItemDeletingEventArgs;
window.ASPxClientGridFocusedCellChangingEventArgs = ASPxClientGridFocusedCellChangingEventArgs;
window.ASPxClientGridBatchEditApi = ASPxClientGridBatchEditApi;
window.ASPxClientGridCellInfo = ASPxClientGridCellInfo;
window.ASPxClientGridColumnMovingTargetPosition = ASPxClientGridColumnMovingTargetPosition;
window.ASPxClientGridToolbarItemClickEventArgs = ASPxClientGridToolbarItemClickEventArgs;
})();

(function() {
var GridViewLayoutHelper = ASPx.CreateClass(ASPx.GridLayoutHelper, {
 constructor: function(grid) {
  this.constructor.prototype.constructor.call(this, grid);
  this.adaptiveLayoutInfo = null;
  this.mergeIntervals = null;
  this.groupLevels = null;
  this.spannedRowIds = [
   ASPx.GridViewConsts.GroupRowID,
   ASPx.GridViewConsts.GroupRowExpID,
   ASPx.GridViewConsts.PreviewRowID,
   ASPx.GridViewConsts.DetailRowID,
   ASPx.GridViewConsts.EmptyDataRowID,
   ASPx.GridViewConsts.EditingErrorItemID
  ];
  this.spannedTemplatedRowIds = [
   ASPx.GridViewConsts.DataRowID,
   ASPx.GridViewConsts.FooterRowID,
   ASPx.GridViewConsts.GroupFooterRowID,
   ASPx.GridViewConsts.FilterRowID,
   ASPx.GridViewConsts.EditingRowID
  ];
  this.spannedTemplatedCellIds = [
   ASPx.GridViewConsts.DataRowTemplateCellID,
   ASPx.GridViewConsts.FooterRowTemplateCellID,
   ASPx.GridViewConsts.GroupFooterRowTemplateCellID,
   ASPx.GridViewConsts.FilterRowTemplateCellID,
   ASPx.GridViewConsts.EditFormTableCellID
  ];
  this.cachedHasCellMerging = null;
  this.cachedHasServerGroupLevelInfo = null;
 },
 GetSpannedRowRegexp: function() {
  if(!this.spannedRowRegExp)
   this.spannedRowRegExp = new RegExp(this.GetSpannedElementPattern(this.spannedRowIds));
  return this.spannedRowRegExp;
 },
 GetSpannedTemplatedRowRegexp: function() {
  if(!this.spannedTemplatedRowRegExp)
   this.spannedTemplatedRowRegExp = new RegExp(this.GetSpannedElementPattern(this.spannedTemplatedRowIds));
  return this.spannedTemplatedRowRegExp;
 },
 GetSpannedTemplatedCellRegexp: function() {
  if(!this.spannedTemplatedCellRegExp)
   this.spannedTemplatedCellRegExp = new RegExp(this.GetSpannedElementPattern(this.spannedTemplatedCellIds));
  return this.spannedTemplatedCellRegExp;
 },
 GetSpannedElementPattern: function(idParts) {
  return "^" + this.grid.name + "_(" + idParts.join("|") + ")(-?\\d+)?(_\\d+)?$"; 
 },
 IsSpannedRow: function(row) { 
  if(!row) return false;
  var isTemplateRow = this.GetSpannedTemplatedRowRegexp().test(row.id);
  if(isTemplateRow) {
   var cell = this.GetSpannedCell(row);
   return cell && this.GetSpannedTemplatedCellRegexp().test(cell.id);
  }
  return this.GetSpannedRowRegexp().test(row.id);
 },
 GetSpannedCell: function(row) { return this.grid.GetLastNonAdaptiveIndentCell(row); },
 IsArmatureRowRequired: function() { return this.grid.HasScrolling() || this.grid.AllowResizing(); }, 
 GetArmatureRows: function() { return this.GetAllTables().map(function(table) { return table.rows[0]; }); },
 GetColumnWidthInfo: function() { return this.grid.clientMoveColumnWidths; },
 GetColumnWidth: function(columnIndex) { 
  var info = this.GetColumnWidthInfo();
  if(!info) return null;
  var colWidth = info[columnIndex];
  return colWidth || "";
 },
 GetGridName: function() { return this.grid.name; },
 GetTotalIndentCount: function() { return this.grid.indentColumnCount; },
 GetGroupFooterVisibleIndices: function() { return this.grid.GetGroupFooterVisibleIndices(); },
 GetShowColumnHeaders: function() { return this.grid.showColumnHeaders; },
 GetShowFilterRow: function() { return !!this.grid.GetFilterRow(); },
 GetShowFooterRow: function() { return !!this.grid.GetFooterRow(); },
 GetShowEditingRow: function() { return this.IsInlineEditMode() && this.grid.GetEditingRow(); },
 IsBatchEditMode: function() { return this.grid.IsBatchEditMode(); },
 IsInlineEditMode: function() { return this.grid.IsInlineEditMode(); },
 HasMergedGroups: function() { return !!this.grid.hasMergedGroups; },
 GetAllTableRows: function() {
  var rows = [];
  var tables = this.GetAllTables();
  for(var i = 0; i < tables.length; i++)
   rows = rows.concat([].slice.call(tables[i].rows));
  return rows;
 },
 GetAllTables: function() {
  var grid = this.grid;
  var helper = grid.GetTableHelper();
  var headerTable = helper ? helper.GetHeaderTable() : null;
  var contentTable = grid.GetMainTable();
  var footerTable = helper ? helper.GetFooterTable() : null;
  return [ headerTable, contentTable, footerTable ].filter(function(table) { return !!table; });
 },
 Invalidate: function() { 
  ASPx.GridLayoutHelper.prototype.Invalidate.call(this);
  this.adaptiveLayoutInfo = null;
  this.mergeIntervals = null;
  this.groupLevels = null;
  this.cachedHasCellMerging = null;
  this.cachedHasServerGroupLevelInfo = null;
 },
 GetFixedColumnsHelper: function() { return this.grid.GetFixedColumnsHelper(); },
 GetIndentColumnCount: function() { return this.grid.indentColumnCount; },
 GetHasDetailRows: function() { return this.grid.hasDetailRows; },
 GetShowDetailButton: function() { return this.grid.showDetailButton; },
 GetHasDetailButton: function() { return this.GetHasDetailRows() && this.GetShowDetailButton(); },
 GetShowGroupButton: function() { return this.grid.showGroupButton; },
 GetHasGroupButton: function() { return this.GetGroupIndentsCount() > 0 && this.GetShowGroupButton() && !this.GetHasGroupRowTemplate(); },
 GetAdaptiveButtonPos: function() { return this.grid.adaptiveButtonPos; },
 GetHasFilterRowTemplate: function() { return this.grid.hasFilterRowTemplate; },
 GetHasDataRowTemplate: function() { return this.grid.hasDataRowTemplate; },
 GetHasGroupRowTemplate: function() { return this.grid.hasGroupRowTemplate; },
 GetHasGroupFooterRowTemplate: function() { return this.grid.hasGroupFooterRowTemplate; },
 GetHasFooterRowTemplate: function() { return this.grid.hasFooterRowTemplate; },
 HasServerGroupLevelInfo: function() {
  if(this.cachedHasServerGroupLevelInfo === null) {
   var groupLevelInfo = this.GetGroupLevelServerInfo();
   this.cachedHasServerGroupLevelInfo = groupLevelInfo && Object.keys(groupLevelInfo).length > 0;
  }
  return this.cachedHasServerGroupLevelInfo;
 },
 HasCellMerging: function() { 
  if(this.cachedHasCellMerging === null) {
   var mergedCellInfo = this.GetMergedCellServerInfo();
   this.cachedHasCellMerging = mergedCellInfo && Object.keys(mergedCellInfo).length > 0;
  }
  return this.cachedHasCellMerging;
 },
 GetGroupLevelServerInfo: function() { return this.grid.stateObject.groupLevelState || { }; },
 SetGroupLevelServerInfo: function(info) { this.grid.stateObject.groupLevelState = info; },
 GetGroupRowLevel: function(visibleIndex) { 
  this.EnsureGroupLevelInfo();
  if(!this.groupLevels) return -1;
  var level = this.groupLevels[visibleIndex];
  return ASPx.IsExists(level) ? level : -1;
 },
 EnsureGroupLevelInfo: function() {
  if(this.groupLevels || !this.HasServerGroupLevelInfo()) 
   return;
  var serverInfo = this.GetGroupLevelServerInfo();
  this.groupLevels = { };
  for(var level in serverInfo) {
   if(!serverInfo.hasOwnProperty(level)) continue;
   level = parseInt(level);
   var intervals = serverInfo[level];
   for(var i = 0; i < intervals.length; i++) {
    var interval = intervals[i];
    var start = interval[0];
    var end = interval[1];
    for(var visibleIndex = start; visibleIndex <= end; visibleIndex++)
     this.groupLevels[visibleIndex] = level;
   }
  }
 },
 GetGroupRowColSpan: function(visibleIndex) { 
  var groupLevel = this.GetGroupRowLevel(visibleIndex);
  if(!ASPx.IsExists(groupLevel))
   return -1;
  var groupIndentsCount = this.GetGroupIndentsCount();
  var layoutWidth = this.GetLayoutWidth();
  var detailButtonWidth = this.GetHasDetailButton() ? 1 : 0;
  var groupButtonWidth = this.GetHasGroupButton() ? 1 : 0;
  return layoutWidth + detailButtonWidth + groupIndentsCount - groupLevel - groupButtonWidth;
 },
 GetGroupFooterRowColSpan: function(visibleIndex) { 
  var layoutWidth = this.GetLayoutWidth();
  var groupLevel = this.GetGroupRowLevel(visibleIndex);
  var footerIndentCount = this.GetGroupIndentsCount() - groupLevel - 1;
  return layoutWidth + footerIndentCount;
 },
 GetGroupIndentsCount: function() {
  return this.HasMergedGroups() ? 1 : this.GetColumnHelper().GetGroupColumnCount();
 },
 GetIndentCellCount: function(visibleIndex, levelIndex, rowType) { 
  var result = this.GetIndentCellCountCore(visibleIndex, rowType);
  if(levelIndex === 0)
   return Math.max(0, result);
  var groupIndentsCount = this.GetGroupIndentsCount();
  var detailButtonWidth = this.GetHasDetailButton() ? 1 : 0;
  if(rowType === ASPx.GridViewRowType.Footer && groupIndentsCount > 0) 
   result--;
  switch(rowType) {
   case ASPx.GridViewRowType.Footer:
   case ASPx.GridViewRowType.Filter:
   case ASPx.GridViewRowType.Data:
   case ASPx.GridViewRowType.BatchEtalon:
   case ASPx.GridViewRowType.GroupFooter:
    if(detailButtonWidth > 0)
     result--;
    break;
   case ASPx.GridViewRowType.Header:
    result = 0;
  }
  return Math.max(0, result);
 },
 GetIndentCellCountCore: function(visibleIndex, rowType) {
  var groupButtonWidth = this.GetHasGroupButton() ? 1 : 0;
  var detailButtonWidth = this.GetHasDetailButton() ? 1 : 0;
  var leftAdaptiveButtonWidth = this.GetAdaptiveButtonPos() === ASPx.GridViewAdaptiveDetailButtonPosition.Left ? 1 : 0;
  var groupIndentsCount = this.GetGroupIndentsCount();
  var groupLevel = this.GetGroupRowLevel(visibleIndex);
  var totalIndentCount = groupIndentsCount + leftAdaptiveButtonWidth + detailButtonWidth;
  switch(rowType) {
   case ASPx.GridViewRowType.Header:
   case ASPx.GridViewRowType.Filter:
   case ASPx.GridViewRowType.Data:
   case ASPx.GridViewRowType.BatchEtalon:
   case ASPx.GridViewRowType.InlineEdit:
    return totalIndentCount;
   case ASPx.GridViewRowType.Footer:
    return leftAdaptiveButtonWidth + detailButtonWidth + (groupIndentsCount > 0 ? 1 : 0);
   case ASPx.GridViewRowType.Group:
    return groupLevel + groupButtonWidth;
   case ASPx.GridViewRowType.GroupFooter:
    var footerIndentCount = groupIndentsCount - groupLevel - 1;
    var dataIndentCount = totalIndentCount - footerIndentCount;
    var footerIndentWidth = (footerIndentCount > 0 && !this.GetHasGroupFooterRowTemplate()) ? 1 : 0;
    return dataIndentCount + footerIndentWidth;
  }
  return 0;
 },
 GetRowInfo: function(rowID) {
  if(!rowID) return null;
  var pattern = "^" + this.GetGridName() + "_([a-z]+)(-?\\d+)?(_\\d+)?$";
  var regex = new RegExp(pattern, "i");
  var matches = regex.exec(rowID);
  if(!matches || matches.length !== 4)
   return null;
  var firstNumber = parseInt(matches[2]);
  var secondNumber = matches[3] !== undefined ? parseInt(matches[3].substr(1)) : NaN;
  var rowType = this.GetRowTypeByPartialID(matches[1]);
  if(rowType === null)
   return null;
  var visibleIndex = -1;
  var level = 0;
  switch(rowType) {
   case ASPx.GridViewRowType.Header:
    if(!isNaN(secondNumber)) return null;
    level = firstNumber;
    break;
   case ASPx.GridViewRowType.Filter:
   case ASPx.GridViewRowType.Footer:
   case ASPx.GridViewRowType.InlineEdit:
   case ASPx.GridViewRowType.BatchEtalon:
    if(!isNaN(firstNumber)) return null;
    level = secondNumber;
    break;
   case ASPx.GridViewRowType.Group:
    if(isNaN(firstNumber) || !isNaN(secondNumber)) return null;
    visibleIndex = firstNumber;
    break;
   case ASPx.GridViewRowType.Data:
   case ASPx.GridViewRowType.GroupFooter:
    if(isNaN(firstNumber)) return null;
    visibleIndex = firstNumber;
    level = secondNumber;
    break;
  }
  if(isNaN(level))
   level = 0;
  return { rowType: rowType, visibleIndex: visibleIndex, level: level };
 },
 GetRowTypeByPartialID: function(partialID) {
  switch(partialID) {
   case ASPx.GridViewConsts.HeaderRowID:
    return ASPx.GridViewRowType.Header;
   case ASPx.GridViewConsts.FilterRowID:
    return ASPx.GridViewRowType.Filter;
   case ASPx.GridViewConsts.DataRowID:
    return ASPx.GridViewRowType.Data;
   case ASPx.GridViewConsts.GroupRowID:
   case ASPx.GridViewConsts.GroupRowExpID:
    return ASPx.GridViewRowType.Group;
   case ASPx.GridViewConsts.GroupFooterRowID:
    return ASPx.GridViewRowType.GroupFooter;
   case ASPx.GridViewConsts.FooterRowID:
    return ASPx.GridViewRowType.Footer;
   case ASPx.GridViewConsts.EditingRowID:
    return ASPx.GridViewRowType.InlineEdit; 
   case ASPx.GridViewConsts.DataRowID + "new":
    return ASPx.GridViewRowType.BatchEtalon;
  }
  return null;
 },
 GetRowCellMap: function(info) {
  if(!info || info.rowType === ASPx.GridViewRowType.Group) 
   return null;
  var layout = null;
  if(info.rowType === ASPx.GridViewRowType.Header)
   layout = this.GetHeaderLayout();
  else 
   layout = info.rowType === ASPx.GridViewRowType.Data ? this.GetDataRowLayout(info.visibleIndex) : this.GetEtalonDataRowLayout();
  var result = { };
  var indentCount = this.GetIndentCellCount(info.visibleIndex, info.level, info.rowType);
  var level = layout[info.level];
  for(var i = 0; i < level.length; i++)
   result[level[i].columnIndex] = indentCount + i;
  return result;
 },
 CopyIndentCells: function(row, cloneRow, visibleIndex, cloneLevelIndex, rowType) {
  if(!this.IsSpannedRow(row)) {
   this.CopyIndentCellsFromLeft(row, cloneRow, visibleIndex, cloneLevelIndex, rowType);
   this.CopyIndentCellsFromRight(row, cloneRow, visibleIndex, cloneLevelIndex, rowType);
  }
 },
 CopyIndentCellsFromLeft: function(row, cloneRow, visibleIndex, cloneLevelIndex, rowType) {
  if(rowType === ASPx.GridViewRowType.Header)
   return;
  var firstRowIndentCellCount = this.GetIndentCellCount(visibleIndex, 0, rowType);
  var cloneRowIndentCellCount = this.GetIndentCellCount(visibleIndex, cloneLevelIndex, rowType);
  var indentCellIndices = ASPx.Data.Range(firstRowIndentCellCount, 0);
  var detailIndentCellIndex = this.GetDetailIndentCellIndex(visibleIndex, 0, rowType);
  var footerGroupIndentCellIndex = this.GetFooterGroupIndentCellIndex(visibleIndex, 0, rowType);
  ASPx.Data.ArrayRemove(indentCellIndices, detailIndentCellIndex);
  ASPx.Data.ArrayRemove(indentCellIndices, footerGroupIndentCellIndex);
  if(indentCellIndices.length !== cloneRowIndentCellCount)
   throw "Wrong indent cell count for clonned row";
  this.CloneIndentCells(row, cloneRow, indentCellIndices);
 },
 CopyIndentCellsFromRight: function(row, cloneRow, visibleIndex, cloneLevelIndex, rowType) { 
  var layoutWidth = this.GetLayoutWidth(rowType === ASPx.GridViewRowType.Header);
  var indentCellCount = this.GetIndentCellCount(visibleIndex, 0, rowType);
  var rightIndentCellIndex = indentCellCount + layoutWidth;
  var indentCellIndices = ASPx.Data.Range(row.cells.length - rightIndentCellIndex, rightIndentCellIndex);
  this.CloneIndentCells(row, cloneRow, indentCellIndices);
 },
 CloneIndentCells: function(row, cloneRow, cellIndices) {
  var targetElement = cloneRow.insertCell();
  for(var i = 0; i < cellIndices.length; i++) {
   var cellIndex = cellIndices[i];
   var cloneCell = row.cells[cellIndex].cloneNode();
   cloneRow.insertBefore(cloneCell, targetElement);
  }
  ASPx.RemoveElement(targetElement);
 },
 GetDetailIndentCellIndex: function(visibleIndex, levelIndex, rowType) {
  if(!this.GetHasDetailButton() || levelIndex > 0) 
   return -1;
  var indentCellCount = this.GetIndentCellCount(visibleIndex, 0, rowType);
  return indentCellCount - 1;
 },
 GetFooterGroupIndentCellIndex: function(visibleIndex, levelIndex, rowType) {
  if(rowType !== ASPx.GridViewRowType.Footer || this.GetHasFooterRowTemplate() || levelIndex > 0) 
   return -1;
  var indentCellCount = this.GetIndentCellCount(visibleIndex, 0, rowType);
  var result = indentCellCount - 1;
  if(this.GetHasDetailButton())
   result--;
  return result;
 },
 UpdateIndentCellRowSpan: function(visibleIndex, rowType) {
  var indentCellCount = this.GetIndentCellCount(visibleIndex, 0, rowType);
  var totalIndentCellIndices = ASPx.Data.Range(indentCellCount, 0);
  var detailIndentCellIndex = this.GetDetailIndentCellIndex(visibleIndex, 0, rowType);
  var footerGroupIndentCellIndex = this.GetFooterGroupIndentCellIndex(visibleIndex, 0, rowType);
  var cellIndices = rowType === ASPx.GridViewRowType.Header ? totalIndentCellIndices : [ detailIndentCellIndex, footerGroupIndentCellIndex ];
  var height = this.GetLayoutHeight(rowType === ASPx.GridViewRowType.Header);
  var row = this.GetRow(visibleIndex, 0, rowType);
  for(var i = 0; i < cellIndices.length; i++) {
   var cellIndex = cellIndices[i];
   if(cellIndex >= 0 && cellIndex < row.cells.length)
    row.cells[cellIndex].rowSpan = height;
  }
 },
 GetColumnHelper: function() { return this.grid.GetColumnHelper(); },
 GetAdaptivityHelper: function() { return this.grid.GetAdaptivityHelper(); },
 GetMergedCellServerInfo: function() { return this.grid.stateObject.mergedCellState || { }; },
 SetMergedCellServerInfo: function(info) { this.grid.stateObject.mergedCellState = info; },
 GetHeaderLayout: function() { return this.GetColumnHelper().GetHeaderLayout(); },
 GetEtalonDataRowLayout: function() { return this.GetColumnHelper().GetDataRowLayout(); },
 GetDataRowLayout: function(visibleIndex) {
  var layout = this.GetEtalonDataRowLayout();
  if(!ASPx.IsExists(visibleIndex) || !this.HasCellMerging())
   return layout;
  var newLayout = [ ];
  for(var i = 0; i < layout.length; i++) {
   var level = layout[i].slice();
   for(var j = level.length - 1; j >= 0; j--) {
    if(this.IsHiddenMergedCell(visibleIndex, level[j].columnIndex))
     level.splice(j, 1); 
   }
   newLayout.push(level);
  }
  return newLayout;
 },
 GetHasRowTemplate: function(rowType) {
  switch(rowType) {
   case ASPx.GridViewRowType.Filter:
    return this.GetHasFilterRowTemplate();
   case ASPx.GridViewRowType.Data:
    return this.GetHasDataRowTemplate();
   case ASPx.GridViewRowType.GroupFooter:
    return this.GetHasGroupFooterRowTemplate();
   case ASPx.GridViewRowType.Footer:
    return this.GetHasFooterRowTemplate();
  }
  return false;
 },
 GetRow: function(visibleIndex, levelIndex, rowType) {
  switch(rowType) {
   case ASPx.GridViewRowType.Header:
    return this.grid.GetHeaderRow(levelIndex);
   case ASPx.GridViewRowType.Filter:
    return this.grid.GetFilterRow(levelIndex);
   case ASPx.GridViewRowType.Data:
    return this.grid.GetDataRow(visibleIndex, levelIndex);
   case ASPx.GridViewRowType.GroupFooter:
    return this.grid.GetGroupFooterRow(visibleIndex, levelIndex);
   case ASPx.GridViewRowType.Footer:
    return this.grid.GetFooterRow(levelIndex);
   case ASPx.GridViewRowType.InlineEdit:
    return this.grid.GetEditingRow(this.grid, levelIndex);
   case ASPx.GridViewRowType.BatchEtalon:
    return this.grid.GetBatchEtalonRow(levelIndex);
  }
  return null;
 },
 GetStretchedRowColsSpan: function(visibleIndex, rowType) { 
  var layoutWidth = this.GetLayoutWidth();
  switch(rowType) {
   case ASPx.GridViewRowType.Filter:
   case ASPx.GridViewRowType.Data:
   case ASPx.GridViewRowType.Footer:
    return layoutWidth;
   case ASPx.GridViewRowType.Group:
    return this.GetGroupRowColSpan(visibleIndex);
   case ASPx.GridViewRowType.GroupFooter:
    return this.GetGroupFooterRowColSpan(visibleIndex);
  }
  return 0;
 },
 GetCell: function(visibleIndex, columnIndex, rowType) {
  switch(rowType) {
   case ASPx.GridViewRowType.Header:
    return this.GetHeaderCell(columnIndex);
   case ASPx.GridViewRowType.Filter:
    return this.GetFilterCell(columnIndex);
   case ASPx.GridViewRowType.Data:
    return this.GetDataCell(visibleIndex, columnIndex);
   case ASPx.GridViewRowType.GroupFooter:
    return this.GetGroupFooterCell(visibleIndex, columnIndex);
   case ASPx.GridViewRowType.Footer:
    return this.GetFooterCell(columnIndex);
   case ASPx.GridViewRowType.BatchEtalon:
    return this.GetBatchEtalonCell(visibleIndex, columnIndex);
   case ASPx.GridViewRowType.InlineEdit:
    return this.GetInlineEditCell(columnIndex);
  }
  return null;
 },
 UpdateStretchedRowsColSpan: function() {
  var helper = this.GetFixedColumnsHelper();
  this.UpdateStretchedRowsColSpanCore(helper ? helper.hiddenColumnCount : 0);
 },
 UpdateStretchedRowsColSpanCore: function(columnsToHide) {
  var groupRowRegexp = new RegExp(this.GetSpannedElementPattern([ ASPx.GridViewConsts.GroupRowID, ASPx.GridViewConsts.GroupRowExpID ]));
  var groupFooterRegexp = new RegExp(this.GetSpannedElementPattern([ ASPx.GridViewConsts.GroupFooterRowID ]));
  var totalSpan = this.GetLayoutWidth(false);
  var stretchedRows = this.GetAllTableRows().filter(function(row) { return this.IsSpannedRow(row); }.aspxBind(this));
  for(var i = 0; i < stretchedRows.length; i++) {
   var row = stretchedRows[i];
   var cell = this.GetSpannedCell(row);
   var colSpan = totalSpan;
   if(groupRowRegexp.test(row.id)) {
    var matches = row.id.match(groupRowRegexp);
    var visibleIndex = parseInt(matches[2]);
    colSpan = this.GetStretchedRowColsSpan(visibleIndex, ASPx.GridViewRowType.Group);
   }
   if(groupFooterRegexp.test(row.id)) {
    var matches = row.id.match(groupFooterRegexp);
    var visibleIndex = parseInt(matches[2]);
    colSpan = this.GetStretchedRowColsSpan(visibleIndex, ASPx.GridViewRowType.GroupFooter);
   }
   ASPx.Attr.ChangeCellSpanCount(cell, colSpan - columnsToHide, true);
  }
 },
 GetHeaderCell: function(columnIndex) { return this.grid.GetHeader(columnIndex); },
 GetFilterCell: function(columnIndex) { return this.GetCellCore(-1, columnIndex, ASPx.GridViewRowType.Filter); },
 GetDataCell: function(visibleIndex, columnIndex) { return this.GetCellCore(visibleIndex, columnIndex, ASPx.GridViewRowType.Data); },
 GetGroupFooterCell: function(visibleIndex, columnIndex) { return this.GetCellCore(visibleIndex, columnIndex, ASPx.GridViewRowType.GroupFooter); },
 GetFooterCell: function(columnIndex) { return this.GetCellCore(-1, columnIndex, ASPx.GridViewRowType.Footer); },
 GetBatchEtalonCell: function(visibleIndex, columnIndex) { return this.GetCellCore(visibleIndex, columnIndex, ASPx.GridViewRowType.BatchEtalon); },
 GetInlineEditCell: function(columnIndex) { 
  if(this.IsInlineEditMode())
   return this.GetCellCore(-1, columnIndex, ASPx.GridViewRowType.InlineEdit); 
  return null;
 },
 GetCellCore: function(visibleIndex, columnIndex, rowType) {
  if(this.GetHasRowTemplate(rowType)) return null;
  columnIndex = parseInt(columnIndex);
  var layout = this.GetEtalonDataRowLayout();
  var pos = this.GetColumnHelper().FindColumnLayoutPos(layout, columnIndex);
  if(pos.levelIndex < 0 || pos.cellIndex < 0)
   return null;
  visibleIndex = this.ResolveMergedCellVisibleIndex(visibleIndex, columnIndex);
  var cellIndex = pos.cellIndex + this.GetIndentCellCount(visibleIndex, pos.levelIndex, rowType);
  if(this.HasCellMerging() && (rowType === ASPx.GridViewRowType.Data || rowType === ASPx.GridViewRowType.BatchEtalon))
   cellIndex -= this.CalcHiddenMergedCellCount(visibleIndex, columnIndex);
  var row = this.GetRow(visibleIndex, pos.levelIndex, rowType);
  return row && cellIndex >= 0 && cellIndex < row.cells.length ? row.cells[cellIndex] : null;
 },
 GetHeaderRows: function() {
  var height = this.grid.showColumnHeaders ? this.GetLayoutHeight(true) : 0;
  return ASPx.Data.Range(height, 0).map(function(i) { return this.grid.GetHeaderRow(i); }.bind(this));
 },
 GetFilterRows: function() {
  var height = this.GetLayoutHeight(false);
  return ASPx.Data.Range(height, 0).map(function(i) { return this.grid.GetFilterRow(i); }.bind(this));
 },
 GetLayoutWidth: function(isHeader) {
  var layout = isHeader ? this.GetHeaderLayout() : this.GetEtalonDataRowLayout();
  return this.GetLayoutWidthCore(layout);
 },
 GetLayoutWidthCore: function(layout) {
  if(!layout || layout.length === 0) 
   return 0;
  var firstLevel = layout[0];
  if(!firstLevel || firstLevel.length === 0)
   return 0;
  return firstLevel.reduce(function(prevValue, node) { return prevValue + node.colSpan; }, 0);
 },
 GetLayoutHeight: function(isHeader) {
  var layout = isHeader ? this.GetHeaderLayout() : this.GetEtalonDataRowLayout();
  return this.GetLayoutHeightCore(layout);
 },
 GetLayoutHeightCore: function(layout) {
  return layout ? layout.length : 0;
 },
 GetColumnIndex: function(cellIndex, visibleIndex, levelIndex) { 
  if(!levelIndex || levelIndex < 0)
   levelIndex = 0;
  var layout = this.GetDataRowLayout(visibleIndex); 
  if(layout.length <= levelIndex)
   return -1;
  var level = layout[levelIndex];
  cellIndex -= this.GetIndentCellCount(visibleIndex, levelIndex, ASPx.GridViewRowType.Data);
  return cellIndex >= 0 && cellIndex < level.length ? level[cellIndex].columnIndex : -1;
 },
 GetDataCellIndex: function(columnIndex, visibleIndex) { 
  var layout = this.GetDataRowLayout(visibleIndex);
  var pos = this.GetColumnHelper().FindColumnLayoutPos(layout, columnIndex);
  if(pos.levelIndex < 0 || pos.cellIndex < 0)
   return -1;
  return pos.cellIndex + this.GetIndentCellCount(visibleIndex, pos.levelIndex, ASPx.GridViewRowType.Data);
 },
 IsMergedCell: function(visibleIndex, columnIndex) { 
  return !!this.GetMergeInterval(visibleIndex, columnIndex);
 },
 IsHiddenMergedCell: function(visibleIndex, columnIndex) {
  return visibleIndex !== this.ResolveMergedCellVisibleIndex(visibleIndex, columnIndex);
 },
 ResolveMergedCellVisibleIndex: function(visibleIndex, columnIndex) {
  if(!this.HasCellMerging()) return visibleIndex;
  var interval = this.GetMergeInterval(visibleIndex, columnIndex);
  return interval ? interval[0] : visibleIndex;
 },
 CalcHiddenMergedCellCount: function(visibleIndex, columnIndex) {
  var layout = this.GetEtalonDataRowLayout();
  var pos = this.GetColumnHelper().FindColumnLayoutPos(layout, columnIndex);
  if(pos.levelIndex < 0 || pos.cellIndex < 0)
   return 0;
  var result = 0;
  var level = layout[pos.levelIndex];
  for(var j = 0; j < pos.cellIndex; j++) {
   if(this.IsHiddenMergedCell(visibleIndex, level[j].columnIndex))
    result++;
  }
  return result;
 },
 GetMergeInterval: function(visibleIndex, columnIndex) {
  this.EnsureMergeIntervals();
  var columnIntervals = this.mergeIntervals[columnIndex];
  return columnIntervals ? columnIntervals[visibleIndex] : null;
 },
 EnsureMergeIntervals: function() {
  if(this.mergeIntervals) return;
  this.mergeIntervals = { };
  var serverInfo = this.GetMergedCellServerInfo();
  for(var columnIndex in serverInfo) {
   if(!serverInfo.hasOwnProperty(columnIndex)) continue;
   var columnIntervals = { };
   var serverIntervals = serverInfo[columnIndex];
   for(var i = 0; i < serverIntervals.length; i++) {
    var interval = serverIntervals[i];
    var start = interval[0];
    var end = interval[1];
    for(var j = start; j <= end; j++)
     columnIntervals[j] = interval;
   }
   this.mergeIntervals[parseInt(columnIndex)] = columnIntervals;
  }
 },
 GetAdaptiveRowLayoutInfo: function(visibleIndex) {
  if(!this.adaptiveLayoutInfo) 
   this.adaptiveLayoutInfo = this.CreateAdaptiveLayoutInfo();
  var baseAdaptiveLayout = this.adaptiveLayoutInfo.adaptiveRowLayout || [ ];
  return { 
   dataRowLayout: this.adaptiveLayoutInfo.dataRowLayout || this.GetEtalonDataRowLayout(),
   adaptiveRowLayout : this.IsAdaptiveDetailExpanded(visibleIndex) ? baseAdaptiveLayout : [ ]
  };
 },
 CreateAdaptiveLayoutInfo: function() {
  var adaptiveHelper = this.GetAdaptivityHelper();
  if(!adaptiveHelper) 
   return { };
  var dataRowLayout = [ ];
  var adaptiveColumnIndices = [ ];
  var columnHelper = this.GetColumnHelper();
  var isFormLayoutMode = adaptiveHelper.IsAdaptiveFormLayoutMode();
  if(adaptiveHelper.IsAdaptivityMode()) {
   var hasAnyAdaptive = adaptiveHelper.HasAnyAdaptiveElement();
   if(hasAnyAdaptive) {
    dataRowLayout = [ ];
    adaptiveColumnIndices = isFormLayoutMode ? adaptiveHelper.GetAdaptiveLayoutColumnIndices() : columnHelper.GetVisibleColumnIndices();
   } else {
    dataRowLayout = this.GetEtalonDataRowLayout();
    adaptiveColumnIndices = [ ];
   }
  } else {
   var adaptiveInfo = columnHelper.GetAdaptiveRowInfo();
   dataRowLayout = adaptiveInfo.dataRowLayout;
   var columnIndicesForAdaptiveIndicesOrder = isFormLayoutMode ? adaptiveHelper.GetAdaptiveLayoutColumnIndices() : columnHelper.GetVisibleColumnIndices();
   for(var i = 0; i < columnIndicesForAdaptiveIndicesOrder.length; i++) {
    var columnIndex = columnIndicesForAdaptiveIndicesOrder[i];
    if(adaptiveInfo.adaptiveColumnIndices.indexOf(columnIndex) > -1)
     adaptiveColumnIndices.push(columnIndex);
   }
  }
  return { dataRowLayout: dataRowLayout, adaptiveRowLayout: this.CreateAdaptiveRowLayout(adaptiveColumnIndices) };
 },
 CreateAdaptiveRowLayout: function(columnIndices) {
  var layout = [ ];
  var width = this.GetAdaptiveLayoutWidth();
  var height = Math.ceil(columnIndices.length / width);
  for(var i = 0; i < height; i++) {
   var level = [ ];
   for(var j = 0; j < width; j++) {
    var index = i * width + j;
    if(index < columnIndices.length)
     level.push({ columnIndex: columnIndices[index], colSpan: 1, rowSpan: 1 });
    else
     level[level.length - 1].colSpan++;
   }
   layout.push(level);
  }
  return layout;
 },
 IsAdaptiveDetailExpanded: function(visibleIndex) {
  var helper = this.GetAdaptivityHelper();
  if(!helper || !helper.HasAnyAdaptiveElement())
   return false;
  return helper.IsAdaptivityMode() || helper.expandedAdaptiveDetailIndices.indexOf(visibleIndex) > -1;
 },
 GetAdaptiveLayoutWidth: function() {
  var helper = this.GetAdaptivityHelper();
  return helper.IsAdaptiveFormLayoutMode() ? helper.GetAdaptiveFormLayoutColCount() : helper.adaptiveDetailColumnCount;
 },
 AreDataRowsHidden: function() {
  var helper = this.GetAdaptivityHelper();
  return helper && helper.IsAdaptivityMode() && helper.HasAnyAdaptiveElement();
 },
});
ASPx.GridViewLayoutHelper = GridViewLayoutHelper;
})();
(function() {
var GridViewFilterHelper = ASPx.CreateClass(ASPx.GridFilterHelper, {
 constructor: function(grid) {
  this.constructor.prototype.constructor.call(this, grid);
  this.initialFilterRowState = { };
  this.filterKeyPressTimerId = -1;
  this.filterKeyPressInputValue = "";
  this.filterKeyPressEditor = null;
  this.preparedToCallbackFilterValue = undefined;
  this.preparedFilterValueClearDelay = 150;
  this.filterRowMenuColumnIndex = -1;
  this.currentCheckedItemIndex = -1;
 },
 GetCustDialogHelper: function() { return this.grid.GetCustDialogHelper(); },
 GetBatchEditHelper: function() { return this.grid.GetBatchEditHelper(); },
 GetAutoFilterDelay: function() { return this.grid.autoFilterDelay; },
 IsMultiColumnAutoFilter: function() { return this.grid.allowMultiColumnAutoFilter; },
 GetFilterRowMenu: function() { return this.grid.GetFilterRowMenu(); },
 GetAutoFilterEditor: function(columnIndex) { return this.grid.GetAutoFilterEditor(columnIndex); },
 GetFilterConditionState: function() { return this.grid.filterRowConditions; },
 AutoFilterByColumnCore: function(columnIndex, editorValue) { 
  this.grid.AutoFilterByColumn(columnIndex, editorValue); 
 },
 AutoFilterByMultipleColumns: function(args) {
  this.grid.gridCallBack([ASPxClientGridViewCallbackCommand.ApplyMultiColumnFilter].concat(args));
 },
 SendCallbackToChangeFilterCondition: function(args) {
  this.grid.gridCallBack([ASPxClientGridViewCallbackCommand.FilterRowMenu].concat(args));
 },
 GetColumnIndicesForFilterRow: function() { 
  var columnHelper = this.grid.GetColumnHelper();
  if(this.GetCustDialogHelper())
   return columnHelper.GetAllColumns().map(function(c) { return c.index; });
  return columnHelper.GetVisibleColumnIndices();
 },
 GetFilterCondition: function(columnIndex) { 
  var state = this.GetFilterConditionState();
  return state ? state[columnIndex] : "";
 },
 SetFilterCondition: function(columnIndex, value) { 
  var state = this.GetFilterConditionState();
  if(state)
   state[columnIndex] = value; 
 },
 IsCustDialogVisible: function() {
  var helper = this.GetCustDialogHelper();
  return helper && helper.IsDialogVisible();
 },
 AutoFilterByColumn: function(columnIndex, editorValue) { 
  if(!this.IsCustDialogVisible())
   this.AutoFilterByColumnCore(columnIndex, editorValue); 
 },
 IsBatchUpdateConfirmLocked: function() {
  var batchHelper = this.GetBatchEditHelper();
  return batchHelper && batchHelper.IsUpdateConfirmLocked();
 },
 ApplyColumnAutoFilterCore: function(editor) {
  if(this.IsFilterLocked()) 
   return;
  this.ClearAutoFilterInputTimer();
  var editorValue = editor.GetValueString();
  if(this.IsBatchUpdateConfirmLocked() && this.preparedToCallbackFilterValue != "undefined"  && editorValue === this.preparedToCallbackFilterValue) 
   return;
  if(editor === this.filterKeyPressEditor && editor.GetValueString() == this.filterKeyPressInputValue)
   return;
  var columnIndex = this.ResolveColumnIndex(editor.name);
  if(columnIndex < 0) 
   return;
  this.SaveFilterEditorActiveElement(editor);
  this.preparedToCallbackFilterValue = editorValue;
  window.setTimeout(function() { delete this.preparedToCallbackFilterValue;  }.bind(this), this.preparedFilterValueClearDelay);
  this.AutoFilterByColumn(columnIndex, editorValue);
  this.OnChange(columnIndex);
 },
 ApplyMultiColumnAutoFilter: function(editor) {
  if(this.IsFilterLocked()) 
   return;
  this.SaveFilterEditorActiveElement(editor);
  var args = this.SerializeChangedAutoFilterValues();
  if(args.length > 0)
   this.AutoFilterByMultipleColumns(args);
  var name = editor ? editor.name : "";
  this.OnChange(this.ResolveColumnIndex(name));
 },
 SerializeChangedAutoFilterValues: function() {
  var result = [ ];
  var changedValues = this.GetChangedAutoFilterValues();
  for(var columnIndex in changedValues) {
   if(!changedValues.hasOwnProperty(columnIndex)) continue;
   result.push(columnIndex);
   result.push(changedValues[columnIndex].value);
   result.push(changedValues[columnIndex].filterCondition);
  }
  return result;
 },
 SaveFilterEditorsState: function() {
  ASPx.GridFilterHelper.prototype.SaveFilterEditorsState.call(this);
  this.initialFilterRowState = this.GetFilterRowState();
 },
 ClearFilterEditorsState: function() { 
  ASPx.GridFilterHelper.prototype.ClearFilterEditorsState.call(this);
  this.initialFilterRowState = { };
 },
 GetFilterRowState: function() {
  var indices = this.GetColumnIndicesForFilterRow();
  return ASPx.Data.ArrayToHash(indices, function(columnIndex) { return columnIndex; }, function(columnIndex) { 
   var editor = this.GetAutoFilterEditor(columnIndex);
   return {
    value: editor && editor.GetMainElement() ? editor.GetValueString() : "",
    filterCondition: this.GetFilterCondition(columnIndex)
   };
  }.bind(this));
 },
 GetChangedAutoFilterValues: function() {
  var result = { };
  var currentFilterRowState = this.GetFilterRowState();
  for(var columnIndex in this.initialFilterRowState) {
   if(!this.initialFilterRowState.hasOwnProperty(columnIndex)) continue;
   columnIndex = parseInt(columnIndex);
   var initialState = this.initialFilterRowState[columnIndex];
   var currentState = currentFilterRowState[columnIndex];
   if(currentState.value !== initialState.value || currentState.filterCondition !== initialState.filterCondition)
    result[columnIndex] = { filterCondition: currentState.filterCondition, value: currentState.value !== null ? currentState.value : "" };
  }
  return result;
 },
 OnColumnFilterInputKeyPress: function(editor, e) {
  if(this.OnColumnFilterInputSpecKeyPress(editor, e))
   return;
  this.ClearAutoFilterInputTimer();
  if(editor != this.filterKeyPressEditor)
   this.filterKeyPressInputValue = editor.GetValueString();
  this.CreateAutoFilterTimer(editor);
  this.OnChange(this.ResolveColumnIndex(editor.name));
 },
 OnColumnFilterInputSpecKeyPress: function(editor, e) {
  if(e.htmlEvent) 
   e = e.htmlEvent;
  if(e.keyCode == ASPx.Key.Tab) 
   return true;
  if(e.keyCode == ASPx.Key.Enter) {
   ASPx.Evt.PreventEventAndBubble(e);
   window.setTimeout(function() {
    editor.Validate();
    if(this.IsMultiColumnAutoFilter())
     this.ApplyMultiColumnAutoFilter(editor);
    else
     this.ApplyColumnAutoFilterCore(editor);
   }.bind(this), 0);
   return true;
  }
  if(e.keyCode == ASPx.Key.Delete && e.ctrlKey) {
   ASPx.Evt.PreventEventAndBubble(e);
   window.setTimeout(function() {
    editor.SetValue(null);
    if(!this.IsMultiColumnAutoFilter())
     this.ApplyColumnAutoFilterCore(editor);
   }.bind(this), 0);
   return true;
  }
  return false;
 },
 OnFilterKeyPressTick: function() {
  if(this.filterKeyPressEditor && this.IsValidInstance())
   this.ApplyColumnAutoFilterCore(this.filterKeyPressEditor);
 },
 OnColumnFilterInputChanged: function(editor) {
  this.ApplyColumnAutoFilterCore(editor);
 },
 OnColumnFilterUserInput: function(editor) {
  if(this.IsAutoFilterTimerActive()) return;
  this.ColumnFilterOnPaste(editor);
 },
 ColumnFilterOnPaste: function(editor) {
  this.EnsureEditorRawValue(editor);
  this.CreateAutoFilterTimer(editor);
 },
 IsAutoFilterTimerActive: function() {
  return this.filterKeyPressTimerId !== -1;
 },
 CreateAutoFilterTimer: function(editor) {
  this.filterKeyPressEditor = editor;
  this.filterKeyPressTimerId = window.setTimeout(this.OnFilterKeyPressTick.bind(this), this.GetAutoFilterDelay());
 },
 ClearAutoFilterInputTimer: function() {
  this.filterKeyPressTimerId = ASPx.Timer.ClearTimer(this.filterKeyPressTimerId);
 },
 OnChange: function(columnIndex) {
  if(this.IsCustDialogVisible())
   window.setTimeout(function() { this.GetCustDialogHelper().ProcessFilterChange(columnIndex); }.bind(this), 0);
 },
 ClearColumnFilter: function(columnIndex) {
  this.ClearColumnAutoFilter(columnIndex);
  this.ClearColumnHeaderFilter(columnIndex);
  this.OnChange(columnIndex);
 },
 ClearColumnAutoFilter: function(columnIndex) {
  var editor = this.GetAutoFilterEditor(columnIndex);
  if(editor)
   editor.SetValue(null);   
 },
 ClearColumnHeaderFilter: function(columnIndex) {
  var column = this.GetColumn(columnIndex);
  var hfMode = column.HFMode;
  var listBox = this.GetListBox(columnIndex);
  if(listBox) {
   listBox.UnselectAll();
   if(hfMode ===  ASPx.GridHeaderFilterMode.List)
    listBox.SelectIndex(0);
  }
  if(hfMode === ASPx.GridHeaderFilterMode.CheckedList) {
   var checkbox = this.GetSelectAllCheckBox(columnIndex); 
   if(checkbox)
    checkbox.SetCheckState(ASPx.CheckBoxCheckState.Unchecked);
  }
  if(hfMode === ASPx.GridHeaderFilterMode.DateRangePicker) {
   var dateEdit_From = this.GetDateEdit_From(columnIndex);
   if(dateEdit_From) 
    dateEdit_From.SetValue(null);
   var dateEdit_To = this.GetDateEdit_To(columnIndex);
   if(dateEdit_To)
    dateEdit_To.SetValue(null);
  }
  if(hfMode === ASPx.GridHeaderFilterMode.DateRangeCalendar) {
   var calendar = this.GetCalendar(columnIndex);
   if(calendar)
    calendar.SetValue(null);
  }
 },
 HasFilter: function(columnIndex) {
  return this.HasHeaderFilter(columnIndex) || this.HasAutoFilter(columnIndex);
 },
 HasHeaderFilter: function(columnIndex) {
  var state = this.GetHeaderFilterState(columnIndex);
  var column = this.GetColumn(columnIndex);
  if(!state || !column)
   return false;
  if(column.HFMode === ASPx.GridHeaderFilterMode.List && state.listBoxSelectedIndices[0] === 0)
   return false;
  var hasDateRange = state.pickerRange && (state.pickerRange.start || state.pickerRange.end);
  var hasSelectedDates = state.calendarDates && state.calendarDates.length > 0;
  return state.listBoxSelectedIndices.length > 0 || hasDateRange || hasSelectedDates;  
 },
 HasAutoFilter: function(columnIndex) {
  var editor = this.GetAutoFilterEditor(columnIndex);   
  var value = editor && editor.GetMainElement() && editor.GetValueString();
  return !!value;
 },
 IsColumnAutoFilterChanged: function(columnIndex) {   
  var editor = this.GetAutoFilterEditor(columnIndex);
  if(!editor || !editor.GetMainElement() || !this.initialFilterRowState[columnIndex]) 
   return false;
  var currentValue =  editor.GetValueString();
  return this.initialFilterRowState[columnIndex].value !== currentValue;
 },
 FilterRowMenuButtonClick: function(columnIndex, element) {
  var menu = this.GetFilterRowMenu();
  if(!menu) return;
  var column = this.GetColumn(columnIndex);
  if(!column) return;
  var checkedItemIndex;
  for(var i = menu.GetItemCount() - 1; i >= 0; i--) {
   var item = menu.GetItem(i);
   var isItemChecked = item.name.substr(0, item.name.indexOf("|")) == this.GetFilterCondition(columnIndex);
   item.SetChecked(isItemChecked);
   if(isItemChecked)
    checkedItemIndex = item.index;
   item.SetVisible(this.GetFilterRowMenuItemVisible(item, column));
  }
  menu.ShowAtElement(element);
  this.filterRowMenuColumnIndex = columnIndex;
  this.currentCheckedItemIndex = checkedItemIndex;
  if(this.GetEnableAccessibility())
   menu.accessibleFocusElement = element;
 },
 FilterRowMenuItemClick: function(item) { 
  var itemName = item.name.substr(0, item.name.indexOf("|"));
  item.menu.ProcessLostFocus();
  if(this.currentCheckedItemIndex === item.index)
   return;
  if(this.IsMultiColumnAutoFilter() || this.IsCustDialogVisible()) {
   this.SetFilterCondition(this.filterRowMenuColumnIndex, parseInt(itemName));
   this.OnChange(this.filterRowMenuColumnIndex);
  } else {
   var args = [this.filterRowMenuColumnIndex, itemName];
   if(!this.IsCustDialogVisible())
    this.SendCallbackToChangeFilterCondition(args);
  }
 },
 GetFilterRowMenuItemVisible: function(item, column) {
  if(column.filterRowTypeKind) {
   var visible = item.name.indexOf(column.filterRowTypeKind) > -1;
   if(!visible && column.showFilterMenuLikeItem)
    return item.name.indexOf("L") > -1;
   return visible;
  }
  return false;
 },
 SetHeaderFilterPopupHtml: function(htmlObj, columnIndex) {
  var processedByCustDialogHelper = false;
  if(this.IsCustDialogVisible())
   processedByCustDialogHelper = this.GetCustDialogHelper().ProcessHeaderFilterCallback(htmlObj, columnIndex);
  if(!processedByCustDialogHelper)
   ASPx.GridFilterHelper.prototype.SetHeaderFilterPopupHtml.call(this, htmlObj, columnIndex);
 },
 OnListBoxSelectionChanged: function(listBox) {
  ASPx.GridFilterHelper.prototype.OnListBoxSelectionChanged.call(this, listBox);
  this.OnChange(listBox.gvColumn.index);
 },
 OnSelectAllCheckedChanged: function(checkBox) {
  ASPx.GridFilterHelper.prototype.OnSelectAllCheckedChanged.call(this, checkBox);
  this.OnChange(checkBox.gvColumn.index);
 },
 OnDateRangePickerValueChanged: function(editor) {
  ASPx.GridFilterHelper.prototype.OnDateRangePickerValueChanged.call(this, editor);
  this.OnChange(editor.gvColumn.index);
 },
 OnCalendarSelectionChanged: function(editor) {
  ASPx.GridFilterHelper.prototype.OnCalendarSelectionChanged.call(this, editor);
  this.OnChange(editor.gvColumn.index);
 },
 RequireApplyHeaderFilterNow: function(mode, columnIndex) {
  if(this.IsCustDialogVisible())
   return false;
  return ASPx.GridFilterHelper.prototype.RequireApplyHeaderFilterNow.call(this, mode, columnIndex);
 },
 OnControlsInitialized: function() {
  ASPx.GridFilterHelper.prototype.OnControlsInitialized.call(this);
  if(this.IsCustDialogVisible())
   this.GetCustDialogHelper().ClearHeaderFilterAfterLoadValues();
 },
 AdjustHeaderFilterListBox: function(column) {
  if(this.IsCustDialogVisible() && this.RequireShowHeaderFilterListBoxScrollbar(column)) {
   var listBox = this.GetListBox(column.index);
   var listBoxMainElement = listBox && listBox.GetMainElement();
   if(listBoxMainElement) {
    ASPx.SetStyles(listBoxMainElement, { minHeight: listBoxMainElement.parentNode.offsetHeight });
    listBox.AdjustControl();
   }
  } else
   ASPx.GridFilterHelper.prototype.AdjustHeaderFilterListBox.call(this, column);
 }
});
ASPx.GridViewFilterHelper = GridViewFilterHelper;
})();
(function() {
var GridViewContextMenuItemType = {
 FullExpand: "FullExpand",
 FullCollapse: "FullCollapse",
 SortAscending: "SortAscending",
 SortDescending: "SortDescending",
 ClearSorting: "ClearSorting",
 ShowFilterBuilder: "ShowFilterEditor",
 ShowFilterRow: "ShowFilterRow",
 ClearFilter: "ClearFilter",
 ShowFilterRowMenu: "ShowFilterRowMenu",
 GroupByColumn: "GroupByColumn",
 UngroupColumn: "UngroupColumn",
 ClearGrouping: "ClearGrouping",
 ShowGroupPanel: "ShowGroupPanel",
 ShowSearchPanel: "ShowSearchPanel",
 ShowColumn: "ShowColumn",
 HideColumn: "HideColumn",
 ShowCustomizationDialog: "ShowCustomizationDialog",
 ShowCustomizationWindow: "ShowCustomizationWindow",
 ShowFooter: "ShowFooter",
 ExpandRow: "ExpandRow",
 CollapseRow: "CollapseRow",
 ExpandDetailRow: "ExpandDetailRow",
 CollapseDetailRow: "CollapseDetailRow",
 NewRow: "NewRow",
 EditRow: "EditRow",
 DeleteRow: "DeleteRow",
 Refresh: "Refresh",
 SummarySum: "SummarySum",
 SummaryMin: "SummaryMin",
 SummaryMax: "SummaryMax",
 SummaryAverage: "SummaryAverage",
 SummaryCount: "SummaryCount",
 SummaryNone: "SummaryNone",
 GroupSummarySum: "GroupSummarySum",
 GroupSummaryMin: "GroupSummaryMin",
 GroupSummaryMax: "GroupSummaryMax",
 GroupSummaryAverage: "GroupSummaryAverage",
 GroupSummaryCount: "GroupSummaryCount",
 GroupSummaryNone: "GroupSummaryNone",
 CustomItem: "CustomItem"
};
var GridViewContextMenuHelper = ASPx.CreateClass(ASPx.ExportHelperBase, {
 constructor: function(grid) {
  this.constructor.prototype.constructor.call(this, ASPx.ASPxClientGridExportFormat);
  this.grid = grid;
  this.emptyElementIndex = -1;
  this.sourceContextMenuRow = null;
  this.activeContextMenu = null;
  this.contextMenuActivating = false;
  this.clickedMenuItem = null;
 },
 GetGridName: function() { return this.grid.name; },
 GetCustWindowSuffix: function() { return this.grid.CustomizationWindowSuffix; }, 
 IsDetailGrid: function() { return this.grid.IsDetailGrid(); },
 GetGroupPanelContextMenu: function() { return this.grid.GetGroupPanelContextMenu(); },
 GetColumnContextMenu: function() { return this.grid.GetColumnContextMenu(); },
 GetRowContextMenu: function() { return this.grid.GetRowContextMenu(); },
 GetFooterContextMenu: function() { return this.grid.GetFooterContextMenu(); },
 GetGroupFooterContextMenu: function() { return this.grid.GetGroupFooterContextMenu(); },
 GetRowHotTrackStyle: function() { return this.rowHotTrackStyle; },
 GetEnableAccessibility: function() { return this.grid.accessibilityCompliant; },
 IsCustWindowVisible: function() { return this.grid.IsCustomizationWindowVisible(); },
 HasContextMenuEventHandler: function() { return !this.grid.ContextMenu.IsEmpty(); },
 RaiseContextMenu: function(objectType, index, htmlEvent, menu, showBrowserMenu) { 
  return this.grid.RaiseContextMenu(objectType, index, htmlEvent, menu, showBrowserMenu);
 },
 RaiseContextMenuItemClick: function(e, itemInfo) {
  return this.grid.RaiseContextMenuItemClick(e, itemInfo);
 },
 HasAnyContextMenu: function() {
  return this.GetGroupPanelContextMenu() || this.GetColumnContextMenu() || this.GetRowContextMenu() || this.GetFooterContextMenu();
 },
 SendContextMenuCallback: function(args) {
  return this.grid.gridCallBack([ ASPxClientGridViewCallbackCommand.ContextMenu ].concat(args));
 },
 SendContextMenuPostBack: function(args) {
  return this.grid.gridPostBack([ ASPxClientGridViewCallbackCommand.ContextMenu ].concat(args));
 },
 OnAfterCallack: function() { 
  this.clickedMenuItem = null;
 },
 GetCallbackState: function() {
  if(!this.clickedMenuItem)
   return "";
  var menu = this.clickedMenuItem.menu;
  var elementInfo = menu.elementInfo;
  return menu.cpType + "," + this.clickedMenuItem.indexPath + "," + elementInfo.index;
 },
 OnContextMenuClick: function(e) {
  var showDefaultMenu = ASPx.EventStorage.getInstance().Load(e);
  if(showDefaultMenu)
   return showDefaultMenu;
  if(this.IsDetailGrid())
   ASPx.EventStorage.getInstance().Save(e, true);
  var args = this.GetContextMenuArgs(e);
  if(!args.objectType && !this.HasAnyContextMenu())
   return true;
  var menu = this.GetPreparedContextMenu(args);
  var showBrowserMenu = !menu && !this.HasContextMenuEventHandler();
  showBrowserMenu = this.RaiseContextMenu(args.objectType, args.index, e, menu, showBrowserMenu);
  if(menu && !showBrowserMenu) {
   if(this.GetEnableAccessibility())
    menu.accessibleFocusElement = ASPx.Evt.GetEventSource(e);
   this.ShowContextMenu(e, menu);
   return false;
  }
  return showBrowserMenu;
 },
 ShowContextMenu: function(mouseEvent, menu) {
  this.contextMenuActivating = true;
  this.HandleContextMenuHover(menu, mouseEvent);
  menu.ShowInternal(mouseEvent);
 },
 HandleContextMenuHover: function(menu, mouseEvent) {
  menu.handler = menu.handler || this.OnContextMenuCloseUp.bind(this);
  menu.CloseUp.AddHandler(menu.handler);
  if(!this.GetRowHotTrackStyle())
   return;
  this.activeContextMenu = menu;
  this.sourceContextMenuRow = this.grid.getItemByHtmlEvent(mouseEvent);
  ASPx.AddAfterClearHoverState(function(source, args) { this.OnClearHoverState(args.item, args.element, args.toElement); }.bind(this));
 },
 OnClearHoverState: function(hoverItem, hoverElement, newHoverElement) {
  if(!this.activeContextMenu || !this.activeContextMenu.GetVisible() || !this.sourceContextMenuRow) {
   ASPx.RemoveClassNameFromElement(hoverElement, this.GetRowHotTrackStyle()[0]);
   return;
  }
  if(this.sourceContextMenuRow.id === hoverElement.id) {
   var newHoverItem = hoverItem.Clone();
   newHoverItem.Apply(hoverElement);
  }
 },
 OnContextMenuCloseUp: function(e) {
  this.contextMenuActivating = false;
  if(!this.sourceContextMenuRow || !this.activeContextMenu || this.activeContextMenu.GetVisible()) return;
  var stateController = ASPx.GetStateController();
  if(!stateController) return;
  if(stateController.currentHoverElement !== this.sourceContextMenuRow)
   stateController.DoClearHoverState(this.sourceContextMenuRow, null);
  this.sourceContextMenuRow = null;
  this.activeContextMenu = null;
 },
 GetPreparedContextMenu: function(args) { 
  var menu = null;
  switch(args.objectType) {
   case "grouppanel":
    menu = this.GetGroupPanelContextMenu();
    break;
   case "header":
   case "emptyheader":
    menu = this.GetColumnContextMenu();
    break;
   case "row":
   case "grouprow":
   case "emptyrow":
    menu = this.GetRowContextMenu();
    break;
   case "footer":
    menu = this.GetFooterContextMenu();
    break;
   case "groupfooter":
    menu = this.GetGroupFooterContextMenu();
    break;
  }
  if(menu)
   this.ActivateContextMenuItems(menu, args);
  return menu;
 },
 GetContextMenuArgs: function(e) { 
  var args = this.GetContextMenuArgsCore(e);
  if(args.objectType || !this.grid.HasBandedDataRows())
   return args;
  var index = -1;
  var grid = this.grid;
  var dataRowIdPrefix = grid.name + "_" + ASPx.GridViewConsts.DataRowID;
  var isBandedDataRowFound = !!ASPx.GetParent(ASPx.Evt.GetEventSource(e), function(element){
   index = grid.getItemIndex(element.id);
   var level = grid.GetBandedDataRowLevelByID(element.id);
   return element.id == dataRowIdPrefix + index + "_" + level;
  });
  if(isBandedDataRowFound)
   args = { objectType: "row", index: index };
  return args;
 },
 GetContextMenuArgsCore: function(e) { 
  var objectTypes = this.GetObjectTypes();
  var src = ASPx.Evt.GetEventSource(e);
  var element = src;
  while(element && element.tagName !== "BODY") {
   var id = element.id;
   element = element.parentNode;
   if(!id) continue;
   var indexInfo = this.grid.tryGetNumberFromEndOfString(id);
   var index = indexInfo.success ? indexInfo.value : "";
   for(var partialID in objectTypes) {
    if(id == partialID + index) {
     var type = objectTypes[partialID];
     var isGroupFooter = type == "groupfooter";
     if(type == "footer" || isGroupFooter) {
      if(!isGroupFooter)
       index = this.grid.GetFooterCellIndex(src);
      else
       index = this.grid.GetGroupFooterCellIndex(src);
      if(index < 0)
       return { objectType: null, index: -1 };
     } else if(type == "emptyheader" || type == "grouppanel" || type == "emptyrow") {
      index = this.emptyElementIndex;
     }
     return { objectType: type, index: index };
    }
   }
  }
  return { objectType: null, index: -1 };
 },
 ActivateContextMenuItems: function(menu, args) {
  menu.elementInfo = args;
  this.SyncMenuItemsInfoSettings(menu, args.index, menu.cpItemsInfo);
 },
 SyncMenuItemsInfoSettings: function(menu, groupElementIndex, itemsInfo) {
  for(var i = 0; i < menu.GetItemCount() ; ++i) {
   var item = menu.GetItem(i);
   var itemInfo = itemsInfo[item.indexPath];
   var visible = this.GetItemServerState(itemInfo[0], groupElementIndex);
   var enabled = this.GetItemServerState(itemInfo[1], groupElementIndex);
   var checked = this.GetItemServerState(itemInfo[2], groupElementIndex);
   if(item.name === GridViewContextMenuItemType.ShowCustomizationWindow)
    checked = this.IsCustWindowVisible();
   item.SetVisible(visible);
   item.SetEnabled(enabled);
   item.SetChecked(checked);
   if(visible && enabled && !checked)
    this.SyncMenuItemsInfoSettings(item, groupElementIndex, itemsInfo);
  }
 },
 GetContextMenuItemChecked: function(item) {
  var itemInfo = item.menu.cpItemsInfo[item.indexPath];
  var elementIndex = item.menu.elementInfo.index;
  return this.GetItemServerState(itemInfo[2], elementIndex);
 },
 GetItemServerState: function(itemInfo, groupElementIndex) {
  var saveVisible = !!itemInfo[0];
  var indices = itemInfo.length === 1 ? [ ] : itemInfo[1];
  return ASPx.Data.ArrayIndexOf(indices, groupElementIndex) > -1 ? saveVisible : !saveVisible;
 },
 OnContextMenuItemClick: function(e) {
  var elementInfo = e.item.menu.elementInfo;
  this.clickedMenuItem = e.item;
  if(this.GetEnableAccessibility() && !e.item.items.length)
   e.item.menu.ProcessLostFocus();
  if(this.RaiseContextMenuItemClick(e, elementInfo))
   return true;
  this.ProcessContextMenuItemClick(e);
 },
 ProcessContextMenuItemClick: function(e){
  var item = e.item;
  var elementInfo = item.menu.elementInfo;
  if(!elementInfo) return;
  switch(item.name) {
   case GridViewContextMenuItemType.FullExpand:
    this.grid.ExpandAll();
    break;
   case GridViewContextMenuItemType.FullCollapse:
    this.grid.CollapseAll();
    break;
   case GridViewContextMenuItemType.SortAscending:
    this.grid.SortBy(elementInfo.index, "ASC", false);
    break;
   case GridViewContextMenuItemType.SortDescending:
    this.grid.SortBy(elementInfo.index, "DSC", false);
    break;
   case GridViewContextMenuItemType.ClearSorting:
    this.grid.SortBy(elementInfo.index, "NONE", false);
    break;
   case GridViewContextMenuItemType.ShowFilterBuilder:
    this.grid.ShowFilterControl();
    break;
   case GridViewContextMenuItemType.ShowFilterRow:
    this.ContextMenuShowFilterRow(!this.GetContextMenuItemChecked(item));
    break;
   case GridViewContextMenuItemType.ClearFilter:
    this.grid.AutoFilterByColumn(this.grid.GetColumn(elementInfo.index));
    break;
   case GridViewContextMenuItemType.ShowFilterRowMenu:
    this.ContextMenuShowFilterRowMenu(!this.GetContextMenuItemChecked(item));
    break;
   case GridViewContextMenuItemType.ShowGroupPanel:
    this.ContextMenuShowGroupPanel(!this.GetContextMenuItemChecked(item));
    break;
   case GridViewContextMenuItemType.ShowSearchPanel:
    this.ContextMenuShowSearchPanel(!this.GetContextMenuItemChecked(item));
    break;
   case GridViewContextMenuItemType.ShowCustomizationDialog:
    this.grid.ShowCustomizationDialog();
    break;
   case GridViewContextMenuItemType.ShowCustomizationWindow:
    if(!this.IsCustWindowVisible())
     this.grid.ShowCustomizationWindow();
    else
     this.grid.HideCustomizationWindow();
    break;
   case GridViewContextMenuItemType.ShowFooter:
    this.ContextMenuShowFooter(!this.GetContextMenuItemChecked(item));
    break;
   case GridViewContextMenuItemType.ExpandRow:
    this.grid.ExpandRow(elementInfo.index);
    break;
   case GridViewContextMenuItemType.CollapseRow:
    this.grid.CollapseRow(elementInfo.index);
    break;
   case GridViewContextMenuItemType.ExpandDetailRow:
    this.grid.ExpandDetailRow(elementInfo.index);
    break;
   case GridViewContextMenuItemType.CollapseDetailRow:
    this.grid.CollapseDetailRow(elementInfo.index);
    break;
   case GridViewContextMenuItemType.NewRow:
    this.grid.AddNewItem();
    break;
   case GridViewContextMenuItemType.EditRow:
    this.ContextMenuStartEditItem(elementInfo.index, e.item.menu);
    break;
   case GridViewContextMenuItemType.DeleteRow:
    this.grid.DeleteGridItem(elementInfo.index);
    break;
   case GridViewContextMenuItemType.Refresh:
    this.grid.Refresh();
    break;
   case GridViewContextMenuItemType.HideColumn:
    var groupped = ASPx.IsExists(this.grid.GetHeader(elementInfo.index, true));
    this.grid.MoveColumn(elementInfo.index, -1, false, false, groupped);
    break;
   case GridViewContextMenuItemType.ShowColumn:
    this.grid.MoveColumn(elementInfo.index, elementInfo.index);
    break;
   case GridViewContextMenuItemType.SummarySum:
    this.ContextMenuSetSummary(item, elementInfo.index, 0);
    break;
   case GridViewContextMenuItemType.SummaryMin:
    this.ContextMenuSetSummary(item, elementInfo.index, 1);
    break;
   case GridViewContextMenuItemType.SummaryMax:
    this.ContextMenuSetSummary(item, elementInfo.index, 2);
    break;
   case GridViewContextMenuItemType.SummaryCount:
    this.ContextMenuSetSummary(item, elementInfo.index, 3);
    break;
   case GridViewContextMenuItemType.SummaryAverage:
    this.ContextMenuSetSummary(item, elementInfo.index, 4);
    break;
   case GridViewContextMenuItemType.SummaryNone:
    this.ContextMenuClearSummary(elementInfo.index);
    break;
   case GridViewContextMenuItemType.GroupSummarySum:
    this.ContextMenuSetGroupSummary(item, elementInfo.index, 0);
    break;
   case GridViewContextMenuItemType.GroupSummaryMin:
    this.ContextMenuSetGroupSummary(item, elementInfo.index, 1);
    break;
   case GridViewContextMenuItemType.GroupSummaryMax:
    this.ContextMenuSetGroupSummary(item, elementInfo.index, 2);
    break;
   case GridViewContextMenuItemType.GroupSummaryCount:
    this.ContextMenuSetGroupSummary(item, elementInfo.index, 3);
    break;
   case GridViewContextMenuItemType.GroupSummaryAverage:
    this.ContextMenuSetGroupSummary(item, elementInfo.index, 4);
    break;
   case GridViewContextMenuItemType.GroupSummaryNone:
    this.ContextMenuClearGroupSummary(elementInfo);
    break;
   case GridViewContextMenuItemType.ClearGrouping:
    this.ContextMenuClearGrouping();
    break;
   case GridViewContextMenuItemType.GroupByColumn:
    this.grid.GroupBy(elementInfo.index);
    break;
   case GridViewContextMenuItemType.UngroupColumn:
    this.grid.UnGroup(elementInfo.index);
    break;
  }
  if(this.IsExportItem(item.name))
   this.ContextMenuExport(item);
 },
 SendExportCommand: function(menuType, itemPath, elementIndex, exportFormat) {
  this.SendContextMenuPostBack([ASPxClientGridViewCallbackCommand.Export, menuType, itemPath, elementIndex, exportFormat]);
 },
 ContextMenuExport: function(item) {
  var menu = item.menu;
  this.SendExportCommand(menu.cpType, item.indexPath, menu.elementInfo.index, this.GetExportFormat(item.name));
  this.clickedMenuItem = null;
 },
 ContextMenuStartEditItem: function(visibleIndex, menu) {
  var rowCells = this.grid.GetRow(visibleIndex).children;
  var colIndex = -1;
  var menuLocationX = menu.GetMainElement().getBoundingClientRect().left;
  for(var i = 0; i < rowCells.length; ++i) {
   var cell = rowCells[i];
   if(cell.tagName !== "TD") continue;
   var cellRect = cell.getBoundingClientRect();
   if(cellRect.left > menuLocationX) break;
   if(menuLocationX > cellRect.left && menuLocationX < cellRect.right) {
    colIndex = i;
    break;
   }
  }
  this.grid.StartEditItem(visibleIndex, colIndex);
 },
 ProcessCustomContextMenuItemClick: function(item, usePostBack) {
  if(usePostBack) {
   this.clickedMenuItem = null;
   var menu = item.menu;
   this.SendContextMenuPostBack(["ItemClick", menu.cpType, item.indexPath, menu.elementInfo.index]);
  } else
   this.SendContextMenuCallback([ "" ]);
 },
 ContextMenuShowGroupPanel: function(show) {
  this.SendContextMenuCallback([ "ShowGroupPanel", show ? 1 : 0 ]);
 },
 ContextMenuShowSearchPanel: function(show) {
  this.SendContextMenuCallback([ "ShowSearchPanel", show ? 1 : 0 ]);
 },
 ContextMenuShowFilterRow: function(show) {
  this.SendContextMenuCallback([ "ShowFilterRow", show ? 1 : 0 ]);
 },
 ContextMenuShowFilterRowMenu: function(show) {
  this.SendContextMenuCallback([ "ShowFilterRowMenu", show ? 1 : 0 ]);
 },
 ContextMenuShowFooter: function(show) {
  this.SendContextMenuCallback([ "ShowFooter", show ? 1 : 0 ]);
 },
 ContextMenuClearGrouping: function() {
  this.SendContextMenuCallback([ "ClearGrouping" ]);
 },
 ContextMenuSetSummary: function(item, index, typeSummary) {
  var checkSummary = this.GetContextMenuItemChecked(item) ? 0 : 1;
  this.SendContextMenuCallback([ "SetSummary", index, typeSummary, checkSummary ]);
 },
 ContextMenuSetGroupSummary: function(item, index, typeSummary, isGroupSummary) {
  var checkSummary = this.GetContextMenuItemChecked(item) ? 0 : 1;
  var isGroupFooterSummary = this.IsGroupFooterMenuItem(item) ? "1" : "0";
  this.SendContextMenuCallback([ "SetGroupSummary", index, typeSummary, checkSummary, isGroupFooterSummary ]);
 },
 ContextMenuClearSummary: function(index) {
  this.SendContextMenuCallback([ "ClearSummary", index ]);
 },
 ContextMenuClearGroupSummary: function(elementInfo) {
  var isGroupFooterSummary = elementInfo.objectType === "groupfooter" ? "1" : "0";
  this.SendContextMenuCallback([ "ClearGroupSummary", elementInfo.index, isGroupFooterSummary ]);
 },
 IsGroupFooterMenuItem: function(item) {
  return item.menu.name === this.grid.GetGroupFooterContextMenuName();
 },
 GetObjectTypes: function() {
  if(!this.objectTypes)
   this.objectTypes = this.CreateObjectTypes();
  return this.objectTypes;
 },
 CreateObjectTypes: function() {
  var gridName = this.GetGridName();
  var result = { };
  result[gridName + "_" + "grouppanel"]          = "grouppanel";
  result[gridName + "_" + ASPx.GridViewConsts.AdaptiveGroupPanelID]   = "grouppanel";
  result[gridName + "_" + ASPx.GridViewConsts.HeaderRowID]   = "emptyheader";
  result[gridName + "_" + "col"]           = "header";
  result[gridName + this.GetCustWindowSuffix() + "_" + "col"]   = "header";
  result[gridName + "_" + "groupcol"]         = "header";
  result[gridName + "_" + ASPx.GridViewConsts.DataRowID]     = "row";
  result[gridName + "_" + ASPx.GridViewConsts.DetailRowID]   = "row";
  result[gridName + "_" + ASPx.GridViewConsts.EmptyDataRowID]   = "emptyrow";
  result[gridName + "_" + ASPx.GridViewConsts.GroupRowID]    = "grouprow";
  result[gridName + "_" + ASPx.GridViewConsts.GroupRowID + "Exp"]  = "grouprow";
  result[gridName + "_" + ASPx.GridViewConsts.FooterRowID]   = "footer";
  result[gridName + "_" + ASPx.GridViewConsts.FilterRowID]   = "filterrow";
  result[gridName + "_" + ASPx.GridViewConsts.GroupFooterRowID]    = "groupfooter";
  return result;
 },
});
ASPx.GridViewContextMenuHelper = GridViewContextMenuHelper;
})();
(function() {
var GridViewToolbarCommandType = {
 FullExpand: "FullExpand",
 FullCollapse: "FullCollapse",
 ClearSorting: "ClearSorting",
 ShowFilterBuilder: "ShowFilterEditor",
 ShowFilterRow: "ShowFilterRow",
 ClearFilter: "ClearFilter",
 ShowFilterRowMenu: "ShowFilterRowMenu",
 ClearGrouping: "ClearGrouping",
 ShowGroupPanel: "ShowGroupPanel",
 ShowSearchPanel: "ShowSearchPanel",
 ShowCustomizationWindow: "ShowCustomizationWindow",
 ShowFooter: "ShowFooter",
 ShowCustomizationDialog: "ShowCustomizationDialog",
 ExpandRow: "ExpandRow",
 CollapseRow: "CollapseRow",
 ExpandDetailRow: "ExpandDetailRow",
 CollapseDetailRow: "CollapseDetailRow",
 New: "New",
 Edit: "Edit",
 Delete: "Delete",
 DeleteSelected: "DeleteSelected",
 DeleteSelectedRowsOnPage: "DeleteSelectedRowsOnPage",
 Refresh: "Refresh",
 Update: "Update",
 Cancel: "Cancel"
};
var GridViewToolbarHelper = ASPx.CreateClass(ASPx.GridToolbarHelper, {
 constructor: function(grid) {
  this.constructor.prototype.constructor.call(this, grid);
 },
 ProcessToolbarItemClick: function(e) {
  var item = e.item;
  switch(item.name) {
   case GridViewToolbarCommandType.FullExpand:
    this.grid.ExpandAll();
    break;
   case GridViewToolbarCommandType.FullCollapse:
    this.grid.CollapseAll();
    break;
   case GridViewToolbarCommandType.ClearSorting:
    this.ToolbarClearSorting();
    break;
   case GridViewToolbarCommandType.ShowFilterBuilder:
    this.grid.ShowFilterControl();
    break;
   case GridViewToolbarCommandType.ShowFilterRow:
    this.ToolbarShowFilterRow(item.GetChecked());
    break;
   case GridViewToolbarCommandType.ClearFilter:
    this.grid.ClearFilter();
    break;
   case GridViewToolbarCommandType.ShowFilterRowMenu:
    this.ToolbarShowFilterRowMenu(item.GetChecked());
    break;
   case GridViewToolbarCommandType.ShowGroupPanel:
    this.ToolbarShowGroupPanel(item.GetChecked());
    break;
   case GridViewToolbarCommandType.ShowSearchPanel:
    this.ToolbarShowSearchPanel(item.GetChecked());
    break;
   case GridViewToolbarCommandType.ShowCustomizationWindow:
    if(!this.grid.IsCustomizationWindowVisible())
     this.grid.ShowCustomizationWindow();
    else
     this.grid.HideCustomizationWindow();
    break;
   case GridViewToolbarCommandType.ShowFooter:
    this.ToolbarShowFooter(item.GetChecked());
    break;
   case GridViewToolbarCommandType.ShowCustomizationDialog:
    this.grid.ShowCustomizationDialog();
    break;
   case GridViewToolbarCommandType.ExpandRow:
    this.grid.ExpandRow(this.grid.GetFocusedRowIndex());
    break;
   case GridViewToolbarCommandType.CollapseRow:
    this.grid.CollapseRow(this.grid.GetFocusedRowIndex());
    break;
   case GridViewToolbarCommandType.ExpandDetailRow:
    this.grid.ExpandDetailRow(this.grid.GetFocusedRowIndex());
    break;
   case GridViewToolbarCommandType.CollapseDetailRow:
    this.grid.CollapseDetailRow(this.grid.GetFocusedRowIndex());
    break;
   case GridViewToolbarCommandType.New:
    this.grid.AddNewItem();
    break;
   case GridViewToolbarCommandType.Edit:
    this.ToolbarStartEdit();
    break;
   case GridViewToolbarCommandType.Delete:
    this.ToolbarDeleteItem();
    break;
   case GridViewToolbarCommandType.DeleteSelected:
    this.ToolbarDeleteSelectedItems();
    break;
   case GridViewToolbarCommandType.DeleteSelectedRowsOnPage:
    this.ToolbarDeleteSelectedVisibleItems();
    break;
   case GridViewToolbarCommandType.Refresh:
    this.grid.Refresh();
    break;
   case GridViewToolbarCommandType.ClearGrouping:
    this.ToolbarClearGrouping();
    break;
   case GridViewToolbarCommandType.Update:
    this.grid.UpdateEdit();
    break;
   case GridViewToolbarCommandType.Cancel:
    this.grid.CancelEdit();
    break;
   default:
    ASPx.GridToolbarHelper.prototype.ProcessToolbarItemClick.call(this, e);
    break;
  }
 },
 ToolbarShowGroupPanel: function(show) {
  this.SendToolbarCallback([ "ShowGroupPanel", show ? 1 : 0 ]);
 },
 ToolbarShowSearchPanel: function(show) {
  this.SendToolbarCallback([ "ShowSearchPanel", show ? 1 : 0 ]);
 },
 ToolbarShowFilterRow: function(show) {
  this.SendToolbarCallback([ "ShowFilterRow", show ? 1 : 0 ]);
 },
 ToolbarShowFilterRowMenu: function(show) {
  this.SendToolbarCallback([ "ShowFilterRowMenu", show ? 1 : 0 ]);
 },
 ToolbarShowFooter: function(show) {
  this.SendToolbarCallback([ "ShowFooter", show ? 1 : 0 ]);
 },
 ToolbarClearGrouping: function() {
  this.SendToolbarCallback([ "ClearGrouping" ]);
 },
 ToolbarClearSorting: function() {
  this.SendToolbarCallback([ "ClearSorting" ]);
 },
 IsUpdateEditItem: function(item) {
  switch(item.name) {
   case GridViewToolbarCommandType.Update:
   case GridViewToolbarCommandType.Cancel:
    return true;
  }
  return false;
 },
 IsShowCustomizationWindowItem: function(item) {
  return item.name === GridViewToolbarCommandType.ShowCustomizationWindow;
 },
 RefreshItemText: function(item) {
  switch(item.name) {
   case GridViewToolbarCommandType.DeleteSelected:
    this.RefreshSelectionBasedItemText(item, this.GetSelectedGridItemCount());
    break;
   case GridViewToolbarCommandType.DeleteSelectedRowsOnPage:
    this.RefreshSelectionBasedItemText(item, this.GetSelectedVisibleGridItemCount());
    break;
  }
 },
 GetToolbarItemEnabled: function(item){
  switch(item.name) {
   case GridViewToolbarCommandType.Edit:
    return this.GetEditItemEnabled();
   case GridViewToolbarCommandType.Delete:
    return this.GetDeleteItemEnabled();
   case GridViewToolbarCommandType.DeleteSelected:
    return this.GetDeleteSelectedRowsItemEnabled();
   case GridViewToolbarCommandType.DeleteSelectedRowsOnPage:
    return this.GetDeleteSelectedRowsOnPageItemEnabled();
   case GridViewToolbarCommandType.ExpandRow:
    return this.GetExpandRowItemEnabled();
   case GridViewToolbarCommandType.CollapseRow:
    return this.GetCollapseRowwItemEnabled();
   case GridViewToolbarCommandType.ExpandDetailRow:
    return this.GetExpandDetailRowEnabled();
   case GridViewToolbarCommandType.CollapseDetailRow:
    return this.GetCollapseDetailRowEnabled();
  }
  return null;
 },
 GetEditItemEnabled: function(){
  var focusedIndex = this.GetFocusedItemIndex();
  return this.grid.allowEdit && !this.IsGroupRow(focusedIndex) && (this.HasBatchEditFocusedCell() || !this.IsEditingItem(focusedIndex));
 },
 GetDeleteItemEnabled: function(){
  var focusedIndex = this.GetFocusedItemIndex();
  return this.grid.allowDelete && !this.IsGroupRow(focusedIndex) && (this.HasBatchEditFocusedCell() || !this.IsEditingItem(focusedIndex));
 },
 GetDeleteSelectedRowsItemEnabled: function() {
  return this.grid.allowDelete && this.GetSelectedGridItemCount() > 0;
 },
 GetDeleteSelectedRowsOnPageItemEnabled: function() {
  return this.grid.allowDelete && this.GetSelectedVisibleGridItemCount() > 0;
 },
 GetExpandRowItemEnabled: function(){
  var focusedIndex = this.GetFocusedItemIndex();
  return this.IsGroupRow(focusedIndex) && !this.IsGroupRowExpanded(focusedIndex);
 },
 GetCollapseRowwItemEnabled: function(){
  var focusedIndex = this.GetFocusedItemIndex();
  return this.IsGroupRow(focusedIndex) && this.IsGroupRowExpanded(focusedIndex);
 },
 GetExpandDetailRowEnabled: function(){
  var focusedIndex = this.GetFocusedItemIndex();
  return !this.IsGroupRow(focusedIndex) && !this.GetDetailRow(focusedIndex);
 },
 GetCollapseDetailRowEnabled: function(){
  var focusedIndex = this.GetFocusedItemIndex();
  return !!this.GetDetailRow(focusedIndex);
 },
 IsGroupRow: function(visibleIndex) {
  return this.control.IsGroupRow(visibleIndex);
 },
 IsGroupRowExpanded: function(visibleIndex){
  return this.control.IsGroupRowExpanded(visibleIndex);
 },
 GetDetailRow: function(visibleIndex){
  return this.control.GetDetailRow(visibleIndex);
 }
});
ASPx.GridViewToolbarHelper = GridViewToolbarHelper;
})();
(function() {
var GridViewColumnHelper = ASPx.CreateClass(null, {
 constructor: function(grid) {
  this.grid = grid;
  this.visibleHeaderTree = null;
  this.visibleDataRowTree = null;
  this.headerLayout = null;
  this.dataRowLayout = null;
  this.headerLeafs = null;
  this.dataRowLeafs = null;
  this.headerNodeHash = { };
  this.dataRowNodeHash = { };
  this.sortedVisibleChildColumnsHash = { };
  this.childColumnHash = { };
  this.fixedColumnsHash = null;
  this.visibleColumnIndices = null;
  this.rightTreeLines = null;
  this.cachedGroupColumnCount = -1;
 },
 GetAllColumns: function() { return this.grid.columns; },
 GetShowGroupedColumns: function() { return this.grid.showGroupedColumns; },
 FindColumn: function(index) {
  index = parseInt(index);
  return this.GetAllColumns().filter(function(c) { return c.index === index; })[0] || null;
 },
 HasColumnChildren: function(index) {
  return this.GetAllColumns().filter(function(c) { return c.parentIndex === index; }).length > 0;
 },
 GetGroupColumnCount: function() { 
  if(this.cachedGroupColumnCount === -1)
   this.cachedGroupColumnCount = this.GetAllColumns().filter(function(c) { return c.groupIndex > -1; }).length;
  return this.cachedGroupColumnCount;
 },
 GetParentColumnIndices: function(columnIndex) {
  var node = this.FindNode(columnIndex);
  if(!node)
   return [ ];
  return this.CreateTreeLine(node, false).map(function(n) { return n.columnIndex; });
 },
 FindColumnLayoutPos: function(layout, columnIndex) {
  for(var i = 0; i < layout.length; i++) {
   var level = layout[i];
   for(var j = 0; j < level.length; j++) {
    if(level[j].columnIndex === columnIndex)
     return { levelIndex: i, cellIndex: j };
   }
  }
  return { levelIndex: -1, cellIndex: -1 };
 },
 FindNode: function(columnIndex, isDataRowTree) {
  this.EnsureTrees();
  var hash = isDataRowTree ? this.dataRowNodeHash : this.headerNodeHash;
  return hash[columnIndex];
 },
 IsColumnFixed: function(columnIndex) {
  this.EnsureFixedColumnsHash();
  return this.fixedColumnsHash[columnIndex];
 },
 EnsureFixedColumnsHash: function() {
  if(this.fixedColumnsHash) 
   return;
  var firstLevelColumnsFixedState = { };
  var firstLevelColumns = this.GetVisibleChildColumns(-1, true);
  for(var i = 0; i < firstLevelColumns.length; i++) {
   var column = firstLevelColumns[i];
   firstLevelColumnsFixedState[column.index] = this.IsColumnFixedRecursive(column);
  }
  this.fixedColumnsHash = { };
  var allColumns = this.GetAllColumns();
  for(var i = 0; i < allColumns.length; i++) {
   var column = allColumns[i];
   var firstLevelColumn = column;
   while(firstLevelColumn.parentIndex >= 0)
    firstLevelColumn = this.FindColumn(firstLevelColumn.parentIndex);
   this.fixedColumnsHash[column.index] = firstLevelColumnsFixedState[firstLevelColumn.index];
  }
 },
 IsColumnFixedRecursive: function(column) {
  if(column.isFixed) return true;
  var childColumns = this.GetVisibleChildColumns(column.index, true);
  for(var i = 0; i < childColumns.length; i++) {
   if(this.IsColumnFixedRecursive(childColumns[i]))
    return true;
  }
  return false;
 },
 IsColumnInRightTreeLine: function(columnIndex, isHeader) {
  this.EnsureRightTreeLines();
  var treeLine = isHeader ? this.rightTreeLines.header : this.rightTreeLines.data;
  return treeLine.filter(function(n) { return n.columnIndex === columnIndex; }).length !== 0;
 },
 EnsureRightTreeLines: function() {
  if(this.rightTreeLines) return;
  this.rightTreeLines = { };
  var headerLeafs = this.GetHeaderLeafs();
  var dataRowLeafs = this.GetDataRowLeafs();
  this.rightTreeLines.header = this.CreateTreeLine(headerLeafs[headerLeafs.length - 1], true);
  this.rightTreeLines.data = this.CreateTreeLine(dataRowLeafs[dataRowLeafs.length - 1], true);
 },
 IsLastColumnInLevel: function(columnIndex, isHeader) { 
  var layout = isHeader ? this.GetHeaderLayout() : this.GetDataRowLayout();
  var pos = this.FindColumnLayoutPos(layout, columnIndex);
  if(pos.levelIndex < 0 || pos.cellIndex < 0) 
   return false;
  return pos.cellIndex === layout[pos.levelIndex].length - 1;
 },
 GetVisibleColumnIndices: function(isDataRowLayout) {
  if(!this.visibleColumnIndices) {
   this.visibleColumnIndices = {
    header: ASPx.Data.ArrayFlatten(this.GetHeaderLayout()).map(function(n) { return n.columnIndex; }),
    data: ASPx.Data.ArrayFlatten(this.GetDataRowLayout()).map(function(n) { return n.columnIndex; })
   };
  }
  return isDataRowLayout ? this.visibleColumnIndices.data : this.visibleColumnIndices.header;
 },
 GetAdaptiveRowInfo: function() {
  var adaptiveNodes = [ ];
  var tree = this.GetVisibleDataRowTree();
  this.FindAdaptiveNodes(tree, adaptiveNodes, false);
  for(var i = 0; i < adaptiveNodes.length; i++) {
   var node = adaptiveNodes[i];
   ASPx.Data.ArrayRemove(node.parent.children, node);
  }
  var dataRowLayout = [ ];
  this.PopulateRowLayout(tree, dataRowLayout);
  this.Invalidate();
  return { 
   dataRowLayout: dataRowLayout, 
   adaptiveColumnIndices: adaptiveNodes.map(function(n) { return n.columnIndex; }) 
  };
 },
 FindAdaptiveNodes: function(node, adaptiveNodes, isAdaptiveParent) {
  var isColumnAdaptive = node.column && node.column.adaptiveHidden;
  if(isColumnAdaptive || isAdaptiveParent) {
   adaptiveNodes.push(node);
   isAdaptiveParent |= isColumnAdaptive;
  }
  for(var i = 0; i < node.children.length; i++)
   this.FindAdaptiveNodes(node.children[i], adaptiveNodes, isAdaptiveParent);
 },
 EnsureTrees: function() {
  this.GetVisibleHeaderTree();
  this.GetVisibleDataRowTree();
 },
 GetVisibleHeaderTree: function() {
  if(!this.visibleHeaderTree) {
   var root = this.CreateTreeNode(-1, null);
   this.PopulateVisualTreeNode(root, this.GetVisibleChildColumns(-1), false);
   this.PopulateHeaderNodeSpans(root);
   this.visibleHeaderTree = root;
  }
  return this.visibleHeaderTree;
 },
 GetVisibleDataRowTree: function() {
  if(!this.visibleDataRowTree) {
   var root = this.CreateTreeNode(-1, null);
   this.PopulateVisualTreeNode(root, this.GetVisibleChildColumns(-1), true);
   this.PopulateDataRowNodeSpans(root);
   this.visibleDataRowTree = root;
  }
  return this.visibleDataRowTree;
 },
 GetHeaderLayout: function() {
  if(!this.headerLayout) {
   this.headerLayout = [ ];
   this.PopulateRowLayout(this.GetVisibleHeaderTree(), this.headerLayout);
  }
  return this.headerLayout;
 },
 GetDataRowLayout: function() {
  if(!this.dataRowLayout) {
   this.dataRowLayout = [ ];
   this.PopulateRowLayout(this.GetVisibleDataRowTree(), this.dataRowLayout);
  }
  return this.dataRowLayout;
 },
 GetHeaderLeafs: function() { 
  if(!this.headerLeafs) {
   this.headerLeafs = [ ];
   this.PopulateLeafs(this.GetVisibleHeaderTree(), this.headerLeafs);
  }
  return this.headerLeafs;
 },
 GetDataRowLeafs: function() { 
  if(!this.dataRowLeafs) {
   this.dataRowLeafs = [ ];
   this.PopulateLeafs(this.GetVisibleDataRowTree(), this.dataRowLeafs);
  }
  return this.dataRowLeafs;
 },
 PopulateVisualTreeNode: function(node, visibleColumns, isDataRowTree) {
  var nodeHash = isDataRowTree ? this.dataRowNodeHash : this.headerNodeHash;
  for(var i = 0; i < visibleColumns.length; i++) {
   var bandNode = node;
   var column = visibleColumns[i];
   var childColumns = this.GetVisibleChildColumns(column.index);
   if(this.UseColumnInVisualTree(column, childColumns, isDataRowTree)) {
    var child = this.CreateTreeNode(column.index, node);
    node.children.push(child);
    nodeHash[column.index] = child;
    bandNode = child;
   }
   if(childColumns.length > 0)
    this.PopulateVisualTreeNode(bandNode, childColumns, isDataRowTree);
  }
 },
 UseColumnInVisualTree: function(column, childColumns, isDataRowTree) {
  if(column.groupIndex > -1 && !this.GetShowGroupedColumns())
   return false;
  if(isDataRowTree && column.isBand) {
   var childBandColumns = childColumns.filter(function(c) { return c.isBand; });
   if(childBandColumns.length > 0)
    return false;
   var visibleChildrenInTree = childColumns.filter(function(c) { return this.UseColumnInVisualTree(c, this.GetVisibleChildColumns(c.index), isDataRowTree); }.bind(this));
   return visibleChildrenInTree.length === 0;
  }
  return true;
 },
 GetChildColumns: function(columnIndex) {
  if(!this.childColumnHash[columnIndex])
   this.childColumnHash[columnIndex] = this.GetAllColumns().filter(function(c) { return c.parentIndex === columnIndex; });
  return this.childColumnHash[columnIndex];
 },
 GetVisibleChildColumns: function(columnIndex, unsorted) {
  columnIndex = parseInt(columnIndex);
  if(unsorted)
   return this.FindVisibleChildColumns(columnIndex, unsorted);
  if(!this.sortedVisibleChildColumnsHash[columnIndex])
   this.sortedVisibleChildColumnsHash[columnIndex] = this.FindVisibleChildColumns(columnIndex);
  return this.sortedVisibleChildColumnsHash[columnIndex];
 },
 FindVisibleChildColumns: function(columnIndex, unsorted) {
  var columns = this.GetChildColumns(columnIndex).filter(function(c) { return c.visible; }.bind(this));
  if(!unsorted)
   columns.sort(function(c1, c2) {
    var isRootLevel = columnIndex === -1;
    if(isRootLevel && this.IsColumnFixed(c1.index) !== this.IsColumnFixed(c2.index))
     return this.IsColumnFixed(c1.index) ? -1 : 1;
    if(c1.visibleIndex > c2.visibleIndex)
     return 1;
    if(c1.visibleIndex < c2.visibleIndex)
     return -1;
    return c1.collectionIndex - c2.collectionIndex;
   }.aspxBind(this));
  return columns;
 },
 PopulateRowLayout: function(node, layout) {
  for(var i = 0; i < node.children.length; i++) {
   var child = node.children[i];
   var levelIndex = this.FindNodeLayoutLevelIndex(child);
   while(layout.length < levelIndex + 1)
    layout.push([ ]);
   layout[levelIndex].push(child);
   this.PopulateRowLayout(child, layout);
  }
 },
 PopulateLeafs: function(node, leafs) {
  for(var i = 0; i < node.children.length; i++) {
   var child = node.children[i];
   if(child.children.length > 0)
    this.PopulateLeafs(child, leafs);
   else
    leafs.push(child);
  }
 },
 FindNodeLayoutLevelIndex: function(node) {
  var level = 0;
  node = node.parent;
  while(node.parent) {
   level += node.rowSpan;
   node = node.parent;
  }
  return level;
 },
 PopulateDataRowNodeSpans: function(root) {
  this.GetVisibleHeaderTree(); 
  root.rowSpan = root.colSpan = 1;
  var useBandedRowLayout = true; 
  for(var key in this.dataRowNodeHash) {
   if(!this.dataRowNodeHash.hasOwnProperty(key)) continue;
   var dataRowNode = this.dataRowNodeHash[key];
   var headerNode = this.headerNodeHash[key];
   dataRowNode.colSpan = headerNode.colSpan;
   dataRowNode.rowSpan = useBandedRowLayout ? headerNode.rowSpan : 1;
  }
  var bandColumnIndices = [ ];
  for(var key in this.headerNodeHash) {
   if(!this.headerNodeHash.hasOwnProperty(key)) continue;
   var headerNode = this.headerNodeHash[key];
   if(headerNode.column && headerNode.column.isBand)
    bandColumnIndices.push(headerNode.column.index);
  }
  if(bandColumnIndices.length > 0 && useBandedRowLayout)
   this.NormalizeDataRowTreeNodeRowSpans(bandColumnIndices);
 },
 NormalizeDataRowTreeNodeRowSpans: function(bandColumnIndices) {
  var matrix = this.CreateLayoutMatrixInfo(this.GetHeaderLayout()).matrix;
  var height = matrix.length;
  var width = matrix[0].length;
  for(var j = 0; j < width; j++) {
   var lastNotBandColumnIndex = matrix[height - 1][j];
   for(var i = height - 2; i >= 0; i--) {
    var columnIndex = matrix[i][j];
    if(bandColumnIndices.indexOf(columnIndex) > -1)
     matrix[i][j] = lastNotBandColumnIndex;
    else 
     lastNotBandColumnIndex = columnIndex;
   }
  }
  for(var i = height - 1; i > 0; i--) {
   if(this.IsMatrixRowEqual(matrix, i, i - 1))
    matrix.splice(i, 1);
  }
  height = matrix.length;
  var columnRowSpan = { };
  for(var j = 0; j < width; j++) {
   var columnIndices = this.GetColumnIndicesByColInd(height, j, matrix);
   var groupedIndices = columnIndices.reduce(function(r, cI) { (r[cI] = r[cI] || [ ]).push(cI); return r; }, { });
   for(var columnIndex in groupedIndices) {
    if(!groupedIndices.hasOwnProperty(columnIndex)) continue;
    columnRowSpan[columnIndex] = groupedIndices[columnIndex].length;
   }
  }
  for(var columnIndex in columnRowSpan) {
   if(!columnRowSpan.hasOwnProperty(columnIndex)) continue;
   this.dataRowNodeHash[columnIndex].rowSpan = columnRowSpan[columnIndex];
  }
 },
 GetColumnIndicesByColInd: function(height, colInd, matrix) {
  return ASPx.Data.Range(height).map(function(i) { return matrix[i][colInd]; });
 },
 PopulateHeaderNodeSpans: function(root) {
  var leafs = [ ];
  this.PopulateLeafs(root, leafs);
  if(leafs.length === 0)
   return;
  var leafTreeLines = [ ];
  for(var i = 0; i < leafs.length; i++) {
   var treeLine = [ ];
   var current = leafs[i];
   while(current != null) {
    current.colSpan |= 0;
    current.colSpan++;
    current.rowSpan = current.column ? current.column.rowSpan : 1;
    treeLine.push(current);
    current = current.parent;
   }
   leafTreeLines.push(treeLine);
  }
  var normalizeIterationCount = 2;
  for(var i = 0; i < normalizeIterationCount; i++)
   this.NormalizeHeaderNodesRowSpan(leafTreeLines);
 },
 NormalizeHeaderNodesRowSpan: function(leafTreeLines) {
  var height = leafTreeLines.reduce(function(prevValue, treeLine) { return Math.max(prevValue, treeLine.length); }, 0);
  for(var i = 0; i < leafTreeLines.length; i++) {
   var treeLine = leafTreeLines[i];
   var rowSpanHeight = treeLine.reduce(function(prevValue, node) { return prevValue + node.rowSpan; }, 0);
   var diff = height - rowSpanHeight;
   if(diff < 0)
    this.CalculateTreeLineRowSpanProportionally(treeLine, height);
   else
    treeLine[0].rowSpan += diff; 
  }
 },
 CalculateTreeLineRowSpanProportionally: function(treeLine, requiredHeight) {
  var rowSpans = this.CalculateTreeLineRowSpanProportionallyCore(treeLine, requiredHeight);
  for(var i = 0; i < treeLine.length; i++)
   treeLine[i].rowSpan = rowSpans[i];
 },
 CalculateTreeLineRowSpanProportionallyCore: function(treeLine, requiredHeight) {
  var result = [ ];
  var height = treeLine.reduce(function(prevValue, node) { return prevValue + node.rowSpan; }, 0);
  var delta = requiredHeight - height;
  if(delta >= 0) 
   return result;
  delta *= -1;
  var excess = delta;
  for(var i = 0; i < treeLine.length; i++) {
   var node = treeLine[i];
   result[i] = node.rowSpan;
   if(excess <= 0) continue;
   var k = Math.ceil(delta * node.rowSpan / height) + 1;
   if(k >= node.rowSpan)
    k = node.rowSpan - 1;
   excess -= k;
   if(excess < 0)
    k += excess;
   result[i] -= k;
  }
  return result;
 },
 CreateTreeNode: function(columnIndex, parent) {
  if(parent === undefined)
   parent = null;
  return { columnIndex: columnIndex, children: [ ], parent: parent, column: this.FindColumn(columnIndex) };
 },
 CreateTreeLine: function(node, insertCurrent) {
  var result = [ ];
  var current = insertCurrent ? node : node.parent;
  while(current.column !== null) {
   result.push(current);
   current = current.parent;
  }
  return result;
 },
 Invalidate: function() {
  this.visibleHeaderTree = null;
  this.visibleDataRowTree = null;
  this.headerLayout = null;
  this.dataRowLayout = null;
  this.headerLeafs = null;
  this.dataRowLeafs = null;
  this.headerNodeHash = { };
  this.dataRowNodeHash = { };
  this.sortedVisibleChildColumnsHash = { };
  this.childColumnHash = { };
  this.fixedColumnsHash = null;
  this.visibleColumnIndices = null;
  this.rightTreeLines = null;
  this.cachedGroupColumnCount = -1;
 },
 GetOrderedColumns: function() {
  var columns = this.GetAllColumns();
  columns.sort(function(c1, c2) {
   if(c1.index > c2.index)
    return 1;
   if(c1.index < c2.index)
    return -1;
   return 0;
  });
  return columns;
 },
 SerializeColumnVisibleState: function() {
  var state = [ ];
  var columns = this.GetOrderedColumns();
  state.push("clientvis" + columns.length);
  for(var i = 0; i < columns.length; i++) {
   var column = columns[i];
   state.push((column.visible ? "t" : "f") + column.visibleIndex);
  }
  return state.join("|");
 },
 SerializeColumnHierarchyState: function() {
  var state = [ ];
  var columns = this.GetOrderedColumns();
  state.push("clienthierar" + columns.length);
  for(var i = 0; i < columns.length; i++) {
   var column = columns[i];
   state.push(column.index + "|" + column.parentIndex);
  }
  return state.join("|");
 },
 CreateLayoutMatrixInfo: function(layout) {
  var matrix = [ ];
  var inverseMatrix = { };
  for(var i = 0; i < layout.length; i++) {
   var lastFreeIndex = 0;
   var level = layout[i];
   for(var j = 0; j < level.length; j++) {
    var node = level[j];
    lastFreeIndex = this.FindMatrixFreeCellIndex(matrix, i, lastFreeIndex);
    this.FillMatrixBlock(matrix, inverseMatrix, i, lastFreeIndex, node.rowSpan, node.colSpan, node.columnIndex);
    lastFreeIndex += node.colSpan;
   }
  }
  return { matrix: matrix, inverseMatrix: inverseMatrix };
 },
 FindMatrixFreeCellIndex: function(matrix, rowIndex, lastFreeCell) {
  var row = matrix[rowIndex];
  var result = lastFreeCell;
  if(row) {
   while(!isNaN(row[result]))
    result++;
  } 
  return result;
 },
 FillMatrixBlock: function(matrix, inverseMatrix, rowIndex, cellIndex, rowSpan, colSpan, columnIndex) {
  var rect = {
   top: rowIndex,
   bottom: rowIndex + rowSpan - 1,
   left: cellIndex,
   right: cellIndex + colSpan - 1
  };
  for(var i = rect.top; i <= rect.bottom; i++) {
   while(!matrix[i])
    matrix.push([]);
   for(var j = rect.left; j <= rect.right; j++)
    matrix[i][j] = columnIndex;
  }
  inverseMatrix[columnIndex] = rect;
 },
 IsMatrixRowEqual: function(matrix, i1, i2) {
  var row1 = matrix[i1];
  var row2 = matrix[i2];
  for(var j = 0; j < row1.length; j++) {
   if(row1[j] !== row2[j])
    return false;
  }
  return true;
 }
});
ASPx.GridViewColumnHelper = GridViewColumnHelper;
})();
(function(){
var GridViewConsts = {
 AdaptiveGroupPanelID: "DXAGroupPanel",
 AdaptiveHeaderPanelID: "DXAHeaderPanel",
 AdaptiveFooterPanelID: "DXAFooterPanel",
 AdaptiveGroupHeaderID: "DXADGroupHeader",
 AdaptiveHeaderID: "DXADHeader",
 HeaderTableID: "DXHeaderTable",
 FooterTableID: "DXFooterTable",
 FilterRowID: "DXFilterRow",
 DataRowID: "DXDataRow",
 DetailRowID: "DXDRow",
 EditingRowID: "DXEditingRow",
 EditingErrorItemID: "DXEditingErrorItem",
 EditFormTableCellID: "DXEFC",
 AdaptiveDetailRowID: "DXADRow",
 PreviewRowID: "DXPRow",
 GroupRowID: "DXGroupRow",
 GroupRowExpID: "DXGroupRowExp",
 EmptyDataRowID: "DXEmptyRow",
 FooterRowID: "DXFooterRow",
 GroupFooterRowID: "DXGFRow",
 HeaderRowID: "DXHeadersRow",
 DataRowTemplateCellID: "tcrow",
 GroupFooterRowTemplateCellID: "tcgfr",
 FooterRowTemplateCellID: "tcFooterRow",
 FilterRowTemplateCellID: "tcFR",
 CustDialogWindowID: "DXCDWindow",
 DataRowPattern: "_DXDataRow(?:-?\\d+|new)(?:_\\d+)?$",
 BandedRowPattern: "_DXDataRow(-?\\d+|new)_(\\d+)$",
 GridViewMarkerCssClass: "dxgv",
 ControlClassName: "dxgvControl",
 DataRowCssClass: "dxgvDataRow",
 GroupRowCssClass: "dxgvGroupRow",
 EmptyPagerRowCssClass: "dxgvEPDR",
 GroupFooterRowClass: "dxgvGroupFooter",
 GroupPanelCssClass: "dxgvGroupPanel",
 FooterScrollDivContainerCssClass: "dxgvFSDC",
 HeaderScrollDivContainerCssClass: "dxgvHSDC",
 HeaderCellCssClass: "dxgvHeader",
 CommandColumnCellCssClass: "dxgvCommandColumn",
 IndentCellCssClass: "dxgvIndentCell",
 InlineEditCellCssClass: "dxgvInlineEditCell",
 DetailCellCssClass: "dxgvDetailCell",
 DetailIndentCellCssClass: "dxgvDIC",
 DetailButtonCellCssClass: "dxgvDetailButton",
 AdaptivityDisabledCssClass: "dxgvAdD",
 AdaptivityEnabledCssClass: "dxgvAE",
 AdaptivityWithLimitEnabledCssClass: "dxgvALE",
 AdaptiveHiddenCssClass: "dxgvAH",
 AdaptiveIndentCellCssClass: "dxgvAIC",
 AdaptiveDetailShowButtonCssClass: "dxgvADSB",
 AdaptiveDetailHideButtonCssClass: "dxgvADHB",
 AdaptiveDetailTableCssClass: "dxgvADT",
 AdaptiveDetailCaptionCellCssClass: "dxgvADCC",
 AdaptiveDetailDataCellCssClass: "dxgvADDC",
 AdaptiveDetailSpacerCellCssClass: "dxgvADSC",
 AdaptiveDetailCommandCellCssClass: "dxgvADCMDC",
 AdaptiveDetailLayoutItemContentCssClass: "dxgvADLIC",
 HorizontalExtraCellClassName: "dxgvHEC",
 HiddenHorizontalExtraCellMarkerClassName: "dxgvHHEC",
 FirstVisibleRowClassName: "dxgvFVR",
 LastVisibleRowClassName: "dxgvLVR",
 AccessibilityInvisibleRowClassName: "dxAIR",
 PageBottomVisibleCellsMarkerClassName: "dxgvPBVC"
};
var GridViewRowType = { Header: 1, Filter: 2, Data: 3, Group: 4, GroupFooter: 5, Footer: 6, InlineEdit: 7, BatchEtalon: 8 };
var GridViewAdaptiveDetailButtonPosition = { None: 0, Left: 1, Right: 2 };
var ASPxClientGridView = ASPx.CreateClass(ASPxClientGridBase, {
 NewRowVisibleIndex: -2147483647,
 constructor: function(name){
  this.constructor.prototype.constructor.call(this, name);
  this.editMode = 2;
  this.enablePostponeResizing = false;
  this.FocusedRowChanged = new ASPxClientEvent();
  this.RowFocusing = new ASPxClientEvent();
  this.ColumnGrouping = new ASPxClientEvent();
  this.ColumnStartDragging  = new ASPxClientEvent();
  this.ColumnResizing  = new ASPxClientEvent();
  this.ColumnResized  = new ASPxClientEvent();
  this.ColumnMoving = new ASPxClientEvent();
  this.RowExpanding  = new ASPxClientEvent();
  this.RowCollapsing  = new ASPxClientEvent();
  this.DetailRowExpanding  = new ASPxClientEvent();
  this.DetailRowCollapsing  = new ASPxClientEvent();
  this.RowClick  = new ASPxClientEvent();
  this.RowDblClick  = new ASPxClientEvent();
  this.ContextMenu = new ASPxClientEvent();
  this.ContextMenuItemClick = new ASPxClientEvent();
  this.BatchEditRowValidating = new ASPxClientEvent();
  this.BatchEditRowInserting = new ASPxClientEvent();
  this.BatchEditRowDeleting = new ASPxClientEvent();
  this.allowFixedGroups = false;
  this.virtualScrollMode = 0;
  this.fixedColumnCount = 0;
  this.hasDetailRows = false;
  this.showDetailButton = true;
  this.showGroupButton = true;
  this.adaptiveButtonPos = GridViewAdaptiveDetailButtonPosition.None;
  this.showColumnHeaders = true;
  this.showGroupedColumns = false;
  this.hasMergedGroups = false;
  this.hasFilterRowTemplate = false;
  this.hasDataRowTemplate = false;
  this.hasGroupRowTemplate = false;
  this.hasFooterRowTemplate = false;
  this.hasGroupFooterRowTemplate = false;
  this.allowChangeColumnHierarchy = false;
  this.allowColumnClientMove = false;
  this.tableHelper = null;
  this.dragHelper = null;
  this.batchEditHelper = null;
  this.custDialogHelper = null;
  this.virtualScrollingDelay = 500;
  this.adaptivityMode = 0;
  this.adaptiveColumnsOrder = [];
  this.adaptivityHelper = null;
  this.enableCustDialog = false;
  this.custDialogApplyButtonName = "";
  this.custDialogCloseButtonName = "";
 },
 applyAccessibilityAttributes: function() {
  this.setAriaDescription("headerLayoutElements");
 },
 GetGroupPanelContextMenu: function() { return ASPx.GetControlCollection().Get(this.name + "_DXContextMenu_GroupPanel"); },
 GetColumnContextMenu: function() { return ASPx.GetControlCollection().Get(this.name + "_DXContextMenu_Columns"); },
 GetRowContextMenu: function() { return ASPx.GetControlCollection().Get(this.name + "_DXContextMenu_Rows"); },
 GetFooterContextMenu: function() { return ASPx.GetControlCollection().Get(this.name + "_DXContextMenu_Footer"); },
 GetGroupFooterContextMenu: function() { return ASPx.GetControlCollection().Get(this.GetGroupFooterContextMenuName()); },
 GetCustDialogWindow: function() { return ASPx.GetControlCollection().Get(this.name + "_" + GridViewConsts.CustDialogWindowID); },
 GetCustDialogHelper: function() {
  if(!this.custDialogHelper && typeof(ASPx.GridViewCustDialogHelper) != "undefined" && this.GetCustDialogWindow())
   this.custDialogHelper = this.CreateCustDialogHelper();
  return this.custDialogHelper;
 },
 CreateCustDialogHelper: function() { return new ASPx.GridViewCustDialogHelper(this); },
 GetGroupFooterContextMenuName: function() { return this.name + "_DXContextMenu_GroupFooter"; },
 GetItem: function(visibleIndex, level){
  var res = this.GetDataRow(visibleIndex, level);
  if(res == null) res = this.GetGroupRow(visibleIndex);
  return res;
 },
 GetDataItem: function(visibleIndex) { return this.GetDataRow(visibleIndex); },
 IsDataItem: function(visibleIndex) { return this.IsDataRow(visibleIndex); },
 GetRow: function(visibleIndex) { return this.GetItem(visibleIndex); },
 GetDataItemIDPrefix: function() { return GridViewConsts.DataRowID; },
 GetEmptyDataItemIDPostfix: function() { return GridViewConsts.EmptyDataRowID; },
 GetHotTrackItemPostfixes: function(){
  if(!this.HasBandedDataRows())
   return ASPxClientGridBase.prototype.GetHotTrackItemPostfixes.call(this);
  var postfixes = [ ];
  var layout = this.GetLayoutHelper().GetEtalonDataRowLayout();
  for(var i = 0; i < layout.length; i++)
   postfixes.push('_' + i);
  return postfixes;
 },
 GetEmptyDataItemCell: function() { 
  var row = this.GetEmptyDataItem();
  return row ? this.GetLastNonAdaptiveIndentCell(row) : null;
 },
 GetDataRow: function(visibleIndex, level) {
  return this.GetChildElement(GridViewConsts.DataRowID + visibleIndex + this.GetBandedRowLevelPostfix(level));
 },
 GetEditingRow: function(obj, level) {
  if(!this.HasBandedDataRows())
   return ASPxClientGridBase.prototype.GetEditingRow.call(this, obj);
  return ASPx.GetElementById((obj ? obj.name : this.name) + this.EditingRowID + this.GetBandedRowLevelPostfix(level));
 },
 GetEditingRowElements: function() {
  var rows = [];
  ASPx.GetNodesByPartialId(this.GetMainTable(), this.EditingRowID, rows);
  var adaptiveInlineEditRow = this.GetAdaptiveInlineEditRow();
  if(adaptiveInlineEditRow)
   rows.push(adaptiveInlineEditRow);
  return rows;
 },
 GetBatchEtalonRow: function(levelIndex) {
  var partialId = this.GetDataItemIDPrefix() + "new"; 
  return this.GetChildElement(partialId + this.GetBandedRowLevelPostfix(levelIndex));
 },
 GetBandedRowLevelPostfix: function(level){
  if(!this.HasBandedDataRows()) return "";
  if(!ASPx.IsExists(level))
   level = 0;
  return "_" + level;
 },
 GetEditFormTableCell: function() { return ASPx.GetElementById(this.name + "_" + GridViewConsts.EditFormTableCellID); },
 HasBandedDataRows: function() { return this.GetLayoutHelper().GetEtalonDataRowLayout().length > 1; }, 
 GetBandedDataRows: function(visibleIndex) {
  var height = this.GetLayoutHelper().GetLayoutHeight();
  var rows = ASPx.Data.Range(height, 0).map(function(i) { return this.GetDataRow(visibleIndex, i); }.bind(this));
  return rows.filter(function(row) { return !!row; });
 },
 GetBandedInlineEditRows: function() {
  var height = this.GetLayoutHelper().GetLayoutHeight();
  var rows = ASPx.Data.Range(height, 0).map(function(i) { return this.GetEditingRow(this, i); }.bind(this));
  return rows.filter(function(row) { return !!row; });
 },
 GetEditingCell: function(columnIndex) { 
  var row = this.GetEditingRow();
  var cellIndex = this.GetDataCellIndex(columnIndex);
  return row ? row.cells[cellIndex] : null;
 },
 GetEditingErrorCell: function(row) { 
  var row = row || this.GetEditingErrorItem();
  return row ? this.GetLastNonAdaptiveIndentCell(row) : null;
 },
 GetErrorTextContainer: function(displayIn) {
  var errorRow = this.GetEditingErrorItem(displayIn);
  if(!errorRow) {
   var editRow = this.GetEditingRow(displayIn);
   if(editRow) {
    errorRow = this.CreateEditingErrorItem();
    errorRow.id = editRow.id.replace("DXEditingRow", this.EditingErrorItemID);
    this.UpdateEditingErrorRowColSpan(errorRow, editRow);
    ASPx.InsertElementAfter(errorRow, editRow);
   }
  }
  return this.GetEditingErrorCell(errorRow);
 },
 CreateEditingErrorItem: function() {
  var wrapperElement = document.createElement("div");
  wrapperElement.innerHTML = "<table><tbody>" + this.styleInfo[ASPxClientGridItemStyle.ErrorItemHtml] + "</tbody></table>";
  var row = wrapperElement.firstChild.rows[0];
  for(var i = 0; i < row.cells.length; i++) {
   var cell = row.cells[i];
   var colSpan = parseInt(ASPx.Attr.GetAttribute(cell, "data-colSpan"));
   if(!isNaN(colSpan)) 
    cell.colSpan = colSpan;
  }
  return row;
 },
 UpdateEditingErrorRowColSpan: function(row, previousRow) {
  var adaptivityHelper = this.GetAdaptivityHelper();
  if(adaptivityHelper && adaptivityHelper.HasAnyAdaptiveElement()) {
   var errorCell = this.GetLastNonAdaptiveIndentCell(row);
   var adaptiveSampleCell = this.GetSampleAdaptiveDetailCell();
   errorCell.colSpan = adaptiveSampleCell.colSpan;
   errorCell.originalColSpan = adaptiveSampleCell.originalColSpan;
  } 
  if(this.GetFixedColumnsHelper() && this.IsEditFormEditMode()) {
   var errorCell = this.GetLastNonAdaptiveIndentCell(row);
   var editRowCell = this.GetLastNonAdaptiveIndentCell(previousRow);
   errorCell.colSpan = editRowCell.colSpan;
  }
 },
 GetCustDialogApplyButton: function() { return ASPx.GetControlCollection().Get(this.custDialogApplyButtonName); },
 GetCustDialogCloseButton: function() { return ASPx.GetControlCollection().Get(this.custDialogCloseButtonName); },
 PrepareCommandButton: function(button) {
  ASPxClientGridBase.prototype.PrepareCommandButton.call(this, button);
  if(this.enableCustDialog) {
   this.EnsureCommandButtonClickArgs(button);
   var commandName = button.gvClickArgs && button.gvClickArgs[0][0];
   if(commandName === "CustDialogApply")
    this.custDialogApplyButtonName = button.name;
   if(commandName === "CustDialogClose")
    this.custDialogCloseButtonName = button.name;
  }
 },
 GetDetailRow: function(visibleIndex) { return this.GetChildElement(GridViewConsts.DetailRowID + visibleIndex); },
 GetDetailCell: function(visibleIndex) { 
  var row = this.GetDetailRow(visibleIndex);
  return row ? this.GetLastNonAdaptiveIndentCell(row) : null;
 },
 GetPreviewRow: function(visibleIndex) { return this.GetChildElement(GridViewConsts.PreviewRowID + visibleIndex); },
 GetPreviewCell: function(visibleIndex) { 
  var row = this.GetPreviewRow(visibleIndex);
  return row ? this.GetLastNonAdaptiveIndentCell(row) : null;
 },
 GetSampleAdaptiveDetailRow: function() { return this.GetChildElement(GridViewConsts.AdaptiveDetailRowID); },
 GetSampleAdaptiveDetailCell: function() { 
  var row = this.GetSampleAdaptiveDetailRow();
  return row ? this.GetLastNonAdaptiveIndentCell(row) : null;
 },
 GetAdaptiveDataRow: function(visibleIndex) { 
  var getDataItem = this.GetDataRow.aspxBind(this);
  var isValidDataItem = function(item) { return !!item; };
  var getInlineEditItem = this.GetEditingRow.aspxBind(this);
  return this.GetAdaptiveItem(visibleIndex, getDataItem, isValidDataItem, getInlineEditItem);
 },
 GetBandedAdaptiveDataRows: function(visibleIndex) {
  var getDataItem = this.GetBandedDataRows.aspxBind(this);
  var isValidDataItem = function(item) { return item && item.length; };
  var getInlineEditItem = this.GetBandedInlineEditRows.aspxBind(this);
  return this.GetAdaptiveItem(visibleIndex, getDataItem, isValidDataItem, getInlineEditItem) || [ ];
 },
 GetAdaptiveItem: function(visibleIndex, getDataItem, isValidDataItem, getInlineEditItem) {
  if(this.IsGroupRow(visibleIndex))
   return null;
  var item = getDataItem(visibleIndex);
  if(isValidDataItem(item))
   return item;
  if(this.IsInlineEditMode())
   return getInlineEditItem();
  return null;
 },
 GetAdaptiveDetailRow: function(visibleIndex, forceCreate) {
  var row = this.GetChildElement(GridViewConsts.AdaptiveDetailRowID + visibleIndex);
  if(!row && forceCreate) {
   var sampleRow = this.GetSampleAdaptiveDetailRow();
   var dataRow = null;
   if(this.HasBandedDataRows()){
    var bandedRows = this.GetBandedAdaptiveDataRows(visibleIndex);
    if(bandedRows.length)
     dataRow = bandedRows[bandedRows.length - 1];
   } else {
    dataRow = this.GetAdaptiveDataRow(visibleIndex);
   }
   if(sampleRow && dataRow) {
    row = sampleRow.cloneNode(true);
    row.id = this.name + "_" + GridViewConsts.AdaptiveDetailRowID + visibleIndex;
    this.GetLastNonAdaptiveIndentCell(row).originalColSpan = this.GetLastNonAdaptiveIndentCell(sampleRow).originalColSpan;
    this.EnsureAdaptiveDetailRowStyle(row, dataRow);
    ASPx.InsertElementAfter(row, dataRow);
    for(var i = 0; i < this.indentColumnCount; i++)
     row.cells[i].style.borderBottomWidth = dataRow.cells[i].style.borderBottomWidth;
   }
  }
  return row;
 },
 GetAdaptiveInlineEditRow: function() {
  if(!this.IsInlineEditMode() || !this.HasAdaptivity())
   return null;
  return this.GetAdaptiveDetailRow(this.editItemVisibleIndex);
 },
 GetAdaptiveHeaderContainer: function(columnIndex, adaptivePanel) { 
  if(!adaptivePanel) return null;
  var isGroupHeader = adaptivePanel === this.GetAdaptiveGroupPanel();
  var headerID = this.GetAdaptiveHeaderID(columnIndex, isGroupHeader);
  var adaptiveHeader = document.getElementById(headerID);
  if(!adaptiveHeader)
   adaptiveHeader = this.CreateAdaptiveHeader(adaptivePanel, headerID, isGroupHeader);
  return adaptiveHeader.dxHeaderContainer;
 },
 GetAdaptiveHeaderID: function(columnIndex, isGroupHeader) {
  return this.name + "_" + (isGroupHeader ? GridViewConsts.AdaptiveGroupHeaderID : GridViewConsts.AdaptiveHeaderID) + columnIndex;
 },
 CreateAdaptiveHeader: function(adaptivePanel, headerID, isGroupHeader) {
  var header = this.GetSampleAdaptiveHeader(isGroupHeader).cloneNode(true);
  header.id = headerID;
  ASPx.SetElementDisplay(header, true);
  header.dxHeaderContainer = this.FindAdaptiveHeaderContainer(header);
  adaptivePanel.appendChild(header);
  return header;
 },
 FindAdaptiveHeaderContainer: function(header) {
  var table = ASPx.GetChildByTagName(header, "TABLE", 0);
  return table.rows[0];
 },
 RemoveAdaptiveHeaders: function() {
  var columnIndices = this.GetVisibleColumnIndices();
  for(var i = 0; i < columnIndices.length; i++) {
   var column = this.GetColumn(columnIndices[i]);
   var headerID = this.GetAdaptiveHeaderID(column.index, column.groupIndex > -1);
   var header = document.getElementById(headerID);
   ASPx.RemoveElement(header);
  }
 },
 GetAdaptiveGroupPanel: function() { return this.GetChildElement(GridViewConsts.AdaptiveGroupPanelID); },
 GetAdaptiveHeaderPanel: function() { return this.GetChildElement(GridViewConsts.AdaptiveHeaderPanelID); },
 GetAdaptiveFooterPanel: function() { return this.GetChildElement(GridViewConsts.AdaptiveFooterPanelID); },
 GetSampleAdaptiveHeader: function(isGroupHeader) { return this.GetChildElement(isGroupHeader ? GridViewConsts.AdaptiveGroupHeaderID : GridViewConsts.AdaptiveHeaderID); },
 IsAdaptiveCell: function(cell) {
  var adaptiveClasses = [ASPx.GridViewConsts.AdaptiveDetailDataCellCssClass, ASPx.GridViewConsts.AdaptiveDetailCommandCellCssClass];
  for(var i = 0; i < adaptiveClasses.length; i++)
   if(ASPx.ElementHasCssClass(cell, adaptiveClasses[i])) return true;     
  return false;
 }, 
 IsCellAdaptiveHidden: function(cell) {
  return ASPx.ElementContainsCssClass(cell, ASPx.GridViewConsts.AdaptiveHiddenCssClass);
 },
 IsAdaptiveDetailHideButton: function(button) {
  return ASPx.ElementContainsCssClass(button.GetMainElement(), ASPx.GridViewConsts.AdaptiveDetailHideButtonCssClass);
 },
 IsAdaptiveDetailShowButton: function(button) {
  return ASPx.ElementContainsCssClass(button.GetMainElement(), ASPx.GridViewConsts.AdaptiveDetailShowButtonCssClass);
 },
 GetAdaptiveCell: function(visibleIndex, columnIndex) {
  var adaptiveDetailsCell = this.GetAdaptiveDetailCell(visibleIndex, false);
  return adaptiveDetailsCell && adaptiveDetailsCell.adaptiveDetailsCells ? adaptiveDetailsCell.adaptiveDetailsCells[columnIndex] : null;
 },
 GetAdaptiveDetailCell: function(visibleIndex, forceCreate) { 
  var row = this.GetAdaptiveDetailRow(visibleIndex, forceCreate);
  return row ? this.GetLastNonAdaptiveIndentCell(row) : null;
 },
 GetDetailButtonCell: function(visibleIndex, fromAdaptiveRow) {
  var row = fromAdaptiveRow ? this.GetAdaptiveDetailRow(visibleIndex) : this.GetAdaptiveDataRow(visibleIndex);
  return ASPx.GetChildByPartialClassName(row, GridViewConsts.DetailButtonCellCssClass);
 },
 GetGroupRow: function(visibleIndex) { 
  var element = this.GetChildElement(GridViewConsts.GroupRowID + visibleIndex);
  if(!element)
   element = this.GetExpandedGroupRow(visibleIndex);
  return element; 
 },
 GetGroupCell: function(visibleIndex) { 
  var row = this.GetGroupRow(visibleIndex);
  return row ? this.GetLastNonAdaptiveIndentCell(row) : null;
 },
 GetGroupLevel: function(visibleIndex){
  var group = this.GetGroupRow(visibleIndex);
  return group ? this.GetFooterIndentCount(group) : -1;
 },
 GetExpandedGroupRow: function(visibleIndex) { return this.GetChildElement(GridViewConsts.GroupRowID + "Exp" + visibleIndex); },
 GetGroupFooterRow: function(visibleIndex, level) { return this.GetChildElement(GridViewConsts.GroupFooterRowID + visibleIndex + this.GetBandedRowLevelPostfix(level)); },
 GetGroupFooterVisibleIndices: function() { 
  var ids = [].slice.call(this.GetMainTable().rows).map(function(row) { return row.id; });
  return this.GetGroupFooterVisibleIndicesCore(ids);
 },
 GetGroupFooterVisibleIndicesCore: function(ids) {
  var result = [ ];
  var regex = this.GetGroupFooterVisibleIndicesRegExp();
  for(var i = 0; i < ids.length; i++) {
   var matches = ids[i].match(regex);
   if(matches && matches[1]) {
    var index = parseInt(matches[1]);
    if(result.indexOf(index) === -1)
     result.push(index);
   }
  }
  return result;
 },
 GetGroupFooterVisibleIndicesRegExp: function() {
  var pattern = "^" + this.name + "_" + GridViewConsts.GroupFooterRowID + "(\\d+)(_(\\d+))?$";
  return new RegExp(pattern);
 },
 _isGroupRow: function(row) { return row.id.indexOf(GridViewConsts.GroupRowID) > -1; },
 IsHeaderRow: function(row) { return this.IsHeaderRowID(row.id); },
 IsHeaderRowID: function(id) { return id.indexOf(this.name + "_" + GridViewConsts.HeaderRowID) == 0; },
 IsEmptyHeaderID: function(id) { return id.indexOf(this.EmptyHeaderSuffix) > -1; },
 IsBandedDataRowID: function(id) {
  var pattern = new RegExp(this.name + GridViewConsts.BandedRowPattern);
  return pattern.test(id);
 },
 CreateEndlessPagingHelper: function(){
  return new ASPx.GridViewEndlessPagingHelper(this);
 },
 GetCssClassNamePrefix: function() { return "dxgv"; },
 GetFilterRow: function(level) { return this.GetChildElement(GridViewConsts.FilterRowID + this.GetBandedRowLevelPostfix(level)); },
 GetFilterCell: function(columnIndex) { return this.GetLayoutHelper().GetFilterCell(columnIndex); },
 GetDataCellIndex: function(columnIndex, visibleIndex) { 
  return this.GetLayoutHelper().GetDataCellIndex(columnIndex, visibleIndex);
 },
 GetColumnIndexByDataCell: function(dataCell) { 
  if(!dataCell) return -1;
  if(ASPx.IsExists(dataCell.columnIndex)) return dataCell.columnIndex;
  var dataRow = this.GetDataItemByChild(dataCell);
  var visibleIndex = dataRow ? this.getItemIndex(dataRow.id) : -1;
  var level = dataRow ? this.GetBandedDataRowLevelByID(dataRow.id) : -1;
  return this.GetLayoutHelper().GetColumnIndex(dataCell.cellIndex, visibleIndex, level);
 },
 GetColumnIndexByHeaderCell: function(headerCell){
  var match = headerCell.id.match(/_col(\d+)$/);
  if(match)
   return match[1];
  return -1;
 },
 GetDataItemByChild: function(element) { return ASPx.GetParent(element, this.IsDataItemElement.aspxBind(this)); },
 IsDataItemElement: function(item) {
  if(!item || !item.id) return false;
  var regex = new RegExp(GridViewConsts.DataRowPattern);
  return regex.test(item.id);
 },
 GetDataCell: function(visibleIndex, columnIndex) {
  return this.GetLayoutHelper().GetDataCell(visibleIndex, columnIndex);
 },
 GetDataCellByRow: function(row, columnIndex, visibleIndex){
  if(!row)
   return null;
  var cellIndex = this.GetDataCellIndex(columnIndex, visibleIndex);
  return (0 <= cellIndex && cellIndex < row.cells.length) ? row.cells[cellIndex] : null;
 },
 GetVisibleColumnIndices: function() { return this.GetColumnHelper().GetVisibleColumnIndices(); },
 GetArmatureCells: function(columnIndex) {
  var result = [ ];
  var cellIndex = this.GetDataCellIndex(columnIndex); 
  var tableHelper = this.GetTableHelper();
  if(tableHelper) {
   if(tableHelper.GetHeaderTable()) {
    var cells = tableHelper.GetArmatureCells(tableHelper.GetHeaderTable());
    if(cells) result.push(cells[cellIndex]);
   }
   if(tableHelper.GetContentTable()) {
    var cells = tableHelper.GetArmatureCells(tableHelper.GetContentTable());
    if(cells) result.push(cells[cellIndex]);
   }
   if(tableHelper.GetFooterTable()) {
    var cells = tableHelper.GetArmatureCells(tableHelper.GetFooterTable());
    if(cells) result.push(cells[cellIndex]);
   }
  }
  else {
   var mainTable = this.GetMainTable();
   result.push(mainTable.rows[0].cells[cellIndex]);
  }
  return result;
 },
 GetDataTableAccessibilityHeaderCells: function(columnIndex) {
  var result = [ ];
  if(this.accessibilityCompliant) {
   var cellIndex = this.GetDataCellIndex(columnIndex);
   var mainTable = this.GetMainTable();
   if(ASPx.ElementHasCssClass(mainTable.rows[1], GridViewConsts.AccessibilityInvisibleRowClassName))
    result.push(mainTable.rows[1].cells[cellIndex]);
  }
  return result;
 },
 GetLastNonAdaptiveIndentCell: function(row) {
  var count = 1;
  while(count <= row.cells.length){
   var cell = row.cells[row.cells.length - count];
   if(!ASPx.ElementHasCssClass(cell, GridViewConsts.AdaptiveIndentCellCssClass) && !ASPx.ElementHasCssClass(cell, GridViewConsts.HorizontalExtraCellClassName))
    return cell;
   count++;
  }
  return null;
 },
 GetHeaderScrollContainer:function() {
  return ASPx.GetNodeByClassName(this.GetMainElement(), GridViewConsts.HeaderScrollDivContainerCssClass);
 },
 GetFooterScrollContainer:function() {
  return ASPx.GetNodeByClassName(this.GetMainElement(), GridViewConsts.FooterScrollDivContainerCssClass);
 },
 SetHeadersClientEvents: function() {
  ASPxClientGridBase.prototype.SetHeadersClientEvents.call(this);
  if(!this.AllowResizing())
   return;
  var helper = this.GetResizingHelper();
  var attachMouseMove = function(headerCell) { 
   ASPx.Evt.AttachEventToElement(headerCell, "mousemove", function(e) { helper.UpdateCursor(e, headerCell); });
  };
  this.AttachEventToHeaderCells(attachMouseMove, false);
 },
 GetFooterRow: function(level){
  return this.GetChildElement(GridViewConsts.FooterRowID + this.GetBandedRowLevelPostfix(level));
 },
 GetFooterCell: function(columnIndex) { return this.GetLayoutHelper().GetFooterCell(columnIndex); },
 GetUserCommandNamesForRow: function() { return ASPxClientGridBase.prototype.GetUserCommandNamesForRow().concat([ "ShowAdaptiveDetail", "HideAdaptiveDetail" ]); },
 GetItemVisibleIndexRegExp: function(dataAndGroupOnly) {
  var idParts = [ GridViewConsts.DataRowID, GridViewConsts.GroupRowID + "(?:Exp)?", GridViewConsts.AdaptiveDetailRowID ];
  if(!dataAndGroupOnly) {
   idParts.push(GridViewConsts.PreviewRowID);
   idParts.push(GridViewConsts.DetailRowID);
  }
  return this.GetItemVisibleIndexRegExpByIdParts(idParts);
 },
 IsMainTableChildElement: function(src) {
  if(!src) return true;
  var tables = [ this.GetMainTable() ];
  var tableHelper = this.GetTableHelper();
  if(tableHelper) {
   tables.push(tableHelper.GetHeaderTable());
   tables.push(tableHelper.GetFooterTable());
  }
  for(var i = 0; i < tables.length; i++) {
   if(ASPx.GetIsParent(tables[i], src))
    return true;
  }
  return false;
 },
 CreateBatchEditApi: function() { return new ASPxClientGridViewBatchEditApi(this); },
 IsVirtualScrolling: function() { return this.virtualScrollMode > 0; },
 IsVirtualSmoothScrolling: function() { return this.virtualScrollMode === 2; },
 SetData: function(data){
  if(data.adaptiveModeInfo)
   this.SetAdaptiveMode(data.adaptiveModeInfo);
 },
 CreateColumn: function(prop) { return new ASPxClientGridViewColumn(prop); },
 Initialize: function() {
  ASPxClientGridBase.prototype.Initialize.call(this);
  if(this.enableKeyboard) {
   this.kbdHelper = this.customKbdHelperName ? new ASPx[this.customKbdHelperName](this) : new ASPx.GridViewKbdHelper(this);
   this.kbdHelper.Init();
   ASPx.KbdHelper.RegisterAccessKey(this);
  }
  this.ResetStretchedColumnWidth();
  this.PrepareEditorsToKeyboardNavigation();
  this.AttachInternalContexMenuEventHandler();
  this.InitializeDropDownElementsScrolling();
  this.SetFixedColumnScrollableRows();
  this.PrepareFixedGroups();
  var resizingHelper = this.GetResizingHelper();
  if(resizingHelper)
   resizingHelper.Initialize();
  var custDialogHelper = this.GetCustDialogHelper();
  if(custDialogHelper)
   custDialogHelper.OnInit();
 },
 PrepareFixedGroups: function() {
  var helper = this.GetFixedGroupsHelper();
  if(helper)
   helper.Initialize();
 },
 InitializeDropDownElementsScrolling: function() {
  if(this.HasVertScroll()) {
   this.ScrollableContainerDropDownEditors = null;
   var vertScrollableControl = this.GetScrollHelper().GetVertScrollableControl();
   ASPx.Evt.AttachEventToElement(vertScrollableControl, "scroll", function(evt) {
    if(ASPx.Evt.GetEventSource(evt) === vertScrollableControl)
     this.AdjustDropDownElements();
   }.aspxBind(this));
  }
 },
 AttachInternalContexMenuEventHandler: function() {
  if(this.IsDetailGrid()) {
   ASPx.Evt.AttachEventToElement(this.GetMainElement(), "contextmenu", function(e) {
    var showDefaultMenu = ASPx.EventStorage.getInstance().Load(e);
    if(showDefaultMenu)
     ASPx.Evt.CancelBubble(e);
    else 
     ASPx.EventStorage.getInstance().Save(e, true);
   }.aspxBind(this), true);
  }
 },
 AdjustControlCore: function() {
  ASPxClientGridBase.prototype.AdjustControlCore.call(this);
  this.CalculateAdaptivity();
  this.UpdateIndentCellWidths();
  this.ValidateColumnWidths();
  this.UpdateFixedColumnsFrozenRowWidths();
 },
 IsAdjustmentRequired: function() {
  if(ASPxClientControl.prototype.IsAdjustmentRequired.call(this))
   return true;
  var scrollHelper = this.GetScrollHelper();
  return scrollHelper ? scrollHelper.IsRestoreScrollPosition() : false;
 },
 SaveCallbackSettings: function() {
  ASPxClientGridBase.prototype.SaveCallbackSettings.call(this);
  var helper = this.GetFixedColumnsHelper();
  if(helper != null) helper.SaveCallbackSettings();
 },
 RestoreCallbackSettings: function() {
  this.ResetStretchedColumnWidth();
  this.SetFixedColumnScrollableRows();
  var fixedColumnsHelper = this.GetFixedColumnsHelper();
  if(fixedColumnsHelper != null)
   fixedColumnsHelper.RestoreCallbackSettings();
  this.SaveAdaptiveScrollTop();
  this.UpdateScrollableControls();
  if(fixedColumnsHelper != null)
   fixedColumnsHelper.HideColumnsRelyOnScrollPosition();
  this.UpdateIndentCellWidths();
  this.ValidateColumnWidths();
  ASPxClientGridBase.prototype.RestoreCallbackSettings.call(this);
 },
 SaveAdaptiveScrollTop: function() {
  this.adaptiveScrollTop = this.stateObject.scrollState ? this.stateObject.scrollState[1] : null;
 },
 ApplyAdaptiveScrollTop: function() {
  if(ASPx.IsExists(this.adaptiveScrollTop)) {
   this.SetVerticalScrollPosition(this.adaptiveScrollTop);
   this.adaptiveScrollTop = null;
  }
 },
 GetPopupEditFormHorzOffsetCorrection: function(popup) {
  var scrollHelper = this.GetScrollHelper();
  if(!scrollHelper) return 0;
  var scrollDiv = scrollHelper.GetHorzScrollableControl();
  if(!scrollDiv)  return 0;
  var horzAlign = popup.GetHorizontalAlign();
  if(ASPx.PopupUtils.IsRightSidesAlign(horzAlign) || ASPx.PopupUtils.IsOutsideRightAlign(horzAlign))
   return scrollDiv.scrollWidth - scrollDiv.offsetWidth;
  if(ASPx.PopupUtils.IsCenterAlign(horzAlign))
   return (scrollDiv.scrollWidth - scrollDiv.offsetWidth) / 2;
  return 0;
 },
 UpdateIndentCellWidths: function() {
  var tableHelper = this.GetTableHelper();
  if(tableHelper)
     tableHelper.UpdateIndentCellWidths();
 },
 UpdateFixedColumnsFrozenRowWidths: function() {
  var helper = this.GetFixedColumnsHelper();
  if(helper)
   helper.UpdateFrozenRowWidths();
 },
 OnBeforeCallbackOrPostBack: function() {
  ASPxClientGridBase.prototype.OnBeforeCallbackOrPostBack.call(this);
  this.SaveControlDimensions();
 },
 OnBeforeCallback: function(command) {
  ASPxClientGridBase.prototype.OnBeforeCallback.call(this, command);
  var scrollHelper = this.GetScrollHelper();
  if(scrollHelper && this.IsVirtualScrolling())
   scrollHelper.ClearVirtualScrollTimer();
 },
 OnAfterCallback: function() {
  ASPxClientGridBase.prototype.OnAfterCallback.call(this);
  this.SaveControlDimensions();
  this.GetContextMenuHelper().OnAfterCallack();
  var resizingHelper = this.GetResizingHelper();
  if(resizingHelper)
   resizingHelper.OnAfterCallback();
  var fixedGroupsHelper = this.GetFixedGroupsHelper();
  if(fixedGroupsHelper)
   fixedGroupsHelper.OnAfterCallback();
  this.PrepareEditorsToKeyboardNavigation();
  this.InitializeDropDownElementsScrolling();
  if(this.accessibilityCompliant)
   this.applyAccessibilityAttributes();
  var custDialogHelper = this.GetCustDialogHelper();
  if(custDialogHelper)
   custDialogHelper.OnAfterCallback();
 },
 PrepareEditorsToKeyboardNavigation: function() {
  if(!this.RequireEditorsKeyboardNavigation()) return;
  for(var i = 0; i < this.columns.length; i++) {
   this.AttachEventToEditor(this.columns[i].index, "GotFocus", function(s, e) { this.OnEditorGotFocus(s, e); }.aspxBind(this));
   this.AttachEventToEditor(this.columns[i].index, "KeyDown", function(s, e) { this.OnEditorKeyDown(s, e); }.aspxBind(this));
  }
 },
 RequireEditorsKeyboardNavigation: function() {
  return this.GetFixedColumnsHelper() && (this.IsInlineEditMode() || this.IsEditFormEditMode());
 },
 OnEditorGotFocus: function(s, e) {
  if(!this.RequireEditorsKeyboardNavigation()) return;
  this.TryMakeNeighborEditorVisible(s);
 },
 OnEditorKeyDown: function(s, e) {
  if(!this.RequireEditorsKeyboardNavigation()) return;
  var keyCode = ASPx.Evt.GetKeyCode(e.htmlEvent);
  if(keyCode !== ASPx.Key.Tab) return;
  var neighborEditor = this.GetNeighborEditor(s, e.htmlEvent.shiftKey);
  if(neighborEditor && this.TryMakeNeighborEditorVisible(neighborEditor)) {
   ASPx.Evt.PreventEventAndBubble(e.htmlEvent);
   ASPx.Selection.SetCaretPosition(s.GetInputElement());
   neighborEditor.Focus();
  }
 },
 GetNeighborEditor: function(editor, left) {
  var neighborEditor = null;
  if(this.IsEditFormEditMode()) {
   var neighborEditorIndex = this.editorIDList.indexOf(editor.name) + (left ? -1 : 1);
   var neighborEditorName = this.editorIDList[neighborEditorIndex];
   neighborEditor = ASPx.GetControlCollection().GetByName(neighborEditorName);
  } else {
   var matrix = this.GetHeaderMatrix();
   var neighborColumnIndex = left ? matrix.GetLeftNeighbor(editor.dxgvColumnIndex, true) : matrix.GetRightNeighbor(editor.dxgvColumnIndex, true);
   neighborEditor = this.GetEditorByColumnIndex(neighborColumnIndex);
  }
  return neighborEditor;
 },
 TryMakeNeighborEditorVisible: function(editor) {
  var helper = this.GetFixedColumnsHelper();
  if(this.IsEditFormEditMode())
   return helper.TryScrollToFocusedEditor(editor);
  var columnIndex = this.tryGetNumberFromEndOfString(editor.name).value;
  return helper.TryShowColumn(columnIndex, true);
 },
 IsInlineEditMode: function() { return this.editMode === 0; },
 IsEditFormEditMode: function() { return this.editMode === 1 || this.editMode === 2; },
 IsBatchEditMode: function() { return this.editMode === 4; },
 IsEditRowHasDisplayedDataRow: function() { return this.editMode >= 2; },
 canGroupByColumn: function(headerElement) {
  return this.getColumnObject(headerElement.id).allowGroup;
 },
 canDragColumn: function(headerElement) {
  var column = this._getColumnObjectByArg(this.getColumnIndex(headerElement.id));
  return !this.RaiseColumnStartDragging(column) && this.getColumnObject(headerElement.id).allowDrag;
 },
 doPagerOnClick: function(id) {
  if(!ASPx.IsExists(id)) return;
  this.AssignSlideAnimationDirectionByPagerArgument(id, this.pageIndex);
  if(ASPx.Browser.IE && this.kbdHelper)
   this.kbdHelper.Focus();
  var scrollHelper = this.GetScrollHelper();
  if(scrollHelper)
   scrollHelper.ResetScrollTop();
  ASPxClientGridBase.prototype.doPagerOnClick.call(this, id);
 },
 TryStartColumnResizing: function(e, headerCell) {
  var helper = this.GetResizingHelper();
  if(!helper || !helper.CanStartResizing(e, headerCell))
   return false;
  var columnIndex = helper.GetResizingColumnIndex(e, headerCell);
  var column = this.columns.filter(function(c) { return c.index == columnIndex; })[0];
  if(this.RaiseColumnResizing(column))
   return false;
  helper.StartResizing(column.index);
  return true;
 },
 IsPossibleSelectItem: function(visibleIndex, newSelectedValue){
  return this.IsDataRow(visibleIndex) && ASPxClientGridBase.prototype.IsPossibleSelectItem.call(this, visibleIndex, newSelectedValue);
 },
 _isRowSelected: function(visibleIndex) {
  return this.IsDataRow(visibleIndex) && ASPxClientGridBase.prototype._isRowSelected.call(this, visibleIndex);
 },
 GetDataItemCountOnPage: function(){
  var dataRowCount = 0;
  for(var i = 0; i < this.pageRowCount; i++){
   var index = i + this.visibleStartIndex;
   if(!this.IsGroupRow(index))
    dataRowCount++;
  }
  return dataRowCount;
 },
 GetFocusedItemStyle: function(visibleIndex, focused){
  var row = this.GetItem(visibleIndex);
  if(focused && row)
   return this._isGroupRow(row) ? ASPxClientGridItemStyle.FocusedGroupItem : ASPxClientGridItemStyle.FocusedItem;
  return ASPxClientGridBase.prototype.GetFocusedItemStyle.call(this, visibleIndex, focused);
 },
 RequireChangeItemStyle: function(visibleIndex, itemStyle){
  if(!ASPxClientGridBase.prototype.RequireChangeItemStyle.call(this, visibleIndex, itemStyle))
   return false;
  return itemStyle != ASPxClientGridItemStyle.Selected || !this.IsGroupRow(visibleIndex); 
 },
 UpdateItemsStyle: function() {
  this.UpdateFirstAndLastVisibleRowMarkers();
  ASPxClientGridBase.prototype.UpdateItemsStyle.call(this);
 },
 GetItemStyle: function(visibleIndex){
  var style = ASPxClientGridBase.prototype.GetItemStyle.call(this, visibleIndex);
  if(style == ASPxClientGridItemStyle.FocusedItem && this.IsGroupRow(visibleIndex))
   style = ASPxClientGridItemStyle.FocusedGroupItem;
  return style;
 },
 ApplyItemStyle: function(visibleIndex, styleInfo) {
  if(this.HasBandedDataRows() && !this.IsGroupRow(visibleIndex)){
   var rows = this.GetBandedDataRows(visibleIndex);
   for(var i = 0; i < rows.length; i++)
    this.ApplyElementStyle(rows[i], styleInfo);
  } else
   ASPxClientGridBase.prototype.ApplyItemStyle.call(this, visibleIndex, styleInfo);
  var adaptivityHelper = this.GetAdaptivityHelper();
  if(adaptivityHelper && !adaptivityHelper.IsResponsiveMode()) {
   if(adaptivityHelper.HasAnyAdaptiveElement() && !this.IsGroupRow(visibleIndex)) {
    var dataRows = this.HasBandedDataRows() ? this.GetBandedAdaptiveDataRows(visibleIndex) : [this.GetDataRow(visibleIndex)];
    var hideRow = function(row) { if(row) ASPx.AddClassNameToElement(row, GridViewConsts.AdaptiveHiddenCssClass); };
    dataRows.forEach(hideRow);
   }
   var adaptiveItem = this.GetAdaptiveDetailRow(visibleIndex);
   if(adaptiveItem) {
    ASPx.Attr.SaveStyleAttribute(adaptiveItem, "display");
    this.ApplyElementStyle(adaptiveItem, styleInfo);
    ASPx.Attr.RestoreStyleAttribute(adaptiveItem, "display");
   }
  }
 },
 EnsureAdaptiveDetailRowStyle: function(adaptiveRow, dataRow) {
  if(this.GetAdaptivityHelper().IsResponsiveMode()) 
   return;
  var visibleIndex = this.getItemIndex(dataRow.id);
  this.ApplyItemStyle(visibleIndex, this.getItemStyleInfo(ASPxClientGridItemStyle.Item));
  var exceptions = [ GridViewConsts.DataRowCssClass, GridViewConsts.AdaptiveHiddenCssClass, GridViewConsts.FirstVisibleRowClassName, GridViewConsts.LastVisibleRowClassName ];
  var classNames = ASPx.GetClassNameList(dataRow);
  classNames = classNames.filter(function(name) { 
   for(var i = 0; i < exceptions.length; i++) {
    if(exceptions[i].indexOf(name) > -1)
     return false;
   }
   return true; 
  });
  for(var i = 0; i < classNames.length; i++)
   ASPx.AddClassNameToElement(adaptiveRow, classNames[i]);
  adaptiveRow.style.cssText = dataRow.style.cssText + " " + adaptiveRow.style.cssText;
  this.UpdateItemStyle(visibleIndex);
 },
 OnScroll: function(evt){
 },
 getItemByHtmlEvent: function(evt) {
  return this.getItemByHtmlEventCore(evt, GridViewConsts.DataRowID) || this.getItemByHtmlEventCore(evt, GridViewConsts.GroupRowID) || this.getItemByHtmlEventCore(evt, GridViewConsts.AdaptiveDetailRowID);
 },
 NeedProcessTableClick: function(evt){
  var headerTable = ASPx.GetParentByPartialId(ASPx.Evt.GetEventSource(evt), GridViewConsts.HeaderTableID);
  if(headerTable) {
   var headerTableID = headerTable.id;
   var gridID = headerTableID.substr(0, headerTableID.length - GridViewConsts.HeaderTableID.length - 1);
   return this.name == gridID;
  }
  return ASPxClientGridBase.prototype.NeedProcessTableClick.call(this, evt);
 },
 IsHeaderChild: function(source) {
  if(!this.showColumnHeaders) return false;
  var headerRowCount = this.GetHeaderMatrix().GetRowCount();
  for(var i = 0; i < headerRowCount; i++) {
   if(ASPx.GetIsParent(this.GetHeaderRow(i), source))
    return true;
  }
  return false;
 },
 IsActionElement: function(mainElement, source) {
  if(this.testActionElement(source))
   return true;
  var parent = source;
  var controlCollection = ASPx.GetControlCollection();
  while(parent.id !== mainElement.id) {
   var control = controlCollection.Get(parent.id);
   if(this.IsActionClientControl(control))
    return true;
   parent = parent.parentElement;
  }  
  return false;
 },
 IsActionClientControl: function(control) {
  if(!ASPx.IsExists(control)) return false;
  var isClientButton = typeof(ASPxClientButton) !== "undefined" && control instanceof ASPxClientButton;
  var isClientEditBase = typeof(ASPxClientEditBase) !== "undefined" && control instanceof ASPxClientEditBase;
  return isClientButton || isClientEditBase;
 },
 IsDetailGridFocused: function(evt) {
  var result = false;
  var mainTable = this.GetMainTable();
  var target = ASPx.Evt.GetEventSource(evt);  
  ASPx.GetControlCollection().ForEachControl(function(control) {   
   var isDetailGrid = control instanceof ASPxClientGridView && control !== this && ASPx.GetIsParent(mainTable, control.GetMainElement());
   if(isDetailGrid) {
    var helper = control.GetCellFocusHelper();
    if(helper && ASPx.GetIsParent(helper.GetCurrentFocusedCell(), target)) {
     result = true;
     return true;
    }
   }
  }, this);
  return result;
 },
 NeedPreventGestures: function(element, mainElement) {
  var gridElement = ASPx.GetParent(element, function(el) { return ASPx.GetControlCollection().GetByName(el.id) instanceof ASPxClientGridView; });
  if(gridElement !== this.GetMainElement())
   return true;
  return ASPxClientGridBase.prototype.NeedPreventGestures.call(this, element, mainElement);
 },
 getItemIndex: function(rowId) {
  if(this.IsHeaderRowID(rowId))
   return -1;
  if(this.IsBandedDataRowID(rowId))
   return this.GetBandedDataRowVisibleIndexByID(rowId);
  return ASPxClientGridBase.prototype.getItemIndex.call(this, rowId);
 },
 GetBandedDataRowLevelByID: function(rowId){
  if(!rowId) return -1;
  var matches = rowId.match(this.name + GridViewConsts.BandedRowPattern);
  return matches && matches.length > 2 ? parseInt(matches[2]) : -1;
 },
 GetBandedDataRowVisibleIndexByID: function(rowId){
  if(!rowId) return -1;
  var matches = rowId.match(this.name + GridViewConsts.BandedRowPattern);
  return matches && matches.length > 2 ? parseInt(matches[1]) : -1;
 },
 CreateBatchEditHelper: function() { return new ASPx.GridViewBatchEditHelper(this); },
 CreateCellFocusHelper: function() { return new ASPx.GridViewCellFocusHelper(this); },
 GetColumnHelper: function() {
  if(!this.columnHelper)
   this.columnHelper = new ASPx.GridViewColumnHelper(this);
  return this.columnHelper;
 },
 GetColumnMovingHelper: function() {
  if(!this.allowColumnClientMove) return;
  if(!this.columnMovingHelper && typeof(ASPx.GridViewColumnMovingHelper) != "undefined")
   this.columnMovingHelper = new ASPx.GridViewColumnMovingHelper(this);
  return this.columnMovingHelper;
 },
 GetTableHelper: function() {
  if(!this.tableHelper && typeof(ASPx.GridViewTableHelper) != "undefined")
   this.tableHelper = new ASPx.GridViewTableHelper(this, this.MainTableID, GridViewConsts.HeaderTableID, GridViewConsts.FooterTableID, this.horzScroll, this.vertScroll);
  return this.tableHelper;
 },
 GetScrollHelper: function() {
  if(!this.HasScrolling()) return null;
  if(!this.scrollableHelper)
   this.scrollableHelper = new ASPx.GridViewTableScrollHelper(this.GetTableHelper());
  return this.scrollableHelper;
 },
 GetFixedColumnsHelper: function() {
  if(!this.GetFixedColumnsDiv()) return null;
  if(!this.fixedColumnsHelper)
   this.fixedColumnsHelper = new ASPx.GridViewTableFixedColumnsHelper(this.GetTableHelper(), this.FixedColumnsDivID, this.FixedColumnsContentDivID, this.fixedColumnCount);
  return this.fixedColumnsHelper;
 },
 GetFixedGroupsHelper: function() {
  if(!this.allowFixedGroups) return null;
  if(!this.fixedGroupsHelper)
   this.fixedGroupsHelper = new ASPx.GridViewFixedGroupsHelper(this.GetTableHelper());
  return this.fixedGroupsHelper;
 },
 GetResizingHelper: function() {
  if(!this.AllowResizing()) return null;
  if(!this.resizingHelper)
   this.resizingHelper = new ASPx.GridViewTableResizingHelper(this.GetTableHelper());
  return this.resizingHelper;
 },
 GetHeaderMatrix: function() {
  if(!this.headerMatrix)
   this.headerMatrix = new GridViewHeaderMatrix(this);
  return this.headerMatrix;
 },
 GetContextMenuHelper: function() {
  if(!this.contextMenuHelper)
   this.contextMenuHelper = this.CreateContextMenuHelper();
  return this.contextMenuHelper;
 },
 CreateContextMenuHelper: function() { return new ASPx.GridViewContextMenuHelper(this); },
 CreateLayoutHelper: function() { return new ASPx.GridViewLayoutHelper(this); },
 CreateNavigationHelper: function() { return typeof(ASPx.GridViewNavigationHelper) != "undefined" ? new ASPx.GridViewNavigationHelper(this) : null; },
 CreateFilterHelper: function() { return new ASPx.GridViewFilterHelper(this); },
 CreateCallbackHelper: function() { return new GridViewCallbackHelper(this); },
 CreateToolbarHelper: function() { return new ASPx.GridViewToolbarHelper(this); },
 Invalidate: function() {
  this.GetColumnHelper().Invalidate();
  this.GetHeaderMatrix().Invalidate();
  ASPxClientGridBase.prototype.Invalidate.call(this);
 },
 ValidateColumnWidths: function() {
  var helper = this.GetResizingHelper();
  if(helper)
   helper.ValidateColumnWidths();
 },
 ResetStretchedColumnWidth: function() {
  var helper = this.GetResizingHelper();
  if(helper)
   helper.ResetStretchedColumnWidth();
 },
 SaveControlDimensions: function() {
  var helper = this.GetResizingHelper();
  if(helper)
   helper.SaveControlDimensions(true);
 },
 AdjustDropDownElements: function() {
  var vertScrollableControl = this.GetScrollHelper().GetVertScrollableControl();
  var scrollableRect = vertScrollableControl.getBoundingClientRect();
  ASPx.Data.ForEach(this.GetDropDownEditors(), function(dropDownEditor) {
   var editorRect = dropDownEditor.GetMainElement().getBoundingClientRect();
   var editorBottomIsVisible = editorRect.top + editorRect.height < scrollableRect.bottom
    && editorRect.top + editorRect.height > scrollableRect.top;
   if(dropDownEditor.GetPopupControl().IsVisible())
    if(editorBottomIsVisible)
     dropDownEditor.AdjustDropDownWindow();
    else
     dropDownEditor.HideDropDown();
  });
 },
 GetDropDownEditors: function() {
  if(this.ScrollableContainerDropDownEditors === null) {
   var dropDownEditorPopupElementPostfixRegex = /_DDD_PW-\d+$/g;
   var controlCollection = ASPx.GetControlCollection();
   var vertScrollableControl = this.GetScrollHelper().GetVertScrollableControl();
   var popupElements = ASPx.GetNodesByClassName(vertScrollableControl, "dxpc-ddSys")
    .filter(function(element) { return element.id.match(dropDownEditorPopupElementPostfixRegex); });
   var editorNames = popupElements.map(function(element) { return element.id.replace(dropDownEditorPopupElementPostfixRegex, ""); });
   this.ScrollableContainerDropDownEditors = editorNames.map(controlCollection.GetByName.aspxBind(controlCollection));
  }
  return this.ScrollableContainerDropDownEditors;
 },
 BrowserWindowResizeSubscriber: function() {
  return this.IsFixedLayoutWithUnsetWidth() || this.enableCustDialog || ASPxClientGridBase.prototype.BrowserWindowResizeSubscriber.call(this);
 }, 
 IsFixedLayoutWithUnsetWidth: function() {
  var mainElement = this.GetMainElement();
  var mainTable = this.GetMainTable();
  if(mainElement && mainTable) {
   var mainElementStyle = ASPx.GetCurrentStyle(mainElement);
   var mainTableStyle = ASPx.GetCurrentStyle(mainTable);
   return mainTableStyle.tableLayout === "fixed" && mainElementStyle.width === "";
  }
 }, 
 OnBrowserWindowResize: function(e) {
  this.EndBatchEdit(e);
  if(this.AllowResizing() && !this.HasScrolling())
   this.ValidateColumnWidths();
  var custDialogHelper = this.GetCustDialogHelper();
  if(custDialogHelper)
   custDialogHelper.OnBrowserWindowResize(e);
  var fixedGroupsHelper = this.GetFixedGroupsHelper();
  if(fixedGroupsHelper)
   fixedGroupsHelper.OnBrowserWindowResize(e);
  this.AdjustControl();
 },
 ShowCustomizationDialog: function() {
  var window = this.GetCustDialogWindow();
  if(window)
   window.Show();
 },
 EndBatchEdit: function(e){ 
  var batchEditHelper = this.GetBatchEditHelper();
  if(this.HasAdaptivity() && batchEditHelper && e.prevWndWidth != e.wndWidth)
   batchEditHelper.EndEdit();
 },
 GetAdaptivityHelper: function() {
  if(this.adaptivityMode === 0) return null;
  if(!this.adaptivityHelper)
   this.adaptivityHelper = this.CreateAdaptivityHelper();
  return this.adaptivityHelper;
 },
 HasAdaptivity: function() { return !!this.GetAdaptivityHelper(); },
 CreateAdaptivityHelper: function() {
  return new ASPx.GridViewColumnAdaptivityHelper(this);
 },
 SetAdaptiveMode: function(data) {
  this.adaptivityMode = data.adaptivityMode;
  var adaptivityHelper = this.GetAdaptivityHelper();
  if(adaptivityHelper)
   adaptivityHelper.ApplySettings(data);
 }, 
 CalculateAdaptivity: function(forceCalculate) {
  var adaptivityHelper = this.GetAdaptivityHelper();
  if(adaptivityHelper)
   adaptivityHelper.CalculateAdaptivity(forceCalculate);
 },
 ResetAdaptivityOnCallback: function(){
  var adaptivityHelper = this.GetAdaptivityHelper();
  if(adaptivityHelper)
   adaptivityHelper.ResetAdaptivityOnCallback();
 },
 RestoreAdaptivityState: function() {
  var adaptivityHelper = this.GetAdaptivityHelper();
  if(adaptivityHelper)
   adaptivityHelper.RestoreAdaptivityState();
 },
 ToggleAdaptiveDetails: function(visibleIndex) {
  var adaptivityHelper = this.GetAdaptivityHelper();
  if(adaptivityHelper) {
   adaptivityHelper.ToggleAdaptiveDetails(visibleIndex);
   this.InvalidateLayout();
  }
 },
 UA_ShowAdaptiveDetail: function(visibleIndex) {
  this.ToggleAdaptiveDetails(visibleIndex);
 },
 UA_HideAdaptiveDetail: function(visibleIndex) {
  this.ToggleAdaptiveDetails(visibleIndex);
 },
 UA_ApplyMultiColumnAutoFilter: function() {
  this.ApplyOnClickRowFilter();
 },
 UA_CustDialogApply: function() {
  var helper = this.GetCustDialogHelper();
  if(helper)
   helper.ApplyChanges();
 },
 UA_CustDialogClose: function() {
  var helper = this.GetCustDialogHelper();
  if(helper)
   helper.CancelChanges();
 },
 IsLastDataRow: function(visibleIndex) {
  return visibleIndex == this.visibleStartIndex + this.pageRowCount - 1 && (this.IsLastPage() || this.pageIndex < 0);
 },
 UpdateFirstAndLastVisibleRowMarkers: function() {
  if(this.HasBandedDataRows())
   return;
  if(!this.GetHeaderRow(0))
   this.UpdateExtemeVisibleRowMarker(true);
  this.UpdateExtemeVisibleRowMarker(false);
 },
 UpdateExtemeVisibleRowMarker: function(isFirstVisibleRow) {
  var tBody = ASPx.GetNodeByTagName(this.GetMainTable(), "TBODY", 0);
  var markerClassName = isFirstVisibleRow ? GridViewConsts.FirstVisibleRowClassName : GridViewConsts.LastVisibleRowClassName;
  var prevMarkedRows = ASPx.GetChildNodesByClassName(tBody, markerClassName);
  for(var i = 0; i < prevMarkedRows.length; i++) {
   ASPx.RemoveClassNameFromElement(prevMarkedRows[i], markerClassName);
  }
  var exteremeRow = this.FindExtemeVisibleRow(isFirstVisibleRow);
  if(exteremeRow)
   ASPx.AddClassNameToElement(exteremeRow, markerClassName);
  if(!isFirstVisibleRow) {
   this.MarkPageBottomVisibleCells();
  }
 },
 MarkPageBottomVisibleCells: function() {
  var rows = this.GetMainTable().rows;
  var rowCount = rows.length;
  var lvrIndex = -1;
  for(var i = rowCount - 1; i >= 0; i--) {
   var row = rows[i];
   if(this.IsVisibleRow(row)) {
    lvrIndex = i;
    break;
   }
  }
  if(lvrIndex > 0) {
   var markBottomCell = function(c) { ASPx.AddClassNameToElement(c, GridViewConsts.PageBottomVisibleCellsMarkerClassName); };
   var getFilterMerged = function(index) {
    return function(c) { return c.rowSpan > 1 && c.rowSpan - 1 + index === lvrIndex; };
   };
   for(var i = lvrIndex; i >= 0; i--) {
    var row = rows[i];
    if(this.IsVisibleRow(row)) {
     var cells = [].slice.call(row.cells);
     var filterMerged = getFilterMerged(i);
     var mergedBottomCells = cells.filter(filterMerged);
     mergedBottomCells.forEach(markBottomCell);
    }
   }
  }
 },
 FindExtemeVisibleRow: function(isFirstVisibleRow) {
  var rows = this.GetMainTable().rows;
  var rowCount = rows.length;
  for(var i = 0; i < rowCount; i++) {
   var row = isFirstVisibleRow ? rows[i] : rows[rowCount - 1 - i];
   if(this.IsVisibleRow(row))
    return row;
  }
  return this.GetEmptyDataItem();
 },
 IsVisibleRow: function(row) {
  var isDataRow = this.GetItemVisibleIndexRegExp(false).test(row.id);
  var isEditingRow = row.id && row.id.indexOf(this.EditingRowID) > -1;
  return ASPx.ElementContainsCssClass(row, this.EmptyPagerRowCssClass) || ((isDataRow || isEditingRow) && ASPx.GetElementDisplay(row));
 },
 OnCallbackFinalized: function() {
  this.ResetAdaptivityOnCallback();
  ASPxClientGridBase.prototype.OnCallbackFinalized.call(this);
  this.AdjustPagerControls();
  this.CalculateAdaptivity();
  this.RestoreAdaptivityState();
 },
 SetWidth: function(width) {
  if(this.IsControlCollapsed())
   this.ExpandControl();
  var mainElemnt = this.GetMainElement();
  if(!ASPx.IsExistsElement(mainElemnt) || mainElemnt.offsetWidth === width) return;
  var scrollHelper = this.GetScrollHelper();
  if(scrollHelper)
   scrollHelper.OnSetWidth(width);
  this.ResetControlAdjustment();
  ASPxClientControl.prototype.SetWidth.call(this, width);
 },
 NeedCollapseControlCore: function() {
  var adaptivityHelper = this.GetAdaptivityHelper();
  return adaptivityHelper && adaptivityHelper.IsResponsiveMode() || ASPxClientGridBase.prototype.NeedCollapseControlCore.call(this);
 },
 SortBy: function(column, sortOrder, reset, sortIndex){
    ASPxClientGridBase.prototype.SortBy.call(this, column, sortOrder, reset, sortIndex);
 },
 MoveColumn: function(column, columnMoveTo, moveBefore, moveToGroup, moveFromGroup){
  ASPxClientGridBase.prototype.MoveColumn.call(this, column, columnMoveTo, moveBefore, moveToGroup, moveFromGroup);
 },
 MoveColumnCore: function(sourceIndex, targetIndex, direction, moveToGroup, moveFromGroup) {
  var helper = this.GetColumnMovingHelper();
  var requireCallback = !helper || !helper.MoveColumn(sourceIndex, targetIndex, direction, moveToGroup, moveFromGroup);
  this.Invalidate();
  if(requireCallback)
   ASPxClientGridBase.prototype.MoveColumnCore.call(this, sourceIndex, targetIndex, direction, moveToGroup, moveFromGroup);
  else {
   var adaptivityHelper = this.GetAdaptivityHelper();
   if(adaptivityHelper) {
    adaptivityHelper.ResetAdaptivity();
    this.RemoveAdaptiveHeaders();
    adaptivityHelper.CalculateAdaptivity(true);
   }
   var fixedHelper = this.GetFixedColumnsHelper();
   if(fixedHelper)
    fixedHelper.OnColumnClientMove();
   this.SaveClientColumnStateToCookies();
   this.stateObject.columnMoveState = helper.GetColumnMoveState();
  }
 },
 GetColumnLayout: function() {
  var helper = this.GetColumnMovingHelper();
  return helper ? helper.GetColumnLayout() : null;
 },
 SetColumnLayout: function(layout) {
  var helper = this.GetColumnMovingHelper();
  if(helper)
   helper.SetColumnLayout(layout);
 },
 SaveClientColumnStateToCookies: function() {
  if(!this.cookieName) return;
  var cookieValue = ASPx.Cookie.GetCookie(this.cookieName);
  if(!cookieValue) return;
  var prevClientStateIndex = cookieValue.indexOf("|clientvis");
  if(prevClientStateIndex > -1)
   cookieValue = cookieValue.substr(0, prevClientStateIndex);
  var columnHelper = this.GetColumnHelper();
  var visibleState = columnHelper.SerializeColumnVisibleState();
  var hierarchyState = columnHelper.SerializeColumnHierarchyState();
  cookieValue += "|" + hierarchyState + "|" + visibleState;
  ASPx.Cookie.SetCookie(this.cookieName, cookieValue);
 },
 GroupBy: function(column, groupIndex, sortOrder){
  if(this.RaiseColumnGrouping(this._getColumnObjectByArg(column))) return;
  column = this._getColumnIndexByColumnArgs(column);
  if(!ASPx.IsExists(groupIndex)) groupIndex = "";
  if(!ASPx.IsExists(sortOrder)) sortOrder = "ASC";
  this.gridCallBack([ASPxClientGridViewCallbackCommand.Group, column, groupIndex, sortOrder]);
 },
 UnGroup: function(column){
  this.Ungroup(column);
 },
 Ungroup: function(column){
  column = this._getColumnIndexByColumnArgs(column);
  this.GroupBy(column, -1);
 },
 ExpandAll: function(){
  this.gridCallBack([ASPxClientGridViewCallbackCommand.ExpandAll]);
 },
 CollapseAll: function(){
  this.gridCallBack([ASPxClientGridViewCallbackCommand.CollapseAll]);
 },
 ExpandAllDetailRows: function(){
  this.gridCallBack([ASPxClientGridViewCallbackCommand.ShowAllDetail]);
 },
 CollapseAllDetailRows: function(){
  this.gridCallBack([ASPxClientGridViewCallbackCommand.HideAllDetail]);
 },
 ExpandRow: function(visibleIndex, recursive){
  if(this.RaiseRowExpanding(visibleIndex)) return;
  recursive = !!recursive;
  this.gridCallBack([ASPxClientGridViewCallbackCommand.ExpandRow, visibleIndex, recursive]);
 },
 CollapseRow: function(visibleIndex, recursive){
  if(this.RaiseRowCollapsing(visibleIndex)) return;
  recursive = !!recursive;
  this.gridCallBack([ASPxClientGridViewCallbackCommand.CollapseRow, visibleIndex, recursive]);
 },
 MakeRowVisible: function(visibleIndex) {
  if(!this.HasVertScroll()) return;
  var row = this.GetItem(visibleIndex);
  if(row == null && visibleIndex >= this.visibleStartIndex && visibleIndex < this.visibleStartIndex + this.pageRowCount) 
   row = this.GetEditingRow();
  if(row == null) return;
  this.GetScrollHelper().MakeRowVisible(row);
 },
 ExpandDetailRow: function(visibleIndex){
  var key = this.GetRowKey(visibleIndex);
  if(key == null) return;
  if(this.RaiseDetailRowExpanding(visibleIndex)) return;
  this.gridCallBack([ASPxClientGridViewCallbackCommand.ShowDetailRow, key]);
 },
 CollapseDetailRow: function(visibleIndex){
  var key = this.GetRowKey(visibleIndex);
  if(key == null) return;
  if(this.RaiseDetailRowCollapsing(visibleIndex)) return;
  this.gridCallBack([ASPxClientGridViewCallbackCommand.HideDetailRow, key]);
 },
 GetRowKey: function(visibleIndex) {
  return this.GetItemKey(visibleIndex);
 },
 StartEditRow: function(visibleIndex) {
    this.StartEditItem(visibleIndex);
 },
 StartEditRowByKey: function(key) {
  this.StartEditItemByKey(key);
 },
 IsNewRowEditing: function() {
  return this.IsNewItemEditing();
 },
 AddNewRow: function(){
    this.AddNewItem();
 },
 DeleteRow: function(visibleIndex){
  this.DeleteItem(visibleIndex);
 },
 DeleteRowByKey: function(key) {
  this.DeleteItemByKey(key);
 },
 GetFocusedRowIndex: function() {
  return this._getFocusedItemIndex();
 },
 SetFocusedRowIndex: function(visibleIndex) {
  return this._setFocusedItemIndex(visibleIndex);
 },
 SelectRows: function(visibleIndices, selected){
  this.SelectItemsCore(visibleIndices, selected, false);
 },
 SelectRowsByKey: function(keys, selected){
  this.SelectItemsByKey(keys, selected);
 },
 UnselectRowsByKey: function(keys){
  this.SelectRowsByKey(keys, false);
 },
 UnselectRows: function(visibleIndices){
  this.SelectRows(visibleIndices, false);
 },
 UnselectFilteredRows: function() {
  this.UnselectFilteredItemsCore();
 },
 SelectRowOnPage: function(visibleIndex, selected){
  if(!ASPx.IsExists(selected)) selected = true;
  this.SelectItem(visibleIndex, selected);
 },
 UnselectRowOnPage: function(visibleIndex){
  this.SelectRowOnPage(visibleIndex, false);
 },
 SelectAllRowsOnPage: function(selected){
  this.SelectAllItemsOnPage(selected);
 },
 UnselectAllRowsOnPage: function(){
  this.UnselectAllItemsOnPage();
 },
 GetSelectedRowCount: function() {
  return this._getSelectedRowCount();
 },
 IsRowSelectedOnPage: function(visibleIndex) {
  return this._isRowSelected(visibleIndex);
 },
 IsGroupRow: function(visibleIndex) {
  return this.GetGroupRow(visibleIndex) != null;
 },
 IsDataRow: function(visibleIndex) {
  return this.GetDataRow(visibleIndex) != null || this.HasBandedDataRows() && this.GetBandedDataRows(visibleIndex).length > 0;
 },
 IsGroupRowExpanded: function(visibleIndex) { 
  return this.GetExpandedGroupRow(visibleIndex) != null;
 },
 GetVertScrollPos: function() {
  return this.GetVerticalScrollPosition();
 },
 GetVerticalScrollPosition: function() {
  if(this.IsVirtualScrolling())
   return 0;
  var scrollHelper = this.GetScrollHelper();
  if(scrollHelper)
   return scrollHelper.GetVertScrollPosition();
  return 0;
 },
 GetHorzScrollPos: function() {
  return this.GetHorizontalScrollPosition();
 },
 GetHorizontalScrollPosition: function() {
  var scrollHelper = this.GetScrollHelper();
  if(scrollHelper)
   return scrollHelper.GetHorzScrollPosition();
  return 0;
 },
 SetVertScrollPos: function(value) {
  this.SetVerticalScrollPosition(value);
 },
 SetVerticalScrollPosition: function(value) {
  if(this.IsVirtualScrolling())
   return;
  var scrollHelper = this.GetScrollHelper();
  if(scrollHelper)
   scrollHelper.SetVertScrollPosition(value);
 },
 SetHorzScrollPos: function(value) {
  this.SetHorizontalScrollPosition(value);
 },
 SetHorizontalScrollPosition: function(value) {
  var scrollHelper = this.GetScrollHelper();
  if(scrollHelper)
   scrollHelper.SetHorzScrollPosition(value);
 },
 SetFixedColumnScrollableRows: function(scrollableRowSettings) {
  var helper = this.GetFixedColumnsHelper();
  if(helper)
   helper.SetFixedColumnScrollableRows(scrollableRowSettings);
 },
 ExportTo: function(format) {
  ASPxClientGridBase.prototype.ExportTo.call(this, format);
 },
 RaiseColumnGrouping: function(column) {
  if(!this.ColumnGrouping.IsEmpty()){
   var args = new ASPxClientGridViewColumnCancelEventArgs(column);
   this.ColumnGrouping.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseItemClick: function(visibleIndex, htmlEvent) {
  if(!this.RowClick.IsEmpty()){
   var args = new ASPxClientGridViewRowClickEventArgs(visibleIndex, htmlEvent);
   this.RowClick.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseItemDblClick: function(visibleIndex, htmlEvent) {
  if(!this.RowDblClick.IsEmpty()){
   ASPx.Selection.Clear(); 
   var args = new ASPxClientGridViewRowClickEventArgs(visibleIndex, htmlEvent);
   this.RowDblClick.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseContextMenu: function(objectType, index, htmlEvent, menu, showBrowserMenu) {
  var args = new ASPxClientGridViewContextMenuEventArgs(objectType, index, htmlEvent, menu, showBrowserMenu);
  if(!this.ContextMenu.IsEmpty())
   this.ContextMenu.FireEvent(this, args);
  return !!args.showBrowserMenu;
 },
 RaiseFocusedItemChanged: function(isChangedOnServer) {
  if(!this.FocusedRowChanged.IsEmpty()){
   var args = new ASPxClientGridViewFocusEventArgs(isChangedOnServer);
   this.FocusedRowChanged.FireEvent(this, args);
   if(args.processOnServer)
    this.gridCallBack([ASPxClientGridViewCallbackCommand.FocusedRow]);
  }
  return false; 
 },
 RaiseItemFocusing: function(visibleIndex, htmlEvent) { 
  if(!this.RowFocusing.IsEmpty()){
   var args = new ASPxClientGridViewRowFocusingEventArgs(visibleIndex, htmlEvent);
   this.RowFocusing.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseColumnStartDragging: function(column) {
  if(!this.ColumnStartDragging.IsEmpty()){
   var args = new ASPxClientGridViewColumnCancelEventArgs(column);
   this.ColumnStartDragging.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseColumnResizing: function(column) {
  if(!this.ColumnResizing.IsEmpty()){
   var args = new ASPxClientGridViewColumnCancelEventArgs(column);
   this.ColumnResizing.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseColumnResized: function(column) {
  if(!this.ColumnResized.IsEmpty()){
   var args = new ASPxClientGridViewColumnProcessingModeEventArgs(column);
   this.ColumnResized.FireEvent(this, args);
   if(args.processOnServer)
    this.Refresh();
  }
 },
 RaiseRowExpanding: function(visibleIndex) {
  if(!this.RowExpanding.IsEmpty()){
   var args = new ASPxClientGridViewRowCancelEventArgs(visibleIndex);
   this.RowExpanding.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseRowCollapsing: function(visibleIndex) {
  if(!this.RowCollapsing.IsEmpty()){
   var args = new ASPxClientGridViewRowCancelEventArgs(visibleIndex);
   this.RowCollapsing.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseDetailRowExpanding: function(visibleIndex) {
  if(!this.DetailRowExpanding.IsEmpty()){
   var args = new ASPxClientGridViewRowCancelEventArgs(visibleIndex);
   this.DetailRowExpanding.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseDetailRowCollapsing: function(visibleIndex) {
  if(!this.DetailRowCollapsing.IsEmpty()){
   var args = new ASPxClientGridViewRowCancelEventArgs(visibleIndex);
   this.DetailRowCollapsing.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseBatchEditConfirmShowing: function(requestTriggerID) {
  if(!this.BatchEditConfirmShowing.IsEmpty()) {
   var args = new ASPxClientGridViewBatchEditConfirmShowingEventArgs(requestTriggerID);
   this.BatchEditConfirmShowing.FireEvent(this, args);
   return args.cancel;
  }
  return false;
 },
 RaiseBatchEditStartEditing: function(visibleIndex, column, rowValues) {
  var args = new ASPxClientGridViewBatchEditStartEditingEventArgs(visibleIndex, column, rowValues);
  if(!this.BatchEditStartEditing.IsEmpty())
   this.BatchEditStartEditing.FireEvent(this, args);
  return args;
 },
 RaiseBatchEditEndEditing: function(visibleIndex, rowValues) {
  var args = new ASPxClientGridViewBatchEditEndEditingEventArgs(visibleIndex, rowValues);
  if(!this.BatchEditEndEditing.IsEmpty())
   this.BatchEditEndEditing.FireEvent(this, args);
  return args;
 },
 RaiseBatchEditItemValidating: function(visibleIndex, validationInfo) {
  var args = new ASPxClientGridViewBatchEditRowValidatingEventArgs(visibleIndex, validationInfo);
  if(!this.BatchEditRowValidating.IsEmpty())
   this.BatchEditRowValidating.FireEvent(this, args);
  return args.validationInfo;
 },
 RaiseBatchEditTemplateCellFocused: function(columnIndex) {
  var column = this._getColumn(columnIndex);
  if(!column) return false;
  var args = new ASPxClientGridViewBatchEditTemplateCellFocusedEventArgs(column);
  if(!this.BatchEditTemplateCellFocused.IsEmpty())
   this.BatchEditTemplateCellFocused.FireEvent(this, args);
  return args.handled;
 },
 RaiseBatchEditChangesSaving: function(valuesInfo) { 
  if(!this.BatchEditChangesSaving.IsEmpty()){
   var args = new ASPxClientGridViewBatchEditChangesSavingEventArgs(valuesInfo.insertedValues, valuesInfo.deletedValues, valuesInfo.updatedValues);
   this.BatchEditChangesSaving.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseBatchEditChangesCanceling: function(valuesInfo) { 
  if(!this.BatchEditChangesCanceling.IsEmpty()){
   var args = new ASPxClientGridViewBatchEditChangesCancelingEventArgs(valuesInfo.insertedValues, valuesInfo.deletedValues, valuesInfo.updatedValues);
   this.BatchEditChangesCanceling.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseBatchEditItemInserting: function(visibleIndex) { 
  if(!this.BatchEditRowInserting.IsEmpty()){
   var args = new ASPxClientGridViewBatchEditRowInsertingEventArgs(visibleIndex);
   this.BatchEditRowInserting.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseBatchEditItemDeleting: function(visibleIndex, itemValues) { 
  if(!this.BatchEditRowDeleting.IsEmpty()){
   var args = new ASPxClientGridViewBatchEditRowDeletingEventArgs(visibleIndex, itemValues);
   this.BatchEditRowDeleting.FireEvent(this, args);
   return args.cancel;
  }
  return false; 
 },
 RaiseContextMenuItemClick: function(e, itemInfo) {
  if(this.ContextMenuItemClick.IsEmpty())
   return false;
  var args = new ASPxClientGridViewContextMenuItemClickEventArgs(e.item, itemInfo.objectType, itemInfo.index);
  this.ContextMenuItemClick.FireEvent(this, args);
  if(!args.handled && args.processOnServer) {
   this.GetContextMenuHelper().ProcessCustomContextMenuItemClick(e.item, args.usePostBack);
   return true;
  }
  return args.handled;
 },
 RaiseColumnMoving: function(targets) {
  if(this.ColumnMoving.IsEmpty()) return;
  var srcColumn = this.getColumnObject(targets.obj.id);
  var destColumn = this.getColumnObject(targets.targetElement.id);
  var isLeft = targets.isLeftPartOfElement();
  var isGroupPanel = targets.targetElement == targets.control.GetGroupPanel();
  var args = new ASPxClientGridViewColumnMovingEventArgs(srcColumn, destColumn, isLeft, isGroupPanel);
  this.ColumnMoving.FireEvent(this, args);
  if(!args.allow)
   targets.targetElement = null;
 },
 CreateCommandCustomButtonEventArgs: function(index, id){
  return new ASPxClientGridViewCustomButtonEventArgs(index, id);
 },
 CreateSelectionEventArgs: function(visibleIndex, isSelected, isAllRecordsOnPage, isChangedOnServer){
  return new ASPxClientGridViewSelectionEventArgs(visibleIndex, isSelected, isAllRecordsOnPage, isChangedOnServer);
 },
 CreateColumnCancelEventArgs: function(column){
  return new ASPxClientGridViewColumnCancelEventArgs(column);
 },
 CreateColumnMovingEventArgs: function(sourceColumn, destinationColumn, isDropBefore, isGroupPanel){
  return new ASPxClientGridViewColumnMovingEventArgs(sourceColumn, destinationColumn, isDropBefore, isGroupPanel);
 },
 CreateCellInfo: function(visibleIndex, column) { return new ASPxClientGridViewCellInfo(visibleIndex, column); },
 CreateFocusedCellChangingArgs: function(cellInfo) { return new ASPxClientGridViewFocusedCellChangingEventArgs(cellInfo); },
 GetRowValues: function(visibleIndex, fieldNames, onCallBack) {
  this.GetItemValues(visibleIndex, fieldNames, onCallBack);
 },
 GetPageRowValues: function(fieldNames, onCallBack) {
  this.GetPageItemValues(fieldNames, onCallBack);
 },
 GetVisibleRowsOnPage: function() {
  return this.GetVisibleItemsOnPage();
 },
 GetRowIndicesVisibleInViewPort: function(includePartiallyVisible) {
  var mainTable = this.GetMainTable();
  var treeLine = ASPx.GetElementTreeLine(mainTable).filter(function(element) {
   var style = ASPx.GetCurrentStyle(element);
   return style.overflow !== "visible" || style.overflowY !== "visible";
  });
  treeLine.push(mainTable);
  treeLine.push(document.body);
  var treeLineDimensions = treeLine.map(function(element) { 
   var y = ASPx.GetAbsoluteY(element);
   var height = element.tagName === "BODY" ? ASPx.GetDocumentClientHeight() : element.offsetHeight;
   return { element: element, top: y, bottom: y + height - 1 };
  });
  var mainTableViewPortTop = ASPx.Data.Max(treeLineDimensions, function(info) { return info.top; });
  var mainTableViewPortBottom = ASPx.Data.Min(treeLineDimensions, function(info) { return info.bottom; });
  var dataRowVisibleIndices = this.GetLayoutHelper().GetDataItemVisibleIndices();
  var groupRowVisibleIndices = ASPx.Data.Range(this.GetVisibleRowsOnPage(), this.GetTopVisibleIndex()).filter(function(i) { return this.IsGroupRow(i); }.bind(this));
  var dataRows = dataRowVisibleIndices.map(function(i) {   return { visibleIndex: i, row: this.GetDataRow(i) }; }.bind(this));
  var groupRows = groupRowVisibleIndices.map(function(i) { return { visibleIndex: i, row: this.GetGroupRow(i) }; }.bind(this));
  var result = dataRows.concat(groupRows).filter(function(rowInfo) {
   var rowTop = ASPx.GetAbsoluteY(rowInfo.row);
   var rowBottom = rowTop + rowInfo.row.offsetHeight - 1;
   if(includePartiallyVisible)
    return rowTop <= mainTableViewPortBottom && rowBottom >= mainTableViewPortTop;
   return rowTop >= mainTableViewPortTop && rowBottom <= mainTableViewPortBottom;
  }).map(function(rowInfo) { return rowInfo.visibleIndex; });
  ASPx.Data.ArrayIntegerSort(result);
  return result;
 },
 ApplyOnClickRowFilter: function() {
  this.GetFilterHelper().ApplyMultiColumnAutoFilter();
 }
});
ASPxClientGridView.Cast = ASPxClientControl.Cast;
var ASPxClientGridViewColumn = ASPx.CreateClass(ASPxClientGridColumnBase, {
 constructor: function(prop){
  this.constructor.prototype.constructor.call(this, prop);
  this.visibleIndex =    ASPx.IsExists(prop[8])  ? prop[8]  : -1;
  this.groupIndex =      ASPx.IsExists(prop[9])  ? prop[9]  : -1;
  this.columnType =      ASPx.IsExists(prop[10]) ? prop[10] : 0;
  this.filterRowTypeKind =  ASPx.IsExists(prop[11]) ? prop[11] : "";
  this.isFixed =      ASPx.IsExists(prop[12]) ?  !!prop[12] : false;
  this.allowGroup =      ASPx.IsExists(prop[13]) ?  !!prop[13] : true;
  this.allowDrag =    ASPx.IsExists(prop[14]) ?  !!prop[14] : true;
  this.parentIndex =     ASPx.IsExists(prop[15]) ? prop[15] : -1;
  this.inCustWindow =    ASPx.IsExists(prop[16]) ?  !!prop[16] : false;
  this.minWidth =     ASPx.IsExists(prop[17]) ? prop[17] : 0;
  this.rowSpan =      ASPx.IsExists(prop[18]) ? prop[18] : 1;
  this.showFilterMenuLikeItem =   ASPx.IsExists(prop[19]) ?  !!prop[19] : false;
  this.collectionIndex  =   ASPx.IsExists(prop[20]) ? prop[20] : -1;
  this.showInCustomizationForm =  ASPx.IsExists(prop[21]) ?  !!prop[21] : true;
  this.isCommandColumn = this.columnType === 1;
  this.isBand = this.columnType === 2;
 }
});
var ASPxClientGridViewColumnCancelEventArgs = ASPx.CreateClass(ASPxClientCancelEventArgs, {
 constructor: function(column){
  this.constructor.prototype.constructor.call(this);
  this.column = column;
 }
});
var ASPxClientGridViewColumnProcessingModeEventArgs = ASPx.CreateClass(ASPxClientProcessingModeEventArgs, {
 constructor: function(column){
  this.constructor.prototype.constructor.call(this, false);
  this.column = column;
 }
});
var ASPxClientGridViewRowCancelEventArgs = ASPx.CreateClass(ASPxClientCancelEventArgs, {
 constructor: function(visibleIndex){
  this.constructor.prototype.constructor.call(this);
  this.visibleIndex = visibleIndex;
 }
});
var ASPxClientGridViewSelectionEventArgs = ASPx.CreateClass(ASPxClientProcessingModeEventArgs, {
 constructor: function(visibleIndex, isSelected, isAllRecordsOnPage, isChangedOnServer){
  this.constructor.prototype.constructor.call(this, false);
  this.visibleIndex = visibleIndex;
  this.isSelected = isSelected;
  this.isAllRecordsOnPage = isAllRecordsOnPage;
  this.isChangedOnServer = !!isChangedOnServer;
 }
});
var ASPxClientGridViewFocusEventArgs = ASPx.CreateClass(ASPxClientProcessingModeEventArgs, {
 constructor: function(isChangedOnServer){
  this.constructor.prototype.constructor.call(this, false);
  this.isChangedOnServer = !!isChangedOnServer;
 }
});
var ASPxClientGridViewRowFocusingEventArgs = ASPx.CreateClass(ASPxClientGridViewRowCancelEventArgs, {
 constructor: function(visibleIndex, htmlEvent){
  this.constructor.prototype.constructor.call(this, visibleIndex);
  this.htmlEvent = htmlEvent;
 }
});
var ASPxClientGridViewRowClickEventArgs = ASPx.CreateClass(ASPxClientGridViewRowCancelEventArgs, {
 constructor: function(visibleIndex, htmlEvent){
  this.constructor.prototype.constructor.call(this, visibleIndex);
  this.htmlEvent = htmlEvent;
 }
});
var ASPxClientGridViewContextMenuEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(objectType, index, htmlEvent, menu, showBrowserMenu) {
  this.constructor.prototype.constructor.call(this);
  this.objectType = objectType;
  this.index = index;
  this.htmlEvent = htmlEvent;
  this.menu = menu;
  this.showBrowserMenu = showBrowserMenu;
 }
});
var ASPxClientGridViewContextMenuItemClickEventArgs = ASPx.CreateClass(ASPxClientProcessingModeEventArgs, {
 constructor: function(item, objectType, elementIndex, processOnServer){
  this.constructor.prototype.constructor.call(this, processOnServer);
  this.item = item;
  this.objectType = objectType;
  this.elementIndex = elementIndex;
  this.usePostBack = false;
  this.handled = false;
 }
});
var ASPxClientGridViewCustomButtonEventArgs = ASPx.CreateClass(ASPxClientProcessingModeEventArgs, {
 constructor: function(visibleIndex, buttonID) {
  this.constructor.prototype.constructor.call(this, false);
  this.visibleIndex = visibleIndex;
  this.buttonID = buttonID;
 } 
});
var ASPxClientGridViewColumnMovingEventArgs = ASPx.CreateClass(ASPxClientEventArgs, {
 constructor: function(sourceColumn, destinationColumn, isDropBefore, isGroupPanel) {
  this.constructor.prototype.constructor.call(this);
  this.allow = true;
  this.sourceColumn = sourceColumn;
  this.destinationColumn = destinationColumn;
  this.isDropBefore = isDropBefore;
  this.isGroupPanel = isGroupPanel;
 }
});
var ASPxClientGridViewBatchEditConfirmShowingEventArgs = ASPx.CreateClass(ASPxClientGridBatchEditConfirmShowingEventArgs, {
 constructor: function(requestTriggerID) {
  this.constructor.prototype.constructor.call(this, requestTriggerID);
 }
});
var ASPxClientGridViewBatchEditStartEditingEventArgs = ASPx.CreateClass(ASPxClientGridBatchEditStartEditingEventArgs, {
 constructor: function(visibleIndex, focusedColumn, itemValues) {
  this.constructor.prototype.constructor.call(this, visibleIndex, focusedColumn, itemValues);
  this.rowValues = this.itemValues;
 }
});
var ASPxClientGridViewBatchEditEndEditingEventArgs = ASPx.CreateClass(ASPxClientGridBatchEditEndEditingEventArgs, {
 constructor: function(visibleIndex, itemValues) {
  this.constructor.prototype.constructor.call(this, visibleIndex, itemValues);
  this.rowValues = this.itemValues;
 }
});
var ASPxClientGridViewBatchEditRowValidatingEventArgs = ASPx.CreateClass(ASPxClientGridBatchEditItemValidatingEventArgs, {
 constructor: function(visibleIndex, validationInfo) {
  this.constructor.prototype.constructor.call(this, visibleIndex, validationInfo);
 }
});
var ASPxClientGridViewBatchEditTemplateCellFocusedEventArgs = ASPx.CreateClass(ASPxClientGridBatchEditTemplateCellFocusedEventArgs, {
 constructor: function(column) {
  this.constructor.prototype.constructor.call(this, column);
 }
});
var ASPxClientGridViewBatchEditChangesSavingEventArgs = ASPx.CreateClass(ASPxClientGridBatchEditClientChangesEventArgs, {
 constructor: function(insertedValues, deletedValues, updatedValues) {
  this.constructor.prototype.constructor.call(this, insertedValues, deletedValues, updatedValues);
 }
});
var ASPxClientGridViewBatchEditChangesCancelingEventArgs = ASPx.CreateClass(ASPxClientGridBatchEditClientChangesEventArgs, {
 constructor: function(insertedValues, deletedValues, updatedValues) {
  this.constructor.prototype.constructor.call(this, insertedValues, deletedValues, updatedValues);
 }
});
var ASPxClientGridViewBatchEditRowInsertingEventArgs = ASPx.CreateClass(ASPxClientGridBatchEditItemInsertingEventArgs, {
 constructor: function(visibleIndex) {
  this.constructor.prototype.constructor.call(this, visibleIndex);
 }
});
var ASPxClientGridViewBatchEditRowDeletingEventArgs = ASPx.CreateClass(ASPxClientGridBatchEditItemDeletingEventArgs, {
 constructor: function(visibleIndex, itemValues) {
  this.constructor.prototype.constructor.call(this, visibleIndex, itemValues);  
  this.rowValues = this.itemValues;  
 }
});
var ASPxClientGridViewFocusedCellChangingEventArgs = ASPx.CreateClass(ASPxClientGridFocusedCellChangingEventArgs, {
 constructor: function(cellInfo) {
  this.constructor.prototype.constructor.call(this, cellInfo);
 }
});
var ASPxClientGridViewCellInfo = ASPx.CreateClass(ASPxClientGridCellInfo, {
 constructor: function(visibleIndex, column) {
  this.constructor.prototype.constructor.call(this, visibleIndex, column);
  this.rowVisibleIndex = this.itemVisibleIndex;
 }
});
ASPx.GVContextMenu = function(name, e) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) {
  var showDefaultMenu = gv.GetContextMenuHelper().OnContextMenuClick(e);
  return showDefaultMenu;
  }
 return true;
};
ASPx.GVContextMenuItemClick = function(name, e) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null)
  gv.GetContextMenuHelper().OnContextMenuItemClick(e);
};
ASPx.GVExpandRow = function(name, visibleIndex, event) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) {
  if(gv.useEndlessPaging && event)
   visibleIndex = gv.FindParentRowVisibleIndex(ASPx.Evt.GetEventSource(event), true);
  gv.ExpandRow(visibleIndex);
 }
};
ASPx.GVCollapseRow = function(name, visibleIndex, event) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) {
  if(gv.useEndlessPaging && event)
   visibleIndex = gv.FindParentRowVisibleIndex(ASPx.Evt.GetEventSource(event), true);
  gv.CollapseRow(visibleIndex);
 }
};
ASPx.GVShowDetailRow = function(name, visibleIndex, event) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) {
  if(gv.useEndlessPaging && event)
   visibleIndex = gv.FindParentRowVisibleIndex(ASPx.Evt.GetEventSource(event), true);
  gv.ExpandDetailRow(visibleIndex);
 }
};
ASPx.GVHideDetailRow = function(name, visibleIndex, event) {
 var gv = ASPx.GetControlCollection().Get(name);
 if(gv != null) {
  if(gv.useEndlessPaging && event)
   visibleIndex = gv.FindParentRowVisibleIndex(ASPx.Evt.GetEventSource(event), true);
  gv.CollapseDetailRow(visibleIndex);
 }
};
ASPx.Evt.AttachEventToElement(window, "scroll", function(evt) {
 ASPx.GetControlCollection().ForEachControl(function(control){
  if(control instanceof ASPxClientGridView && ASPx.IsExists(control.GetMainElement()))
   control.OnScroll(evt);
 });
});
var GridViewCallbackHelper = ASPx.CreateClass(ASPx.GridCallbackHelper, {
 constructor: function(grid) {
  this.constructor.prototype.constructor.call(this, grid);
 },
 GetResizingState: function() { return this.grid.stateObject.resizingState; },
 GetContextMenuState: function() { return this.grid.GetContextMenuHelper().GetCallbackState(); },
 GetGridCallbackState: function() {
  var state = ASPx.GridCallbackHelper.prototype.GetGridCallbackState.call(this);
  return state.concat([
   [ "CR", this.GetResizingState() ],
   [ "CM", this.GetContextMenuState() ]
  ]);
 }
});
var GridViewKbdHelper = ASPx.CreateClass(ASPx.KbdHelper, {
  CanFocus: function(e) {
  var grid = this.control;
  if(grid.IsDetailGridFocused(e))
   return false;
  var batchEditHelper = grid.GetBatchEditHelper();
  if(batchEditHelper && batchEditHelper.CanStartEditOnTableClick(e))
   return false;
  var filterControlPopup = grid.GetFilterControlPopup();
  if(filterControlPopup && filterControlPopup.IsVisible())
   return false;
  return ASPx.KbdHelper.prototype.CanFocus(e);
 },
 HandleKeyDown: function(e) {
  this.moveIterationCount = 0;
  var grid = this.control;
  var index = grid.GetFocusedRowIndex();
  var busy = grid.keyboardLock;
  var key = ASPx.Evt.GetKeyCode(e);
  if(grid.rtl) {
   if(key == ASPx.Key.Left)
    key = ASPx.Key.Right;
   else if(key == ASPx.Key.Right)
    key = ASPx.Key.Left;
  }
  switch(key) {
   case ASPx.Key.Down:
    if(!busy) 
     this.TryMoveFocusDown(index, e.shiftKey, e);
    return true;
   case ASPx.Key.Up:
    if(!busy) 
     this.TryMoveFocusUp(index, e.shiftKey, e);
    return true;
   case ASPx.Key.Right:
    if(!busy) {
     if(!this.TryExpand(index))
      this.TryMoveFocusDown(index, e.shiftKey, e);
    }
    return true;
   case ASPx.Key.Left:
    if(!busy) {
     if(!this.TryCollapse(index))
      this.TryMoveFocusUp(index, e.shiftKey, e);
    }
    return true;
   case ASPx.Key.PageDown:
    if(e.shiftKey) {
     if(!busy && grid.pageIndex < grid.pageCount - 1)
      grid.NextPage();
     return true; 
    }
    break;
   case ASPx.Key.PageUp:
    if(e.shiftKey) {
     if(!busy && grid.pageIndex > 0)
      grid.PrevPage();
     return true; 
    }
    break;     
  }
  return false;
 },
 HandleKeyPress: function(e) {
  var grid = this.control;
  var index = grid.GetFocusedRowIndex();
  var busy = grid.keyboardLock;
  switch(ASPx.Evt.GetKeyCode(e)) {
   case ASPx.Key.Space:
    if(!busy && this.IsRowSelectable(index))
     if(grid.IsRowSelectedOnPage(index)) {
      grid.UnselectRowOnPage(index);
     } else {
      grid.SelectRowOnPage(index);
     }
    return true;
    case 43:
    if(!busy)
     this.TryExpand(index);
    return true;
    case 45: 
    if(!busy)   
     this.TryCollapse(index);    
    return true;
  }
  return false;
 },
 EnsureFocusedRowVisible: function() {
  var grid = this.control;
  if(!grid.HasVertScroll()) return;
  var row = grid.GetItem(grid.GetFocusedRowIndex());
  grid.GetScrollHelper().MakeRowVisible(row, true);
 },
 HasDetailButton: function(expanded) {
  var grid = this.control;
  var row = grid.GetItem(grid.GetFocusedRowIndex());
  if(!row) return;
  var needle = expanded ? "ASPx.GVHideDetailRow" : "ASPx.GVShowDetailRow";
  return row.innerHTML.indexOf(needle) > -1;
 },
 IsRowSelectable: function(index) {
  if(this.control.allowSelectByItemClick)
   return true;
  var row = this.control.GetItem(index);
  if(row && row.innerHTML.indexOf("aspxGVSelectRow") > -1)
   return true;
  var check = this.control.GetDataRowSelBtn(index); 
  if(check && this.control.internalCheckBoxCollection && !!this.control.internalCheckBoxCollection.Get(check.id))
   return true;
  return false;
 },
 UpdateShiftSelection: function(start, end) {
  var grid = this.control;
  grid.UnselectAllRowsOnPage();
  if(grid.lastMultiSelectIndex > -1)   
   start = grid.lastMultiSelectIndex;
  else   
   grid.lastMultiSelectIndex = start;
  if(grid.allowSelectSingleRowOnly)
   start = end;
  for(var i = Math.min(start, end); i <= Math.max(start, end); i++)
   grid.SelectRowOnPage(i);
 },
 TryExpand: function(index) {
  var grid = this.control;
  if(grid.IsGroupRow(index) && !grid.IsGroupRowExpanded(index)) {
   grid.ExpandRow(index);
   return true;
  }
  if(this.HasDetailButton(false)) {
   grid.ExpandDetailRow(index);
   return true;
  }
  return false;
 },
 TryCollapse: function(index) {
  var grid = this.control;
  if(grid.IsGroupRow(index) && grid.IsGroupRowExpanded(index)) {
   grid.CollapseRow(index);
   return true;
  }
  if(this.HasDetailButton(true)) {
   grid.CollapseDetailRow(index);
   return true;
  }
  return false;
 },
 TryMoveFocusDown: function(index, select, htmlEvent) {
  this.moveIterationCount++;
  var grid = this.control;
  if(index < grid.visibleStartIndex + grid.pageRowCount - 1) {
   var focusedRowIndex = index >= 0 ? index + 1 : grid.visibleStartIndex;
   var focusChanged = grid.TryFocusItem(focusedRowIndex, htmlEvent);
   this.EnsureFocusedRowVisible();
   if(this.IsRowSelectable(index)) {
    if(select) {
     this.UpdateShiftSelection(index, index + 1);
    } else {
     grid.lastMultiSelectIndex = -1;
    }
   }
   if(grid.allowFocusedRow && !grid.InCallback() && !focusChanged && this.moveIterationCount < 100)
    this.TryMoveFocusDown(++index, select, htmlEvent);
  } else {
   if(grid.pageIndex < grid.pageCount - 1 && grid.pageIndex >= 0) {       
    grid.NextPage();
   }
  }  
 },
 TryMoveFocusUp: function(index, select, htmlEvent) {
  this.moveIterationCount++;
  var grid = this.control;
  if(index > grid.visibleStartIndex || index == -1) {
   var focusedRowIndex = index >= 0 ? index - 1 : grid.visibleStartIndex + grid.pageRowCount - 1;
   var focusChanged = grid.TryFocusItem(focusedRowIndex, htmlEvent);
   this.EnsureFocusedRowVisible();
   if(this.IsRowSelectable(index)) {
    if(select) {
     this.UpdateShiftSelection(index, index - 1);
    } else {
     grid.lastMultiSelectIndex = -1;
    }
   }
   if(grid.allowFocusedRow && !grid.InCallback() && !focusChanged && this.moveIterationCount < 100)
    this.TryMoveFocusUp(--index, select, htmlEvent);
  } else {
   if(grid.pageIndex > 0) {
    grid.PrevPage(true);
   }
  }
 }
});
var GridViewHeaderMatrix = ASPx.CreateClass(null, {
 constructor: function(grid) {
  this.grid = grid;
 },
 Invalidate: function() {
  this.matrix = null;
  this.inverseMatrix = null;
 },
 GetRowCount: function() {
  this.EnsureMatrix();
  return this.matrix.length;
 },
 IsLeftmostColumn: function(columnIndex) {
  this.EnsureMatrix();
  return this.inverseMatrix[columnIndex].left == 0;
 },
 IsRightmostColumn: function(columnIndex) {
  this.EnsureMatrix();  
  return this.inverseMatrix[columnIndex].right == this.matrix[0].length - 1;
 },
 IsLeaf: function(columnIndex) {
  this.EnsureMatrix();
  return this.inverseMatrix.hasOwnProperty(columnIndex) && this.inverseMatrix[columnIndex].bottom == this.matrix.length - 1;
 },
 GetLeaf: function(columnIndex, isLeft, isOuter) {
  this.EnsureMatrix();
  var rect = this.inverseMatrix[columnIndex];
  var row = this.matrix[this.matrix.length - 1];
  if(isLeft) {
   if(isOuter)
    return row[rect.left - 1];
   return row[rect.left];
  }
  if(isOuter)
   return row[rect.right + 1];
  return row[rect.right];
 },
 GetLeafIndex: function(columnIndex) {
  this.EnsureMatrix();
  return this.inverseMatrix[columnIndex].left;
 },
 GetLeafIndices: function() {
  return this.GetRowIndices(this.GetRowCount() - 1);
 },
 GetRowIndices: function(rowIndex) {
  this.EnsureMatrix();
  return this.matrix[rowIndex] || [];
 },
 GetRowSpan: function(columnIndex) {
  this.EnsureMatrix();
  var rect = this.inverseMatrix[columnIndex];
  return rect.bottom - rect.top + 1;
 },
 GetLeftNeighbor: function(columnIndex, skipHidden) {
  return this.GetNeighbor(columnIndex, true, skipHidden);
 },
 GetRightNeighbor: function(columnIndex, skipHidden) {
  return this.GetNeighbor(columnIndex, false, skipHidden);
 },
 GetNeighbor: function(columnIndex, isLeft, skipHidden) {
  this.EnsureMatrix();
  if(!skipHidden)
   return this.GetNeighborCore(columnIndex, isLeft);
  var boundLeafIndex = this.GetBoundLeaf(isLeft);
  while(columnIndex !== boundLeafIndex) {
   columnIndex = this.GetNeighborCore(columnIndex, isLeft);
   if(isNaN(columnIndex) || !this.GetColumn(columnIndex).adaptiveHidden)
    return columnIndex;
  }
 },
 GetNeighborCore: function(columnIndex, isLeft) {
  var rect = this.inverseMatrix[columnIndex];
  var cellIndex = isLeft ? rect.left - 1 : rect.right + 1;
  return this.matrix[rect.top][cellIndex];
 },
 GetBoundLeaf: function(isLeft) {
  var leafs = this.GetLeafIndices();
  var cellIndex = isLeft ? 0 : leafs.length - 1;
  return leafs[cellIndex];
 },
 GetColumnLevel: function(columnIndex) {
  this.EnsureMatrix();
  var rect = this.inverseMatrix[columnIndex];
  return rect ? rect.top : -1;
 },
 GetColumnHelper: function() { return this.grid.GetColumnHelper(); },
 GetColumn: function(columnIndex) { return this.grid.GetColumn(columnIndex); },
 EnsureMatrix: function() {
  if(!this.matrix)
   this.Fill();
 },
 Fill: function() {
  var columnHelper = this.GetColumnHelper();
  var headerLayout = columnHelper.GetHeaderLayout();
  var info = columnHelper.CreateLayoutMatrixInfo(headerLayout);
  this.matrix = info.matrix;
  this.inverseMatrix = info.inverseMatrix;
 }
});
var ASPxClientGridViewBatchEditApi = ASPx.CreateClass(ASPxClientGridBatchEditApi, {
 constructor: function(grid) {
  this.constructor.prototype.constructor.call(this, grid);
 },
 ValidateRows: function(validateOnlyModified) { return this.ValidateItems(validateOnlyModified); },
 ValidateRow: function(visibleIndex) { return this.ValidateItem(visibleIndex); },
 GetRowVisibleIndices: function(includeDeleted) { return this.GetItemVisibleIndices(includeDeleted); },
 GetDeletedRowIndices: function() { return this.GetDeletedItemVisibleIndices(); },
 GetInsertedRowIndices: function() { return this.GetInsertedItemVisibleIndices(); },
 IsDeletedRow: function(visibleIndex) { return this.IsDeletedItem(visibleIndex); },
 IsNewRow: function(visibleIndex) { return this.IsNewItem(visibleIndex); },
 AddNewRow: function() { this.AddNewItem(); },
 DeleteRow: function(visibleIndex) { this.DeleteItem(visibleIndex); },
 DeleteRowByKey: function(key) { this.DeleteItemByKey(key); },
 RecoverRow: function(visibleIndex) { this.RecoverItem(visibleIndex); },
 RecoverRowByKey: function(key) { this.RecoverItemByKey(key); },
});
window.ASPxClientGridView = ASPxClientGridView;
window.ASPxClientGridViewColumn = ASPxClientGridViewColumn;
window.ASPxClientGridViewColumnCancelEventArgs = ASPxClientGridViewColumnCancelEventArgs;
window.ASPxClientGridViewColumnProcessingModeEventArgs = ASPxClientGridViewColumnProcessingModeEventArgs;
window.ASPxClientGridViewRowCancelEventArgs = ASPxClientGridViewRowCancelEventArgs;
window.ASPxClientGridViewSelectionEventArgs = ASPxClientGridViewSelectionEventArgs;
window.ASPxClientGridViewRowClickEventArgs = ASPxClientGridViewRowClickEventArgs;
window.ASPxClientGridViewContextMenuEventArgs = ASPxClientGridViewContextMenuEventArgs;
window.ASPxClientGridViewContextMenuItemClickEventArgs = ASPxClientGridViewContextMenuItemClickEventArgs;
window.ASPxClientGridViewCustomButtonEventArgs = ASPxClientGridViewCustomButtonEventArgs;
window.ASPxClientGridViewColumnMovingEventArgs = ASPxClientGridViewColumnMovingEventArgs;
window.ASPxClientGridViewBatchEditConfirmShowingEventArgs = ASPxClientGridViewBatchEditConfirmShowingEventArgs;
window.ASPxClientGridViewBatchEditStartEditingEventArgs = ASPxClientGridViewBatchEditStartEditingEventArgs;
window.ASPxClientGridViewBatchEditEndEditingEventArgs = ASPxClientGridViewBatchEditEndEditingEventArgs;
window.ASPxClientGridViewBatchEditRowValidatingEventArgs = ASPxClientGridViewBatchEditRowValidatingEventArgs;
window.ASPxClientGridViewBatchEditTemplateCellFocusedEventArgs = ASPxClientGridViewBatchEditTemplateCellFocusedEventArgs;
window.ASPxClientGridViewBatchEditChangesSavingEventArgs = ASPxClientGridViewBatchEditChangesSavingEventArgs;
window.ASPxClientGridViewBatchEditChangesCancelingEventArgs = ASPxClientGridViewBatchEditChangesCancelingEventArgs;
window.ASPxClientGridViewBatchEditRowInsertingEventArgs = ASPxClientGridViewBatchEditRowInsertingEventArgs;
window.ASPxClientGridViewBatchEditRowDeletingEventArgs = ASPxClientGridViewBatchEditRowDeletingEventArgs;
window.ASPxClientGridViewFocusedCellChangingEventArgs = ASPxClientGridViewFocusedCellChangingEventArgs;
ASPx.GridViewHeaderMatrix = GridViewHeaderMatrix;
ASPx.GridViewKbdHelper = GridViewKbdHelper;
ASPx.GridViewConsts = GridViewConsts;
ASPx.GridViewRowType = GridViewRowType;
ASPx.GridViewCallbackHelper = GridViewCallbackHelper;
ASPx.GridViewAdaptiveDetailButtonPosition = GridViewAdaptiveDetailButtonPosition;
window.ASPxClientGridViewBatchEditApi = ASPxClientGridViewBatchEditApi;
window.ASPxClientGridViewCellInfo = ASPxClientGridViewCellInfo;
window.ASPxClientGridViewExportFormat = ASPx.ASPxClientGridExportFormat;
})();
(function () {
var compositeKeyNameSeparator = ";";
var compositeKeyValueSeparator = "|";
var MVCxGridAdapter = ASPx.CreateClass(null, {
 constructor: function(grid){
  this.grid = grid;
 },
 AssignCallbackRoutes: function(){
  var grid = this.grid;
  if(grid.callbackUrl)
   grid.callBack = function(arg){ MVCx.PerformControlCallback(grid.name, grid.callbackUrl, arg, grid.GetCallbackParams(arg), grid.callbackCustomArgs); };
  if(grid.deleteSelectedItemsUrl)
   grid.deleteSelectedItemsCallBack = function(arg){ MVCx.PerformControlCallback(grid.name, grid.deleteSelectedItemsUrl, arg, grid.GetCallbackParams(arg), grid.callbackCustomArgs); };
  if(grid.addNewItemUrl)
   grid.addNewItemCallBack = function (arg) { MVCx.PerformControlCallback(grid.name, grid.addNewItemUrl, arg, grid.GetCallbackParams(arg), grid.callbackCustomArgs); };
  if(grid.updateItemUrl)
   grid.updateItemCallBack = function (arg) { MVCx.PerformControlCallback(grid.name, grid.updateItemUrl, arg, grid.GetCallbackParams(arg), grid.callbackCustomArgs); };
  if(grid.deleteItemUrl)
   grid.deleteItemCallBack = function (arg) { MVCx.PerformControlCallback(grid.name, grid.deleteItemUrl, arg, grid.GetCallbackParams(arg), grid.callbackCustomArgs); };
  if(grid.allowBatchEditing && grid.batchUpdateUrl)
   grid.batchUpdateCallBack = function(arg) { MVCx.PerformControlCallback(grid.name, grid.batchUpdateUrl, arg, grid.GetCallbackParams(arg), grid.callbackCustomArgs); }; 
  for(var command in grid.callbackActionUrlCollection)
   if(grid.callbackActionUrlCollection.hasOwnProperty(command))
    (function(command) {
     grid.callbackMethods[command] = function(arg) {
      MVCx.PerformControlCallback(grid.name, grid.callbackActionUrlCollection[command], arg, grid.GetCallbackParams(arg), grid.callbackCustomArgs); 
     };
    }).call(this, command);
 },
 ValidateEditorsByJQuery: function(){
  var isValid = true;
  var jQValidation = MVCx.JQueryValidation;
  if(jQValidation.IsEnabled(this.grid)){
   this.PrepareUnobtrusiveValidation();
   $.each(this.GetEditorsToValidate(), function(i, editor){
    isValid &= jQValidation.Validate(editor);
   });
   if(jQValidation.HasPendingRequests(this.grid)){
    jQValidation.SetOnStopRequestHandler(this.grid, this.grid.UpdateEdit.aspxBind(this.grid));
    isValid = false;
   }
  }
  return isValid;
 },
 PrepareUnobtrusiveValidation: function(){
  MVCx.JQueryValidation.PrepareUVRules(this.grid, function() { this.ResolveRemoteValidation(); }.aspxBind(this));
 },
 ResolveRemoteValidation: function(){
  var context = this;
  var fieldsMapMarker = "data-val-remote-dxfieldsmap";
  var editors = this.GetEditorsToValidate();
  for(var i = 0; i < editors.length; i++){
   $input = $(MVCx.GetValueInputElement(editors[i]));
   if($input.attr("data-val-remote-additionalfields") && !$input.attr(fieldsMapMarker))
    $input.attr(fieldsMapMarker, JSON.stringify(context.GetFieldsMap()));
  }
 },
 GetFieldsMap: function(){
  var fieldsMap = {};
  var columns = this.grid.columns;
  for(var i = 0; i < columns.length; i++){
   var editor = this.grid.GetEditor(columns[i]);
   if(editor)
    fieldsMap[columns[i].fieldName] = editor.name;
  }
  return fieldsMap;
 },
 GetEditorsToValidate: function(){
  var editors = this.grid._getEditors() || [];
  $.each(this.grid.columns, function(i, column){
   var control = ASPx.GetControlCollection().Get(column.fieldName);
   if(control && ASPx.Ident.IsASPxClientEdit(control))
    editors.push(control);
  });
  return editors;
 },
 GetCallbackMethod: function(command){
  var grid = this.grid;
  if(command == "FUNCTION")
   return grid.funcCallbackMethod || grid.callBack;
  if(command == ASPxClientGridViewCallbackCommand.DeleteRow)
   return grid.deleteItemCallBack;
  if(command == ASPxClientGridViewCallbackCommand.UpdateEdit && grid.allowBatchEditing)
   return grid.batchUpdateCallBack;
  if(command == ASPxClientGridViewCallbackCommand.UpdateEdit)
   return grid.IsNewItemEditing() ? grid.addNewItemCallBack : grid.updateItemCallBack;
  if(grid.deleteSelectedItemsOnPage)
   return grid.deleteSelectedItemsCallBack;
  return grid.callbackMethods[command] || grid.callBack;
 },
 GetCallbackParams: function(){
  var params = {};
  MVCx.AddCallbackParam(params, this.grid.GetStateHiddenField());
  MVCx.AddCallbackParamsInContainer(params, this.grid.GetMainElement());
  this.AddEditingCallbackParams(params);
  this.AddSelectedKeysParams(params);
  return params;
 },
 AddEditingCallbackParams: function(params){
  if(this.grid.IsEditing() || this.grid.deleteKeyValue)
   this.AddEditorsCallbackParams(params);
  if(this.grid.allowBatchEditing)
   this.AddBatchEditingCallbackParams(params);
 },
 AddEditorsCallbackParams: function(params){
  var grid = this.grid;
  var editFields = [];
  var editors = grid._getEditors();
  for(var i = 0; i < editors.length; i++){
   var editorIndex = grid.GetEditorIndex(editors[i].name);
   var column = grid.columns[editorIndex];
   params[column.fieldName] = ASPx.Json.ToJson(MVCx.GetEditorValueByControl(editors[i]));
   editFields.push(column.fieldName);
  }
  this.AddKeyValueParams(params, editFields);
  if(editFields.length > 0)
   params["DXMVCGridEditFields"] = ASPx.Json.ToJson(editFields);
  MVCx.AddDXEditorValuesInContainer(params, grid.GetMainElement());
 },
 AddKeyValueParams: function(params, editFields){
  var grid = this.grid;
  var keyFields = this.GetKeyFieldNames();
  if(keyFields.length == 0)
   return;
  var keyValues;
  if(grid.deleteKeyValue)
   keyValues = grid.deleteKeyValue;
  else if(!grid.IsNewItemEditing() && grid.editingItemVisibleIndex > -1)
   keyValues = grid.GetItemKey(grid.editingItemVisibleIndex);
  if(keyValues){
   keyValues = this.IsCompositeKey() ? keyValues.split(compositeKeyValueSeparator) : [ keyValues ];
   var keyCount = Math.min(keyFields.length, keyValues.length);
   for(var i = 0; i < keyCount; i++){
    var keyName = keyFields[i];
    params[keyName] = ASPx.Json.ToJson(keyValues[i]);
    if(editFields.indexOf(keyName) < 0)
     editFields.push(keyName);
   }
  }
 },
 IsCompositeKey: function() {
  return this.grid.keyName.indexOf(compositeKeyNameSeparator) > -1;
 },
 GetKeyFieldNames: function(){
  if(!this.grid.keyName)
   return [ ];
  if(this.IsCompositeKey())
   return this.grid.keyName.split(compositeKeyNameSeparator);
  return [ this.grid.keyName ];
 },
 AddBatchEditingCallbackParams: function(params){
  params["DXMVCBatchEditingValuesRequestKey"] = this.grid.uniqueID;
  params["DXMVCBatchEditingKeyFieldName"] = this.grid.keyName;
 },
 AddSelectedKeysParams: function(params){
  if(this.grid.deleteSelectedItemsOnPage)
   params["DXMVCGridSelectedKeys"] = ASPx.Json.ToJson(this.grid.GetSelectedKeysOnPage());
 },
 GridCallBack: function(args) {
  if(args[0] === ASPxClientGridViewCallbackCommand.Sort)
   this.grid.callbackCustomArgs["reset"] = args[4];
  else if(args[0] === ASPxClientGridViewCallbackCommand.Toolbar && args[1] === "DeleteSelected")
   this.grid.deleteSelectedItemsOnPage = true;
 },
 OnAfterCallback: function() {
  delete this.grid.deleteSelectedItemsOnPage;
  MVCx.JQueryValidation.ResetUVRules(this.grid);
 },
 ExportTo: function(format) {
  this.GridPerformExportCallback([ASPxClientGridViewCallbackCommand.Export, format]);
 },
 GetExportCallbackArgs: function(args) {
  var grid = this.grid,
   callbackHelper = grid.GetCallbackHelper(),
   callbackState = callbackHelper.GetGridCallbackState(),
   callbackInfo = grid.CreateCallbackInfo(ASPx.CallbackType.Common, null),
   callbackID = grid.SaveCallbackInfo(callbackInfo);
  callbackState.push(["GB", callbackHelper.SerializeCallbackArgs(args)]);
  var callbackArgs = callbackHelper.FormatCallbackState(callbackState),
   res = grid.GetSerializedCallbackInfoByID(callbackID) + callbackArgs;
  grid.DequeueCallbackInfo(callbackID);
  return res;
 },
 GridPerformExportCallback: function(args) {
  var grid = this.grid,
   form = grid.GetParentForm();
  if(form) {
   var sourceFormAction = form.action,
    sourceFormMethod = form.method,
    url = grid.callbackUrl,
    exportCallbackArgs = this.GetExportCallbackArgs(args);
   form.action = url + (url.indexOf("?") > -1 ? "&" : "?") + "DXCallbackName=" + grid.name + "&__DXCallbackArgument=" + exportCallbackArgs;
   form.method = "post";
   form.submit();
   window.setTimeout(function() {
    form.action = sourceFormAction;
    form.method = sourceFormMethod;
   }, 0);
  }
  else
   ASPx.ShowErrorMessage('The form is not found. Add a form to use this feature.');
 }
});
var GridBatchEditHelperAdapter = ASPx.CreateClass(null, {
 constructor: function() {
  this.batchEditHelper = null;
  this.grid = null;
 },
 Init: function(batchEditHelper) {
  this.batchEditHelper = batchEditHelper;
  this.grid = this.batchEditHelper.grid;
 },
 PrepareEditorsValidation: function(){
  if(!MVCx.JQueryValidation.IsEnabled(this.grid))
   return;
  this.grid.gridAdapter.PrepareUnobtrusiveValidation();
  var columnIndices = this.batchEditHelper.GetEditColumnIndices();
  for(var i = 0; i < columnIndices.length; i++) {
   var editor = this.grid.GetEditor(columnIndices[i]);
   if(editor) {
    editor.GotFocus.AddHandler(function(s){ $.validator.prototype.lastElement = s.GetInputElement(); });
    editor.LostFocus.AddHandler(function(s) { $.validator.lastElement = null; });
   }
  }
 },
 SafeCallValidateItem: function(validateItemFunc) {
  var oldValidateInvisibleEditors = MVCx.validateInvisibleEditors;
  try {
   MVCx.validateInvisibleEditors = true;
   return validateItemFunc();
  } finally{
   MVCx.validateInvisibleEditors = oldValidateInvisibleEditors;
  }
 },
 ValidateEditor: function(editor){
  var jQValidation = MVCx.JQueryValidation;
  if(jQValidation.IsEnabled(this.grid)) {
   jQValidation.Validate(editor);
   if(jQValidation.HasPendingRequests(this.grid))
    this.SetHandlerAtEndingRequest(editor);
  }
 },
 SetHandlerAtEndingRequest : function(editor) {
  var helper = this.batchEditHelper;
  var visibleIndex = helper.editItemVisibleIndex;
  var columnIndex = editor.dxgvColumnIndex;
  MVCx.JQueryValidation.SetOnStopRequestHandler(this.grid, function() {
   if(editor.GetValue() !== helper.GetCellValue(visibleIndex, columnIndex)) return;
   if(!editor.GetIsValid()) {
    helper.ApplyCellValidationError(visibleIndex, columnIndex, MVCx.JQueryValidation.GetValidationErrorMessage(editor));
    editor.SetIsValid(true);
   } else
    helper.ResetCellValidationError(visibleIndex, columnIndex);
  }.bind(this));
 },
 GetUVRemoteAdditionalColumnIndices: function(columnIndices) {
  var indices = [ ].concat(columnIndices);
  for(var i = 0; i < columnIndices.length; i++) {
   var editor = this.grid.GetEditor(columnIndices[i]);
   var fields = editor && editor.uvRemoteAdditionalFields;
   if(!fields) continue;
   for(var j = 0; j < fields.length; j++) {
    var index = this.grid._getColumnIndexByColumnArgs(fields[j]);
    if(ASPx.IsExists(index) && indices.indexOf(index) === -1)
     indices.push(index);
   }
  }
  return indices;
 }
});
var GridToolbarHelperAdapter = ASPx.CreateClass(null, {
 constructor: function() {
  this.toolbarHelper = null;
 },
 Init: function(toolbarHelper) {
  this.toolbarHelper = toolbarHelper;
 },
 SendExportCommand: function(toolbarIndex, indexPath, exportFormat) {
  var grid = this.toolbarHelper.grid;
  grid.gridAdapter.GridPerformExportCallback([ASPxClientGridViewCallbackCommand.Export, exportFormat]);
 }
});
function InitUnobtrusiveRules(name, rules){
 var editor = ASPx.GetControlCollection().Get(name);
 MVCx.JQueryValidation.SetUVAttributes(editor, rules);
}
MVCx.GridAdapter = MVCxGridAdapter;
MVCx.GridBatchEditHelperAdapter = GridBatchEditHelperAdapter;
MVCx.GridToolbarHelperAdapter = GridToolbarHelperAdapter;
MVCx.InitUnobtrusiveRules = InitUnobtrusiveRules;
})();

(function() {
var MVCxClientGridView = ASPx.CreateClass(ASPxClientGridView, {
 constructor: function(name) {
  this.constructor.prototype.constructor.call(this, name);
  this.callbackUrl = "";
  this.customActionUrl = "";
  this.addNewItemUrl = "";
  this.updateItemUrl = "";
  this.deleteItemUrl = "";
  this.batchUpdateUrl = "";
  this.callbackCustomArgs = {};
  this.callbackActionUrlCollection = {};
  this.deleteSelectedItemsCallBack = undefined;
  this.customActionCallBack = undefined;
  this.addNewItemCallBack = undefined;
  this.updateItemCallBack = undefined;
  this.deleteItemCallBack = undefined;
  this.batchUpdateCallBack = undefined;
  this.callbackMethods = {};
  this.funcCallbackMethod = undefined;
  this.deleteKeyValue = undefined;
  this.gridAdapter = new MVCx.GridAdapter(this);
 },
 PerformCallback: function(data, onSuccess){
  ASPx.Data.MergeHashTables(this.callbackCustomArgs, data);
  ASPxClientGridView.prototype.PerformCallback.call(this, data, onSuccess);
 },
 GetValuesOnCustomCallback: function(data, onCallback) {
  this.funcCallbackMethod = this.callbackMethods[ASPxClientGridViewCallbackCommand.CustomValues];
  ASPx.Data.MergeHashTables(this.callbackCustomArgs, data);
  ASPxClientGridView.prototype.GetValuesOnCustomCallback.call(this, data, onCallback);
 },
 InlineInitialize: function(){
  this.gridAdapter.AssignCallbackRoutes();
  ASPxClientGridView.prototype.InlineInitialize.call(this);
 },
 RaiseBeginCallbackInternal: function(command){
  var args = new MVCxClientBeginCallbackEventArgs(command);
  if(!this.BeginCallback.IsEmpty())
   this.BeginCallback.FireEvent(this, args);
  ASPx.Data.MergeHashTables(this.callbackCustomArgs, args.customArgs);
 },
 CreateCallbackByInfo: function(arg, command, callbackInfo) {
  this.CreateCallbackInternal(arg, command, true, callbackInfo);
 },
 GetSortingCallbackParamsMethod: function(arg){
  var param = this.GetCallbackParams(arg);
  return param;
 },
 GetCallbackParams: function(arg) {
  return this.gridAdapter.GetCallbackParams();
 },
 EvalCallbackResult: function(resultString){
  var resultStringParts = resultString.split(MVCx.CallbackHtmlContentPrefix);
  if(resultStringParts.length == 2){
   var resultObj = ASPxClientGridView.prototype.EvalCallbackResult.call(this, resultStringParts[0]);
   resultObj.result.html = resultStringParts[1];
   return resultObj;
  }
  return ASPxClientGridView.prototype.EvalCallbackResult.call(this, resultString);
 },
 CreateCallbackCore: function(arg, command, callbackID){
  if(this.callbackCustomArgs != {})
   window.setTimeout(function(){ this.callbackCustomArgs = {}; }.aspxBind(this), 0);
  if(this.funcCallbackMethod)
   window.setTimeout(function() { this.funcCallbackMethod = null; }.aspxBind(this), 0);
  ASPxClientGridView.prototype.CreateCallbackCore.call(this, arg, command, callbackID);
 },
 GetCallbackMethod: function(command) {
  return this.gridAdapter.GetCallbackMethod(command);
 },
 DeleteItemByKey: function(key) {
  this.deleteKeyValue = key;
  ASPxClientGridView.prototype.DeleteItemByKey.call(this, key);
 },
 gridCallBack: function(args, handler) {
  this.gridAdapter.GridCallBack(args);
  ASPxClientGridView.prototype.gridCallBack.call(this, args, handler);
 },
 OnAfterCallback: function() {
  delete this.deleteKeyValue;
  this.gridAdapter.OnAfterCallback();
  ASPxClientGridView.prototype.OnAfterCallback.call(this);
 },
 DoCallbackError: function(errorMessage) {
  ASPxClientGridView.prototype.DoCallbackError.call(this, errorMessage);
  this.SetAfterCallbackRequired();
  this.DoEndCallback();
 },
 ShowCallbackErrorCore: function(displayIn, errorText) {
  ASPxClientGridView.prototype.ShowCallbackErrorCore.call(this, displayIn, errorText);
  if(!this.serverExceptionOnLastCallback)
   MVCx.ThrowExceptionOnCallback();
 },
 ExportTo: function(format) {
  this.gridAdapter.ExportTo(format);
 },
 CreateToolbarHelper: function() {
  this.InitializeToolbarHelperClass();
  return new MVCxClientGridViewToolbarHelper(this, new MVCx.GridToolbarHelperAdapter());
 },
 InitializeToolbarHelperClass: function() {
  if(typeof(MVCxClientGridViewToolbarHelper) != 'undefined') return;
  MVCxClientGridViewToolbarHelper = ASPx.CreateClass(ASPx.GridViewToolbarHelper, {
   constructor: function(grid, toolbarHelperAdapter) { 
    this.constructor.prototype.constructor.call(this, grid);
    this.toolbarHelperAdapter = toolbarHelperAdapter;
    this.toolbarHelperAdapter.Init(this);
   },
   SendExportCommand: function(toolbarIndex, indexPath, exportFormat) {
    this.toolbarHelperAdapter.SendExportCommand(toolbarIndex, indexPath, exportFormat);
   }
  });
 },
 CreateContextMenuHelper: function() {
  this.InitializeContextMenuHelperClass();
  return new MVCxClientGridViewContextMenuHelper(this);
 },
 InitializeContextMenuHelperClass: function() {
  if(typeof(MVCxClientGridViewContextMenuHelper) != 'undefined') return;
  MVCxClientGridViewContextMenuHelper = ASPx.CreateClass(ASPx.GridViewContextMenuHelper, {
   SendExportCommand: function(menuType, itemPath, elementIndex, exportFormat) {
    var gridAdapter = this.grid.gridAdapter;
    gridAdapter.GridPerformExportCallback([ASPxClientGridViewCallbackCommand.ContextMenu, ASPxClientGridViewCallbackCommand.Export, menuType, itemPath, elementIndex, exportFormat]);
   }
  });
 },
 _validateEditors: function () {
  return ASPxClientGridView.prototype._validateEditors.call(this) && this.gridAdapter.ValidateEditorsByJQuery();
 },
 CreateBatchEditHelper: function(){
  this.InitializeBatchEditHelperClass();
  return new MVCxClientGridViewBatchEditHelper(this, new MVCx.GridBatchEditHelperAdapter());
 },
 InitializeBatchEditHelperClass: function(){
  if(typeof(MVCxClientGridViewBatchEditHelper) != 'undefined') return;
  MVCxClientGridViewBatchEditHelper = ASPx.CreateClass(ASPx.GridViewBatchEditHelper, {
   constructor: function(grid, batchEditHelperAdapter) { 
    this.constructor.prototype.constructor.call(this, grid);
    this.batchEditHelperAdapter = batchEditHelperAdapter;
    this.batchEditHelperAdapter.Init(this);
   },
   GetNonEditableColumnValues: function() { return this.grid.batchEditClientState.nonEditableColumnValues; },
   Init: function(){
    ASPx.GridViewBatchEditHelper.prototype.Init.call(this);
    this.batchEditHelperAdapter.PrepareEditorsValidation();
   },
   OnAfterCallback: function(){
    ASPx.GridViewBatchEditHelper.prototype.OnAfterCallback.call(this);
    this.batchEditHelperAdapter.PrepareEditorsValidation();
   },
   SetEditorValues: function(itemValues, columnIndices) {
    columnIndices = this.batchEditHelperAdapter.GetUVRemoteAdditionalColumnIndices(columnIndices);
    ASPx.GridViewBatchEditHelper.prototype.SetEditorValues.call(this, itemValues, columnIndices);
   },
   ValidateItem: function(visibleIndex, itemValues, validateNotModified) {
    return this.batchEditHelperAdapter.SafeCallValidateItem(
     function(){ return ASPx.GridViewBatchEditHelper.prototype.ValidateItem.call(this, visibleIndex, itemValues, validateNotModified); }.aspxBind(this)
    );
   },
   ValidateEditor: function(editor){
    ASPx.GridViewBatchEditHelper.prototype.ValidateEditor.call(this, editor);
    this.batchEditHelperAdapter.ValidateEditor(editor);
   },
   CreateItemEditState: function(visibleIndex, columnIndices) {
    var state = ASPx.GridViewBatchEditHelper.prototype.CreateItemEditState.call(this, visibleIndex, columnIndices);
    this.AppendNonEditableColumnValues(state, visibleIndex);
    return state;
   },
   AppendNonEditableColumnValues: function(itemState, visibleIndex) {
    var values = this.GetNonEditableColumnValues();
    var key = this.GetItemKey(visibleIndex);
    var rowValues = values && values[key];
    if(!rowValues) return;
    for(var columnKey in rowValues) {
     if(rowValues.hasOwnProperty(columnKey)) {
      var columnIndex = parseInt(columnKey);
      var fieldName = this.grid.GetColumn(columnIndex).fieldName;
      var value = rowValues[columnIndex];
      itemState[fieldName] = this.GetValueString(value);
     }
    }
   }
  });
 }
});
MVCxClientGridView.Cast = ASPxClientControl.Cast;
window.MVCxClientGridView = MVCxClientGridView;
})();
